/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.DeleteStatement;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.NoCursorClause;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.UsingKeysClause;
import org.eclipse.edt.compiler.core.ast.UsingPCBClause;
import org.eclipse.edt.compiler.core.ast.WithInlineDLIClause;
import org.eclipse.edt.compiler.core.ast.WithInlineSQLClause;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.statement.DLIStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.IOStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.SQLStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;

public class DeleteStatementValidator
extends IOStatementValidator {
    public DeleteStatementValidator(IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(problemRequestor, compilerOptions);
    }

    @Override
    public boolean visit(final DeleteStatement adeleteStatement) {
        StatementValidator.validateIOTargetsContainer(adeleteStatement.getIOObjects(), this.problemRequestor);
        Expression expr = adeleteStatement.getTarget();
        this.validateTargetType(expr);
        final Node[] nocursorNode = new Node[1];
        final Node[] inlineSqlNode = new Node[1];
        adeleteStatement.accept(new AbstractASTVisitor(){
            UsingPCBClause pcbClause = null;
            Node inlinesql = null;
            Node inlinedli = null;

            @Override
            public boolean visit(WithInlineSQLClause withInlineSQLClause) {
                inlineSqlNode[0] = withInlineSQLClause;
                DeleteStatementValidator.this.checkIsSQLTarget("with sql", withInlineSQLClause);
                if (this.inlinesql != null) {
                    DeleteStatementValidator.this.problemRequestor.acceptProblem((Node)withInlineSQLClause, 6512, new String[]{"delete".toUpperCase()});
                } else {
                    this.inlinesql = withInlineSQLClause;
                    if (StatementValidator.isClauseEmpty(withInlineSQLClause.getSqlStmt().getValue())) {
                        DeleteStatementValidator.this.problemRequestor.acceptProblem((Node)withInlineSQLClause, 6500, new String[]{"delete".toUpperCase()});
                    } else {
                        SQLStatementValidator.checkDeleteClauses(withInlineSQLClause, adeleteStatement.getSqlInfo().getParser(), DeleteStatementValidator.this.problemRequestor);
                    }
                }
                return false;
            }

            @Override
            public boolean visit(WithInlineDLIClause withInlineDLIClause) {
                if (this.inlinedli != null) {
                    DeleteStatementValidator.this.problemRequestor.acceptProblem((Node)withInlineDLIClause, 6546, new String[]{"delete".toUpperCase()});
                } else {
                    this.inlinedli = withInlineDLIClause;
                }
                return false;
            }

            @Override
            public boolean visit(UsingPCBClause usingPCBClause) {
                this.pcbClause = usingPCBClause;
                return false;
            }

            @Override
            public boolean visit(NoCursorClause noCursorClause) {
                nocursorNode[0] = noCursorClause;
                DeleteStatementValidator.this.checkIsSQLTarget("noCursor", noCursorClause);
                DeleteStatementValidator.this.checkMutuallyExclusiveClauses(NO_CURSOR_USINGKEYS, "noCursor", noCursorClause);
                return false;
            }

            @Override
            public boolean visit(UsingKeysClause usingKeysClause) {
                DeleteStatementValidator.this.checkIsSQLTarget("usingKeys", usingKeysClause);
                DeleteStatementValidator.this.checkMutuallyExclusiveClauses(NO_CURSOR_USINGKEYS, "usingKeys", usingKeysClause);
                return false;
            }

            @Override
            public void endVisit(DeleteStatement deleteStatement) {
                if (deleteStatement.getDliInfo() != null) {
                    DLIStatementValidator validator = new DLIStatementValidator(deleteStatement, DeleteStatementValidator.this.problemRequestor, 5);
                    validator.validateDLI(this.pcbClause);
                }
            }
        });
        if (expr != null) {
            ITypeBinding typeBinding = expr.resolveTypeBinding();
            if (this.isSQLTarget && typeBinding.getAnnotation(((IPartBinding)typeBinding).getSubType()).findData("keyItems") == IBinding.NOT_FOUND_BINDING && nocursorNode[0] != null && inlineSqlNode[0] == null) {
                this.problemRequestor.acceptProblem(nocursorNode[0], 6690, new String[]{typeBinding.getCaseSensitiveName()});
            }
        }
        return false;
    }

    protected void validateTargetType(Expression expression) {
        boolean isValid = false;
        if (expression == null) {
            return;
        }
        ITypeBinding typeBinding = expression.resolveTypeBinding();
        if (StatementValidator.isValidBinding(typeBinding) && (typeBinding.getKind() == 6 || typeBinding.getKind() == 7)) {
            boolean bl = this.isSQLTarget = typeBinding.getAnnotation(EGLIOSQL, "SQLRecord") != null;
            if (this.isSQLTarget || typeBinding.getAnnotation(EGLIOSQL, "SQLRecord") != null || typeBinding.getAnnotation(EGLIOFILE, "IndexedRecord") != null || typeBinding.getAnnotation(EGLIODLI, "DLISegment") != null || typeBinding.getAnnotation(EGLIOFILE, "RelativeRecord") != null) {
                isValid = true;
            }
        }
    }

    protected boolean isClauseEmpty(String clause) {
        int i = 0;
        while (i < clause.length()) {
            if (!Character.isWhitespace(clause.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

