/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.ForStatement;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.utils.TypeCompatibilityUtil;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;

public class ForStatementValidator
extends DefaultASTVisitor {
    private IProblemRequestor problemRequestor;
    private ICompilerOptions compilerOptions;

    public ForStatementValidator(IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
    }

    @Override
    public boolean visit(final ForStatement forStatement) {
        forStatement.accept(new AbstractASTExpressionVisitor(){

            @Override
            public boolean visitExpression(Expression expr) {
                ITypeBinding tBinding = expr.resolveTypeBinding();
                if (StatementValidator.isValidBinding(tBinding) && !TypeCompatibilityUtil.isMoveCompatible(PrimitiveTypeBinding.getInstance(Primitive.INT), tBinding, expr, ForStatementValidator.this.compilerOptions) && !tBinding.isDynamic()) {
                    if (expr == forStatement.getCounterVariable()) {
                        ForStatementValidator.this.problemRequestor.acceptProblem(expr, 5035);
                    } else {
                        String insert = "";
                        if (expr == forStatement.getFromIndex()) {
                            insert = "start";
                        } else if (expr == forStatement.getEndIndex()) {
                            insert = "end";
                        } else if (expr == forStatement.getDeltaExpression()) {
                            insert = "delta";
                        }
                        if (insert.length() > 0) {
                            ForStatementValidator.this.problemRequestor.acceptProblem((Node)expr, 5036, new String[]{insert});
                        }
                    }
                }
                return false;
            }
        });
        return false;
    }
}

