/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import java.util.Iterator;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.TopLevelFunction;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.AnnotationValidator;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.FieldValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;

public class FunctionDataDeclarationValidator
extends DefaultASTVisitor {
    private IProblemRequestor problemRequestor;
    private ICompilerOptions compilerOptions;
    private IPartBinding enclosingPart;

    public FunctionDataDeclarationValidator(IProblemRequestor problemRequestor, ICompilerOptions compilerOptions, IPartBinding enclosingPart) {
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
        this.enclosingPart = enclosingPart;
    }

    @Override
    public boolean visit(FunctionDataDeclaration functionDataDeclaration) {
        Iterator iter = functionDataDeclaration.getNames().iterator();
        while (iter.hasNext()) {
            EGLNameValidator.validate((Name)iter.next(), 1, this.problemRequestor, this.compilerOptions);
        }
        StatementValidator.validateDataDeclarationInitializer(functionDataDeclaration, this.problemRequestor, this.compilerOptions);
        StatementValidator.validateRequiredFieldsInCUIDeclaration(functionDataDeclaration.getType(), functionDataDeclaration.getSettingsBlockOpt(), this.problemRequestor);
        if (functionDataDeclaration.isConstant()) {
            StatementValidator.validatePrimitiveConstant(functionDataDeclaration.getType(), this.problemRequestor);
        }
        this.validateDataType(functionDataDeclaration);
        new AnnotationValidator(this.problemRequestor, this.compilerOptions).validateAnnotationTarget(functionDataDeclaration);
        IBinding binding = ((Name)functionDataDeclaration.getNames().get(0)).resolveBinding();
        if (binding != null && IBinding.NOT_FOUND_BINDING != binding && binding.isDataBinding()) {
            StatementValidator.validateDeclarationForStereotypeContext((IDataBinding)binding, this.problemRequestor, functionDataDeclaration.getType().getBaseType());
        }
        functionDataDeclaration.accept(new FieldValidator(this.problemRequestor, this.compilerOptions));
        return false;
    }

    protected void validateDataType(final FunctionDataDeclaration functionDataDeclaration) {
        functionDataDeclaration.getParent().accept(new AbstractASTVisitor(){

            @Override
            public boolean visit(NestedFunction f) {
                this.validate(f.getName().getCanonicalName());
                return false;
            }

            @Override
            public boolean visit(TopLevelFunction f) {
                this.validate(f.getName().getCanonicalName());
                return false;
            }

            protected void validate(String name) {
                ((Expression)functionDataDeclaration.getNames().get(0)).getCanonicalString();
                StatementValidator.validateDataDeclarationType(functionDataDeclaration.getType(), FunctionDataDeclarationValidator.this.problemRequestor, FunctionDataDeclarationValidator.this.enclosingPart);
            }
        });
        ITypeBinding declType = functionDataDeclaration.getType().resolveTypeBinding();
        if (IBinding.NOT_FOUND_BINDING != declType && declType != null && AbstractBinder.typeIs(declType.getBaseType(), new String[]{"egl", "ui", "console"}, "ConsoleField")) {
            this.problemRequestor.acceptProblem(functionDataDeclaration.getType(), 7710);
        }
    }
}

