/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import java.util.List;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.ExternalTypeBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.Boolean;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.ThrowStatement;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class ThrowStatementValidator
extends DefaultASTVisitor {
    private IProblemRequestor problemRequestor;
    private IPartBinding enclosingPart;

    public ThrowStatementValidator(IProblemRequestor problemRequestor, IPartBinding enclosingPart) {
        this.problemRequestor = problemRequestor;
        this.enclosingPart = enclosingPart;
    }

    @Override
    public boolean visit(ThrowStatement throwStatement) {
        if (this.enclosingPart != null) {
            boolean isV60ExceptionCompatibility;
            IAnnotationBinding aBinding = this.enclosingPart.getAnnotation(new String[]{"egl", "core"}, "V60ExceptionCompatibility");
            boolean bl = isV60ExceptionCompatibility = aBinding != null && Boolean.YES == aBinding.getValue();
            if (isV60ExceptionCompatibility) {
                this.problemRequestor.acceptProblem(throwStatement, 3445);
            } else {
                ITypeBinding tBinding = throwStatement.getExpression().resolveTypeBinding();
                if (tBinding != null && IBinding.NOT_FOUND_BINDING != tBinding && !this.isAnyException(tBinding) && tBinding.getAnnotation(new String[]{"eglx", "lang"}, "Exception") == null) {
                    this.problemRequestor.acceptProblem((Node)throwStatement.getExpression(), 3444, new String[]{tBinding.getCaseSensitiveName()});
                }
            }
        }
        return false;
    }

    private boolean isAnyException(ITypeBinding type) {
        if (!Binding.isValidBinding(type)) {
            return false;
        }
        if (type.getKind() != 28) {
            return false;
        }
        if (type.getName() != InternUtil.intern((String)"anyException")) {
            ExternalTypeBinding etBinding = (ExternalTypeBinding)type;
            List supers = ((ExternalTypeBinding)etBinding.getNonNullableInstance()).getExtendedTypes();
            if (supers.size() > 0) {
                for (Object o : supers) {
                    if (!(o instanceof ITypeBinding) || !this.isAnyException((ITypeBinding)o)) continue;
                    return true;
                }
            }
            return false;
        }
        return type.getPackageName() == InternUtil.intern((String[])new String[]{"eglx", "lang"});
    }
}

