/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.binding.StructureItemBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.ArrayType;
import org.eclipse.edt.compiler.core.ast.AsExpression;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.DataItem;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.FunctionParameter;
import org.eclipse.edt.compiler.core.ast.IsAExpression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.core.ast.PrimitiveType;
import org.eclipse.edt.compiler.core.ast.ProgramParameter;
import org.eclipse.edt.compiler.core.ast.ReturnsDeclaration;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;

public class PrimitiveTypeValidator {
    static PrimitiveType passedPrimitiveType = null;
    static int primitiveInt;
    static String pattern;
    static String ownerName;
    static IProblemRequestor problemRequestor;
    public static final String BIN_RANGE = "(4, 9, 18)";
    public static final String CHAR_RANGE = "(1..32767)";
    public static final String DBCHAR_RANGE = "(1..16383)";
    public static final String HEX_RANGE = "(2, 4,...,65534)";
    public static final String MBCHAR_RANGE = "(1..32767)";
    public static final String NUM_RANGE = "(1..32)";
    public static final String NUMC_RANGE = "(1..18)";
    public static final String PACF_RANGE = "(1, 3,...,17;18)";
    public static final String DECIMAL_RANGE = "(1..32)";
    public static final String UNICODE_RANGE = "(1..16383)";
    public static final String MONEY_RANGE = "(2..32)";
    public static final String TIMESTAMP_RANGE = "(2..20)";
    public static final String INTERVAL_RANGE = "(3..28)";
    public static final String CLOB_RANGE = "(1..2 gigabytes)";
    public static final String BLOB_RANGE = "(1..2 gigabytes)";
    public static final String DATE_RANGE = "(8)";
    public static final String TIME_RANGE = "(6)";
    public static final String FLOAT_RANGE = "(8)";
    public static final String SMALLFLOAT_RANGE = "(4)";
    public static final String INT_RANGE = "(9)";
    public static final String BIGINT_RANGE = "(18)";
    public static final String SMALLINT_RANGE = "(4)";
    public static final String[] LENGTH_RANGES;
    public static final int NUMERIC_MAX = 18;
    public static final int TIMESTAMP_MAX = 20;
    public static final int INTERVAL_MAX = 28;
    public static final int DECIMAL_MAX = 32;
    public static final int CHAR_MIX_MAX = Short.MAX_VALUE;
    public static final int DBCHAR_UNICODE_MAX = 16383;
    public static final int HEX_MAX = 65534;
    public static final int BLOB_CLOB_MAX = Integer.MAX_VALUE;
    public static final int PRIMITIVE_TYPE_MIN = 1;
    public static final int BIN_MIN = 4;
    public static final int HEX_MIN = 2;
    public static final int SQL_ITEM_BIN_MIN = 4;
    public static final int SQL_ITEM_BIN_MAX = 9;
    public static final String SQL_ITEM_BIN_RANGE = "(4, 9)";

    static {
        ownerName = null;
        problemRequestor = null;
        LENGTH_RANGES = new String[]{BIN_RANGE, "(1..32767)", "(1..16383)", HEX_RANGE, "(1..32767)", "(1..32)", NUMC_RANGE, PACF_RANGE, "(1..32)", "(1..16383)", INT_RANGE, BIGINT_RANGE, "(4)"};
    }

    private static void initializeOwnerName() {
        passedPrimitiveType.getParent().accept(new ParentAbstractASTVisitor());
    }

    public static void validate(PrimitiveType passedType, IProblemRequestor pr, ICompilerOptions compilerOptions) {
        passedPrimitiveType = passedType;
        problemRequestor = pr;
        PrimitiveTypeValidator.initializeOwnerName();
        primitiveInt = passedPrimitiveType.getPrimitive().getType();
        ITypeBinding binding = passedPrimitiveType.resolveTypeBinding();
        pattern = null;
        if (binding.getKind() == 3) {
            pattern = ((PrimitiveTypeBinding)binding).getTimeStampOrIntervalPattern();
        }
        if ((primitiveInt == 18 || primitiveInt == 10 || primitiveInt == 1 || primitiveInt == 8 || primitiveInt == 17 || primitiveInt == 14 || primitiveInt == 23 || primitiveInt == 27 || primitiveInt == 19 || primitiveInt == 0) && passedPrimitiveType.hasPrimLength()) {
            problemRequestor.acceptProblem((Node)passedPrimitiveType, 4400, new String[0]);
        }
        if (!PrimitiveTypeValidator.logicalChildrenCheckNeeded(passedPrimitiveType, primitiveInt, passedPrimitiveType.getPrimitive().getName().toUpperCase())) {
            PrimitiveTypeValidator.checkLength(primitiveInt, passedPrimitiveType.getPrimitive().getName().toUpperCase(), passedType.hasPrimLength());
        }
        if (PrimitiveTypeValidator.checkDecimalSpecified(primitiveInt, passedPrimitiveType.getPrimitive().getName().toUpperCase()) && PrimitiveTypeValidator.checkDecimalRange()) {
            PrimitiveTypeValidator.checkDecimalLength();
        }
        PrimitiveTypeValidator.checkTimestampOrIntervalPattern();
        if (primitiveInt == 26 && pattern == null) {
            problemRequestor.acceptProblem((Node)passedPrimitiveType, 4405, new String[]{ownerName, "interval"});
        }
    }

    public static void validateParamInFunction(PrimitiveType passedType, IProblemRequestor pr, ICompilerOptions compilerOptions) {
        passedPrimitiveType = passedType;
        problemRequestor = pr;
        PrimitiveTypeValidator.initializeOwnerName();
        primitiveInt = passedPrimitiveType.getPrimitive().getType();
        ITypeBinding binding = passedPrimitiveType.resolveTypeBinding();
        pattern = null;
        if (binding.getKind() == 3) {
            pattern = ((PrimitiveTypeBinding)binding).getTimeStampOrIntervalPattern();
        }
        if (!PrimitiveTypeValidator.logicalChildrenCheckNeeded(passedPrimitiveType, primitiveInt, passedPrimitiveType.getPrimitive().getName().toUpperCase())) {
            if (PrimitiveTypeValidator.isStringPrimitive(passedPrimitiveType)) {
                int primitiveLength = 0;
                if (binding.getKind() == 3) {
                    primitiveLength = ((PrimitiveTypeBinding)binding).getLength();
                }
                if (primitiveLength != 0) {
                    PrimitiveTypeValidator.checkLength(primitiveInt, passedPrimitiveType.getPrimitive().getName().toUpperCase(), passedPrimitiveType.hasPrimLength());
                }
            } else if (primitiveInt == 0 || primitiveInt == 14) {
                if (passedPrimitiveType.hasPrimLength()) {
                    problemRequestor.acceptProblem((Node)passedPrimitiveType, 4400, new String[0]);
                }
            } else {
                PrimitiveTypeValidator.checkLength(primitiveInt, passedPrimitiveType.getPrimitive().getName().toUpperCase(), passedPrimitiveType.hasPrimLength());
            }
        }
        if (PrimitiveTypeValidator.checkDecimalSpecified(primitiveInt, passedPrimitiveType.getPrimitive().getName().toUpperCase()) && PrimitiveTypeValidator.checkDecimalRange()) {
            PrimitiveTypeValidator.checkDecimalLength();
        }
        PrimitiveTypeValidator.checkTimestampOrIntervalPattern();
    }

    private static void checkTimestampOrIntervalPattern() {
        int i;
        Integer[] errors;
        DateTimePattern dtPat;
        ITypeBinding binding = passedPrimitiveType.resolveTypeBinding();
        String pattern = null;
        if (binding.getKind() == 3) {
            pattern = ((PrimitiveTypeBinding)binding).getTimeStampOrIntervalPattern();
        }
        if (primitiveInt == 28 && pattern != null && !(dtPat = new DateTimePattern(pattern)).isValidTimeStampPattern()) {
            errors = dtPat.getErrorMessageNumbers();
            i = 0;
            while (i < errors.length) {
                problemRequestor.acceptProblem((Node)passedPrimitiveType, (int)errors[i], new String[]{pattern});
                ++i;
            }
        }
        if (!(primitiveInt != 24 && primitiveInt != 25 || pattern == null || (dtPat = new DateTimePattern(pattern)).isValidIntervalPattern())) {
            errors = dtPat.getErrorMessageNumbers();
            i = 0;
            while (i < errors.length) {
                problemRequestor.acceptProblem((Node)passedPrimitiveType, (int)errors[i], new String[]{pattern});
                ++i;
            }
        }
    }

    protected static int getLogicalLengthInBytes(StructureItemBinding binding) {
        int logicalLengthInBytes = 0;
        if (binding.getChildren().size() > 0) {
            int i = 0;
            while (i < binding.getChildren().size()) {
                StructureItemBinding childBinding = (StructureItemBinding)binding.getChildren().get(i);
                logicalLengthInBytes += PrimitiveTypeValidator.getLogicalLengthInBytes(childBinding);
                ++i;
            }
        } else {
            logicalLengthInBytes = binding.getLengthInBytes();
        }
        return logicalLengthInBytes;
    }

    private static boolean logicalChildrenCheckNeeded(final PrimitiveType myPrimitive, final int primitiveInt, final String primitiveName) {
        BoolASTVisitor visitor = new BoolASTVisitor(){

            @Override
            public boolean visit(StructureItem structureItem) {
                StructureItemBinding binding;
                if (StatementValidator.isValidBinding(structureItem.resolveBinding()) && structureItem.resolveBinding().isDataBinding() && ((IDataBinding)structureItem.resolveBinding()).getKind() == 5 && StatementValidator.isValidBinding(binding = (StructureItemBinding)structureItem.resolveBinding()) && binding.getChildren().size() > 0 && !myPrimitive.hasPrimLength()) {
                    int logicalLengthInBytes = PrimitiveTypeValidator.getLogicalLengthInBytes(binding);
                    PrimitiveTypeValidator.validateLogicalChildrenLength(primitiveInt, PrimitiveTypeValidator.convertBytesToLength(primitiveInt, logicalLengthInBytes), primitiveName);
                    this.retVal = true;
                }
                return false;
            }
        };
        passedPrimitiveType.getParent().accept(visitor);
        return visitor.isValid();
    }

    private static int convertBytesToLength(int primitiveInt, int lengthInBytes) {
        int lengthInDigits = 0;
        switch (primitiveInt) {
            case 2: {
                if (lengthInBytes == 2) {
                    lengthInDigits = 4;
                    break;
                }
                if (lengthInBytes == 4) {
                    lengthInDigits = 9;
                    break;
                }
                if (lengthInBytes == 8) {
                    lengthInDigits = 18;
                    break;
                }
                lengthInDigits = -1;
                break;
            }
            case 9: {
                lengthInDigits = lengthInBytes * 2;
                break;
            }
            case 5: 
            case 20: {
                if (lengthInBytes < 2 || lengthInBytes % 2 != 0) {
                    lengthInDigits = -1;
                    break;
                }
                lengthInDigits = lengthInBytes / 2;
                break;
            }
            case 7: 
            case 12: 
            case 16: {
                lengthInDigits = lengthInBytes * 2 - 1;
                break;
            }
            default: {
                lengthInDigits = lengthInBytes;
            }
        }
        return lengthInDigits;
    }

    private static void validateLogicalChildrenLength(int primitiveInt, int primitiveLength, String primitiveName) throws ClassCastException {
        switch (primitiveInt) {
            case 2: {
                if (primitiveLength == 4 || primitiveLength == 9 || primitiveLength == 18) break;
                problemRequestor.acceptProblem((Node)passedPrimitiveType, 4404, new String[]{primitiveLength != -1 ? Integer.toString(primitiveLength) : "", ownerName, "BIN", BIN_RANGE});
                break;
            }
            case 4: 
            case 11: {
                if (primitiveLength >= 1 && primitiveLength <= Short.MAX_VALUE) break;
                problemRequestor.acceptProblem((Node)passedPrimitiveType, 4404, new String[]{primitiveLength != -1 ? Integer.toString(primitiveLength) : "", ownerName, primitiveName, "(1..32767)"});
                break;
            }
            case 5: 
            case 20: {
                if (primitiveLength >= 1 && primitiveLength <= 16383) break;
                problemRequestor.acceptProblem((Node)passedPrimitiveType, 4404, new String[]{primitiveLength != -1 ? Integer.toString(primitiveLength) : "", ownerName, primitiveName, "(1..16383)"});
                break;
            }
            case 9: {
                if (primitiveLength >= 2 && primitiveLength <= 65534 && primitiveLength % 2 == 0) break;
                problemRequestor.acceptProblem((Node)passedPrimitiveType, 4404, new String[]{primitiveLength != -1 ? Integer.toString(primitiveLength) : "", ownerName, "HEX", HEX_RANGE});
                break;
            }
            case 7: 
            case 13: {
                if (primitiveLength >= 1 && primitiveLength <= 32) break;
                problemRequestor.acceptProblem((Node)passedPrimitiveType, 4404, new String[]{primitiveLength != -1 ? Integer.toString(primitiveLength) : "", ownerName, primitiveName, "(1..32)"});
                break;
            }
            case 12: {
                if (primitiveLength >= 2 && primitiveLength <= 32) break;
                problemRequestor.acceptProblem((Node)passedPrimitiveType, 4404, new String[]{primitiveLength != -1 ? Integer.toString(primitiveLength) : "", ownerName, primitiveName, MONEY_RANGE});
                break;
            }
            case 28: {
                if (primitiveLength >= 2 && primitiveLength <= 20) break;
                problemRequestor.acceptProblem((Node)passedPrimitiveType, 4404, new String[]{primitiveLength != -1 ? Integer.toString(primitiveLength) : "", ownerName, primitiveName, TIMESTAMP_RANGE});
                break;
            }
            case 24: 
            case 25: {
                if (primitiveLength >= 3 && primitiveLength <= 28) break;
                problemRequestor.acceptProblem((Node)passedPrimitiveType, 4404, new String[]{primitiveLength != -1 ? Integer.toString(primitiveLength) : "", ownerName, primitiveName, INTERVAL_RANGE});
                break;
            }
            case 15: 
            case 16: {
                if (primitiveLength >= 1 && primitiveLength <= 18) break;
                problemRequestor.acceptProblem((Node)passedPrimitiveType, 4404, new String[]{primitiveLength != -1 ? Integer.toString(primitiveLength) : "", ownerName, primitiveName, NUMC_RANGE});
                break;
            }
            case 8: {
                if (!passedPrimitiveType.hasPrimLength() || primitiveLength == 8) break;
                problemRequestor.acceptProblem((Node)passedPrimitiveType, 4410, new String[]{Integer.toString(primitiveLength), ownerName, "FLOAT", "(8)"});
                break;
            }
            case 17: {
                if (!passedPrimitiveType.hasPrimLength() || primitiveLength == 4) break;
                problemRequestor.acceptProblem((Node)passedPrimitiveType, 4410, new String[]{Integer.toString(primitiveLength), ownerName, "SMALLFLOAT", "(4)"});
                break;
            }
            case 10: {
                if (!passedPrimitiveType.hasPrimLength() || primitiveLength == 9) break;
                problemRequestor.acceptProblem((Node)passedPrimitiveType, 4410, new String[]{Integer.toString(primitiveLength), ownerName, "INT", INT_RANGE});
                break;
            }
            case 1: {
                if (!passedPrimitiveType.hasPrimLength() || primitiveLength == 18) break;
                problemRequestor.acceptProblem((Node)passedPrimitiveType, 4410, new String[]{Integer.toString(primitiveLength), ownerName, "BIGINT", BIGINT_RANGE});
                break;
            }
            case 18: {
                if (!passedPrimitiveType.hasPrimLength() || primitiveLength == 4) break;
                problemRequestor.acceptProblem((Node)passedPrimitiveType, 4410, new String[]{Integer.toString(primitiveLength), ownerName, "SMALLINT", "(4)"});
            }
        }
    }

    public static void checkLength(int primitiveInt, String primitiveName, boolean lengthDefined) {
        try {
            ITypeBinding binding;
            int primitiveLength = 0;
            if (lengthDefined && (binding = passedPrimitiveType.resolveTypeBinding()).getKind() == 3) {
                primitiveLength = ((PrimitiveTypeBinding)binding).getLength();
            }
            switch (primitiveInt) {
                case 2: {
                    if (primitiveLength != 4 && primitiveLength != 9 && primitiveLength != 18) {
                        PrimitiveTypeValidator.issueWrongOrMissingLengthError(primitiveLength, primitiveName, BIN_RANGE, lengthDefined);
                    }
                    break;
                }
                case 4: {
                    if (primitiveLength < 1 || primitiveLength > Short.MAX_VALUE) {
                        PrimitiveTypeValidator.issueWrongOrMissingLengthError(primitiveLength, primitiveName, "(1..32767)", lengthDefined);
                    }
                    break;
                }
                case 11: {
                    if (primitiveLength < 1 || primitiveLength > Short.MAX_VALUE) {
                        PrimitiveTypeValidator.issueWrongOrMissingLengthError(primitiveLength, primitiveName, "(1..32767)", lengthDefined);
                    }
                    break;
                }
                case 5: 
                case 20: {
                    if (primitiveLength < 1 || primitiveLength > 16383) {
                        PrimitiveTypeValidator.issueWrongOrMissingLengthError(primitiveLength, primitiveName, "(1..16383)", lengthDefined);
                    }
                    break;
                }
                case 9: {
                    if (primitiveLength < 2 || primitiveLength > 65534 || primitiveLength % 2 != 0) {
                        PrimitiveTypeValidator.issueWrongOrMissingLengthError(primitiveLength, primitiveName, HEX_RANGE, lengthDefined);
                    }
                    break;
                }
                case 15: 
                case 16: {
                    if (primitiveLength < 1 || primitiveLength > 18) {
                        PrimitiveTypeValidator.issueWrongOrMissingLengthError(primitiveLength, primitiveName, NUMC_RANGE, lengthDefined);
                    }
                    break;
                }
                case 13: {
                    if (primitiveLength < 1 || primitiveLength > 32) {
                        PrimitiveTypeValidator.issueWrongOrMissingLengthError(primitiveLength, primitiveName, "(1..32)", lengthDefined);
                    }
                    break;
                }
                case 7: {
                    if (primitiveLength < 0 || primitiveLength > 32) {
                        PrimitiveTypeValidator.issueWrongOrMissingLengthError(primitiveLength, primitiveName, "(1..32)", lengthDefined);
                    }
                    break;
                }
                case 12: {
                    if (primitiveLength != 0 && (primitiveLength < 2 || primitiveLength > 32)) {
                        PrimitiveTypeValidator.issueWrongOrMissingLengthError(primitiveLength, primitiveName, MONEY_RANGE, lengthDefined);
                    }
                    break;
                }
                case 21: 
                case 22: {
                    break;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }

    private static void issueWrongOrMissingLengthError(int primitiveLength, String typeString, String rangeString, boolean lengthDefined) {
        if (lengthDefined) {
            problemRequestor.acceptProblem((Node)passedPrimitiveType, 4401, new String[]{Integer.toString(primitiveLength), ownerName, typeString, rangeString});
        } else {
            problemRequestor.acceptProblem((Node)passedPrimitiveType, 4350, new String[]{typeString});
        }
    }

    public static boolean checkDecimalSpecified(int primitiveInt, String primitiveName) {
        ITypeBinding binding = passedPrimitiveType.resolveTypeBinding();
        if (binding.getKind() == 3) {
            if (passedPrimitiveType.hasPrimDecimals() && ((PrimitiveTypeBinding)binding).getDecimals() != 0) {
                if (primitiveInt != 2 && primitiveInt != 7 && primitiveInt != 13 && primitiveInt != 15 && primitiveInt != 16 && primitiveInt != 12) {
                    problemRequestor.acceptProblem((Node)passedPrimitiveType, 3005, new String[]{ownerName, primitiveName});
                    return false;
                }
                return true;
            }
            return true;
        }
        return true;
    }

    public static boolean checkDecimalRange() {
        ITypeBinding binding = passedPrimitiveType.resolveTypeBinding();
        if (binding.getKind() == 3) {
            int decimals = ((PrimitiveTypeBinding)binding).getDecimals();
            int primitiveInt = passedPrimitiveType.getPrimitive().getType();
            if (!(primitiveInt != 2 && primitiveInt != 15 && primitiveInt != 16 || decimals >= 0 && decimals <= 18)) {
                problemRequestor.acceptProblem((Node)passedPrimitiveType, 4402, new String[]{String.valueOf(decimals), ownerName, NUMC_RANGE});
                return false;
            }
            if (!(primitiveInt != 7 && primitiveInt != 13 && primitiveInt != 12 || decimals >= 0 && decimals <= 32)) {
                problemRequestor.acceptProblem((Node)passedPrimitiveType, 4402, new String[]{String.valueOf(decimals), ownerName, "(1..32)"});
                return false;
            }
            return true;
        }
        return true;
    }

    public static void checkDecimalLength() {
        try {
            ITypeBinding binding = passedPrimitiveType.resolveTypeBinding();
            if (binding.getKind() == 3) {
                int length = ((PrimitiveTypeBinding)binding).getLength();
                int decimals = ((PrimitiveTypeBinding)binding).getDecimals();
                if (length > 0 && decimals > length) {
                    problemRequestor.acceptProblem((Node)passedPrimitiveType, 4403, new String[]{String.valueOf(decimals), ownerName, String.valueOf(length)});
                }
            }
        }
        catch (NumberFormatException exception) {
            problemRequestor.acceptProblem((Node)passedPrimitiveType, 3224, new String[]{exception.getLocalizedMessage(), String.valueOf(Integer.MAX_VALUE)});
        }
    }

    public static boolean isNumericPrimitive(PrimitiveType myPrimitiveType) {
        Primitive type = myPrimitiveType.getPrimitive();
        return Primitive.isNumericType(type);
    }

    public static boolean isStringPrimitive(PrimitiveType myPrimitiveType) {
        Primitive type = myPrimitiveType.getPrimitive();
        return Primitive.isStringType(type);
    }

    public static boolean isDateTimePrimitive(PrimitiveType myPrimitiveType) {
        Primitive type = myPrimitiveType.getPrimitive();
        return Primitive.isDateTimeType(type);
    }

    public static boolean isNonHexStringPrimitive(PrimitiveType myPrimitiveType) {
        int type = myPrimitiveType.getPrimitive().getType();
        switch (type) {
            case 4: 
            case 5: 
            case 11: 
            case 20: {
                return true;
            }
        }
        return false;
    }

    public static boolean isDecimalAllowed(PrimitiveType myPrimitiveType) {
        int primitive = myPrimitiveType.getPrimitive().getType();
        return primitive == 2 || primitive == 7 || primitive == 13 || primitive == 15 || primitive == 16 || primitive == 8 || primitive == 17 || primitive == 12;
    }

    private static class BoolASTVisitor
    extends AbstractASTVisitor {
        boolean retVal = false;

        public boolean isValid() {
            return this.retVal;
        }
    }

    public static class DateTimePattern {
        private String[] components = null;
        private boolean isValidPattern = true;
        private Set errorMessageNumbers = new TreeSet();
        String text;
        static final List VALID_CHARS = new ArrayList<Character>(Arrays.asList(new Character('y'), new Character('M'), new Character('d'), new Character('h'), new Character('m'), new Character('s'), new Character('f')));
        private static Map maxOccurences = new HashMap();

        static {
            maxOccurences.put(new Character('y'), new Integer(4));
            maxOccurences.put(new Character('M'), new Integer(2));
            maxOccurences.put(new Character('d'), new Integer(2));
            maxOccurences.put(new Character('h'), new Integer(2));
            maxOccurences.put(new Character('m'), new Integer(2));
            maxOccurences.put(new Character('s'), new Integer(2));
            maxOccurences.put(new Character('f'), new Integer(6));
        }

        public DateTimePattern(String atext) {
            this.text = atext;
            if (this.text.startsWith("\"") && this.text.endsWith("\"")) {
                this.text = atext.substring(1, atext.length() - 1);
            }
            if (this.text.length() == 0) {
                this.isValidPattern = false;
                this.errorMessageNumbers.add(new Integer(7635));
                return;
            }
            StringBuffer component = new StringBuffer();
            ArrayList<String> componentsList = new ArrayList<String>();
            char currentChar = this.text.charAt(0);
            int i = 0;
            while (i < this.text.length() && this.isValidPattern) {
                char ch = this.text.charAt(i);
                if (!VALID_CHARS.contains(new Character(Character.toLowerCase(ch)))) {
                    this.isValidPattern = false;
                    this.errorMessageNumbers.add(new Integer(7625));
                } else {
                    if (Character.toLowerCase(currentChar) != Character.toLowerCase(ch)) {
                        componentsList.add(component.toString());
                        component = new StringBuffer();
                        currentChar = ch;
                    }
                    component.append(ch);
                }
                ++i;
            }
            if (component.toString().length() != 0) {
                componentsList.add(component.toString());
            }
            this.components = componentsList.toArray(new String[0]);
        }

        private void checkOrder() {
            char currentChar = this.components[0].charAt(0);
            if (currentChar == 'm' && this.components.length > 1 && Character.toLowerCase(this.components[1].charAt(0)) == 'd') {
                currentChar = 'M';
            }
            int currentIndex = VALID_CHARS.indexOf(new Character(currentChar == 'M' ? currentChar : Character.toLowerCase(currentChar)));
            int i = 1;
            while (i < this.components.length && this.isValidPattern) {
                char nextChar = this.components[i].charAt(0);
                if (nextChar == 'm' && Character.toLowerCase(currentChar) == 'y') {
                    nextChar = 'M';
                }
                int nextIndex = VALID_CHARS.indexOf(new Character(nextChar == 'M' ? nextChar : Character.toLowerCase(nextChar)));
                if (nextChar != currentChar) {
                    boolean nextCharValid;
                    boolean bl = Character.toLowerCase(currentChar) == 'y' ? Character.toLowerCase(nextChar) == 'm' : (nextCharValid = Character.toLowerCase(nextChar) == Character.toLowerCase(((Character)VALID_CHARS.get(currentIndex + 1)).charValue()));
                    if (!nextCharValid) {
                        this.isValidPattern = false;
                        this.errorMessageNumbers.add(nextIndex < currentIndex ? new Integer(7626) : new Integer(7634));
                    }
                }
                currentChar = nextChar;
                currentIndex = nextIndex;
                ++i;
            }
        }

        private void checkOccurences(int firstFieldAllowedLength) {
            int[] occurenceMessages = new int[]{7627, 7628, 7629, 7630, 7631, 7632, 7633};
            int i = 0;
            while (i < this.components.length) {
                char currentChar = this.components[i].charAt(0);
                boolean isValid = false;
                if (i == 0 && firstFieldAllowedLength != -1) {
                    isValid = this.components[i].length() <= firstFieldAllowedLength;
                } else if (Character.toLowerCase(currentChar) == 'f') {
                    isValid = this.components[i].length() <= (Integer)maxOccurences.get(new Character(Character.toLowerCase(currentChar)));
                } else {
                    boolean bl = isValid = this.components[i].length() == ((Integer)maxOccurences.get(new Character(currentChar == 'M' ? currentChar : Character.toLowerCase(currentChar)))).intValue();
                }
                if (!isValid) {
                    this.isValidPattern = false;
                    char lookupChar = currentChar == 'M' ? currentChar : (currentChar == 'm' && this.isMonthSpanInterval() ? (char)'M' : Character.toLowerCase(currentChar));
                    if (i == 0 && firstFieldAllowedLength != -1) {
                        this.errorMessageNumbers.add(new Integer(7624));
                    } else {
                        this.errorMessageNumbers.add(new Integer(occurenceMessages[VALID_CHARS.indexOf(new Character(lookupChar))]));
                    }
                }
                ++i;
            }
        }

        private void checkIntervalSpan() {
            boolean spanValid = true;
            char firstChar = Character.toLowerCase(this.components[0].charAt(0));
            char lastChar = Character.toLowerCase(this.components[this.components.length - 1].charAt(0));
            if (firstChar == 'y') {
                spanValid = lastChar == 'm' ? this.components.length == 2 : lastChar == 'y';
            } else if (firstChar == 'm') {
                boolean bl = this.components.length == 1 ? true : (spanValid = this.components[1].charAt(0) != 'd');
            }
            if (!spanValid) {
                this.isValidPattern = false;
                this.errorMessageNumbers.add(new Integer(7636));
            }
        }

        public boolean isValidTimeStampPattern() {
            if (!this.isValidPattern) {
                return false;
            }
            this.checkOrder();
            if (!this.isValidPattern) {
                return false;
            }
            this.checkOccurences(-1);
            return this.isValidPattern;
        }

        public boolean isValidIntervalPattern() {
            if (!this.isValidPattern) {
                return false;
            }
            this.checkOrder();
            if (!this.isValidPattern) {
                return false;
            }
            this.checkOccurences(9);
            if (!this.isValidPattern) {
                return false;
            }
            this.checkIntervalSpan();
            return this.isValidPattern;
        }

        public Integer[] getErrorMessageNumbers() {
            return this.errorMessageNumbers.toArray(new Integer[0]);
        }

        public String[] getComponents() {
            return this.components;
        }

        public int length() {
            int len = 0;
            int i = 0;
            while (i < this.components.length) {
                len += this.components[i].length();
                ++i;
            }
            return len;
        }

        public boolean isMonthSpanInterval() {
            char firstChar = this.components[0].charAt(0);
            return Character.toLowerCase(firstChar) == 'y' || this.components.length == 1 && 'M' == firstChar;
        }

        public boolean isSecondSpanInterval() {
            return !this.isMonthSpanInterval();
        }
    }

    private static class ParentAbstractASTVisitor
    extends DefaultASTVisitor {
        private ParentAbstractASTVisitor() {
        }

        @Override
        public boolean visit(ClassDataDeclaration classDataDeclaration) {
            if (classDataDeclaration.getNames().size() > 0) {
                ownerName = ((Expression)classDataDeclaration.getNames().get(0)).getCanonicalString();
            }
            return false;
        }

        @Override
        public boolean visit(FunctionDataDeclaration functionDataDeclaration) {
            if (functionDataDeclaration.getNames().size() > 0) {
                ownerName = ((Expression)functionDataDeclaration.getNames().get(0)).getCanonicalString();
            }
            return false;
        }

        @Override
        public boolean visit(FunctionParameter functionParameter) {
            ownerName = functionParameter.getName().getCanonicalName();
            return false;
        }

        @Override
        public boolean visit(ProgramParameter programParameter) {
            ownerName = programParameter.getName().getCanonicalName();
            return false;
        }

        @Override
        public boolean visit(StructureItem structureItem) {
            ownerName = structureItem.isEmbedded() ? "embed" : (structureItem.isFiller() ? "*" : structureItem.getName().getCanonicalName());
            return false;
        }

        @Override
        public boolean visit(ReturnsDeclaration returnStatement) {
            ownerName = "return";
            return false;
        }

        @Override
        public boolean visit(ArrayType arrayType) {
            arrayType.getParent().accept(new ParentAbstractASTVisitor());
            return false;
        }

        @Override
        public boolean visit(IsAExpression isAExpression) {
            ownerName = passedPrimitiveType.getCanonicalName();
            return false;
        }

        @Override
        public boolean visit(AsExpression asExpression) {
            ownerName = passedPrimitiveType.getCanonicalName();
            return false;
        }

        @Override
        public boolean visit(DataItem dataItem) {
            ownerName = dataItem.getName().getCanonicalName();
            return false;
        }
    }
}

