/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.egl2mof;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.edt.compiler.Context;
import org.eclipse.edt.compiler.binding.AnnotationBinding;
import org.eclipse.edt.compiler.binding.AnnotationBindingForElement;
import org.eclipse.edt.compiler.binding.AnnotationFieldBinding;
import org.eclipse.edt.compiler.binding.ArrayDictionaryBinding;
import org.eclipse.edt.compiler.binding.ArrayTypeBinding;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.ClassConstantBinding;
import org.eclipse.edt.compiler.binding.ClassFieldBinding;
import org.eclipse.edt.compiler.binding.ConstructorBinding;
import org.eclipse.edt.compiler.binding.DataBinding;
import org.eclipse.edt.compiler.binding.DictionaryBinding;
import org.eclipse.edt.compiler.binding.EnumerationDataBinding;
import org.eclipse.edt.compiler.binding.ExternalTypeBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordFieldBinding;
import org.eclipse.edt.compiler.binding.FormBinding;
import org.eclipse.edt.compiler.binding.FormFieldBinding;
import org.eclipse.edt.compiler.binding.FormGroupBinding;
import org.eclipse.edt.compiler.binding.FunctionBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.IPartSubTypeAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.LibraryBinding;
import org.eclipse.edt.compiler.binding.MultiplyOccuringItemTypeBinding;
import org.eclipse.edt.compiler.binding.NestedFunctionBinding;
import org.eclipse.edt.compiler.binding.PartBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.binding.StructureItemBinding;
import org.eclipse.edt.compiler.binding.SystemEnumerationDataBinding;
import org.eclipse.edt.compiler.binding.annotationType.AnnotationTypeBindingImpl;
import org.eclipse.edt.compiler.core.Boolean;
import org.eclipse.edt.compiler.core.IEGLConstants;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.ExternalType;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.internal.core.builder.CircularBuildRequestException;
import org.eclipse.edt.compiler.internal.core.lookup.DefaultCompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.utils.ExpressionParser;
import org.eclipse.edt.compiler.internal.egl2mof.Egl2Mof;
import org.eclipse.edt.compiler.internal.sdk.compile.ASTManager;
import org.eclipse.edt.compiler.internal.sdk.compile.SourcePathInfo;
import org.eclipse.edt.mof.EClass;
import org.eclipse.edt.mof.EClassifier;
import org.eclipse.edt.mof.EEnum;
import org.eclipse.edt.mof.EEnumLiteral;
import org.eclipse.edt.mof.EField;
import org.eclipse.edt.mof.EGenericType;
import org.eclipse.edt.mof.EMember;
import org.eclipse.edt.mof.EMemberContainer;
import org.eclipse.edt.mof.EMetadataObject;
import org.eclipse.edt.mof.EMetadataType;
import org.eclipse.edt.mof.EModelElement;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.EType;
import org.eclipse.edt.mof.MofFactory;
import org.eclipse.edt.mof.MofSerializable;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.AnnotationType;
import org.eclipse.edt.mof.egl.ArrayType;
import org.eclipse.edt.mof.egl.Classifier;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.ElementKind;
import org.eclipse.edt.mof.egl.Form;
import org.eclipse.edt.mof.egl.FormField;
import org.eclipse.edt.mof.egl.FormGroup;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.GenericType;
import org.eclipse.edt.mof.egl.InvalidName;
import org.eclipse.edt.mof.egl.IrFactory;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.MemberAccess;
import org.eclipse.edt.mof.egl.MemberName;
import org.eclipse.edt.mof.egl.MofConversion;
import org.eclipse.edt.mof.egl.Name;
import org.eclipse.edt.mof.egl.ParameterizableType;
import org.eclipse.edt.mof.egl.ParameterizedType;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.PartName;
import org.eclipse.edt.mof.egl.Stereotype;
import org.eclipse.edt.mof.egl.StereotypeType;
import org.eclipse.edt.mof.egl.StructuredField;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.TypeName;
import org.eclipse.edt.mof.egl.TypeParameter;
import org.eclipse.edt.mof.egl.TypedElement;
import org.eclipse.edt.mof.egl.lookup.ProxyElement;
import org.eclipse.edt.mof.egl.lookup.ProxyPart;
import org.eclipse.edt.mof.egl.utils.InternUtil;
import org.eclipse.edt.mof.egl.utils.TimeStampAndIntervalPatternFixer;
import org.eclipse.edt.mof.serialization.DeserializationException;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.serialization.MofObjectNotFoundException;
import org.eclipse.edt.mof.serialization.ProxyEClass;
import org.eclipse.edt.mof.serialization.ProxyEObject;
import org.eclipse.edt.mof.utils.EList;

abstract class Egl2MofBase
extends AbstractASTVisitor
implements MofConversion {
    protected static Map<String, MofSerializable> processed = new HashMap<String, MofSerializable>();
    protected static Map<String, ProxyPart> proxyParts = new HashMap<String, ProxyPart>();
    protected Stack<MofSerializable> partProcessingStack = new Stack();
    protected static String TempEClassMarker = "eze_temp";
    protected static String[] reflectPackage = new String[]{"egl", "lang", "reflect"};
    MofFactory mof;
    IrFactory factory;
    IEnvironment env;
    Context context;
    boolean inMofContext = false;
    boolean inMofProxyContext = false;
    boolean inEMetadataTypeContext = false;
    boolean inAnnotationTypeContext = false;
    boolean visitFunctionBody = false;
    public Stack<Object> stack;
    public Map<IBinding, EObject> eObjects;
    public Map<IBinding, ProxyEObject> proxies;

    Egl2MofBase(IEnvironment env) {
        this.env = env;
        this.mof = MofFactory.INSTANCE;
        this.factory = IrFactory.INSTANCE;
        this.stack = new Stack();
        this.eObjects = new HashMap<IBinding, EObject>();
        this.proxies = new HashMap<IBinding, ProxyEObject>();
    }

    public void setEnvironment(IEnvironment env) {
        this.env = env;
    }

    protected void eStackPush(EObject obj, IBinding element) {
        this.stack.push(obj);
        this.eObjects.put(element, obj);
    }

    protected EObject eStackPop() {
        return (EObject)this.stack.pop();
    }

    protected MofSerializable getPartBeingProcessed() {
        return this.partProcessingStack.isEmpty() ? null : this.partProcessingStack.peek();
    }

    protected EObject getEObjectFor(IBinding element) {
        if (element == null) {
            return null;
        }
        IBinding key = element instanceof NestedFunctionBinding ? ((NestedFunctionBinding)element).getType() : element;
        Object result = this.eObjects.get(key);
        if (result == null) {
            result = (EObject)this.proxies.get(key);
        }
        if (result == null) {
            result = this.inMofContext ? new ProxyEObject() : new ProxyElement();
            this.proxies.put(key, (ProxyEObject)result);
        }
        return result;
    }

    protected IAnnotationBinding getAnnotation(IBinding binding, String typeName) {
        if (binding != null) {
            FlexibleRecordBinding record;
            for (IAnnotationBinding ann : binding.getAnnotations()) {
                if (!ann.getCaseSensitiveName().equalsIgnoreCase(typeName)) continue;
                return ann;
            }
            if (binding instanceof AnnotationTypeBindingImpl && (record = ((AnnotationTypeBindingImpl)binding).getAnnotationRecord()) != null) {
                for (IAnnotationBinding ann : record.getAnnotations()) {
                    if (!ann.getCaseSensitiveName().equalsIgnoreCase(typeName)) continue;
                    return ann;
                }
            }
        }
        return null;
    }

    protected void createAnnotations(IBinding binding, EModelElement element) {
        if (!Binding.isValidBinding(binding)) {
            return;
        }
        for (AnnotationBinding annotation : binding.getAnnotations()) {
            if (annotation instanceof AnnotationBindingForElement) continue;
            element.getMetadataList().add((EMetadataObject)this.mofValueFrom(annotation));
        }
    }

    protected void createAnnotations(IPartBinding binding, EClass eClass) {
        IAnnotationBinding subtype = binding.getSubTypeAnnotationBinding();
        for (AnnotationBinding annotation : binding.getAnnotations()) {
            if (subtype == annotation || annotation instanceof AnnotationBindingForElement) continue;
            eClass.getMetadataList().add((EMetadataObject)this.mofValueFrom(annotation));
        }
    }

    protected void createAnnotations(IPartBinding binding, AnnotationType eClass) {
        IAnnotationBinding subtype = binding.getSubTypeAnnotationBinding();
        for (AnnotationBinding annotation : binding.getAnnotations()) {
            if (subtype == annotation || annotation instanceof AnnotationBindingForElement) continue;
            eClass.getAnnotations().add((Annotation)this.mofValueFrom(annotation));
        }
    }

    protected void createAnnotations(IBinding binding, Element element) {
        if (!Binding.isValidBinding(binding)) {
            return;
        }
        for (AnnotationBinding annotation : binding.getAnnotations()) {
            if (annotation instanceof AnnotationBindingForElement) continue;
            element.getAnnotations().add(this.createAnnotation(binding, annotation));
        }
    }

    protected void createElementAnnotations(StructureItemBinding binding, StructuredField field) {
        if (field.getOccurs() > 1) {
            for (IAnnotationBinding annBinding : binding.getAnnotations()) {
                if (!(annBinding instanceof AnnotationBindingForElement)) continue;
                int index = ((AnnotationBindingForElement)annBinding).getIndex();
                Annotation eAnn = this.createAnnotation(binding, annBinding);
                field.getElementAnnotations(index).add(eAnn);
            }
        }
    }

    protected void createElementAnnotations(FormFieldBinding binding, FormField field) {
        if (field.getOccurs() > 1) {
            for (IAnnotationBinding annBinding : binding.getAnnotations()) {
                if (!(annBinding instanceof AnnotationBindingForElement)) continue;
                int index = ((AnnotationBindingForElement)annBinding).getIndex();
                Annotation eAnn = this.createAnnotation(binding, annBinding);
                field.getElementAnnotations(index).add(eAnn);
            }
        }
    }

    protected void createAnnotations(IPartBinding binding, Part part) {
        IAnnotationBinding subtype = binding.getSubTypeAnnotationBinding();
        boolean bypass = subtype != null && this.isEGLReflectType(binding);
        for (AnnotationBinding annotation : binding.getAnnotations()) {
            if (bypass && subtype == annotation || annotation instanceof AnnotationBindingForElement) continue;
            if (this.inMofContext) {
                ((EClass)part).getMetadataList().add((EMetadataObject)this.mofValueFrom(annotation));
                continue;
            }
            part.getAnnotations().add((Annotation)this.mofValueFrom(annotation));
        }
    }

    private Annotation createAnnotation(IBinding binding, IAnnotationBinding annBinding) {
        EObject ann = this.mofValueFrom(annBinding);
        if (ann instanceof Annotation) {
            return (Annotation)ann;
        }
        throw new IllegalArgumentException("Type " + ann.getEClass().getETypeSignature() + " is not an AnnotationType");
    }

    protected MemberName createMemberName(IBinding binding) {
        MemberName name = this.factory.createMemberName();
        name.setId(binding.getCaseSensitiveName());
        name.setMember((Member)this.getEObjectFor(binding));
        return name;
    }

    protected Object getFieldValue(IAnnotationBinding annotationBinding, String fieldName) {
        Object result = null;
        for (AnnotationFieldBinding field : annotationBinding.getAnnotationFields()) {
            if (field.getCaseSensitiveName().equalsIgnoreCase(fieldName) && (result = this.getValue(null, field.getValue(), false)) != null) break;
        }
        return result;
    }

    protected Object getValue(IBinding binding, Object annotationValue, boolean isMetaDataFieldValue) {
        if (annotationValue == IBinding.NOT_FOUND_BINDING) {
            InvalidName name = this.factory.createInvalidName();
            name.setId("EZENOTFOUND");
            return name;
        }
        if (annotationValue instanceof Integer[] || annotationValue instanceof Integer[][] || annotationValue instanceof int[] || annotationValue instanceof int[][] || annotationValue instanceof String[] || annotationValue instanceof String[][]) {
            return annotationValue;
        }
        if (annotationValue == Boolean.NO) {
            return java.lang.Boolean.FALSE;
        }
        if (annotationValue == Boolean.YES) {
            return java.lang.Boolean.TRUE;
        }
        if (annotationValue instanceof SystemEnumerationDataBinding || annotationValue instanceof SystemEnumerationDataBinding[]) {
            return annotationValue;
        }
        if (annotationValue instanceof EnumerationDataBinding) {
            return annotationValue;
        }
        if (annotationValue instanceof PartBinding) {
            EObject value = this.mofTypeFor((PartBinding)annotationValue);
            if (value instanceof Part && !isMetaDataFieldValue) {
                value = this.createTypeName((Type)((Part)value));
            }
            return value;
        }
        if (annotationValue instanceof IFunctionBinding) {
            IFunctionBinding functionBinding = (IFunctionBinding)annotationValue;
            IPartBinding declarer = functionBinding.getDeclarer();
            if (declarer != null && declarer.getKind() == 11) {
                PartName nameType = this.factory.createPartName();
                nameType.setId(declarer.getCaseSensitiveName());
                nameType.setPackageName(this.asString(declarer.getPackageName()));
                MemberAccess access = this.factory.createMemberAccess();
                access.setId(functionBinding.getCaseSensitiveName());
                access.setQualifier((org.eclipse.edt.mof.egl.Expression)nameType);
                return access;
            }
            return this.createMemberName(functionBinding);
        }
        if (annotationValue instanceof IAnnotationBinding) {
            return this.mofValueFrom((IAnnotationBinding)annotationValue);
        }
        if (annotationValue instanceof Expression) {
            ((Expression)annotationValue).accept(this);
            return (org.eclipse.edt.mof.egl.Expression)this.stack.pop();
        }
        if (annotationValue instanceof IDataBinding) {
            ITypeBinding container;
            IDataBinding valueBinding = (IDataBinding)annotationValue;
            IPartBinding declarer = valueBinding.getDeclaringPart();
            if (declarer != null && declarer.getKind() == 11 && declarer != this.getLibraryContainer(binding)) {
                PartName nameType = this.factory.createPartName();
                nameType.setId(declarer.getCaseSensitiveName());
                nameType.setPackageName(this.asString(declarer.getPackageName()));
                MemberAccess access = this.factory.createMemberAccess();
                access.setId(binding.getCaseSensitiveName());
                access.setQualifier((org.eclipse.edt.mof.egl.Expression)nameType);
                return access;
            }
            if (Binding.isValidBinding(valueBinding) && valueBinding.getKind() == 8) {
                Expression expr = this.createExpression(binding, (IDataBinding)annotationValue, false);
                expr.accept(this);
                return (Expression)this.stack.pop();
            }
            if (binding instanceof DataBinding && (container = this.getContainer(valueBinding)) != null && container == ((DataBinding)valueBinding).getType()) {
                Expression expr = this.createExpression(binding, (IDataBinding)annotationValue, true);
                expr.accept(this);
                return (Expression)this.stack.pop();
            }
            return this.createMemberName((IDataBinding)annotationValue);
        }
        if (annotationValue instanceof ITypeBinding) {
            EObject value = this.mofTypeFor((ITypeBinding)annotationValue);
            if (value instanceof Type) {
                value = this.createTypeName((Type)value);
            }
            return value;
        }
        if (annotationValue instanceof Object[]) {
            Object[] arrVal = (Object[])annotationValue;
            Object[] value = new Object[arrVal.length];
            int i = 0;
            while (i < value.length) {
                value[i] = this.getValue(binding, arrVal[i], isMetaDataFieldValue);
                ++i;
            }
            return value;
        }
        return annotationValue;
    }

    private String asString(String[] strArr) {
        if (strArr == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < strArr.length) {
            if (i > 0) {
                buffer.append(".");
            }
            buffer.append(strArr[i]);
            ++i;
        }
        return buffer.toString();
    }

    private TypeName createTypeName(Type type) {
        if (type instanceof Part) {
            Part part = (Part)type;
            PartName partName = this.factory.createPartName();
            partName.setId(part.getId());
            partName.setPackageName(part.getPackageName());
            return partName;
        }
        String key = type.getMofSerializationKey();
        TypeName typeName = this.factory.createTypeName();
        typeName.setId(key);
        return typeName;
    }

    private Expression createExpression(IBinding binding, IDataBinding valueBinding, boolean addImplicitQualifier) {
        SimpleName name = new ExpressionParser(this.getCompilerOptions()).parseAsSimpleName(valueBinding.getCaseSensitiveName());
        name.setDataBinding(valueBinding);
        name.setTypeBinding(valueBinding.getType());
        name.setBinding(valueBinding);
        if (addImplicitQualifier) {
            name.setAttribute(org.eclipse.edt.compiler.core.ast.Name.IMPLICIT_QUALIFIER_DATA_BINDING, binding);
        }
        return name;
    }

    private ICompilerOptions getCompilerOptions() {
        ICompilerOptions compilerOptions = DefaultCompilerOptions.getInstance();
        return compilerOptions;
    }

    private ITypeBinding getContainer(IDataBinding db) {
        if (db.getKind() == 5) {
            return ((StructureItemBinding)db).getEnclosingStructureBinding();
        }
        return db.getDeclaringPart();
    }

    private LibraryBinding getLibraryContainer(IBinding binding) {
        IPartBinding part;
        if (binding == null) {
            return null;
        }
        if (binding instanceof LibraryBinding) {
            return (LibraryBinding)binding;
        }
        if (binding instanceof IDataBinding && (part = ((IDataBinding)binding).getDeclaringPart()) != null && part.getKind() == 11) {
            return (LibraryBinding)part;
        }
        return null;
    }

    protected void eAdd(EObject target, String fieldName, Object value) {
        ((List)target.eGet(fieldName)).add(value);
    }

    private boolean shouldReflect(IAnnotationBinding reflectTypeBinding, String fieldName) {
        IDataBinding binding;
        IPartSubTypeAnnotationTypeBinding subType;
        FlexibleRecordBinding record;
        return reflectTypeBinding == null || !(reflectTypeBinding.getAnnotationType() instanceof IPartSubTypeAnnotationTypeBinding) || (record = (subType = (IPartSubTypeAnnotationTypeBinding)reflectTypeBinding.getAnnotationType()).getAnnotationRecord()) == null || (binding = record.findData(InternUtil.intern((String)fieldName))) == null || binding.getAnnotation(IEGLConstants.PACKAGE_EGL_LANG_REFLECT, "NoReflect") == null;
    }

    private boolean isSpecialNamedElementCase(Object o, EType type) {
        if (o instanceof String && type instanceof EClass) {
            if (((EClass)type).isSubClassOf(this.factory.getNamedElementEClass())) {
                return true;
            }
            EObject newType = this.getMofSerializable(type.getMofSerializationKey());
            if (newType instanceof EClass && ((EClass)newType).isSubClassOf(this.factory.getNamedElementEClass())) {
                return true;
            }
        }
        return false;
    }

    protected void setReflectTypeValues(EObject target, IAnnotationBinding reflectTypeBinding) {
        if (reflectTypeBinding == null) {
            return;
        }
        EClass eClass = target.getEClass();
        for (EField field : eClass.getAllEFields()) {
            Object obj = this.mofValueFrom(this.getFieldValue(reflectTypeBinding, field.getName()));
            if (obj == null || !this.shouldReflect(reflectTypeBinding, field.getName())) continue;
            if (obj instanceof List) {
                for (Object o : (List)obj) {
                    EType type;
                    if (this.isSpecialNamedElementCase(o, type = (EType)((EGenericType)field.getEType()).getETypeArguments().get(0))) {
                        o = this.convertStringValueToNamedElementType((String)o, (EClass)type);
                    }
                    ((List)target.eGet(field)).add(o);
                }
                continue;
            }
            EClassifier type = (EClassifier)field.getEType();
            if (obj instanceof String && type instanceof EClass && ((EClass)type).isSubClassOf(this.mof.getENamedElementClass())) {
                obj = this.convertStringValueToNamedElementType((String)obj, (EClass)type);
            } else if (obj instanceof PartName) {
                obj = ((PartName)obj).getPart();
            }
            if (obj instanceof String && type == this.mof.getETypeClass()) {
                obj = this.createProxyPart((String)obj);
            }
            target.eSet(field, obj);
        }
        if (target instanceof StereotypeType) {
            this.setReflectTypeValues(target, this.getAnnotation(reflectTypeBinding, "Stereotype"));
        }
    }

    protected EObject convertStringValueToNamedElementType(String obj, EClass eClass) {
        EObject result = eClass.newInstance();
        result.eSet("name", (Object)obj);
        return result;
    }

    protected void updateProxyReferences(IBinding element, EObject obj) {
        ProxyEObject proxy = this.proxies.get(element);
        if (proxy != null) {
            proxy.updateReferences((Object)obj);
        }
    }

    protected List<Object> mofValueFrom(Object[] array) {
        EList result = new EList();
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            result.add(this.mofValueFrom(obj));
            ++n2;
        }
        return result;
    }

    protected List<Object> mofValueFrom(List list) {
        EList result = new EList();
        for (Object obj : list) {
            result.add(this.mofValueFrom(obj));
        }
        return result;
    }

    protected Object mofValueFrom(Object value) {
        if (value instanceof IAnnotationBinding) {
            return this.mofValueFrom((IAnnotationBinding)value);
        }
        if (value instanceof ITypeBinding) {
            return this.mofTypeFor((ITypeBinding)value);
        }
        if (value instanceof EnumerationDataBinding) {
            return this.mofValueFrom((EnumerationDataBinding)value);
        }
        if (value instanceof IAnnotationBinding) {
            return this.mofValueFrom((IAnnotationBinding)value);
        }
        if (value instanceof IDataBinding) {
            return this.getEObjectFor((IDataBinding)value);
        }
        if (value instanceof Part) {
            return this.mofValueFrom((Part)value);
        }
        if (value instanceof Object[]) {
            return this.mofValueFrom((Object[])value);
        }
        if (value instanceof List) {
            return this.mofValueFrom((List)value);
        }
        return value;
    }

    protected EObject mofValueFrom(Part part) {
        if (!(part instanceof ProxyPart) && this.isMofProxy(part)) {
            return this.resolveProxy(part);
        }
        return part;
    }

    protected EObject mofValueFrom(IAnnotationBinding binding) {
        Object value;
        if (!Binding.isValidBinding(binding)) {
            return null;
        }
        if (binding.getAnnotationType() instanceof AnnotationTypeBindingImpl) {
            EClass typeClass = (EClass)this.mofTypeFor(binding.getAnnotationType());
            value = typeClass.newInstance();
        } else {
            value = this.isEMetadataObject(binding) ? MofFactory.INSTANCE.createEMetadataObject(true) : IrFactory.INSTANCE.createAnnotation(binding.getCaseSensitiveName());
        }
        for (AnnotationBinding subAnnotation : binding.getAnnotations()) {
            if (subAnnotation instanceof AnnotationFieldBinding) continue;
            if (value instanceof Annotation) {
                ((Annotation)value).getAnnotations().add((Annotation)this.mofValueFrom(subAnnotation));
                continue;
            }
            value.getMetadataList().add((EMetadataObject)this.mofValueFrom(subAnnotation));
        }
        for (AnnotationFieldBinding field : binding.getAnnotationFields()) {
            Object fieldValue = this.mofValueFrom(this.getValue(field, field.getValue(), this.isEMetadataObject(binding)));
            value.eSet(field.getCaseSensitiveName(), fieldValue);
        }
        return value;
    }

    protected Object mofValueFrom(EnumerationDataBinding dataBinding) {
        Object convertedValue;
        ITypeBinding typeBinding = dataBinding.getType();
        String name = dataBinding.getCaseSensitiveName();
        if (typeBinding.getCaseSensitiveName().equals("ElementKind")) {
            if (this.inEMetadataTypeContext) {
                convertedValue = name.equals(ElementKind_ExternalTypePart) ? this.getMofSerializable("org.eclipse.edt.mof.EClass") : (name.equals(ElementKind_Part) ? this.getMofSerializable("org.eclipse.edt.mof.EClass") : (name.equals(ElementKind_FieldMbr) ? this.getMofSerializable("org.eclipse.edt.mof.EField") : (name.equals(ElementKind_FunctionMbr) ? this.getMofSerializable("org.eclipse.edt.mof.EFunction") : this.mof.getEModelElementClass())));
            } else {
                try {
                    Class<?> enumClass = Class.forName("org.eclipse.edt.mof.egl.ElementKind");
                    convertedValue = Enum.valueOf(enumClass, dataBinding.getCaseSensitiveName());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    EEnum enumType = (EEnum)this.getMofSerializable("org.eclipse.edt.mof.egl.ElementKind");
                    convertedValue = enumType.getEEnumLiteral(dataBinding.getCaseSensitiveName());
                }
            }
        } else {
            try {
                Class<?> enumClass = Class.forName(typeBinding.getPackageQualifiedName());
                convertedValue = Enum.valueOf(enumClass, dataBinding.getCaseSensitiveName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                EEnum enumType = (EEnum)this.mofTypeFor(typeBinding);
                convertedValue = enumType.getEEnumLiteral(dataBinding.getCaseSensitiveName());
            }
        }
        return convertedValue;
    }

    protected EClass mofMemberTypeFor(IDataBinding binding) {
        IAnnotationBinding opAnn;
        EClass mbrType = binding instanceof NestedFunctionBinding ? ((opAnn = this.getAnnotation(binding.getType(), "Operation")) == null ? (EClass)this.getMofSerializable("org.eclipse.edt.mof.egl.Function") : (EClass)this.getMofSerializable("org.eclipse.edt.mof.egl.Operation")) : (binding instanceof ConstructorBinding ? (EClass)this.getMofSerializable("org.eclipse.edt.mof.egl.Constructor") : (binding instanceof ClassConstantBinding ? (EClass)this.getMofSerializable("org.eclipse.edt.mof.egl.ConstantField") : (binding instanceof ClassFieldBinding || binding instanceof FlexibleRecordFieldBinding ? (EClass)this.getMofSerializable("org.eclipse.edt.mof.egl.Field") : (binding instanceof StructureItemBinding ? (EClass)this.getMofSerializable("org.eclipse.edt.mof.egl.StructuredField") : (EClass)this.getMofSerializable("org.eclipse.edt.mof.egl.Field")))));
        return mbrType;
    }

    protected EObject mofTypeFromTypedElement(IDataBinding element) {
        ITypeBinding type = null;
        if (element instanceof FunctionBinding) {
            type = ((FunctionBinding)((Object)element)).getReturnType();
        } else if (element instanceof NestedFunctionBinding) {
            type = ((FunctionBinding)((NestedFunctionBinding)element).getType()).getReturnType();
        } else if (element instanceof ConstructorBinding) {
            type = ((ConstructorBinding)element).getDeclaringPart();
        } else if (Binding.isValidBinding(element)) {
            type = element.getType();
        }
        if (type != null) {
            return this.mofTypeFor(type);
        }
        return null;
    }

    protected EObject mofTypeFromASTFor(IPartBinding binding) {
        String partName = binding.getCaseSensitiveName();
        File declaringFile = SourcePathInfo.getInstance().getDeclaringFile(binding.getPackageName(), partName);
        Node partAST = ASTManager.getInstance().getAST(declaringFile, partName);
        Egl2Mof converter = new Egl2Mof(this.env);
        return converter.convert((org.eclipse.edt.compiler.core.ast.Part)partAST, null, null);
    }

    protected EObject mofTypeFor(ITypeBinding type) {
        EObject eType;
        if (!Binding.isValidBinding(type)) {
            return null;
        }
        switch (type.getKind()) {
            case 26: {
                return this.mofTypeFor(((MultiplyOccuringItemTypeBinding)type).getBaseType());
            }
            case 2: {
                ITypeBinding elementType = ((ArrayTypeBinding)type).getElementType();
                EObject mofType = this.mofTypeFor(elementType);
                if (this.inMofContext && mofType instanceof EType) {
                    EGenericType generic = this.mof.createEGenericType(true);
                    generic.setEClassifier((EClassifier)this.mof.getEListEDataType());
                    generic.getETypeArguments().add((EType)mofType);
                    eType = generic;
                    break;
                }
                ArrayType generic = this.factory.createArrayType();
                generic.setClassifier((Classifier)this.getMofSerializable("egl:eglx.lang.EList"));
                generic.getTypeArguments().add((Type)mofType);
                generic.setElementsNullable(elementType.isNullable());
                eType = generic;
                break;
            }
            case 8: {
                FormGroupBinding fgBinding = ((FormBinding)type).getEnclosingFormGroup();
                eType = null;
                if (fgBinding != null) {
                    FormGroup fg = (FormGroup)this.mofTypeFor(fgBinding);
                    for (Form form : fg.getForms()) {
                        if (!form.getName().equalsIgnoreCase(((FormBinding)type).getName())) continue;
                        eType = form;
                        break;
                    }
                }
                if (eType != null) break;
            }
            default: {
                String key = this.mofSerializationKeyFor(type);
                eType = this.getMofSerializable(key);
                if (eType == null && !key.startsWith("egl:") && (this.isAnnotationType(type) || this.isStereotypeType(type))) {
                    key = "egl:" + key;
                    eType = this.getMofSerializable(key);
                }
                if (eType != null) break;
                if (type instanceof IPartBinding) {
                    if (this.inMofContext && this.isMofClass((PartBinding)type) && type instanceof ExternalTypeBinding) {
                        eType = this.createTempEClass((ExternalTypeBinding)type);
                        break;
                    }
                    eType = this.createProxyPart(((IPartBinding)type).getPackageQualifiedName());
                    break;
                }
                if (type instanceof PrimitiveTypeBinding) {
                    PrimitiveTypeBinding prim = (PrimitiveTypeBinding)type;
                    eType = this.createPrimitiveType(key, prim);
                    switch (prim.getPrimitive().getType()) {
                        case 4: 
                        case 5: 
                        case 9: 
                        case 11: 
                        case 20: {
                            this.eSet(eType, "length", (Object)prim.getLength());
                            break;
                        }
                        case 2: 
                        case 7: 
                        case 12: 
                        case 13: {
                            this.eSet(eType, "length", (Object)prim.getLength());
                            this.eSet(eType, "decimals", (Object)prim.getDecimals());
                            break;
                        }
                        case 24: 
                        case 25: 
                        case 26: 
                        case 27: 
                        case 28: {
                            this.eSet(eType, "pattern", (Object)this.getPattern(prim));
                        }
                    }
                    break;
                }
                if (!(type instanceof IAnnotationTypeBinding)) break;
                eType = this.createAnnotationType((IAnnotationTypeBinding)type);
            }
        }
        return eType;
    }

    protected String mofTypeSignatureFor(ITypeBinding type, boolean isArrayType) {
        String typeSignature;
        if (type instanceof PrimitiveTypeBinding) {
            typeSignature = this.mofPrimitiveTypeSignatureFor((PrimitiveTypeBinding)type);
        } else if (type instanceof DictionaryBinding) {
            typeSignature = "egl:eglx.lang.EDictionary";
        } else if (type instanceof ArrayDictionaryBinding) {
            typeSignature = "egl:eglx.lang.EArrayDictionary";
        } else if (type instanceof ArrayTypeBinding) {
            typeSignature = this.inMofContext ? "org.eclipse.edt.mof.EList" : "egl:eglx.lang.EList";
            typeSignature = String.valueOf(typeSignature) + "<" + this.mofTypeSignatureFor(((ArrayTypeBinding)type).getElementType(), isArrayType) + ">";
        } else if (type instanceof IAnnotationTypeBinding) {
            typeSignature = this.inMofContext && !this.inAnnotationTypeContext || this.isEMetadataType(type) ? type.getPackageQualifiedName() : "egl:" + type.getPackageQualifiedName();
        } else if (type instanceof IPartBinding) {
            if (this.isEDTReflectType((IPartBinding)type)) {
                typeSignature = this.mofEDTReflectTypeSignature((IPartBinding)type);
            } else if (this.isMofProxy((IPartBinding)type) && !this.inMofProxyContext) {
                IAnnotationBinding ann = ((IPartBinding)type).getSubTypeAnnotationBinding();
                typeSignature = (String)this.getFieldValue(ann, "packageName");
                if (typeSignature == null) {
                    typeSignature = this.concatWithSeparator(type.getPackageName(), ".");
                }
                typeSignature = String.valueOf(typeSignature) + ".";
                String name = (String)this.getFieldValue(ann, "name");
                if (name == null || "".equals(name)) {
                    name = type.getCaseSensitiveName();
                }
                typeSignature = String.valueOf(typeSignature) + name;
            } else if (this.isReflectType((IPartBinding)type) && !this.inMofProxyContext) {
                IAnnotationBinding ann = ((IPartBinding)type).getSubTypeAnnotationBinding();
                String name = (String)this.getFieldValue(ann, "name");
                if (name == null) {
                    name = type.getCaseSensitiveName();
                }
                typeSignature = this.concatWithSeparator(type.getPackageName(), ".");
                typeSignature = String.valueOf(typeSignature) + ".";
                typeSignature = String.valueOf(typeSignature) + name;
                if (!this.isMofReflectType((IPartBinding)type) && this.isEGLReflectType((IPartBinding)type) || this.inMofProxyContext) {
                    typeSignature = "egl:" + typeSignature;
                }
            } else {
                typeSignature = "egl:" + type.getPackageQualifiedName();
            }
        } else {
            typeSignature = "org.eclipse.edt.mof.EObject";
        }
        return typeSignature;
    }

    boolean isEDTReflectType(IPartBinding binding) {
        String name = binding.getName();
        return name.equalsIgnoreCase("fieldRef") || name.equalsIgnoreCase("internalRef") || name.equalsIgnoreCase("partRef") || name.equalsIgnoreCase("functionRef") || name.equalsIgnoreCase("functionMemberRef") || name.equalsIgnoreCase("typeRef") || name.equalsIgnoreCase("sqlString") || name.equalsIgnoreCase("FieldInTargetRef") || name.equalsIgnoreCase("RecordRef") || name.equalsIgnoreCase("serviceRef");
    }

    String mofEDTReflectTypeSignature(IPartBinding binding) {
        boolean isMofTypeRef;
        boolean bl = isMofTypeRef = this.inMofContext && !this.inAnnotationTypeContext;
        String typeSignature = binding.getName().equalsIgnoreCase("fieldRef") ? (isMofTypeRef ? "org.eclipse.edt.mof.EField" : "egl.lang.reflect.reftypes.EGLFieldRef") : (binding.getName().equalsIgnoreCase("fieldInTargetRef") ? (isMofTypeRef ? "org.eclipse.edt.mof.EModelElement" : "egl.lang.reflect.reftypes.EGLFieldInTargetRef") : (binding.getName().equalsIgnoreCase("internalRef") ? (isMofTypeRef ? "org.eclipse.edt.mof.EModelElement" : "egl.lang.reflect.reftypes.EGLInternalRef") : (binding.getName().equalsIgnoreCase("partRef") ? (isMofTypeRef ? "org.eclipse.edt.mof.EClassifier" : "egl.lang.reflect.reftypes.EGLPartRef") : (binding.getName().equalsIgnoreCase("functionRef") ? (isMofTypeRef ? "org.eclipse.edt.mof.EFunction" : "egl.lang.reflect.reftypes.EGLFunctionRef") : (binding.getName().equalsIgnoreCase("functionMemberRef") ? (isMofTypeRef ? "org.eclipse.edt.mof.EFunction" : "egl.lang.reflect.reftypes.EGLFunctionMemberRef") : (binding.getName().equalsIgnoreCase("typeRef") ? (isMofTypeRef ? "org.eclipse.edt.mof.EType" : "egl.lang.reflect.reftypes.EGLTypeRef") : (binding.getName().equalsIgnoreCase("serviceRef") ? (isMofTypeRef ? "org.eclipse.edt.mof.EClassifier" : "egl.lang.reflect.reftypes.EGLServiceRef") : (binding.getName().equalsIgnoreCase("recordRef") ? (isMofTypeRef ? "org.eclipse.edt.mof.EClassifier" : "egl.lang.reflect.reftypes.EGLRecordRef") : (binding.getName().equalsIgnoreCase("sqlString") ? (isMofTypeRef ? "org.eclipse.edt.mof.EString" : "egl.lang.reflect.reftypes.EGLSQLStringRef") : "org.eclipse.edt.mof.EObject")))))))));
        return typeSignature;
    }

    protected Type mofPrimitiveFor(Primitive type) {
        String key = this.mofPrimitiveSignatureFor(type);
        return (Type)this.getMofSerializable(key);
    }

    protected String mofPrimitiveSignatureFor(Primitive type) {
        String typeSignature;
        switch (type.getType()) {
            case 0: {
                typeSignature = this.inMofContext ? "org.eclipse.edt.mof.JavaObject" : "egl:eglx.lang.EAny";
                break;
            }
            case 3: {
                typeSignature = this.inMofContext ? "org.eclipse.edt.mof.EBoolean" : "egl:eglx.lang.EBoolean";
                break;
            }
            case 10: {
                typeSignature = this.inMofContext ? "org.eclipse.edt.mof.EInt32" : "egl:eglx.lang.EInt";
                break;
            }
            case 19: {
                typeSignature = this.inMofContext ? "org.eclipse.edt.mof.EString" : "egl:eglx.lang.EString";
                break;
            }
            case 1: {
                typeSignature = "egl:eglx.lang.EBigint";
                break;
            }
            case 2: {
                typeSignature = "egl:eglx.lang.AnyBin";
                break;
            }
            case 21: {
                typeSignature = "egl:eglx.lang.AnyBlob";
                break;
            }
            case 4: {
                typeSignature = this.inMofContext ? "org.eclipse.edt.mof.EString" : "egl:eglx.lang.AnyChar";
                break;
            }
            case 22: {
                typeSignature = "egl:eglx.lang.AnyClob";
                break;
            }
            case 23: {
                typeSignature = "egl:eglx.lang.EDate";
                break;
            }
            case 5: {
                typeSignature = "egl:eglx.lang.AnyDBChar";
                break;
            }
            case 7: {
                typeSignature = this.inMofContext ? "org.eclipse.edt.mof.EDecimal" : "egl:eglx.lang.EDecimal";
                break;
            }
            case 8: {
                typeSignature = this.inMofContext ? "org.eclipse.edt.mof.EFloat" : "egl:eglx.lang.EFloat";
                break;
            }
            case 9: {
                typeSignature = "egl:eglx.lang.AnyHex";
                break;
            }
            case 26: {
                typeSignature = "egl:eglx.lang.AnyInterval";
                break;
            }
            case 11: {
                typeSignature = "egl:eglx.lang.AnyMBChar";
                break;
            }
            case 12: {
                typeSignature = "egl:eglx.lang.EDecimal";
                break;
            }
            case 24: {
                typeSignature = "egl:eglx.lang.AnyMonthsInterval";
                break;
            }
            case 13: {
                typeSignature = "egl:eglx.lang.AnyNum";
                break;
            }
            case 14: {
                typeSignature = "egl:eglx.lang.ENumber";
                break;
            }
            case 15: {
                typeSignature = "egl:eglx.lang.AnyNumc";
                break;
            }
            case 16: {
                typeSignature = "egl:eglx.lang.AnyPacf";
                break;
            }
            case 25: {
                typeSignature = "egl:eglx.lang.AnySecondsInterval";
                break;
            }
            case 17: {
                typeSignature = "egl:eglx.lang.ESmallfloat";
                break;
            }
            case 18: {
                typeSignature = "egl:eglx.lang.ESmallint";
                break;
            }
            case 27: {
                typeSignature = "egl:eglx.lang.ETime";
                break;
            }
            case 28: {
                typeSignature = "egl:eglx.lang.ETimestamp";
                break;
            }
            case 20: {
                typeSignature = "egl:eglx.lang.AnyUnicode";
                break;
            }
            default: {
                typeSignature = "egl:eglx.lang.EAny";
            }
        }
        return typeSignature;
    }

    protected String mofPrimitiveTypeSignatureFor(PrimitiveTypeBinding type) {
        String typeSignature = this.mofPrimitiveSignatureFor(type.getPrimitive());
        if (this.inMofContext) {
            return typeSignature;
        }
        switch (type.getPrimitive().getType()) {
            case 4: 
            case 5: 
            case 9: 
            case 11: 
            case 19: 
            case 20: {
                typeSignature = String.valueOf(typeSignature) + (type.getLength() == 0 ? "" : "(" + type.getLength() + ")");
                break;
            }
            case 2: 
            case 7: 
            case 12: 
            case 13: {
                typeSignature = String.valueOf(typeSignature) + (type.getLength() == 0 ? "" : "(" + type.getLength() + ":" + type.getDecimals() + ")");
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                typeSignature = String.valueOf(typeSignature) + (type.getPattern() == null ? "" : "(" + this.getPattern(type) + ")");
                break;
            }
            case 28: {
                typeSignature = String.valueOf(typeSignature) + (type.getPattern() == null ? "" : "(" + this.getPattern(type) + ")");
            }
        }
        return typeSignature;
    }

    private String getPattern(PrimitiveTypeBinding type) {
        return new TimeStampAndIntervalPatternFixer(type.getPattern()).toString();
    }

    protected String getParameterizedTypeSignature(PrimitiveTypeBinding type) {
        String typeSignature = null;
        if (this.inMofContext) {
            return typeSignature;
        }
        switch (type.getPrimitive().getType()) {
            case 4: 
            case 5: 
            case 9: 
            case 11: 
            case 19: 
            case 20: {
                typeSignature = "org.eclipse.edt.mof.egl.SequenceType";
                break;
            }
            case 2: 
            case 7: 
            case 12: 
            case 13: {
                typeSignature = "org.eclipse.edt.mof.egl.FixedPrecisionType";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                typeSignature = "org.eclipse.edt.mof.egl.IntervalType";
                break;
            }
            case 28: {
                typeSignature = "org.eclipse.edt.mof.egl.TimestampType";
            }
        }
        return typeSignature;
    }

    protected boolean isParameterizedType(PrimitiveTypeBinding type) {
        boolean is = false;
        switch (type.getPrimitive().getType()) {
            case 28: {
                is = type.getPattern() != null;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 26: {
                is = true;
                break;
            }
            default: {
                is = false;
            }
        }
        return is && (type.getLength() != 0 || type.getDecimals() != 0 || type.getPattern() != null);
    }

    protected String mofPartTypeSignatureFor(org.eclipse.edt.compiler.core.ast.Part part) {
        IPartBinding binding = (IPartBinding)part.getName().resolveBinding();
        return this.mofPartTypeSignatureFor(binding);
    }

    protected String mofPartTypeSignatureFor(IPartBinding partBinding) {
        String typeSignature;
        if (this.isReflectType(partBinding)) {
            typeSignature = this.getReflectedTypeSignature(partBinding);
        } else {
            switch (partBinding.getKind()) {
                case 17: {
                    typeSignature = "org.eclipse.edt.mof.egl.DataItem";
                    break;
                }
                case 5: {
                    typeSignature = "org.eclipse.edt.mof.egl.DataTable";
                    break;
                }
                case 27: {
                    typeSignature = "org.eclipse.edt.mof.egl.Delegate";
                    break;
                }
                case 19: {
                    typeSignature = this.inMofContext ? "org.eclipse.edt.mof.EEnum" : "org.eclipse.edt.mof.egl.Enumeration";
                    break;
                }
                case 28: {
                    typeSignature = this.inMofContext ? "org.eclipse.edt.mof.EClass" : "org.eclipse.edt.mof.egl.ExternalType";
                    break;
                }
                case 6: {
                    typeSignature = "org.eclipse.edt.mof.egl.StructuredRecord";
                    break;
                }
                case 7: {
                    typeSignature = "org.eclipse.edt.mof.egl.Record";
                    break;
                }
                case 8: {
                    typeSignature = "org.eclipse.edt.mof.egl.Form";
                    break;
                }
                case 9: {
                    typeSignature = "org.eclipse.edt.mof.egl.FormGroup";
                    break;
                }
                case 20: {
                    typeSignature = "org.eclipse.edt.mof.egl.FunctionPart";
                    break;
                }
                case 10: {
                    typeSignature = "org.eclipse.edt.mof.egl.Handler";
                    break;
                }
                case 15: {
                    typeSignature = "org.eclipse.edt.mof.egl.Interface";
                    break;
                }
                case 11: {
                    typeSignature = "org.eclipse.edt.mof.egl.Library";
                    break;
                }
                case 13: {
                    typeSignature = "org.eclipse.edt.mof.egl.Program";
                    break;
                }
                case 14: {
                    typeSignature = "org.eclipse.edt.mof.egl.Service";
                    break;
                }
                default: {
                    typeSignature = "org.eclipse.edt.mof.EClass";
                }
            }
        }
        return typeSignature;
    }

    protected EObject getMofSerializable(String mofSignature) {
        EObject result = null;
        try {
            result = this.env.find(mofSignature);
        }
        catch (MofObjectNotFoundException mofObjectNotFoundException) {
            result = (EObject)processed.get(mofSignature);
        }
        catch (DeserializationException e2) {
            e2.printStackTrace();
            result = null;
        }
        return result;
    }

    protected String mofSerializationKeyFor(ITypeBinding binding) {
        return this.mofTypeSignatureFor(binding, false);
    }

    protected EObject newEObject(String typeSignature) {
        EClass eClass = (EClass)this.getMofSerializable(typeSignature);
        return eClass.newInstance();
    }

    protected EClass createAnnotationType(IAnnotationBinding annotation) {
        EClass annType = this.createAnnotationType((IAnnotationTypeBinding)annotation.getType());
        if (annType == null) {
            annType = this.mof.createEMetadataType(true);
            annType.setName(annotation.getCaseSensitiveName());
            annType.setPackageName("");
            for (AnnotationFieldBinding fieldBinding : annotation.getAnnotationFields()) {
                EField field = this.mof.createEField(true);
                field.setName(fieldBinding.getCaseSensitiveName());
                EClassifier type = fieldBinding.getValue() instanceof String ? (EClassifier)this.getMofSerializable("org.eclipse.edt.mof.EString") : (fieldBinding.getValue() instanceof Boolean ? (EClassifier)this.getMofSerializable("org.eclipse.edt.mof.EBoolean") : (fieldBinding.getValue() instanceof Integer ? (EClassifier)this.getMofSerializable("org.eclipse.edt.mof.EInt32") : (fieldBinding.getValue() instanceof List ? (EClassifier)this.getMofSerializable("org.eclipse.edt.mof.EList") : (EClassifier)this.getMofSerializable("org.eclipse.edt.mof.EMetadataObject"))));
                field.setEType((EType)type);
                field.setDeclarer((EMemberContainer)annType);
                annType.getEFields().add(field);
            }
        }
        return annType;
    }

    protected EClass createAnnotationType(IAnnotationTypeBinding typeBinding) {
        if (typeBinding instanceof AnnotationTypeBindingImpl) {
            return this.createAnnotationType((AnnotationTypeBindingImpl)typeBinding);
        }
        AnnotationType annType = IrFactory.INSTANCE.createAnnotationType();
        return annType;
    }

    protected EClass createAnnotationType(AnnotationTypeBindingImpl part) {
        EClass record = null;
        FlexibleRecordBinding annType = part.getAnnotationRecord();
        if (annType != null) {
            record = (EClass)this.newEObject(this.mofPartTypeSignatureFor(annType));
            record.setName(part.getCaseSensitiveName());
            record.setPackageName(this.concatWithSeparator(part.getPackageName(), "."));
            boolean previousInEMetadataTypeContext = this.inEMetadataTypeContext;
            if (record instanceof EMetadataType) {
                this.inEMetadataTypeContext = true;
            }
            IAnnotationBinding subtype = annType.getSubTypeAnnotationBinding();
            List<Object> targets = this.mofValueFrom((Object[])this.getFieldValue(subtype, "targets"));
            if (record instanceof EMetadataType) {
                for (Object eClass : targets) {
                    ((EMetadataType)record).getTargets().add((EClass)eClass);
                }
            } else {
                for (Object literal : targets) {
                    ((AnnotationType)record).getTargets().add((ElementKind)literal);
                }
            }
            this.inEMetadataTypeContext = previousInEMetadataTypeContext;
            boolean currentMofContext = this.inMofContext;
            this.inMofContext = true;
            for (IDataBinding field : annType.getDeclaredFields()) {
                EField eField = this.mof.createEField(true);
                eField.setName(field.getCaseSensitiveName());
                eField.setEType((EType)this.mofTypeFor(field.getType()));
                eField.setContainment(true);
                record.addMember((EMember)eField);
            }
            this.inMofContext = currentMofContext;
            if (record instanceof StereotypeType) {
                record.getSuperTypes().set(0, (EClass)this.getMofSerializable("org.eclipse.edt.mof.egl.Stereotype"));
            } else if (record instanceof AnnotationType) {
                record.getSuperTypes().set(0, (EClass)this.getMofSerializable("org.eclipse.edt.mof.egl.Annotation"));
            }
        }
        this.env.save(record, false);
        return record;
    }

    protected EClass createTempEClass(ExternalTypeBinding part) {
        EClass eClass = this.mof.createEClass(true);
        eClass.setName(part.getCaseSensitiveName());
        eClass.setPackageName(this.concatWithSeparator(part.getPackageName(), "."));
        String key = this.mofSerializationKeyFor(part);
        this.env.save(key, (EObject)eClass, false);
        for (ClassFieldBinding binding : part.getDeclaredData()) {
            EField field = this.mof.createEField(true);
            field.setName(binding.getCaseSensitiveName());
            EClass type = null;
            try {
                type = (EType)this.mofTypeFor(binding.getType());
                field.setEType((EType)type);
                if (binding.getType().isNullable()) {
                    field.setIsNullable(true);
                }
            }
            catch (CircularBuildRequestException circularBuildRequestException) {
                type = MofFactory.INSTANCE.getEObjectClass();
            }
            eClass.addMember((EMember)field);
            field.setDeclarer((EMemberContainer)eClass);
        }
        IAnnotationBinding subtype = part.getSubTypeAnnotationBinding();
        this.setReflectTypeValues((EObject)eClass, subtype);
        eClass.getMetadataList().add(this.getTempClassMarker());
        ArrayList<EClass> superTypes = new ArrayList<EClass>();
        for (ITypeBinding superType : part.getExtendedTypes()) {
            superTypes.add((EClass)this.mofTypeFor(superType));
        }
        eClass.addSuperTypes(superTypes);
        return eClass;
    }

    protected boolean isTempEClass(EObject eclass) {
        return eclass instanceof EClass ? ((EClass)eclass).getMetadata(TempEClassMarker) != null : false;
    }

    protected EMetadataObject getTempClassMarker() {
        EMetadataType temp = (EMetadataType)this.getMofSerializable(TempEClassMarker);
        if (temp == null) {
            temp = this.mof.createEMetadataType(true);
            temp.setName(TempEClassMarker);
            EField value = this.mof.createEField(true);
            value.setName("value");
            value.setEType((EType)this.mof.getEBooleanEDataType());
            value.setDeclarer((EMemberContainer)temp);
            value.setInitialValue((Object)true);
            temp.getEFields().add(value);
            this.env.save(TempEClassMarker, (EObject)temp, false);
        }
        return (EMetadataObject)temp.newInstance();
    }

    protected ProxyEObject createProxyPart(String name) {
        String key;
        ProxyEClass type;
        if (this.inMofContext) {
            type = new ProxyEClass(name);
            key = type.getMofSerializationKey();
        } else {
            type = new ProxyPart(name);
            key = ((ProxyPart)type).getMofSerializationKey();
        }
        this.env.save(key, (EObject)type, false);
        return type;
    }

    protected Type createPrimitiveType(String key, PrimitiveTypeBinding part) {
        String parmTypeSignature = this.getParameterizedTypeSignature(part);
        ProxyPart type = null;
        if (parmTypeSignature != null && this.isParameterizedType(part)) {
            type = (ParameterizedType)((EClass)this.getMofSerializable(parmTypeSignature)).newInstance();
            String primSignature = this.mofPrimitiveSignatureFor(part.getPrimitive());
            int i = primSignature.indexOf(":");
            primSignature = i == -1 ? primSignature : primSignature.substring(i + 1);
            ProxyPart eprim = new ProxyPart(primSignature);
            ((ParameterizedType)type).setParameterizableType((ParameterizableType)eprim);
        } else {
            type = new ProxyPart(this.mofPrimitiveTypeSignatureFor(part));
        }
        this.env.save(key, (EObject)type, false);
        return type;
    }

    protected String concatWithSeparator(String[] fragments, String separator) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < fragments.length) {
            result.append(fragments[i]);
            if (i < fragments.length - 1) {
                result.append(separator);
            }
            ++i;
        }
        return result.toString();
    }

    protected void eSet(EObject target, String fieldName, Object value) {
        EField field = target.getEClass().getEField(fieldName);
        this.eSet(target, field, value);
    }

    protected void eSet(EObject target, EField field, Object value) {
        Object convertedValue = this.mofValueFrom(value);
        if (field.getEType() instanceof EEnum && convertedValue instanceof Name) {
            EEnumLiteral lit = ((EEnum)field.getEType()).getEEnumLiteral(((Name)convertedValue).getId());
            if (lit != null) {
                convertedValue = lit;
            }
        } else if (field.getEType() instanceof EGenericType && ((EGenericType)field.getEType()).getETypeArguments().size() > 0 && ((EGenericType)field.getEType()).getETypeArguments().get(0) instanceof EEnum && convertedValue instanceof EList) {
            EEnum enumObj = (EEnum)((EGenericType)field.getEType()).getETypeArguments().get(0);
            EList newValue = new EList();
            Iterator iterator = ((EList)convertedValue).iterator();
            while (iterator.hasNext()) {
                EEnumLiteral lit;
                Object obj;
                Object val = obj = iterator.next();
                if (obj instanceof Name && (lit = enumObj.getEEnumLiteral(((Name)obj).getId())) != null) {
                    val = lit;
                }
                newValue.add(val);
            }
            convertedValue = newValue;
        }
        target.eSet(field, convertedValue);
    }

    protected void eAdd(List list, Object value) {
        Object convertedValue = null;
        if (value instanceof Object[]) {
            Object[] objectArray = (Object[])value;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                convertedValue = this.mofValueFrom(obj);
                list.add(convertedValue);
                ++n2;
            }
        } else {
            for (Object obj : (List)value) {
                convertedValue = this.mofValueFrom(obj);
                list.add(convertedValue);
            }
        }
    }

    protected boolean isAbstractFunction(Function function) {
        return function != null && function.getContainer() instanceof ExternalType;
    }

    protected boolean isReflectType(ITypeBinding typeBinding) {
        boolean isReflectType;
        if (!(typeBinding instanceof IPartBinding)) {
            return false;
        }
        IPartBinding partBinding = (IPartBinding)typeBinding;
        boolean bl = isReflectType = this.isAnnotationType(partBinding) || this.isStereotypeType(partBinding) || this.isEMetadataType(partBinding);
        if (!isReflectType) {
            boolean bl2 = isReflectType = this.getAnnotation(typeBinding, "PartType") != null;
            if (!isReflectType && typeBinding instanceof IPartBinding) {
                isReflectType = this.getAnnotation(((IPartBinding)typeBinding).getSubType(), "PartType") != null;
            }
        }
        return isReflectType;
    }

    protected MofSerializable getDefaultSuperType(ITypeBinding typeBinding) {
        if (!(typeBinding instanceof IPartBinding)) {
            return null;
        }
        IPartBinding partBinding = (IPartBinding)typeBinding;
        IPartSubTypeAnnotationTypeBinding subtype = partBinding.getSubType();
        String superTypeName = null;
        if (subtype != null) {
            superTypeName = this.getDefaultSuperTypeSignature((IPartBinding)typeBinding);
        }
        return superTypeName != null ? (MofSerializable)this.getMofSerializable(superTypeName) : null;
    }

    protected EClass getReflectedType(ITypeBinding typeBinding) {
        if (!(typeBinding instanceof IPartBinding)) {
            return null;
        }
        IPartBinding partBinding = (IPartBinding)typeBinding;
        IPartSubTypeAnnotationTypeBinding subtype = partBinding.getSubType();
        String reflectedTypeName = null;
        if (subtype != null) {
            reflectedTypeName = this.getReflectedTypeSignature((IPartBinding)typeBinding);
        }
        return reflectedTypeName != null ? (EClass)this.getMofSerializable(reflectedTypeName) : null;
    }

    protected boolean isMofReflectType(ITypeBinding typeBinding) {
        EClass reflectedType = this.getReflectedType(typeBinding);
        if (reflectedType != null) {
            return reflectedType.isSubClassOf(MofFactory.INSTANCE.getEModelElementClass());
        }
        return false;
    }

    protected boolean isEGLReflectType(ITypeBinding typeBinding) {
        EClass reflectedType = this.getReflectedType(typeBinding);
        if (reflectedType != null) {
            return reflectedType.isSubClassOf(IrFactory.INSTANCE.getElementEClass());
        }
        return false;
    }

    protected String getDefaultSuperTypeSignature(IPartBinding type) {
        IAnnotationBinding subtype = type.getSubTypeAnnotationBinding();
        IAnnotationBinding reflectType = this.getAnnotation(subtype.getType(), "DefaultSuperType");
        if (reflectType != null) {
            return this.mofTypeSignatureFor((ITypeBinding)reflectType.getValue(), false);
        }
        if (this.isEMetadataType(type)) {
            return "org.eclipse.edt.mof.EMetadataObject";
        }
        if (this.isAnnotationType(type)) {
            return "org.eclipse.edt.mof.egl.Annotation";
        }
        if (this.isStereotypeType(type)) {
            return "org.eclipse.edt.mof.egl.Stereotype";
        }
        return null;
    }

    protected String getReflectedTypeSignature(IPartBinding type) {
        IAnnotationBinding subtype = type.getSubTypeAnnotationBinding();
        IAnnotationBinding reflectType = this.getAnnotation(subtype.getType(), "PartType");
        if (reflectType != null) {
            return (String)reflectType.getValue();
        }
        if (this.isEMetadataType(type)) {
            return "org.eclipse.edt.mof.EMetadataType";
        }
        if (this.isAnnotationType(type)) {
            return "org.eclipse.edt.mof.egl.AnnotationType";
        }
        if (this.isStereotypeType(type)) {
            return "org.eclipse.edt.mof.egl.StereotypeType";
        }
        return null;
    }

    protected boolean isAnnotationType(ITypeBinding type) {
        if (!(type instanceof IPartBinding)) {
            return false;
        }
        IPartBinding edtType = (IPartBinding)type;
        IAnnotationBinding ann = edtType.getSubTypeAnnotationBinding();
        return ann != null && ann.getName().equalsIgnoreCase("Annotation") && this.getAnnotation(ann, "Stereotype") == null && !this.isEMetadataType(edtType);
    }

    protected boolean isStereotypeType(ITypeBinding type) {
        if (!(type instanceof IPartBinding)) {
            return false;
        }
        IPartBinding edtType = (IPartBinding)type;
        IAnnotationBinding ann = edtType.getSubTypeAnnotationBinding();
        return ann != null && ann.getName().equalsIgnoreCase("Annotation") && this.getAnnotation(ann, "Stereotype") != null && !this.isEMetadataType(edtType);
    }

    protected boolean isEMetadataType(ITypeBinding edtType) {
        if (edtType.getName().equalsIgnoreCase("IsEMetadataType")) {
            return true;
        }
        IAnnotationBinding ann = this.getAnnotation(edtType, "IsEMetadataType");
        return ann != null && ((java.lang.Boolean)ann.getValue()).equals(java.lang.Boolean.TRUE);
    }

    protected boolean isEMetadataObject(IAnnotationBinding ann) {
        ITypeBinding annType = ann.getType();
        if (annType instanceof AnnotationTypeBindingImpl) {
            annType = ((AnnotationTypeBindingImpl)annType).getAnnotationRecord();
        }
        return this.isEMetadataType(annType);
    }

    protected boolean isMofClass(IPartBinding edtType) {
        IAnnotationBinding ann = edtType.getSubTypeAnnotationBinding();
        return ann != null && ann.getName().equalsIgnoreCase("MofClass");
    }

    protected boolean isMofDataType(IPartBinding edtType) {
        IAnnotationBinding ann = edtType.getSubTypeAnnotationBinding();
        return ann != null && ann.getName().equalsIgnoreCase("MofDataType");
    }

    protected boolean isMofBaseType(IPartBinding edtType) {
        IAnnotationBinding ann = edtType.getSubTypeAnnotationBinding();
        return ann != null && ann.getName().equalsIgnoreCase("MofBaseType");
    }

    protected boolean isMofProxy(IPartBinding edtType) {
        IAnnotationBinding ann = edtType.getSubTypeAnnotationBinding();
        return ann != null && ann.getName().equalsIgnoreCase("MofClass") && this.getFieldValue(ann, "isProxy") != null;
    }

    protected boolean isMofProxy(Part part) {
        Stereotype ann = part.getStereotype();
        return ann != null && ann.getEClass().getName().equalsIgnoreCase("MofClass") && (java.lang.Boolean)ann.eGet("isProxy") != false;
    }

    protected EClass resolveProxy(Part part) {
        Stereotype ann = part.getStereotype();
        String packageName = (String)ann.eGet("packageName");
        String name = (String)ann.eGet("name");
        if (name == null || name.equals("")) {
            name = part.getName();
        }
        return (EClass)this.getMofSerializable(String.valueOf(packageName) + "." + name);
    }

    protected void setElementInformation(Node node, EObject obj) {
        if (obj instanceof Element) {
            Element elem = (Element)obj;
            Annotation ann = this.factory.createDynamicAnnotation("EGL_Location");
            ann.setValue("len", (Object)new Integer(node.getLength()));
            ann.setValue("off", (Object)new Integer(node.getOffset()));
            ann.setValue("line", (Object)new Integer(this.getLine(node)));
            elem.addAnnotation(ann);
        }
        if (obj instanceof Classifier) {
            int packageSegmentCount = ((Classifier)obj).getPackageName().split("\\.").length;
            String absPath = this.context.getAbsolutePath();
            if (!absPath.contains("/")) {
                absPath = absPath.replace("\\", "/");
            }
            String[] absPathSegments = absPath.split("\\/");
            StringBuilder fileName = new StringBuilder(100);
            int i = absPathSegments.length - packageSegmentCount - 1;
            while (i < absPathSegments.length) {
                fileName.append(absPathSegments[i]);
                if (i + 1 < absPathSegments.length) {
                    fileName.append("/");
                }
                ++i;
            }
            ((Classifier)obj).setFileName(fileName.toString());
        }
    }

    protected int getLine(Node node) {
        if (this.context != null) {
            return this.context.getLineNumber(node);
        }
        return 0;
    }

    public void setUpEglTypedElement(TypedElement obj, IDataBinding edtObj) {
        Type type = null;
        EObject mofType = this.mofTypeFromTypedElement(edtObj);
        if (mofType instanceof Type) {
            type = (Type)mofType;
        }
        if (type != null && type.getTypeSignature().equals("eglx.lang.EAny")) {
            Classifier part = (Classifier)this.getPartBeingProcessed();
            if (part == null) {
                System.out.println("Null processing part: " + obj.toStringHeader());
            } else if (!part.getTypeParameters().isEmpty()) {
                type = this.factory.createGenericType();
                ((GenericType)type).setTypeParameter((TypeParameter)part.getTypeParameters().get(0));
            }
        }
        obj.setType(type);
        if (Binding.isValidBinding(edtObj)) {
            obj.setName(edtObj.getCaseSensitiveName());
        }
        if (type != null) {
            boolean isNullable = edtObj.getType() instanceof IFunctionBinding ? ((IFunctionBinding)edtObj.getType()).getReturnType() != null && ((IFunctionBinding)edtObj.getType()).getReturnType().isNullable() : edtObj.getType().isNullable();
            obj.setIsNullable(isNullable);
        }
    }
}

