/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.egl2mof.eglx.jtopen;

import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.CallStatement;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.internal.core.lookup.FunctionArgumentValidator;
import org.eclipse.edt.compiler.internal.core.utils.TypeCompatibilityUtil;
import org.eclipse.edt.compiler.internal.core.validation.DefaultStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class IBMiProgramCallStatementValidator
extends DefaultStatementValidator {
    @Override
    public boolean visit(CallStatement callStatement) {
        this.validateIBMiProgramCall(callStatement);
        return false;
    }

    private void validateIBMiProgramCall(CallStatement callStatement) {
        ITypeBinding usingType;
        ITypeBinding targType = callStatement.getInvocationTarget().resolveTypeBinding();
        if (!Binding.isValidBinding(targType) || 20 != targType.getKind()) {
            return;
        }
        IFunctionBinding functionBinding = (IFunctionBinding)targType;
        if (functionBinding.getAnnotation(InternUtil.intern((String[])new String[]{"eglx", "jtopen", "annotations"}), InternUtil.intern((String)"IBMiProgram")) == null) {
            this.problemRequestor.acceptProblem(callStatement.getInvocationTarget(), 5728, 2, new String[]{functionBinding.getCaseSensitiveName()});
            return;
        }
        callStatement.accept(new FunctionArgumentValidator(functionBinding, functionBinding.getDeclarer(), this.problemRequestor, this.compilerOptions));
        if (functionBinding.getReturnType() != null && (callStatement.getCallSynchronizationValues() == null || callStatement.getCallSynchronizationValues().getReturnTo() == null && callStatement.getCallSynchronizationValues().getReturns() == null)) {
            this.problemRequestor.acceptProblem(callStatement.getInvocationTarget(), 5724, 2, new String[0]);
        }
        if (callStatement.getUsing() != null && Binding.isValidBinding(usingType = callStatement.getUsing().resolveTypeBinding()) && !this.isIBMiConnection(usingType)) {
            this.problemRequestor.acceptProblem(callStatement.getUsing(), 5727, 2, new String[0]);
        }
        if (callStatement.getCallSynchronizationValues() != null) {
            if (callStatement.getCallSynchronizationValues().getReturns() != null) {
                Expression callReturnsExpr;
                ITypeBinding callReturnsType;
                if (functionBinding.getReturnType() == null) {
                    this.problemRequestor.acceptProblem(callStatement.getCallSynchronizationValues().getReturns(), 5725, 2, new String[]{functionBinding.getCaseSensitiveName()});
                } else if (Binding.isValidBinding(functionBinding.getReturnType()) && !TypeCompatibilityUtil.isMoveCompatible(callReturnsType = (callReturnsExpr = callStatement.getCallSynchronizationValues().getReturns().getExpression()).resolveTypeBinding(), functionBinding.getReturnType(), null, this.compilerOptions)) {
                    this.problemRequestor.acceptProblem(callStatement.getCallSynchronizationValues().getReturns(), 5726, 2, new String[]{StatementValidator.getShortTypeString(functionBinding.getReturnType()), functionBinding.getCaseSensitiveName(), StatementValidator.getShortTypeString(callReturnsType), callReturnsExpr.getCanonicalString()});
                }
            }
            if (callStatement.getCallSynchronizationValues().getReturnTo() != null) {
                this.problemRequestor.acceptProblem(callStatement.getCallSynchronizationValues().getReturnTo(), 5729, 2, new String[0]);
            }
            if (callStatement.getCallSynchronizationValues().getOnException() != null) {
                this.problemRequestor.acceptProblem(callStatement.getCallSynchronizationValues().getOnException(), 5729, 2, new String[0]);
            }
        }
    }

    private boolean isIBMiConnection(ITypeBinding type) {
        if (Binding.isValidBinding(type) && 28 == type.getKind()) {
            return type.getName() == InternUtil.intern((String)"IBMiConnection") && type.getPackageName() == InternUtil.intern((String[])new String[]{"eglx", "jtopen"});
        }
        return false;
    }
}

