/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.egl2mof.eglx.persistence.sql;

import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.AddStatement;
import org.eclipse.edt.compiler.core.ast.CloseStatement;
import org.eclipse.edt.compiler.core.ast.DeleteStatement;
import org.eclipse.edt.compiler.core.ast.ExecuteStatement;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.ForEachStatement;
import org.eclipse.edt.compiler.core.ast.FromOrToExpressionClause;
import org.eclipse.edt.compiler.core.ast.GetByKeyStatement;
import org.eclipse.edt.compiler.core.ast.InlineSQLStatement;
import org.eclipse.edt.compiler.core.ast.IntoClause;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.OpenStatement;
import org.eclipse.edt.compiler.core.ast.PrepareStatement;
import org.eclipse.edt.compiler.core.ast.ReplaceStatement;
import org.eclipse.edt.compiler.core.ast.UsingClause;
import org.eclipse.edt.compiler.core.ast.UsingKeysClause;
import org.eclipse.edt.compiler.core.ast.WithExpressionClause;
import org.eclipse.edt.compiler.core.ast.WithInlineSQLClause;
import org.eclipse.edt.compiler.internal.egl2mof.AbstractIOStatementGenerator;
import org.eclipse.edt.mof.EClass;
import org.eclipse.edt.mof.egl.GetByPositionStatement;
import org.eclipse.edt.mof.egl.Statement;
import org.eclipse.edt.mof.egl.StatementBlock;
import org.eclipse.edt.mof.eglx.persistence.sql.SqlActionStatement;
import org.eclipse.edt.mof.eglx.persistence.sql.SqlAddStatement;
import org.eclipse.edt.mof.eglx.persistence.sql.SqlCloseStatement;
import org.eclipse.edt.mof.eglx.persistence.sql.SqlDeleteStatement;
import org.eclipse.edt.mof.eglx.persistence.sql.SqlExecuteStatement;
import org.eclipse.edt.mof.eglx.persistence.sql.SqlFactory;
import org.eclipse.edt.mof.eglx.persistence.sql.SqlForEachStatement;
import org.eclipse.edt.mof.eglx.persistence.sql.SqlGetByKeyStatement;
import org.eclipse.edt.mof.eglx.persistence.sql.SqlOpenStatement;
import org.eclipse.edt.mof.eglx.persistence.sql.SqlPrepareStatement;
import org.eclipse.edt.mof.eglx.persistence.sql.SqlReplaceStatement;
import org.eclipse.edt.mof.serialization.IEnvironment;

public class SQLActionStatementGenerator
extends AbstractIOStatementGenerator {
    SqlFactory factory = SqlFactory.INSTANCE;
    final SQLActionStatementGenerator generator = this;

    public SQLActionStatementGenerator() {
        super(null);
    }

    public SQLActionStatementGenerator(IEnvironment env) {
        super(env);
    }

    private void doCommonVisit(org.eclipse.edt.compiler.core.ast.Statement node, final SqlActionStatement stmt) {
        for (Node expr : node.getIOObjects()) {
            expr.accept(this);
            stmt.getTargets().add((org.eclipse.edt.mof.egl.Expression)this.stack.pop());
        }
        node.accept(new AbstractASTExpressionVisitor(){

            @Override
            public boolean visit(IntoClause clause) {
                for (Node expr : clause.getExpressions()) {
                    expr.accept(SQLActionStatementGenerator.this.generator);
                    stmt.getTargets().add((org.eclipse.edt.mof.egl.Expression)SQLActionStatementGenerator.this.stack.pop());
                }
                return false;
            }

            @Override
            public boolean visit(FromOrToExpressionClause clause) {
                clause.getExpression().accept(SQLActionStatementGenerator.this.generator);
                stmt.setDataSource((org.eclipse.edt.mof.egl.Expression)SQLActionStatementGenerator.this.stack.pop());
                return false;
            }

            @Override
            public boolean visit(WithInlineSQLClause sqlStmt) {
                String sql = sqlStmt.getSqlStmt().getValue();
                stmt.setHasExplicitSql(Boolean.valueOf(true));
                stmt.setSqlString(sql);
                return false;
            }

            @Override
            public boolean visit(WithExpressionClause sqlStmt) {
                sqlStmt.getExpression().accept(SQLActionStatementGenerator.this.generator);
                stmt.setPreparedStatement((org.eclipse.edt.mof.egl.Expression)SQLActionStatementGenerator.this.stack.pop());
                return false;
            }

            @Override
            public boolean visit(InlineSQLStatement sqlStmt) {
                String sql = sqlStmt.getValue();
                stmt.setHasExplicitSql(Boolean.valueOf(true));
                stmt.setSqlString(sql);
                return false;
            }

            @Override
            public boolean visit(UsingClause clause) {
                for (Expression expr : clause.getExpressions()) {
                    expr.accept(SQLActionStatementGenerator.this.generator);
                    stmt.getUsingExpressions().add((org.eclipse.edt.mof.egl.Expression)SQLActionStatementGenerator.this.stack.pop());
                }
                return false;
            }

            @Override
            public boolean visit(UsingKeysClause clause) {
                for (Expression expr : clause.getExpressions()) {
                    expr.accept(SQLActionStatementGenerator.this.generator);
                    stmt.getUsingKeyExpressions().add((org.eclipse.edt.mof.egl.Expression)SQLActionStatementGenerator.this.stack.pop());
                }
                return false;
            }
        });
        this.setElementInformation((Node)node, (Statement)stmt);
    }

    @Override
    public boolean visit(AddStatement node) {
        SqlAddStatement stmt = this.factory.createSqlAddStatement();
        this.stack.push(stmt);
        this.doCommonVisit(node, (SqlActionStatement)stmt);
        return false;
    }

    @Override
    public boolean visit(CloseStatement node) {
        SqlCloseStatement stmt = this.factory.createSqlCloseStatement();
        this.stack.push(stmt);
        this.doCommonVisit(node, (SqlActionStatement)stmt);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.GetByPositionStatement getByPositionStatement) {
        GetByPositionStatement stmt = this.factory.createGetByPositionStatement();
        this.stack.push(stmt);
        this.setElementInformation((Node)getByPositionStatement, (Statement)stmt);
        return false;
    }

    @Override
    public boolean visit(DeleteStatement node) {
        SqlDeleteStatement stmt = this.factory.createSqlDeleteStatement();
        this.stack.push(stmt);
        this.doCommonVisit(node, (SqlActionStatement)stmt);
        return false;
    }

    @Override
    public boolean visit(ExecuteStatement node) {
        SqlExecuteStatement stmt = this.factory.createSqlExecuteStatement();
        this.stack.push(stmt);
        this.doCommonVisit(node, (SqlActionStatement)stmt);
        return false;
    }

    @Override
    public boolean visit(ForEachStatement forEachStatement) {
        SqlForEachStatement forEachStmt = this.factory.createSqlForEachStatement();
        this.stack.push(forEachStmt);
        this.doCommonVisit(forEachStatement, (SqlActionStatement)forEachStmt);
        for (Node expr : forEachStatement.getTargets()) {
            expr.accept(this);
            forEachStmt.getTargets().add((org.eclipse.edt.mof.egl.Expression)this.stack.pop());
        }
        StatementBlock block = this.irFactory.createStatementBlock();
        forEachStmt.setBody((Statement)block);
        for (Node node : forEachStatement.getStmts()) {
            node.accept(this);
            block.getStatements().add((Statement)this.stack.pop());
        }
        return false;
    }

    @Override
    public boolean visit(GetByKeyStatement node) {
        SqlGetByKeyStatement stmt = this.factory.createSqlGetByKeyStatement();
        this.stack.push(stmt);
        this.doCommonVisit(node, (SqlActionStatement)stmt);
        return false;
    }

    @Override
    public boolean visit(OpenStatement node) {
        SqlOpenStatement stmt = this.factory.createSqlOpenStatement();
        this.stack.push(stmt);
        node.getResultSet().accept(this);
        stmt.getTargets().add((org.eclipse.edt.mof.egl.Expression)this.stack.pop());
        this.doCommonVisit(node, (SqlActionStatement)stmt);
        return false;
    }

    @Override
    public boolean visit(PrepareStatement node) {
        SqlPrepareStatement stmt = this.factory.createSqlPrepareStatement();
        this.stack.push(stmt);
        if (node.getSqlStmt() != null) {
            node.getSqlStmt().accept(this);
            stmt.setPreparedStatement((org.eclipse.edt.mof.egl.Expression)this.stack.pop());
            stmt.getTargets().add(stmt.getPreparedStatement());
        }
        if (node.getDataSource() != null) {
            node.getDataSource().accept(this);
            stmt.setDataSource((org.eclipse.edt.mof.egl.Expression)this.stack.pop());
        }
        if (node.getWithClause() != null) {
            node.getWithClause().accept(this);
            if (node.getWithClause().isWithExpression()) {
                stmt.setSqlStringExpr((org.eclipse.edt.mof.egl.Expression)this.stack.pop());
            }
            if (node.getWithClause().isWithInlineSQL()) {
                InlineSQLStatement inline = ((WithInlineSQLClause)node.getWithClause()).getSqlStmt();
                String sql = inline.getValue().replaceAll("[\\n\\r]", " ");
                stmt.setSqlString(sql);
            }
        }
        return false;
    }

    @Override
    public boolean visit(ReplaceStatement node) {
        SqlReplaceStatement stmt = this.factory.createSqlReplaceStatement();
        this.stack.push(stmt);
        this.doCommonVisit(node, (SqlActionStatement)stmt);
        return false;
    }

    public EClass getStatementEClass(AddStatement stmt) {
        return this.factory.getSqlAddStatementEClass();
    }

    public EClass getStatementEClass(CloseStatement stmt) {
        return this.factory.getSqlCloseStatementEClass();
    }

    public EClass getStatementEClass(DeleteStatement stmt) {
        return this.factory.getSqlDeleteStatementEClass();
    }

    public EClass getStatementEClass(ExecuteStatement stmt) {
        return this.factory.getSqlExecuteStatementEClass();
    }

    public EClass getStatementEClass(ForEachStatement stmt) {
        return this.factory.getSqlForEachStatementEClass();
    }

    public EClass getStatementEClass(GetByKeyStatement stmt) {
        return this.factory.getSqlGetByKeyStatementEClass();
    }

    public EClass getStatementEClass(OpenStatement stmt) {
        return this.factory.getSqlOpenStatementEClass();
    }

    public EClass getStatementEClass(PrepareStatement stmt) {
        return this.factory.getSqlPrepareStatementEClass();
    }

    public EClass getStatementEClass(ReplaceStatement stmt) {
        return this.factory.getSqlReplaceStatementEClass();
    }
}

