/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.egl2mof.eglx.persistence.sql.validation;

import java.util.Collection;
import java.util.List;
import org.eclipse.edt.compiler.binding.ArrayTypeBinding;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.ExternalTypeBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordBinding;
import org.eclipse.edt.compiler.binding.HandlerBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class AbstractSqlStatementValidator {
    protected static final String[] SQL_PKG = InternUtil.intern((String[])new String[]{"eglx", "persistence", "sql"});
    protected static final String[] PERSISTENCE_PKG = InternUtil.intern((String[])new String[]{"eglx", "persistence"});

    protected boolean isResultSet(ITypeBinding type) {
        if (!Binding.isValidBinding(type)) {
            return false;
        }
        if (type.getKind() != 28) {
            return false;
        }
        return type.getName() == InternUtil.intern((String)"SQLResultSet") && type.getPackageName() == SQL_PKG;
    }

    protected boolean isDataSource(ITypeBinding type) {
        if (!Binding.isValidBinding(type)) {
            return false;
        }
        if (type.getKind() != 28) {
            return false;
        }
        return type.getName() == InternUtil.intern((String)"SQLDataSource") && type.getPackageName() == SQL_PKG;
    }

    protected boolean isSqlStatement(ITypeBinding type) {
        if (!Binding.isValidBinding(type)) {
            return false;
        }
        if (type.getKind() != 28) {
            return false;
        }
        return type.getName() == InternUtil.intern((String)"SQLStatement") && type.getPackageName() == SQL_PKG;
    }

    protected boolean isEntity(ITypeBinding type) {
        if (!Binding.isValidBinding(type)) {
            return false;
        }
        switch (type.getKind()) {
            case 7: 
            case 10: 
            case 28: {
                return true;
            }
        }
        return false;
    }

    protected boolean isEntityWithID(ITypeBinding type) {
        if (!Binding.isValidBinding(type) || !this.isEntity(type)) {
            return false;
        }
        return this.hasID(type);
    }

    protected boolean hasID(ITypeBinding type) {
        if (!Binding.isValidBinding(type)) {
            return false;
        }
        List fields = null;
        while (type != null && type.getKind() == 2) {
            type = ((ArrayTypeBinding)type).getElementType();
        }
        switch (type.getKind()) {
            case 7: {
                fields = ((FlexibleRecordBinding)type).getDeclaredFields();
                break;
            }
            case 10: {
                fields = ((HandlerBinding)type).getDeclaredData();
                break;
            }
            case 28: {
                fields = ((ExternalTypeBinding)type).getDeclaredAndInheritedData();
                break;
            }
        }
        if (fields == null) {
            return false;
        }
        for (IDataBinding field : fields) {
            if (field.getAnnotation(PERSISTENCE_PKG, "ID") == null) continue;
            return true;
        }
        return false;
    }

    protected boolean isAssociationExpression(Expression exp) {
        IDataBinding data = exp.resolveDataBinding();
        if (!Binding.isValidBinding(data)) {
            return false;
        }
        if (!Binding.isValidBinding(data.getDeclaringPart())) {
            return false;
        }
        if (!this.isEntity(data.getDeclaringPart())) {
            return false;
        }
        IAnnotationBinding annotation = null;
        annotation = data.getAnnotation(PERSISTENCE_PKG, InternUtil.intern((String)"OneToOne"));
        if (annotation == null) {
            annotation = data.getAnnotation(PERSISTENCE_PKG, InternUtil.intern((String)"OneToMany"));
        }
        if (annotation == null) {
            annotation = data.getAnnotation(PERSISTENCE_PKG, InternUtil.intern((String)"ManyToOne"));
        }
        if (annotation == null) {
            annotation = data.getAnnotation(PERSISTENCE_PKG, InternUtil.intern((String)"ManyToMany"));
        }
        return annotation != null;
    }

    protected boolean isDataExpr(Expression expr) {
        ITypeBinding type = expr.resolveTypeBinding();
        if (!Binding.isValidBinding(type)) {
            return false;
        }
        if (type.getKind() == 2) {
            ITypeBinding elementType = ((ArrayTypeBinding)type).getElementType();
            return Binding.isValidBinding(elementType) && this.isEntity(elementType);
        }
        return this.isScalar(expr) || this.isEntity(type) || this.isAssociationExpression(expr);
    }

    protected boolean isScalar(Expression expr) {
        ITypeBinding type = expr.resolveTypeBinding();
        return Binding.isValidBinding(type) && 3 == type.getKind();
    }

    protected boolean mapsToColumns(List exprs) {
        int size = exprs.size();
        int i = 0;
        while (i < size) {
            Node n = (Node)exprs.get(i);
            if (n instanceof Expression) {
                Expression expr = (Expression)n;
                if (!this.isScalar(expr)) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean mapsToSingleTable(List<Expression> exprs) {
        IPartBinding firstParent = null;
        for (Expression e : exprs) {
            IDataBinding binding = e.resolveDataBinding();
            if (!Binding.isValidBinding(binding)) continue;
            IPartBinding parent = binding.getDeclaringPart();
            if (parent == null) {
                return false;
            }
            if (firstParent == null) {
                firstParent = parent;
                continue;
            }
            if (firstParent.equals(parent)) continue;
            return false;
        }
        if (firstParent == null) {
            return false;
        }
        return this.isEntity(firstParent) && this.isSingleTable(firstParent);
    }

    protected int[] getOffsets(Collection<Node> nodes) {
        int startOffset = -1;
        int endOffset = -1;
        for (Node n : nodes) {
            int nextStart = n.getOffset();
            int nextEnd = nextStart + n.getLength();
            if (startOffset == -1 || nextStart < startOffset) {
                startOffset = nextStart;
            }
            if (endOffset != -1 && nextEnd <= endOffset) continue;
            endOffset = nextEnd;
        }
        return new int[]{startOffset, endOffset};
    }

    protected boolean isSingleTable(ITypeBinding type) {
        Object value;
        if (!Binding.isValidBinding(type)) {
            return false;
        }
        if (type.getAnnotation(SQL_PKG, "SECONDARYTABLE") != null) {
            return false;
        }
        IAnnotationBinding annot = type.getAnnotation(SQL_PKG, "SECONDARYTABLES");
        if (annot != null && (value = annot.getValue()) instanceof IAnnotationBinding[]) {
            return ((IAnnotationBinding[])value).length == 0;
        }
        return true;
    }
}

