/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.egl2mof.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.AddStatement;
import org.eclipse.edt.compiler.core.ast.CloseStatement;
import org.eclipse.edt.compiler.core.ast.DeleteStatement;
import org.eclipse.edt.compiler.core.ast.ExecuteStatement;
import org.eclipse.edt.compiler.core.ast.ForEachStatement;
import org.eclipse.edt.compiler.core.ast.ForExpressionClause;
import org.eclipse.edt.compiler.core.ast.ForUpdateClause;
import org.eclipse.edt.compiler.core.ast.FromExpressionClause;
import org.eclipse.edt.compiler.core.ast.FromOrToExpressionClause;
import org.eclipse.edt.compiler.core.ast.GetByKeyStatement;
import org.eclipse.edt.compiler.core.ast.GetByPositionStatement;
import org.eclipse.edt.compiler.core.ast.InlineSQLStatement;
import org.eclipse.edt.compiler.core.ast.IntoClause;
import org.eclipse.edt.compiler.core.ast.NoCursorClause;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.OpenStatement;
import org.eclipse.edt.compiler.core.ast.PrepareStatement;
import org.eclipse.edt.compiler.core.ast.ReplaceStatement;
import org.eclipse.edt.compiler.core.ast.SingleRowClause;
import org.eclipse.edt.compiler.core.ast.UsingClause;
import org.eclipse.edt.compiler.core.ast.UsingKeysClause;
import org.eclipse.edt.compiler.core.ast.WithIDClause;
import org.eclipse.edt.compiler.core.ast.WithInlineSQLClause;
import org.eclipse.edt.compiler.internal.egl2mof.DefaultIOStatementGenerator;
import org.eclipse.edt.compiler.internal.sql.ItemNameToken;
import org.eclipse.edt.compiler.internal.sql.SQLInfo;
import org.eclipse.edt.compiler.internal.sql.Token;
import org.eclipse.edt.compiler.internal.sql.WhereCurrentOfToken;
import org.eclipse.edt.mof.EClass;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.LHSExpr;
import org.eclipse.edt.mof.egl.Statement;
import org.eclipse.edt.mof.egl.StatementBlock;
import org.eclipse.edt.mof.egl.sql.SqlAddStatement;
import org.eclipse.edt.mof.egl.sql.SqlClause;
import org.eclipse.edt.mof.egl.sql.SqlDeleteStatement;
import org.eclipse.edt.mof.egl.sql.SqlExecuteStatement;
import org.eclipse.edt.mof.egl.sql.SqlFactory;
import org.eclipse.edt.mof.egl.sql.SqlForEachStatement;
import org.eclipse.edt.mof.egl.sql.SqlGetByKeyStatement;
import org.eclipse.edt.mof.egl.sql.SqlGetByPositionStatement;
import org.eclipse.edt.mof.egl.sql.SqlInputHostVariableToken;
import org.eclipse.edt.mof.egl.sql.SqlOpenStatement;
import org.eclipse.edt.mof.egl.sql.SqlPrepareStatement;
import org.eclipse.edt.mof.egl.sql.SqlReplaceStatement;
import org.eclipse.edt.mof.egl.sql.SqlSelectNameToken;
import org.eclipse.edt.mof.egl.sql.SqlStringToken;
import org.eclipse.edt.mof.egl.sql.SqlToken;
import org.eclipse.edt.mof.egl.sql.SqlWhereCurrentOfToken;
import org.eclipse.edt.mof.serialization.IEnvironment;

public class SQLIOStatementGenerator
extends DefaultIOStatementGenerator {
    SqlFactory factory = SqlFactory.INSTANCE;
    final SQLIOStatementGenerator generator = this;

    public SQLIOStatementGenerator() {
        super(null);
    }

    public SQLIOStatementGenerator(IEnvironment env) {
        super(env);
    }

    @Override
    public boolean visit(AddStatement node) {
        super.visit(node);
        final SqlAddStatement stmt = (SqlAddStatement)this.stack.peek();
        node.accept(new AbstractASTExpressionVisitor(){

            @Override
            public boolean visit(FromOrToExpressionClause clause) {
                clause.getExpression().accept(SQLIOStatementGenerator.this.generator);
                stmt.setDataSource((Expression)SQLIOStatementGenerator.this.stack.pop());
                return false;
            }

            @Override
            public boolean visit(InlineSQLStatement sqlStmt) {
                stmt.setSqlString(sqlStmt.getValue());
                return false;
            }
        });
        if (node.getSqlInfo() != null) {
            HashMap<String, List<SqlToken>> map = this.createSqlTokensMap(node.getSqlInfo());
            stmt.setColumnsClause(this.createSqlClause("columns", map));
            stmt.setInsertIntoClause(this.createSqlClause("insert into", map));
            stmt.setValuesClause(this.createSqlClause("values", map));
        }
        return false;
    }

    @Override
    public boolean visit(DeleteStatement node) {
        super.visit(node);
        final SqlDeleteStatement stmt = (SqlDeleteStatement)this.stack.peek();
        node.accept(new AbstractASTExpressionVisitor(){

            @Override
            public boolean visit(FromOrToExpressionClause clause) {
                clause.getExpression().accept(SQLIOStatementGenerator.this.generator);
                stmt.setDataSource((Expression)SQLIOStatementGenerator.this.stack.pop());
                return false;
            }

            @Override
            public boolean visit(NoCursorClause noCursorClause) {
                stmt.setNoCursor(Boolean.valueOf(true));
                return false;
            }

            @Override
            public boolean visit(WithInlineSQLClause withInlineSQLClause) {
                stmt.setHasExplicitSql(Boolean.valueOf(true));
                stmt.setSqlString(withInlineSQLClause.getSqlStmt().getValue());
                return false;
            }
        });
        if (node.getSqlInfo() != null) {
            HashMap<String, List<SqlToken>> map = this.createSqlTokensMap(node.getSqlInfo());
            stmt.setDeleteClause(this.createSqlClause("delete", map));
            stmt.setFromClause(this.createSqlClause("from", map));
            stmt.setWhereClause(this.createSqlClause("where", map));
        }
        return false;
    }

    @Override
    public boolean visit(ExecuteStatement node) {
        final SqlExecuteStatement stmt = this.factory.createSqlExecuteStatement();
        this.stack.push(stmt);
        final SQLIOStatementGenerator stmtGenerator = this;
        node.accept(new AbstractASTExpressionVisitor(){

            @Override
            public boolean visit(UsingClause usingClause) {
                for (org.eclipse.edt.compiler.core.ast.Expression expr : usingClause.getExpressions()) {
                    expr.accept(this);
                    stmt.getUsingExpressions().add((Expression)SQLIOStatementGenerator.this.stack.pop());
                }
                return false;
            }

            @Override
            public boolean visit(ForExpressionClause forExpressionClause) {
                forExpressionClause.getExpression().accept(stmtGenerator);
                stmt.getTargets().add((Expression)SQLIOStatementGenerator.this.stack.pop());
                return false;
            }
        });
        if (node.getSqlInfo() != null) {
            HashMap<String, List<SqlToken>> map = this.createSqlTokensMap(node.getSqlInfo());
            stmt.setSqlClause(this.createSqlClause("execute", map));
        }
        return false;
    }

    @Override
    public boolean visit(ForEachStatement forEachStatement) {
        super.visit(forEachStatement);
        final SqlForEachStatement forEachStmt = (SqlForEachStatement)this.stack.peek();
        this.stack.push(forEachStmt);
        if (forEachStatement.hasSQLRecord()) {
            forEachStatement.getSQLRecord().accept(this);
            forEachStmt.getTargets().add((Expression)this.stack.pop());
        } else if (forEachStatement.hasResultSet()) {
            forEachStatement.getResultSet().accept(this);
            forEachStmt.setDataSource((Expression)this.stack.pop());
        }
        forEachStatement.accept(new AbstractASTExpressionVisitor(){

            @Override
            public boolean visit(IntoClause clause) {
                for (org.eclipse.edt.compiler.core.ast.Expression expr : clause.getExpressions()) {
                    expr.accept(SQLIOStatementGenerator.this.generator);
                    forEachStmt.getIntoExpressions().add((Expression)SQLIOStatementGenerator.this.stack.pop());
                }
                return false;
            }
        });
        StatementBlock block = this.irFactory.createStatementBlock();
        forEachStmt.setBody((Statement)block);
        for (Node node : forEachStatement.getStmts()) {
            node.accept(this);
            block.getStatements().add((Statement)this.stack.pop());
        }
        return false;
    }

    @Override
    public boolean visit(GetByKeyStatement node) {
        super.visit(node);
        final SqlGetByKeyStatement stmt = (SqlGetByKeyStatement)this.stack.peek();
        node.accept(new AbstractASTExpressionVisitor(){

            @Override
            public boolean visit(ForUpdateClause clause) {
                stmt.setIsForUpdate(Boolean.valueOf(true));
                return false;
            }

            @Override
            public boolean visit(SingleRowClause clause) {
                stmt.setIsSingleRowSelect(Boolean.valueOf(true));
                return false;
            }

            @Override
            public boolean visit(WithIDClause clause) {
                stmt.setPreparedStatementId(clause.getID());
                stmt.setHasExplicitSql(Boolean.valueOf(true));
                return false;
            }

            @Override
            public boolean visit(IntoClause clause) {
                for (org.eclipse.edt.compiler.core.ast.Expression expr : clause.getExpressions()) {
                    expr.accept(SQLIOStatementGenerator.this.generator);
                    stmt.getIntoExpressions().add((Expression)SQLIOStatementGenerator.this.stack.pop());
                }
                return false;
            }

            @Override
            public boolean visit(FromOrToExpressionClause clause) {
                clause.getExpression().accept(SQLIOStatementGenerator.this.generator);
                stmt.setDataSource((Expression)SQLIOStatementGenerator.this.stack.pop());
                return false;
            }

            @Override
            public boolean visit(WithInlineSQLClause withInlineSQLClause) {
                stmt.setHasExplicitSql(Boolean.valueOf(true));
                stmt.setSqlString(withInlineSQLClause.getSqlStmt().getValue());
                return false;
            }
        });
        if (node.getSqlInfo() != null) {
            HashMap<String, List<SqlToken>> map = this.createSqlTokensMap(node.getSqlInfo());
            stmt.setCallClause(this.createSqlClause("call", map));
            stmt.setSelectClause(this.createSqlClause("select", map));
            stmt.setFromClause(this.createSqlClause("from", map));
            stmt.setWhereClause(this.createSqlClause("where", map));
            stmt.setGroupByClause(this.createSqlClause("group by", map));
            stmt.setHavingClause(this.createSqlClause("having", map));
            stmt.setOrderByClause(this.createSqlClause("order by", map));
            stmt.setForUpdateOfClause(this.createSqlClause("for update of", map));
        }
        return false;
    }

    @Override
    public boolean visit(GetByPositionStatement node) {
        super.visit(node);
        final SqlGetByPositionStatement stmt = (SqlGetByPositionStatement)this.stack.peek();
        node.accept(new AbstractASTExpressionVisitor(){

            @Override
            public boolean visit(IntoClause clause) {
                for (org.eclipse.edt.compiler.core.ast.Expression expr : clause.getExpressions()) {
                    expr.accept(SQLIOStatementGenerator.this.generator);
                    stmt.getIntoExpressions().add((Expression)SQLIOStatementGenerator.this.stack.pop());
                }
                return false;
            }
        });
        if (node.hasFromExpr()) {
            node.getFromExpr().accept(this);
            stmt.setDataSource((Expression)this.stack.pop());
        }
        return false;
    }

    @Override
    public boolean visit(OpenStatement node) {
        final SqlOpenStatement stmt = this.factory.createSqlOpenStatement();
        this.stack.push(stmt);
        stmt.setIsHold(Boolean.valueOf(node.hasHold()));
        stmt.setIsScroll(Boolean.valueOf(node.hasScroll()));
        node.accept(new AbstractASTExpressionVisitor(){

            @Override
            public boolean visit(ForUpdateClause clause) {
                stmt.setIsForUpdate(Boolean.valueOf(true));
                return false;
            }

            @Override
            public boolean visit(FromOrToExpressionClause clause) {
                clause.getExpression().accept(SQLIOStatementGenerator.this.generator);
                stmt.setDataSource((Expression)SQLIOStatementGenerator.this.stack.pop());
                return false;
            }

            @Override
            public boolean visit(WithIDClause clause) {
                stmt.setPreparedStatementId(clause.getID());
                stmt.setHasExplicitSql(Boolean.valueOf(true));
                return false;
            }

            @Override
            public boolean visit(IntoClause clause) {
                for (org.eclipse.edt.compiler.core.ast.Expression expr : clause.getExpressions()) {
                    expr.accept(SQLIOStatementGenerator.this.generator);
                    stmt.getIntoExpressions().add((Expression)SQLIOStatementGenerator.this.stack.pop());
                }
                return false;
            }

            @Override
            public boolean visit(UsingClause clause) {
                for (org.eclipse.edt.compiler.core.ast.Expression expr : clause.getExpressions()) {
                    expr.accept(SQLIOStatementGenerator.this.generator);
                    stmt.getUsingExpressions().add((Expression)SQLIOStatementGenerator.this.stack.pop());
                }
                return false;
            }

            @Override
            public boolean visit(UsingKeysClause clause) {
                for (org.eclipse.edt.compiler.core.ast.Expression expr : clause.getExpressions()) {
                    expr.accept(SQLIOStatementGenerator.this.generator);
                    stmt.getUsingKeyExpressions().add((Expression)SQLIOStatementGenerator.this.stack.pop());
                }
                return false;
            }

            @Override
            public boolean visit(ForExpressionClause forExpressionClause) {
                forExpressionClause.getExpression().accept(SQLIOStatementGenerator.this.generator);
                stmt.getTargets().add((Expression)SQLIOStatementGenerator.this.stack.pop());
                return false;
            }

            @Override
            public boolean visit(WithInlineSQLClause withInlineSQLClause) {
                stmt.setHasExplicitSql(Boolean.valueOf(true));
                stmt.setSqlString(withInlineSQLClause.getSqlStmt().getValue());
                return false;
            }
        });
        node.getResultSet().accept(this);
        stmt.setResultSet((Expression)this.stack.pop());
        if (node.getSqlInfo() != null) {
            HashMap<String, List<SqlToken>> map = this.createSqlTokensMap(node.getSqlInfo());
            stmt.setCallClause(this.createSqlClause("call", map));
            stmt.setSelectClause(this.createSqlClause("select", map));
            stmt.setFromClause(this.createSqlClause("from", map));
            stmt.setWhereClause(this.createSqlClause("where", map));
            stmt.setGroupByClause(this.createSqlClause("group by", map));
            stmt.setHavingClause(this.createSqlClause("having", map));
            stmt.setOrderByClause(this.createSqlClause("order by", map));
            stmt.setForUpdateOfClause(this.createSqlClause("for update of", map));
        }
        this.setElementInformation((Node)node, (Statement)stmt);
        return false;
    }

    @Override
    public boolean visit(PrepareStatement node) {
        final SqlPrepareStatement stmt = this.factory.createSqlPrepareStatement();
        this.stack.push(stmt);
        node.accept(new AbstractASTExpressionVisitor(){

            @Override
            public boolean visit(FromExpressionClause clause) {
                clause.getExpression().accept(SQLIOStatementGenerator.this.generator);
                stmt.setFromExpression((Expression)SQLIOStatementGenerator.this.stack.pop());
                return false;
            }

            @Override
            public boolean visit(ForExpressionClause clause) {
                clause.getExpression().accept(SQLIOStatementGenerator.this.generator);
                stmt.setForExpression((Expression)SQLIOStatementGenerator.this.stack.pop());
                return false;
            }
        });
        this.setElementInformation((Node)node, (Statement)stmt);
        return false;
    }

    @Override
    public boolean visit(ReplaceStatement node) {
        super.visit(node);
        final SqlReplaceStatement stmt = (SqlReplaceStatement)this.stack.peek();
        node.accept(new AbstractASTExpressionVisitor(){

            @Override
            public boolean visit(FromOrToExpressionClause clause) {
                clause.getExpression().accept(SQLIOStatementGenerator.this.generator);
                stmt.setDataSource((Expression)SQLIOStatementGenerator.this.stack.pop());
                return false;
            }

            @Override
            public boolean visit(NoCursorClause noCursorClause) {
                stmt.setNoCursor(Boolean.valueOf(true));
                return false;
            }

            @Override
            public boolean visit(WithInlineSQLClause withInlineSQLClause) {
                stmt.setHasExplicitSql(Boolean.valueOf(true));
                return false;
            }
        });
        if (node.getSqlInfo() != null) {
            HashMap<String, List<SqlToken>> map = this.createSqlTokensMap(node.getSqlInfo());
            stmt.setSetClause(this.createSqlClause("set", map));
            stmt.setUpdateClause(this.createSqlClause("update", map));
            stmt.setWhereClause(this.createSqlClause("where", map));
        }
        return false;
    }

    @Override
    public EClass getStatementEClass(AddStatement stmt) {
        return this.factory.getSqlAddStatementEClass();
    }

    @Override
    public EClass getStatementEClass(CloseStatement stmt) {
        return this.factory.getSqlCloseStatementEClass();
    }

    @Override
    public EClass getStatementEClass(DeleteStatement stmt) {
        return this.factory.getSqlDeleteStatementEClass();
    }

    @Override
    public EClass getStatementEClass(ExecuteStatement stmt) {
        return this.factory.getSqlExecuteStatementEClass();
    }

    @Override
    public EClass getStatementEClass(ForEachStatement stmt) {
        return this.factory.getSqlForEachStatementEClass();
    }

    @Override
    public EClass getStatementEClass(GetByKeyStatement stmt) {
        return this.factory.getSqlGetByKeyStatementEClass();
    }

    @Override
    public EClass getStatementEClass(GetByPositionStatement stmt) {
        return this.factory.getSqlGetByPositionStatementEClass();
    }

    @Override
    public EClass getStatementEClass(OpenStatement stmt) {
        return this.factory.getSqlOpenStatementEClass();
    }

    @Override
    public EClass getStatementEClass(PrepareStatement stmt) {
        return this.factory.getSqlPrepareStatementEClass();
    }

    @Override
    public EClass getStatementEClass(ReplaceStatement stmt) {
        return this.factory.getSqlReplaceStatementEClass();
    }

    private HashMap<String, List<SqlToken>> createSqlTokensMap(SQLInfo sqlinfo) {
        HashMap<String, List<SqlToken>> map = new HashMap<String, List<SqlToken>>();
        HashMap clauseMap = sqlinfo.getClauseMap();
        for (String key : clauseMap.keySet()) {
            Token[] tokens = (Token[])clauseMap.get(key);
            map.put(key, this.convertSqlTokens(tokens));
        }
        return map;
    }

    private SqlToken convertSqlToken(Token oldToken) {
        if (oldToken.isItemNameToken()) {
            ItemNameToken itemNameToken = (ItemNameToken)oldToken;
            if (itemNameToken.getExpression() != null) {
                itemNameToken.getExpression().accept(this);
            }
            SqlInputHostVariableToken newToken = null;
            if (itemNameToken.isInputHostVariableToken()) {
                newToken = this.factory.createSqlInputHostVariableToken();
                newToken.setString(oldToken.getString());
                newToken.setSqlString(oldToken.getSQLString());
            } else if (itemNameToken.isOutputHostVariableToken()) {
                newToken = this.factory.createSqlOutputHostVariableToken();
                newToken.setString(oldToken.getString());
                newToken.setSqlString(oldToken.getSQLString());
            } else if (itemNameToken.isTableNameHostVariableToken()) {
                newToken = this.factory.createSqlTableNameHostVariableToken();
                newToken.setString(oldToken.getString());
                newToken.setSqlString(oldToken.getSQLString());
            }
            if (newToken != null) {
                newToken.setHostVarExpression((LHSExpr)this.stack.pop());
            }
            return newToken;
        }
        if (oldToken.isSelectNameToken()) {
            SqlSelectNameToken newToken = this.factory.createSqlSelectNameToken();
            newToken.setString(oldToken.getString());
            newToken.setSqlString(oldToken.getSQLString());
            return newToken;
        }
        if (oldToken.isStringToken()) {
            SqlStringToken newToken = this.factory.createSqlStringToken();
            newToken.setString(oldToken.getString());
            newToken.setSqlString(oldToken.getSQLString());
            return newToken;
        }
        if (oldToken.isWhereCurrentOfToken()) {
            SqlWhereCurrentOfToken whereToken = this.factory.createSqlWhereCurrentOfToken();
            whereToken.setString(oldToken.getString());
            whereToken.setSqlString(oldToken.getSQLString());
            whereToken.setResultSetIdentifier(((WhereCurrentOfToken)oldToken).getResultSetIdentifier());
            return whereToken;
        }
        return null;
    }

    private List<SqlToken> convertSqlTokens(Token[] oldTokens) {
        if (oldTokens == null) {
            return null;
        }
        ArrayList<SqlToken> list = new ArrayList<SqlToken>();
        int i = 0;
        while (i < oldTokens.length) {
            list.add(this.convertSqlToken(oldTokens[i]));
            ++i;
        }
        return list;
    }

    private SqlClause createSqlClause(String name, Map<String, List<SqlToken>> map) {
        if (map.get(name) != null) {
            SqlClause clause = this.factory.createSqlClause();
            clause.setName(name);
            clause.getTokens().addAll((Collection)map.get(name));
            return clause;
        }
        return null;
    }
}

