/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.eglar;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.eclipse.edt.compiler.internal.eglar.EglarManifest;

public class EglarFile
extends JarFile {
    private EglarManifest manifest;
    private HashMap entries;

    public EglarFile(String fileName) throws IOException {
        super(fileName);
    }

    public EglarFile(File file) throws IOException {
        super(file);
    }

    @Override
    public EglarManifest getManifest() {
        if (this.manifest == null) {
            try {
                this.manifest = new EglarManifest(this.getInputStream(new ZipEntry("META-INF/MANIFEST.MF")));
            }
            catch (Exception exception) {
                this.manifest = new EglarManifest();
            }
        }
        return this.manifest;
    }

    @Override
    public ZipEntry getEntry(String entryName) {
        if (entryName.indexOf(92) > 0) {
            entryName = entryName.replaceAll("\\\\", "/");
        }
        return super.getEntry(entryName);
    }

    public LinkedHashSet getChildrenOf(String parent) {
        if (this.entries == null) {
            this.entries = new HashMap();
            Enumeration<JarEntry> zipEntries = this.entries();
            while (zipEntries.hasMoreElements()) {
                ZipEntry entry = zipEntries.nextElement();
                String name = entry.getName();
                int index = name.indexOf("/");
                String parentName = "";
                LinkedHashSet<String> children = null;
                if (index <= 0 && (children = (LinkedHashSet<String>)this.entries.get(parentName)) == null) {
                    children = new LinkedHashSet<String>();
                    this.entries.put(parentName, children);
                }
                boolean firstSeg = true;
                while (index > 0) {
                    ++index;
                    if (firstSeg) {
                        firstSeg = false;
                        children = (LinkedHashSet<String>)this.entries.get(parentName);
                        if (children == null) {
                            children = new LinkedHashSet<String>();
                            this.entries.put(parentName, children);
                        }
                        children.add(name.substring(0, index));
                    }
                    if ((children = (LinkedHashSet)this.entries.get(parentName = name.substring(0, index))) == null) {
                        children = new LinkedHashSet();
                        this.entries.put(parentName, children);
                    }
                    if (name.indexOf("/", index) > 0) {
                        children.add(name.substring(0, name.indexOf("/", index) + 1));
                    }
                    index = name.indexOf("/", index);
                }
                children.add(entry.getName());
            }
        }
        return (LinkedHashSet)this.entries.get(parent);
    }

    public boolean isManifestExist() {
        return this.getEntry("META-INF/MANIFEST.MF") != null;
    }
}

