/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.io;

import com.ibm.icu.util.StringTokenizer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.compiler.internal.io.DefaultZipFileIOBufferReader;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public abstract class ZipFileBuildPathEntry {
    private DefaultZipFileIOBufferReader reader = null;
    private HashMap partNamesByPackage = new HashMap();
    private HashMap partNamesWithoutPackage = new HashMap();
    protected HashMap partCache = new HashMap();
    private String path = null;

    public ZipFileBuildPathEntry(String path) {
        this.path = path;
        this.reader = new DefaultZipFileIOBufferReader(path);
    }

    public void clear() {
        this.reader = null;
        this.partNamesByPackage.clear();
        this.partNamesWithoutPackage.clear();
        this.partCache = new HashMap();
    }

    public void clearParts() {
        this.partCache = new HashMap();
    }

    public boolean hasPackage(String[] packageName) {
        if (packageName == null || packageName.length == 0) {
            return false;
        }
        return this.partNamesByPackage.get(packageName) != null;
    }

    protected String getEntry(String[] packageName, String partName) {
        String entry = "";
        if (packageName == null || packageName.length == 0) {
            entry = (String)this.partNamesWithoutPackage.get(partName);
        } else {
            Map partpackage = (Map)this.partNamesByPackage.get(packageName);
            if (partpackage != null) {
                entry = (String)partpackage.get(partName);
            }
        }
        return entry;
    }

    protected String[] getPackageName(String packagename) {
        return this.getPackageName(packagename, true);
    }

    protected String[] getPackageName(String packagename, boolean removeLast) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(packagename, new String("\\/"));
        while (tokenizer.hasMoreTokens()) {
            String s = tokenizer.nextToken();
            list.add(s);
        }
        if (removeLast) {
            list.remove(list.size() - 1);
        }
        return InternUtil.intern((String[])list.toArray(new String[list.size()]));
    }

    protected boolean processEntry(String entry) {
        if (entry.endsWith(this.getFileExtension())) {
            String partname = this.getPartName(entry);
            String[] packageName = InternUtil.intern((String[])this.getPackageName(entry));
            if (packageName == null || packageName.length == 0) {
                this.partNamesWithoutPackage.put(InternUtil.intern((String)partname), entry);
            } else {
                Map partpackage = this.getPackagePartNames(packageName);
                partpackage.put(partname, entry);
                int i = 0;
                while (i < packageName.length - 1) {
                    String[] subpackage = new String[i + 1];
                    System.arraycopy(packageName, 0, subpackage, 0, i + 1);
                    this.getPackagePartNames(InternUtil.intern((String[])subpackage));
                    ++i;
                }
            }
            return true;
        }
        return false;
    }

    protected String getPartName(String entry) {
        File temppath = new File(entry);
        String partname = temppath.getName();
        return InternUtil.intern((String)partname.substring(0, partname.indexOf(46)));
    }

    protected String getFileExtension() {
        return ".eglxml";
    }

    protected String[] getAllEntries() {
        ArrayList list = new ArrayList();
        list.addAll(this.partNamesWithoutPackage.values());
        for (Map map : this.partNamesByPackage.values()) {
            list.addAll(map.values());
        }
        return list.toArray(new String[list.size()]);
    }

    private Map getPackagePartNames(String[] packageName) {
        HashMap map = (HashMap)this.partNamesByPackage.get(packageName);
        if (map == null) {
            map = new HashMap();
            this.partNamesByPackage.put(packageName, map);
        }
        return map;
    }

    protected void processEntries() {
        try {
            List entries = this.reader.getEntries();
            int i = 0;
            while (i < entries.size()) {
                String entry = (String)entries.get(i);
                this.processEntry(entry);
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BuildException(e);
        }
    }

    public boolean isZipFile() {
        return true;
    }

    public String getID() {
        return this.path;
    }

    public InputStream getResourceAsStream(String relativePath) {
        try {
            return this.reader.getInputStream(relativePath);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getResourceLocation(String relativePath) {
        throw new UnsupportedOperationException();
    }

    public HashMap getPartNamesByPackage() {
        return this.partNamesByPackage;
    }

    public List<String> getAllKeysFromPkg(String pkg, boolean includeSubPkgs) {
        ArrayList<String> list = new ArrayList<String>();
        if (pkg.length() == 0) {
            list.addAll(this.getAllEntriesAsKeys(this.partNamesWithoutPackage));
            if (includeSubPkgs) {
                for (Map map : this.partNamesByPackage.values()) {
                    list.addAll(this.getAllEntriesAsKeys(map));
                }
            }
            return list;
        }
        String[] pkgName = this.getPackageName(pkg.replace('.', '/'), false);
        for (String[] key : this.partNamesByPackage.keySet()) {
            if (pkgName != key && !this.isSubPkg(key, pkgName)) continue;
            Map map = (Map)this.partNamesByPackage.get(key);
            list.addAll(this.getAllEntriesAsKeys(map));
        }
        return list;
    }

    private boolean isSubPkg(String[] pkgName, String[] subPkgName) {
        if (pkgName.length <= subPkgName.length) {
            return false;
        }
        int i = 0;
        while (i < subPkgName.length) {
            String subPkgFrag = subPkgName[i];
            String pkgFrag = pkgName[i];
            if (!subPkgFrag.equalsIgnoreCase(pkgFrag)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private List<String> getAllEntriesAsKeys(Map map) {
        ArrayList<String> list = new ArrayList<String>();
        for (String entry : map.values()) {
            list.add(this.convertToStoreKey(entry));
        }
        return list;
    }

    protected String convertToStoreKey(String entry) {
        String value = entry.substring(0, entry.indexOf("."));
        value = value.replaceAll("/", ".");
        value = "egl:" + value;
        return value;
    }
}

