/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.sdk.compile;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.edt.compiler.binding.FileBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.TopLevelFunction;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.BindingCreator;
import org.eclipse.edt.compiler.internal.core.lookup.EnvironmentScope;
import org.eclipse.edt.compiler.internal.core.lookup.FileScope;
import org.eclipse.edt.compiler.internal.core.lookup.FunctionContainerScope;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.IEnvironment;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.compiler.internal.core.lookup.SystemScope;
import org.eclipse.edt.compiler.internal.sdk.compile.ASTManager;
import org.eclipse.edt.compiler.internal.sdk.compile.Compiler;
import org.eclipse.edt.compiler.internal.sdk.compile.DependencyInfo;
import org.eclipse.edt.compiler.internal.sdk.compile.ISDKProblemRequestorFactory;
import org.eclipse.edt.compiler.internal.sdk.compile.SourcePathInfo;
import org.eclipse.edt.compiler.internal.sdk.utils.Util;
import org.eclipse.edt.compiler.internal.util.TopLevelFunctionInfo;

public class TopLevelFunctionProcessor {
    private LinkedHashMap pendingUnits = new LinkedHashMap();
    private IPartBinding functionBeingProcessed;
    private HashSet processedUnits = new HashSet();
    private List processedFunctionInfos = new ArrayList();
    private FunctionContainerScope functionContainerScope;
    private DependencyInfo dependencyInfo;
    private IPartBinding containerContext;
    private IEnvironment environment;
    private ICompilerOptions compilerOptions;
    private ISDKProblemRequestorFactory problemRequestorFactory;

    public TopLevelFunctionProcessor(IEnvironment environment, FunctionContainerScope functionContainerScope, DependencyInfo dependencyInfo, ICompilerOptions compilerOptions, ISDKProblemRequestorFactory problemRequestorFactory) {
        this.environment = environment;
        this.functionContainerScope = functionContainerScope;
        this.dependencyInfo = dependencyInfo;
        this.compilerOptions = compilerOptions;
        this.problemRequestorFactory = problemRequestorFactory;
        this.containerContext = functionContainerScope.getPartBinding();
    }

    protected void addPart(IPartBinding function) {
        if (this.functionBeingProcessed != function && !this.processedUnits.contains(new TopLevelFunctionProcessingUnitKey(function))) {
            this.pendingUnits.put(new TopLevelFunctionProcessingUnitKey(function), new TopLevelFunctionProcessingUnit(function));
        }
    }

    public TopLevelFunctionInfo[] process() {
        while (!this.pendingUnits.isEmpty()) {
            Iterator iterator = this.pendingUnits.values().iterator();
            TopLevelFunctionProcessingUnit processingUnit = (TopLevelFunctionProcessingUnit)iterator.next();
            this.process(processingUnit);
        }
        return this.processedFunctionInfos.toArray(new TopLevelFunctionInfo[this.processedFunctionInfos.size()]);
    }

    private void process(TopLevelFunctionProcessingUnit processingUnit) {
        this.pendingUnits.remove(new TopLevelFunctionProcessingUnitKey(processingUnit.function));
        this.functionBeingProcessed = processingUnit.function;
        this.compile(processingUnit);
        this.functionBeingProcessed = null;
        this.processedUnits.add(new TopLevelFunctionProcessingUnitKey(processingUnit.function));
    }

    private Part compile(TopLevelFunctionProcessingUnit functionUnit) {
        String[] functionPackageName = functionUnit.function.getPackageName();
        String functionPartName = functionUnit.function.getName();
        String[] contextPackageName = this.containerContext.getPackageName();
        String contextPartName = this.containerContext.getName();
        String contextSpecificCaseSensitiveInternedFunctionName = functionUnit.contextSpecificCaseSensitiveInternedFunctionName;
        File functionDeclaringFile = SourcePathInfo.getInstance().getDeclaringFile(functionPackageName, functionPartName);
        if (functionDeclaringFile == null || !functionDeclaringFile.exists()) {
            throw new BuildException("Unable to compile top level function " + functionUnit.function.getPackageQualifiedName() + " : EGL source code not be found.");
        }
        TopLevelFunction functionAST = (TopLevelFunction)ASTManager.getInstance().getPartAST(functionDeclaringFile, functionPartName);
        boolean isContainerContextDependent = functionAST.isContainerContextDependent();
        IProblemRequestor pRequestor = this.problemRequestorFactory.getContainerContextTopLevelProblemRequestor(functionDeclaringFile, contextPartName, isContainerContextDependent);
        this.processedFunctionInfos.add(new TopLevelFunctionInfo(functionAST, functionDeclaringFile.getAbsolutePath(), pRequestor));
        IPartBinding functionBinding = new BindingCreator(this.environment, functionPackageName, contextSpecificCaseSensitiveInternedFunctionName, functionAST).getPartBinding();
        functionBinding.setEnvironment(this.environment);
        Scope scope = this.createScope(functionPackageName, contextPackageName, contextPartName, functionDeclaringFile, isContainerContextDependent);
        Compiler.getInstance().compileTopLevelFunction(functionAST, functionBinding, scope, this.containerContext, this.dependencyInfo, pRequestor, this.compilerOptions);
        for (IPartBinding function : this.dependencyInfo.getTopLevelFunctions()) {
            this.addPart(function);
        }
        return functionAST;
    }

    private Scope createScope(String[] functionPackageName, String[] contextPackageName, String contextPartName, File functionDeclaringFile, boolean isContainerContextDependent) {
        FileScope fileScope;
        String fileName;
        if (isContainerContextDependent) {
            fileName = Util.getFilePartName(SourcePathInfo.getInstance().getDeclaringFile(contextPackageName, contextPartName));
            IPartBinding fileBinding = this.environment.getPartBinding(contextPackageName, fileName);
            fileScope = new FileScope(new EnvironmentScope(this.environment, this.dependencyInfo), (FileBinding)fileBinding, this.dependencyInfo);
        } else {
            fileName = Util.getFilePartName(functionDeclaringFile);
            IPartBinding fileBinding = this.environment.getPartBinding(functionPackageName, fileName);
            fileScope = new FileScope(new EnvironmentScope(this.environment, this.dependencyInfo), (FileBinding)fileBinding, this.dependencyInfo);
            this.dependencyInfo.recordTypeBinding(fileBinding);
        }
        FunctionContainerScope scope = new FunctionContainerScope((Scope)new SystemScope(fileScope, this.environment.getSystemEnvironment()), this.functionContainerScope);
        return scope;
    }

    private class TopLevelFunctionProcessingUnit {
        IPartBinding function;
        String contextSpecificCaseSensitiveInternedFunctionName;

        TopLevelFunctionProcessingUnit(IPartBinding function) {
            this.function = function;
            this.contextSpecificCaseSensitiveInternedFunctionName = this.createContextSpecificFunctionName();
        }

        private String createContextSpecificFunctionName() {
            StringBuffer contextSpecificFunctionNameBuffer = new StringBuffer();
            contextSpecificFunctionNameBuffer.append(String.valueOf(TopLevelFunctionProcessor.this.containerContext.getName()) + "$");
            int i = 0;
            while (i < this.function.getPackageName().length) {
                contextSpecificFunctionNameBuffer.append(String.valueOf(this.function.getPackageName()[i]) + ".");
                ++i;
            }
            contextSpecificFunctionNameBuffer.append(this.function.getName());
            return contextSpecificFunctionNameBuffer.toString().intern();
        }
    }

    public class TopLevelFunctionProcessingUnitKey {
        IPartBinding function;

        public TopLevelFunctionProcessingUnitKey(IPartBinding function) {
            this.function = function;
        }

        public boolean equals(Object otherObject) {
            if (this == otherObject) {
                return true;
            }
            if (otherObject instanceof TopLevelFunctionProcessingUnitKey) {
                TopLevelFunctionProcessingUnitKey otherPUKey = (TopLevelFunctionProcessingUnitKey)otherObject;
                return otherPUKey.function == this.function;
            }
            return false;
        }

        public int hashCode() {
            return this.function.getName().hashCode();
        }
    }
}

