/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.sql.statements;

import java.util.List;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.internal.core.builder.Problem;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.sql.statements.EGLSQLClauseFactory;
import org.eclipse.edt.compiler.internal.sql.statements.EGLSQLStatementFactory;

public abstract class EGLSQLDeclareStatementFactory
extends EGLSQLStatementFactory {
    String selectClause = null;
    String intoClause = null;
    String fromClause = null;
    String whereClause = null;
    String eglUsingClause = null;
    List userDefinedIntoItemNames;
    boolean addIntoClauseToStatement = true;
    boolean buildIntoClause = true;
    boolean buildIntoClauseForEditor = false;
    protected boolean isDynamicArrayRecord = false;

    public EGLSQLDeclareStatementFactory(IDataBinding recordBinding, String ioObjectName, List userDefinedIntoItemNames, String[][] keyItemAndColumnNames, boolean isDynamicArrayRecord, ICompilerOptions compilerOptions) {
        super(recordBinding, ioObjectName, compilerOptions);
        this.userDefinedIntoItemNames = userDefinedIntoItemNames;
        this.keyItemAndColumnNames = keyItemAndColumnNames;
        this.isDynamicArrayRecord = isDynamicArrayRecord;
    }

    @Override
    public String buildDefaultSQLStatement() {
        if (!this.setupSQLInfo()) {
            return null;
        }
        this.selectClause = EGLSQLClauseFactory.createDefaultSelectClause(this.columnNames);
        this.sqlStatement = this.selectClause != null ? this.selectClause : "";
        if (this.buildIntoClause) {
            this.intoClause = this.userDefinedIntoItemNames != null ? EGLSQLClauseFactory.createIntoClauseFromItemNameList(this.userDefinedIntoItemNames) : EGLSQLClauseFactory.createDefaultIntoClause(this.itemNames, this.ioObjectName, this.buildIntoClauseForEditor);
            if (this.intoClause != null && this.addIntoClauseToStatement) {
                this.sqlStatement = String.valueOf(this.sqlStatement) + this.intoClause;
            }
        }
        this.fromClause = EGLSQLClauseFactory.createDefaultFromClause(this.tableNames, this.tableLabels);
        if (this.fromClause != null) {
            this.sqlStatement = String.valueOf(this.sqlStatement) + this.fromClause;
        }
        if (this.sqlRecordData.getType().getKind() != 2) {
            this.whereClause = EGLSQLClauseFactory.createDefaultWhereClause(this.getDefaultSelectConditions(), this.keyItemAndColumnNames, this.getIOType(), this.ioObjectName, this.isDynamicArrayRecord, this.useRecordKeys);
            if (this.whereClause != null) {
                this.sqlStatement = String.valueOf(this.sqlStatement) + this.whereClause;
                this.eglUsingClause = EGLSQLClauseFactory.createEglUsingClauseForGet(this.keyItemAndColumnNames, this.ioObjectName);
            }
        }
        return this.sqlStatement;
    }

    public String getFromClause() {
        return this.fromClause;
    }

    public String getIntoClause() {
        return this.intoClause;
    }

    public String getSelectClause() {
        return this.selectClause;
    }

    public String getWhereClause() {
        return this.whereClause;
    }

    @Override
    public String getEglUsingClause() {
        return this.eglUsingClause;
    }

    @Override
    protected boolean isIoObjectValid() {
        boolean isValid = super.isIoObjectValid();
        if (this.numSQLDataItems == 0) {
            this.errorMessages.add(this.getContainsNoItemsMessage());
            isValid = false;
        }
        return isValid;
    }

    protected Problem getContainsNoItemsMessage() {
        return new Problem(0, 0, 2, 4530, new String[]{this.ioObjectName});
    }

    @Override
    protected void setupItemColumnAndKeyInfo() {
        this.itemNames = new String[this.numSQLDataItems];
        this.columnNames = new String[this.numSQLDataItems];
        if (this.keyItemAndColumnNames == null) {
            this.keyItemAndColumnNames = this.getKeyItems() != null ? new String[this.getKeyItems().length][2] : new String[0][0];
        } else {
            this.useRecordKeys = false;
        }
        int numKeys = 0;
        if (this.structureItemBindings != null) {
            int i = 0;
            while (i < this.numSQLDataItems) {
                IDataBinding itemBinding = this.structureItemBindings[i];
                this.itemNames[i] = itemBinding.getName();
                ITypeBinding typeBinding = itemBinding.getType();
                this.columnNames[i] = typeBinding != null && typeBinding.getKind() == 3 && typeBinding.getName().equals("string") ? "rtrim(" + this.getColumnName(itemBinding) + ")" : this.getColumnName(itemBinding);
                if (this.useRecordKeys && this.isKeyItem(this.itemNames[i])) {
                    this.keyItemAndColumnNames[numKeys][0] = this.itemNames[i];
                    this.keyItemAndColumnNames[numKeys][1] = this.columnNames[i];
                    ++numKeys;
                }
                ++i;
            }
        }
        if (this.useRecordKeys && numKeys == 0 && this.getKeyItems().length > 0) {
            this.keyItemAndColumnNames = new String[0][0];
        }
    }

    private boolean isKeyItem(String itemName) {
        block6: {
            block5: {
                if (!this.useRecordKeys) break block5;
                if (this.getKeyItems() == null) break block6;
                int i = 0;
                while (i < this.keyItems.length) {
                    if (itemName.equalsIgnoreCase(this.keyItems[i].getName())) {
                        return true;
                    }
                    ++i;
                }
                break block6;
            }
            if (this.keyItemAndColumnNames != null) {
                int i = 0;
                while (i < this.keyItemAndColumnNames.length) {
                    if (itemName.equalsIgnoreCase(this.keyItemAndColumnNames[i][0])) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    @Override
    public String getSQLStatementType() {
        return "select".toUpperCase();
    }

    public boolean isAddIntoClauseToStatement() {
        return this.addIntoClauseToStatement;
    }

    public void setAddIntoClauseToStatement(boolean b) {
        this.addIntoClauseToStatement = b;
    }

    public boolean isBuildIntoClause() {
        return this.buildIntoClause;
    }

    public boolean isBuildIntoClauseForEditor() {
        return this.buildIntoClauseForEditor;
    }

    public void setBuildIntoClause(boolean b) {
        this.buildIntoClause = b;
    }

    public void setBuildIntoClauseForEditor(boolean b) {
        this.buildIntoClauseForEditor = b;
    }

    public String[][] getKeyItemAndColumnNames() {
        return this.keyItemAndColumnNames;
    }
}

