/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.sql.statements;

import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.internal.core.builder.Problem;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.sql.statements.EGLSQLClauseFactory;
import org.eclipse.edt.compiler.internal.sql.statements.EGLSQLStatementFactory;
import org.eclipse.edt.compiler.internal.sql.util.SQLUtility;

public class EGLSQLExecuteStatementFactory
extends EGLSQLStatementFactory {
    boolean createUpdate;
    boolean createDelete;
    boolean createInsert;

    public EGLSQLExecuteStatementFactory(IDataBinding recordData, String ioObjectName, boolean createUpdate, boolean createDelete, boolean createInsert, ICompilerOptions compilerOptions) {
        super(recordData, ioObjectName, compilerOptions);
        this.createUpdate = createUpdate;
        this.createDelete = createDelete;
        this.createInsert = createInsert;
    }

    @Override
    public String buildDefaultSQLStatement() {
        if (this.createUpdate || this.createDelete || this.createInsert) {
            String whereClause;
            if (!this.setupSQLInfo()) {
                return null;
            }
            if (this.createDelete) {
                this.sqlStatement = EGLSQLClauseFactory.createDefaultDeleteFromClause(this.tableNames, this.tableLabels);
            } else if (this.createUpdate) {
                String setClause;
                this.sqlStatement = EGLSQLClauseFactory.createDefaultUpdateClause(this.tableNames, this.tableLabels);
                if (this.sqlStatement != null && (setClause = EGLSQLClauseFactory.createDefaultSetClause(this.columnNames, this.itemNames, this.ioObjectName)) != null) {
                    this.sqlStatement = String.valueOf(this.sqlStatement) + setClause;
                }
            } else {
                String clause = EGLSQLClauseFactory.createDefaultInsertIntoClause(this.tableNames);
                this.sqlStatement = clause != null ? clause : "";
                clause = EGLSQLClauseFactory.createDefaultColumnsClause(this.columnNames);
                if (clause != null) {
                    this.sqlStatement = String.valueOf(this.sqlStatement) + clause;
                }
                if ((clause = EGLSQLClauseFactory.createDefaultValuesClause(this.itemNames, this.ioObjectName)) != null) {
                    this.sqlStatement = String.valueOf(this.sqlStatement) + clause;
                }
            }
            if ((this.createDelete || this.createUpdate) && this.sqlStatement != null && (whereClause = EGLSQLClauseFactory.createDefaultWhereClause(this.getDefaultSelectConditions(), this.keyItemAndColumnNames, "get forUpdate", this.ioObjectName, false, true)) != null) {
                this.sqlStatement = String.valueOf(this.sqlStatement) + whereClause;
            }
        }
        return this.sqlStatement;
    }

    protected boolean isIoObjectSQLRecord() {
        boolean isValidIoObject = SQLUtility.isEntityRecord(this.sqlRecordData);
        if ((this.createUpdate || this.createDelete || this.createInsert) && (this.ioObjectName == null || this.ioObjectName.trim().length() == 0)) {
            this.errorMessages.add(new Problem(0, 0, 2, 4538, new String[0]));
            isValidIoObject = false;
        }
        return isValidIoObject;
    }

    @Override
    public String getIOType() {
        return "execute".toUpperCase();
    }

    @Override
    protected boolean isIoObjectValid() {
        boolean isValid = true;
        if (this.createUpdate || this.createDelete || this.createInsert) {
            isValid = super.isIoObjectValid();
            if (this.createDelete) {
                if (!this.validateSQLRecordNotJoin()) {
                    isValid = false;
                }
            } else if (this.createUpdate) {
                isValid = this.hasPersistentItems();
                if (!this.validateSQLRecordNotJoinAndContainsOneNonReadOnlyOrNonKeyColumn()) {
                    isValid = false;
                }
            } else if (this.createInsert) {
                isValid = this.hasPersistentItems();
                if (!this.validateSQLRecordNotJoinAndContainsReadWriteColumns()) {
                    isValid = false;
                }
            }
        }
        return isValid;
    }

    protected boolean hasPersistentItems() {
        boolean isValid = true;
        if (this.numSQLDataItems == 0) {
            this.errorMessages.add(this.getContainsNoItemsMessage());
            isValid = false;
        }
        return isValid;
    }

    @Override
    protected void setupItemColumnAndKeyInfo() {
        if (this.createUpdate || this.createDelete) {
            this.setupForSQLUpdateStatement();
        } else if (this.createInsert) {
            this.setupForSQLInsertStatement();
        }
    }

    @Override
    public String getSQLStatementType() {
        if (this.createUpdate) {
            return "update".toUpperCase();
        }
        if (this.createDelete) {
            return "delete".toUpperCase();
        }
        if (this.createInsert) {
            return "insert".toUpperCase();
        }
        return "";
    }

    protected Problem getContainsNoItemsMessage() {
        return new Problem(0, 0, 2, 4530, new String[]{this.ioObjectName});
    }
}

