/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.sqltokenizer;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.edt.compiler.core.ast.WithInlineSQLClause;
import org.eclipse.edt.compiler.internal.core.builder.Problem;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.sqltokenizer.EGLPrimeToken;
import org.eclipse.edt.compiler.internal.sqltokenizer.EGLSQLClauseTree;
import org.eclipse.edt.compiler.internal.sqltokenizer.EGLSQLLexer;

public class EGLSQLParser {
    private Reader inputReader;
    private EGLSQLLexer lexer;
    private ArrayList sqlClauses;
    private ArrayList reservedClauseKeywordsUsed;
    private ArrayList problems;
    private EGLPrimeToken currentToken;
    private EGLPrimeToken previousToken;
    private boolean hasUnion;

    public EGLSQLParser(String input, String stmtType, ICompilerOptions compilerOptions) {
        this.inputReader = new StringReader(input);
        this.lexer = new EGLSQLLexer(this.inputReader, compilerOptions);
        this.sqlClauses = new ArrayList();
        this.reservedClauseKeywordsUsed = new ArrayList();
        this.problems = new ArrayList();
        this.currentToken = null;
        this.hasUnion = false;
        try {
            if (stmtType == "execute") {
                this.parseExecuteSQL();
            } else {
                this.parseSQL();
            }
        }
        catch (Exception iox) {
            iox.printStackTrace();
        }
        ArrayList lexerProbs = this.lexer.getProblems();
        int ii = 0;
        while (ii < lexerProbs.size()) {
            this.problems.add(lexerProbs.get(ii));
            ++ii;
        }
    }

    private boolean isClauseStart(String clauseKeyword) {
        if (clauseKeyword.equalsIgnoreCase("select") || clauseKeyword.equalsIgnoreCase("into") || clauseKeyword.equalsIgnoreCase("from") || clauseKeyword.equalsIgnoreCase("where") || clauseKeyword.equalsIgnoreCase("values") || clauseKeyword.equalsIgnoreCase("delete") || clauseKeyword.equalsIgnoreCase("set") || clauseKeyword.equalsIgnoreCase("having") || clauseKeyword.equalsIgnoreCase("call")) {
            return true;
        }
        if (clauseKeyword.equalsIgnoreCase("update")) {
            return this.previousToken == null || !"keep".equalsIgnoreCase(this.previousToken.getText()) || this.lexer.lookAhead1 == null || !"locks".equalsIgnoreCase(this.lexer.lookAhead1.getText());
        }
        return false;
    }

    private void parseSQL() throws IOException {
        EGLSQLClauseTree currentClause = null;
        EGLSQLClauseTree commentClause = null;
        boolean alreadyConsumed = false;
        this.previousToken = null;
        this.currentToken = this.lexer.getNextToken();
        while (this.currentToken != null) {
            String clauseKeyword = this.nextClauseKeyword(this.currentToken, this.lexer.lookAhead1, this.lexer.lookAhead2);
            if (this.isClauseStart(clauseKeyword)) {
                if (commentClause == null) {
                    currentClause = new EGLSQLClauseTree(this.currentToken);
                } else {
                    currentClause = commentClause;
                    currentClause.setClauseKeyword(this.currentToken);
                }
                currentClause.addToken(this.currentToken);
                this.sqlClauses.add(currentClause);
                if (!clauseKeyword.equalsIgnoreCase("into") && !this.reservedClauseKeywordsUsed.contains(this.currentToken.getText().toLowerCase())) {
                    this.reservedClauseKeywordsUsed.add(this.currentToken.getText().toLowerCase());
                }
            } else if (clauseKeyword.equalsIgnoreCase("order by") || clauseKeyword.equalsIgnoreCase("group by") || clauseKeyword.equalsIgnoreCase("insert into") || clauseKeyword.equalsIgnoreCase("for update")) {
                if (commentClause == null) {
                    currentClause = new EGLSQLClauseTree(this.currentToken, this.lexer.lookAhead1);
                } else {
                    currentClause = commentClause;
                    currentClause.setClauseKeyword(this.currentToken);
                    currentClause.setSecondKeyword(this.lexer.lookAhead1);
                }
                if (!this.reservedClauseKeywordsUsed.contains(this.currentToken.getText().toLowerCase())) {
                    this.reservedClauseKeywordsUsed.add(this.currentToken.getText().toLowerCase());
                }
                currentClause.addToken(this.currentToken);
                currentClause.addToken(this.lexer.lookAhead1);
                this.sqlClauses.add(currentClause);
                this.previousToken = this.currentToken;
                this.currentToken = this.lexer.getNextToken();
            } else if (clauseKeyword.equalsIgnoreCase("for update of") || clauseKeyword.equalsIgnoreCase("where current of")) {
                if (commentClause == null) {
                    currentClause = new EGLSQLClauseTree(this.currentToken, this.lexer.lookAhead1, this.lexer.lookAhead2);
                } else {
                    currentClause = commentClause;
                    currentClause.setClauseKeyword(this.currentToken);
                    currentClause.setSecondKeyword(this.lexer.lookAhead1);
                    currentClause.setThirdKeyword(this.lexer.lookAhead2);
                }
                String temp = null;
                temp = this.currentToken.getText().equalsIgnoreCase("where") ? "where" : "update";
                if (!this.reservedClauseKeywordsUsed.contains(temp.toLowerCase())) {
                    this.reservedClauseKeywordsUsed.add(temp.toLowerCase());
                }
                currentClause.addToken(this.currentToken);
                currentClause.addToken(this.lexer.lookAhead1);
                currentClause.addToken(this.lexer.lookAhead2);
                this.sqlClauses.add(currentClause);
                this.previousToken = this.currentToken;
                this.previousToken = this.currentToken = this.lexer.getNextToken();
                this.currentToken = this.lexer.getNextToken();
                if (clauseKeyword.equalsIgnoreCase("where current of")) {
                    this.currentToken.setWhereCurrentOf();
                }
            } else if (currentClause == null) {
                if (this.currentToken.getType() == Integer.MAX_VALUE) {
                    if (commentClause == null) {
                        commentClause = new EGLSQLClauseTree();
                    }
                    commentClause.addToken(this.currentToken);
                } else {
                    currentClause = new EGLSQLClauseTree();
                    currentClause.setClauseKeyword(new EGLPrimeToken(57, "EXECUTE", this.currentToken.getOffset(), this.currentToken.getLine(), this.currentToken.getColumn()));
                    currentClause.addToken(this.currentToken);
                    this.sqlClauses.add(currentClause);
                }
            } else {
                if (currentClause.getClauseType() == 11 && this.currentToken.getType() == 22) {
                    currentClause = new EGLSQLClauseTree(new EGLPrimeToken(56, "COLUMNS", 0, 0, 0));
                    this.sqlClauses.add(currentClause);
                }
                switch (this.currentToken.getType()) {
                    case 22: {
                        currentClause.addToken(this.currentToken);
                        alreadyConsumed = this.matchSQLParens(currentClause);
                        break;
                    }
                    case 28: {
                        if (this.isReallyAHostVarColon()) {
                            currentClause.addToken(this.currentToken);
                            List probs = this.getHostVarColumnName(currentClause);
                            alreadyConsumed = true;
                            if (probs == null) break;
                            int ii = 0;
                            while (ii < probs.size()) {
                                this.problems.add(probs.get(ii));
                                ++ii;
                            }
                            break;
                        }
                        this.currentToken = new EGLPrimeToken(27, ":", this.currentToken.getOffset(), this.currentToken.getLine(), this.currentToken.getColumn());
                        currentClause.addToken(this.currentToken);
                        break;
                    }
                    default: {
                        currentClause.addToken(this.currentToken);
                        if (this.currentToken.getType() != 15) break;
                        this.setHasUnion(true);
                        String currentClauseKeyword = this.nextClauseKeyword(this.lexer.lookAhead1, this.lexer.lookAhead2, this.lexer.lookAhead3);
                        if (!this.reservedClauseKeywordsUsed.contains(this.currentToken.getText().toLowerCase())) {
                            this.reservedClauseKeywordsUsed.add(this.currentToken.getText().toLowerCase());
                        }
                        this.currentToken = this.lexer.getNextToken();
                        while (this.currentToken != null && !this.reachedUnionEnd(currentClause, currentClauseKeyword)) {
                            switch (this.currentToken.getType()) {
                                case 22: {
                                    currentClause.addToken(this.currentToken);
                                    alreadyConsumed = this.matchSQLParens(currentClause);
                                    break;
                                }
                                case 28: {
                                    if (this.isReallyAHostVarColon()) {
                                        currentClause.addToken(this.currentToken);
                                        List probs = this.getHostVarColumnName(currentClause);
                                        alreadyConsumed = true;
                                        if (probs == null) break;
                                        int ii = 0;
                                        while (ii < probs.size()) {
                                            this.problems.add(probs.get(ii));
                                            ++ii;
                                        }
                                        break;
                                    }
                                    this.currentToken = new EGLPrimeToken(27, ":", this.currentToken.getOffset(), this.currentToken.getLine(), this.currentToken.getColumn());
                                    currentClause.addToken(this.currentToken);
                                    break;
                                }
                                default: {
                                    currentClause.addToken(this.currentToken);
                                }
                            }
                            if (alreadyConsumed) {
                                alreadyConsumed = false;
                            } else {
                                this.previousToken = this.currentToken;
                                this.currentToken = this.lexer.getNextToken();
                            }
                            currentClauseKeyword = this.nextClauseKeyword(this.currentToken, this.lexer.lookAhead1, this.lexer.lookAhead2);
                        }
                        alreadyConsumed = true;
                    }
                }
            }
            if (this.currentToken == null) continue;
            if (alreadyConsumed) {
                alreadyConsumed = false;
                continue;
            }
            this.previousToken = this.currentToken;
            this.currentToken = this.lexer.getNextToken();
        }
        EGLSQLClauseTree whereCurrent = this.getWhereCurrentOfTokens();
        if (whereCurrent != null) {
            int kk = 0;
            while (kk < whereCurrent.tokens.size()) {
                whereCurrent.getToken(kk).setWhereCurrentOf();
                ++kk;
            }
        }
    }

    private boolean reachedUnionEnd(EGLSQLClauseTree currentClause, String currentClauseKeyword) {
        return currentClauseKeyword.equalsIgnoreCase("order by") || currentClauseKeyword.equalsIgnoreCase("for update of");
    }

    private void parseExecuteSQL() throws IOException {
        EGLSQLClauseTree currentClause = null;
        EGLSQLClauseTree commentClause = null;
        boolean alreadyConsumed = false;
        this.previousToken = null;
        this.currentToken = this.lexer.getNextToken();
        while (this.currentToken != null) {
            if (currentClause == null) {
                if (this.currentToken.getType() == Integer.MAX_VALUE) {
                    if (commentClause == null) {
                        commentClause = new EGLSQLClauseTree();
                    }
                    commentClause.addToken(this.currentToken);
                } else {
                    currentClause = new EGLSQLClauseTree();
                    currentClause.setClauseKeyword(new EGLPrimeToken(57, "EXECUTE", this.currentToken.getOffset(), this.currentToken.getLine(), this.currentToken.getColumn()));
                    currentClause.addToken(this.currentToken);
                    this.sqlClauses.add(currentClause);
                }
            } else {
                if (currentClause.getClauseType() == 11 && this.currentToken.getType() == 22) {
                    currentClause = new EGLSQLClauseTree(new EGLPrimeToken(56, "COLUMNS", 0, 0, 0));
                    this.sqlClauses.add(currentClause);
                }
                switch (this.currentToken.getType()) {
                    case 22: {
                        currentClause.addToken(this.currentToken);
                        alreadyConsumed = this.matchSQLParens(currentClause);
                        break;
                    }
                    case 28: {
                        if (this.isReallyAHostVarColon()) {
                            currentClause.addToken(this.currentToken);
                            List probs = this.getHostVarColumnName(currentClause);
                            alreadyConsumed = true;
                            if (probs == null) break;
                            int ii = 0;
                            while (ii < probs.size()) {
                                this.problems.add(probs.get(ii));
                                ++ii;
                            }
                            break;
                        }
                        this.currentToken = new EGLPrimeToken(27, ":", this.currentToken.getOffset(), this.currentToken.getLine(), this.currentToken.getColumn());
                        currentClause.addToken(this.currentToken);
                        break;
                    }
                    default: {
                        currentClause.addToken(this.currentToken);
                    }
                }
            }
            if (this.currentToken == null) continue;
            if (alreadyConsumed) {
                alreadyConsumed = false;
                continue;
            }
            this.previousToken = this.currentToken;
            this.currentToken = this.lexer.getNextToken();
        }
    }

    private String nextClauseKeyword(EGLPrimeToken currentToken, EGLPrimeToken secondToken, EGLPrimeToken thirdToken) {
        StringBuffer keyword = new StringBuffer("");
        if (currentToken == null) {
            return keyword.toString();
        }
        keyword.append(currentToken.getText());
        if (currentToken.getType() == 10 || currentToken.getType() == 9) {
            if (secondToken != null && secondToken.getType() == 13) {
                keyword.append(" " + secondToken.getText());
            }
        } else if (currentToken.getType() == 11) {
            if (secondToken != null && secondToken.getType() == 2) {
                keyword.append(" " + secondToken.getText());
            }
        } else if (currentToken.getType() == 12) {
            if (secondToken != null && secondToken.getType() == 5) {
                keyword.append(" " + secondToken.getText());
                if (thirdToken != null && thirdToken.getType() == 14) {
                    keyword.append(" " + thirdToken.getText());
                }
            }
        } else if (currentToken.getType() == 8 && secondToken != null && secondToken.getType() == 16 && thirdToken != null && thirdToken.getType() == 14) {
            keyword.append(" " + secondToken.getText());
            keyword.append(" " + thirdToken.getText());
        }
        return keyword.toString();
    }

    public boolean matchSQLParens(EGLSQLClauseTree currentClause) throws IOException {
        Stack<EGLPrimeToken> parensStack = new Stack<EGLPrimeToken>();
        EGLPrimeToken paren = null;
        boolean consumed = false;
        int numberLparens = 1;
        int numberRparens = 0;
        parensStack.clear();
        parensStack.push(this.currentToken);
        block5: while (numberLparens != numberRparens && this.currentToken != null) {
            if (consumed) {
                consumed = false;
            } else {
                this.previousToken = this.currentToken;
                this.currentToken = this.lexer.getNextToken();
            }
            if (this.currentToken == null) continue;
            switch (this.currentToken.getType()) {
                case 22: {
                    currentClause.addToken(this.currentToken);
                    ++numberLparens;
                    parensStack.push(this.currentToken);
                    break;
                }
                case 23: {
                    currentClause.addToken(this.currentToken);
                    ++numberRparens;
                    parensStack.pop();
                    break;
                }
                case 28: {
                    if (this.isReallyAHostVarColon()) {
                        currentClause.addToken(this.currentToken);
                        List probs = this.getHostVarColumnName(currentClause);
                        consumed = true;
                        if (probs == null) continue block5;
                        int ii = 0;
                        while (ii < probs.size()) {
                            this.problems.add(probs.get(ii));
                            ++ii;
                        }
                        continue block5;
                    }
                    this.currentToken = new EGLPrimeToken(27, ":", this.currentToken.getOffset(), this.currentToken.getLine(), this.currentToken.getColumn());
                    currentClause.addToken(this.currentToken);
                    break;
                }
                default: {
                    currentClause.addToken(this.currentToken);
                }
            }
        }
        while (!parensStack.empty()) {
            paren = (EGLPrimeToken)parensStack.pop();
            this.problems.add(new Problem(paren.getOffset(), paren.getOffset() + paren.getText().length(), 2, 4557, new String[0]));
        }
        return consumed;
    }

    public List getHostVarColumnName(EGLSQLClauseTree currentClause) throws IOException {
        this.previousToken = this.currentToken;
        this.currentToken = this.lexer.getNextToken();
        if (this.currentToken == null || this.currentToken.getType() != 51) {
            return null;
        }
        this.currentToken.setHostVar();
        EGLSQLClauseTree tempTokens = new EGLSQLClauseTree(this.currentToken);
        tempTokens.addToken(this.currentToken);
        currentClause.addToken(this.currentToken);
        this.previousToken = this.currentToken;
        this.currentToken = this.lexer.getNextToken();
        while (!(this.currentToken == null || this.currentToken.getType() == 23 || this.currentToken.getType() == 45 || this.currentToken.getType() == 30 || this.currentToken.getType() == 40 || this.currentToken.getType() == 36 || this.currentToken.getType() == 37 || this.currentToken.getType() == 38 || this.currentToken.getType() == 39 || this.currentToken.getType() == 29 || this.currentToken.getType() == 31 || this.currentToken.getType() == 33 || this.currentToken.getType() == 32 || this.currentToken.getType() == 35 || this.currentToken.getType() == 43 || this.currentToken.getType() == 41 || this.currentToken.getType() == 44 || this.currentToken.getType() == 42 || this.currentToken.getText().equals("/") || this.currentToken.getType() != 24 && tempTokens.getLastToken().getOffset() + tempTokens.getLastToken().getText().length() != this.currentToken.getOffset())) {
            if (this.currentToken.getType() == 24) {
                while (this.currentToken != null && this.currentToken.getType() != 25) {
                    this.currentToken.setHostVar();
                    tempTokens.addToken(this.currentToken);
                    currentClause.addToken(this.currentToken);
                    this.previousToken = this.currentToken;
                    this.currentToken = this.lexer.getNextToken();
                }
                if (this.currentToken == null) continue;
                this.currentToken.setHostVar();
                tempTokens.addToken(this.currentToken);
                currentClause.addToken(this.currentToken);
                this.previousToken = this.currentToken;
                this.currentToken = this.lexer.getNextToken();
                continue;
            }
            this.currentToken.setHostVar();
            tempTokens.addToken(this.currentToken);
            currentClause.addToken(this.currentToken);
            this.previousToken = this.currentToken;
            this.currentToken = this.lexer.getNextToken();
        }
        return null;
    }

    private boolean isReallyAHostVarColon() {
        if (this.lexer.lookAhead1 != null && "=".equals(this.lexer.lookAhead1.getText())) {
            return false;
        }
        return this.previousToken.getType() != 51 || this.previousToken.getOffset() + this.previousToken.getText().length() != this.currentToken.getOffset();
    }

    private String getSpecificClause(int type) {
        EGLSQLClauseTree aClause = null;
        int ii = 0;
        while (ii < this.sqlClauses.size()) {
            aClause = (EGLSQLClauseTree)this.sqlClauses.get(ii);
            if (aClause.clauseKeyword.getType() == 8) {
                if (type == 16 && aClause.secondKeyword != null && aClause.secondKeyword.getType() == 16) {
                    return aClause.toString();
                }
                if (type == 8 && aClause.secondKeyword == null) {
                    return aClause.toString();
                }
            } else if (aClause.clauseKeyword.getType() == type) {
                return aClause.toString();
            }
            ++ii;
        }
        return null;
    }

    public String getAllClauses() {
        EGLSQLClauseTree aClause = null;
        EGLSQLClauseTree newClauseTree = new EGLSQLClauseTree();
        int ii = 0;
        while (ii < this.sqlClauses.size()) {
            aClause = (EGLSQLClauseTree)this.sqlClauses.get(ii);
            newClauseTree.tokens.addAll(aClause.tokens);
            ++ii;
        }
        return newClauseTree.toString();
    }

    public String getAllClausesWOCommentsAndHostVariables() {
        EGLSQLClauseTree aClause = null;
        EGLSQLClauseTree newClauseTree = new EGLSQLClauseTree();
        int ii = 0;
        while (ii < this.sqlClauses.size()) {
            aClause = (EGLSQLClauseTree)this.sqlClauses.get(ii);
            this.addTokensHostVariableMarks(newClauseTree.tokens, aClause.tokens);
            ++ii;
        }
        return newClauseTree.toString();
    }

    public EGLSQLClauseTree getClauseWOCommentsAndHostVariables(EGLSQLClauseTree aClause) {
        EGLSQLClauseTree newClauseTree = new EGLSQLClauseTree();
        this.removeCommentsAndHostVariables(newClauseTree.tokens, aClause.tokens);
        return newClauseTree;
    }

    public void addTokensHostVariableMarks(ArrayList masterTokens, ArrayList clauseTokens) {
        int ii = 0;
        while (ii < clauseTokens.size()) {
            if (!((EGLPrimeToken)clauseTokens.get(ii)).isHostVar() && ((EGLPrimeToken)clauseTokens.get(ii)).getType() != Integer.MAX_VALUE) {
                if (((EGLPrimeToken)clauseTokens.get(ii)).getType() == 28) {
                    EGLPrimeToken mark = new EGLPrimeToken(61, "?", ((EGLPrimeToken)clauseTokens.get(ii)).getOffset(), ((EGLPrimeToken)clauseTokens.get(ii)).getLine(), ((EGLPrimeToken)clauseTokens.get(ii)).getColumn());
                    masterTokens.add(mark);
                } else {
                    masterTokens.add(clauseTokens.get(ii));
                }
            }
            ++ii;
        }
    }

    public void removeCommentsAndHostVariables(ArrayList masterTokens, ArrayList clauseTokens) {
        int ii = 0;
        while (ii < clauseTokens.size()) {
            if (!((EGLPrimeToken)clauseTokens.get(ii)).isHostVar() && ((EGLPrimeToken)clauseTokens.get(ii)).getType() != Integer.MAX_VALUE && ((EGLPrimeToken)clauseTokens.get(ii)).getType() != 28) {
                masterTokens.add(clauseTokens.get(ii));
            }
            ++ii;
        }
    }

    public String getSelectClause() {
        return this.getSpecificClause(1);
    }

    public String getIntoClause() {
        return this.getSpecificClause(2);
    }

    public String getFromClause() {
        return this.getSpecificClause(3);
    }

    public String getCallClause() {
        return this.getSpecificClause(17);
    }

    public String getDeleteClause() {
        return this.getSpecificClause(18);
    }

    public String getColumnsClause() {
        return this.getSpecificClause(56);
    }

    public String getValuesClause() {
        return this.getSpecificClause(4);
    }

    public String getUnionClause() {
        return this.getSpecificClause(15);
    }

    public String getUpdateClause() {
        return this.getSpecificClause(5);
    }

    public String getSetClause() {
        return this.getSpecificClause(6);
    }

    public String getHavingClause() {
        return this.getSpecificClause(7);
    }

    public String getWhereClause() {
        return this.getSpecificClause(8);
    }

    public String getWhereCurrentOfClause() {
        return this.getSpecificClause(16);
    }

    public String getOrderByClause() {
        return this.getSpecificClause(9);
    }

    public String getGroupByClause() {
        return this.getSpecificClause(10);
    }

    public String getInsertIntoClause() {
        return this.getSpecificClause(11);
    }

    public String getForUpdateOfClause() {
        return this.getSpecificClause(12);
    }

    private EGLSQLClauseTree getSpecificTokens(int type) {
        EGLSQLClauseTree aClause = null;
        int ii = 0;
        while (ii < this.sqlClauses.size()) {
            aClause = (EGLSQLClauseTree)this.sqlClauses.get(ii);
            if (aClause.clauseKeyword.getType() == 8) {
                if (type == 16 && aClause.secondKeyword != null && aClause.secondKeyword.getType() == 16) {
                    return aClause;
                }
                if (type == 8 && aClause.secondKeyword == null) {
                    return aClause;
                }
            } else if (aClause.clauseKeyword.getType() == type) {
                return aClause;
            }
            ++ii;
        }
        return null;
    }

    public EGLSQLClauseTree getAllTokens() {
        EGLSQLClauseTree aClause = null;
        EGLSQLClauseTree newClauseTree = new EGLSQLClauseTree();
        int ii = 0;
        while (ii < this.sqlClauses.size()) {
            aClause = (EGLSQLClauseTree)this.sqlClauses.get(ii);
            newClauseTree.tokens.addAll(aClause.tokens);
            ++ii;
        }
        return newClauseTree;
    }

    public EGLSQLClauseTree getHostVariables() {
        EGLSQLClauseTree aClause = null;
        EGLSQLClauseTree hostVarsTree = new EGLSQLClauseTree();
        int ii = 0;
        while (ii < this.sqlClauses.size()) {
            aClause = (EGLSQLClauseTree)this.sqlClauses.get(ii);
            this.addHostVariableTokens(hostVarsTree, aClause);
            ++ii;
        }
        return hostVarsTree;
    }

    private void addHostVariableTokens(EGLSQLClauseTree hostVars, EGLSQLClauseTree primeTokens) {
        int start;
        if (primeTokens == null) {
            return;
        }
        int ii = start = 0;
        while (ii < primeTokens.size()) {
            if (primeTokens.getToken(ii).getType() == 28) {
                EGLPrimeToken colon = primeTokens.getToken(ii);
                StringBuffer hostVar = new StringBuffer();
                ++ii;
                while (ii < primeTokens.size() && primeTokens.getToken(ii).isHostVar()) {
                    hostVar.append(primeTokens.getToken(ii).getText());
                    ++ii;
                }
                --ii;
                hostVars.addToken(new EGLPrimeToken(51, hostVar.toString(), colon.getOffset() + 1, colon.getLine(), colon.getColumn() + 1));
            }
            ++ii;
        }
    }

    public EGLSQLClauseTree getHostVariablesAsEntered(WithInlineSQLClause sqlClause) {
        EGLSQLClauseTree aClause = null;
        EGLSQLClauseTree hostVarsTree = new EGLSQLClauseTree();
        int ii = 0;
        while (ii < this.sqlClauses.size()) {
            aClause = (EGLSQLClauseTree)this.sqlClauses.get(ii);
            this.addHostVariableTokensAsEntered(hostVarsTree, aClause, sqlClause);
            ++ii;
        }
        return hostVarsTree;
    }

    private void addHostVariableTokensAsEntered(EGLSQLClauseTree hostVars, EGLSQLClauseTree primeTokens, WithInlineSQLClause sqlClause) {
        int start;
        if (primeTokens == null) {
            return;
        }
        String sqlString = sqlClause.getSqlStmt().getValue();
        int ii = start = 0;
        while (ii < primeTokens.size()) {
            if (primeTokens.getToken(ii).getType() == 28) {
                String hostVar = null;
                EGLPrimeToken firstToken = null;
                EGLPrimeToken lastToken = null;
                ++ii;
                while (ii < primeTokens.size() && primeTokens.getToken(ii).isHostVar()) {
                    if (firstToken == null) {
                        firstToken = primeTokens.getToken(ii);
                    }
                    lastToken = primeTokens.getToken(ii);
                    ++ii;
                }
                --ii;
                if (firstToken != null) {
                    hostVar = sqlString.substring(firstToken.getOffset(), lastToken.getOffset() + lastToken.getText().length());
                    hostVars.addToken(new EGLPrimeToken(51, hostVar, firstToken.getOffset(), firstToken.getLine(), firstToken.getColumn()));
                }
            }
            ++ii;
        }
    }

    public void addBlanks(StringBuffer str, int count) {
        if (count > 0) {
            int ii = 1;
            while (ii <= count) {
                str.append(" ");
                ++ii;
            }
        }
    }

    public void addCRLF(StringBuffer str, int count) {
        if (count > 0) {
            int ii = 1;
            while (ii <= count) {
                str.append("\r\n");
                ++ii;
            }
        }
    }

    public EGLSQLClauseTree getSelectTokens() {
        return this.getSpecificTokens(1);
    }

    public EGLSQLClauseTree getIntoTokens() {
        return this.getSpecificTokens(2);
    }

    public EGLSQLClauseTree getFromTokens() {
        return this.getSpecificTokens(3);
    }

    public EGLSQLClauseTree getCallTokens() {
        return this.getSpecificTokens(17);
    }

    public EGLSQLClauseTree getColumnsTokens() {
        return this.getSpecificTokens(56);
    }

    public EGLSQLClauseTree getValuesTokens() {
        return this.getSpecificTokens(4);
    }

    public EGLSQLClauseTree getUpdateTokens() {
        return this.getSpecificTokens(5);
    }

    public EGLSQLClauseTree getSetTokens() {
        return this.getSpecificTokens(6);
    }

    public EGLSQLClauseTree getDeleteTokens() {
        return this.getSpecificTokens(18);
    }

    public EGLSQLClauseTree getHavingTokens() {
        return this.getSpecificTokens(7);
    }

    public EGLSQLClauseTree getWhereTokens() {
        return this.getSpecificTokens(8);
    }

    public EGLSQLClauseTree getWhereCurrentOfTokens() {
        return this.getSpecificTokens(16);
    }

    public String getWhereCurrentOfResultSetIdentifier() {
        EGLSQLClauseTree whereCurrent = this.getSpecificTokens(16);
        if (whereCurrent.tokens.size() >= 3) {
            return ((EGLPrimeToken)whereCurrent.tokens.get(3)).getText();
        }
        return null;
    }

    public EGLSQLClauseTree getOrderByTokens() {
        return this.getSpecificTokens(9);
    }

    public EGLSQLClauseTree getGroupByTokens() {
        return this.getSpecificTokens(10);
    }

    public EGLSQLClauseTree getInsertIntoTokens() {
        return this.getSpecificTokens(11);
    }

    public EGLSQLClauseTree getForUpdateOfTokens() {
        return this.getSpecificTokens(12);
    }

    public ArrayList getSqlClauses() {
        return this.sqlClauses;
    }

    public ArrayList getSqlClauseKeywordsUsed() {
        ArrayList<String> clauseKeywords = new ArrayList<String>();
        int ii = 0;
        while (ii < this.sqlClauses.size()) {
            clauseKeywords.add(((EGLSQLClauseTree)this.sqlClauses.get(ii)).getClauseKeyword().getText().toLowerCase());
            ++ii;
        }
        return clauseKeywords;
    }

    public ArrayList getReservedClauseKeywordsUsed() {
        return this.reservedClauseKeywordsUsed;
    }

    public boolean hasErrors() {
        return this.problems.size() > 0;
    }

    public ArrayList getErrors() {
        return this.problems;
    }

    public boolean hasUnion() {
        return this.hasUnion;
    }

    public void setHasUnion(boolean hasUnion) {
        this.hasUnion = hasUnion;
    }
}

