/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.corext.refactoring.AbstractJavaElementRenameChange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public final class RenameSourceFolderChange
extends AbstractJavaElementRenameChange {
    private static RefactoringStatus checkIfModifiable(IPackageFragmentRoot root) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        if (root == null) {
            result.addFatalError(RefactoringCoreMessages.DynamicValidationStateChange_workspace_changed);
            return result;
        }
        if (!root.exists()) {
            result.addFatalError(Messages.format(RefactoringCoreMessages.Change_does_not_exist, RenameSourceFolderChange.getRootLabel(root)));
            return result;
        }
        if (result.hasFatalError()) {
            return result;
        }
        if (root.isArchive()) {
            result.addFatalError(Messages.format(RefactoringCoreMessages.RenameSourceFolderChange_rename_archive, RenameSourceFolderChange.getRootLabel(root)));
            return result;
        }
        if (root.isExternal()) {
            result.addFatalError(Messages.format(RefactoringCoreMessages.RenameSourceFolderChange_rename_external, RenameSourceFolderChange.getRootLabel(root)));
            return result;
        }
        IResource correspondingResource = root.getCorrespondingResource();
        if (correspondingResource == null || !correspondingResource.exists()) {
            result.addFatalError(Messages.format(RefactoringCoreMessages.RenameSourceFolderChange_error_underlying_resource_not_existing, RenameSourceFolderChange.getRootLabel(root)));
            return result;
        }
        if (correspondingResource.isLinked()) {
            result.addFatalError(Messages.format(RefactoringCoreMessages.RenameSourceFolderChange_rename_linked, RenameSourceFolderChange.getRootLabel(root)));
            return result;
        }
        return result;
    }

    private static String getRootLabel(IPackageFragmentRoot root) {
        return JavaElementLabels.getElementLabel((IJavaElement)root, JavaElementLabels.ALL_DEFAULT);
    }

    public RenameSourceFolderChange(IPackageFragmentRoot sourceFolder, String newName) {
        this(sourceFolder.getPath(), sourceFolder.getElementName(), newName, -1L);
        Assert.isTrue((!sourceFolder.isReadOnly() ? 1 : 0) != 0, (String)"should not be read only");
        Assert.isTrue((!sourceFolder.isArchive() ? 1 : 0) != 0, (String)"should not be an archive");
        Assert.isTrue((!sourceFolder.isExternal() ? 1 : 0) != 0, (String)"should not be an external folder");
        this.setValidationMethod(2);
    }

    private RenameSourceFolderChange(IPath resourcePath, String oldName, String newName, long stampToRestore) {
        super(resourcePath, oldName, newName, stampToRestore);
    }

    protected IPath createNewPath() {
        return this.getResourcePath().removeLastSegments(1).append(this.getNewName());
    }

    protected Change createUndoChange(long stampToRestore) {
        return new RenameSourceFolderChange(this.createNewPath(), this.getNewName(), this.getOldName(), stampToRestore);
    }

    protected void doRename(IProgressMonitor pm) throws CoreException {
        IPackageFragmentRoot sourceFolder = this.getSourceFolder();
        if (sourceFolder != null) {
            sourceFolder.move(this.getNewPath(), this.getCoreMoveFlags(), this.getJavaModelUpdateFlags(), null, pm);
        }
    }

    private int getCoreMoveFlags() {
        if (this.getResource().isLinked()) {
            return 32;
        }
        return 0;
    }

    private int getJavaModelUpdateFlags() {
        return 30;
    }

    public String getName() {
        Object[] keys = new String[]{BasicElementLabels.getJavaElementName(this.getOldName()), BasicElementLabels.getJavaElementName(this.getNewName())};
        return Messages.format(RefactoringCoreMessages.RenameSourceFolderChange_rename, keys);
    }

    private IPath getNewPath() {
        return this.getResource().getFullPath().removeLastSegments(1).append(this.getNewName());
    }

    private IPackageFragmentRoot getSourceFolder() {
        return (IPackageFragmentRoot)this.getModifiedElement();
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = super.isValid(pm);
        if (result.hasFatalError()) {
            return result;
        }
        IPackageFragmentRoot sourceFolder = this.getSourceFolder();
        result.merge(RenameSourceFolderChange.checkIfModifiable(sourceFolder));
        return result;
    }
}

