/*******************************************************************************
 * Copyright © 2008, 2012 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
// NLS_ENCODING=UTF-8
// NLS_MESSAGEFORMAT_VAR
//
// Guidelines for defining Rich UI messages:  
// (1) DO NOT change the variable, "egl.eze$$rscBundles["RuiMessages"]"
// (2) The general format of a message is:
//          'MessageId'  :   'Message Text: {n}'
// (3) 'MessageId' (eg: CRRUI2007E) is composed of 4 parts:
//        - the first 5 characters is product identification, must be 'CRRUI'  
//        - the sixth character is a digit which identifies the component:
//                '0' -  Others       ( used to be 'E' )
//                '1' -  Widget       ( used to be 'I' )
//                '2' -  Runtime      ( used to be 'R' )
//                '3' -  Service      ( used to be 'S' )
//        - the 7th to 9th characters identifies message number, eg: '001'
//        - the 10th character identifies the message type:
//                'E' - error message
//                'I' - informational message
//                'W' - warning message
// (5)The message text may contain 1 or more message inserts, 
//         eg: {n},  where n is a 0 based number
// (6)Insert the message in alphabetical and numeric sort order  
//    against the MessageId to avoid conflicts which can be 
//    difficult to track at runtime            
//
egl.eze$$rscBundles["RuiMessages"] =
{
		'CRRUI0001E' : 'InitalUI[{0}]InitialUI \u540d\u7a31\u662f\u7a7a\u767d\u7684\u3002\u7121\u6cd5\u4f7f\u7528\u51fd\u6578\u547c\u53eb\u4f86\u8d77\u59cb\u8a2d\u5b9a\u540d\u7a31\u3002',		
		'CRRUI0006E' : '{0} RadioGroup \u7fa4\u7d44\u5305\u542b\u4e0d\u5408\u6cd5\u7684\u5f15\u6578\u3002',
					
		'CRRUI1001E' : '\u5c0d\u65bc {0} \u8b8a\u6578\u800c\u8a00\uff0c{1} \u7121\u6cd5\u8a2d\u70ba {2}',
		'CRRUI1010E' : '\u62d6\u653e\u529f\u80fd\u5c6c\u65bc\u51fd\u6578\u53c3\u7167\uff0c\u800c\u975e\u9663\u5217\uff1a{0}',
		'CRRUI1020E' : 'Runtime.asDictionary: \u53ea\u80fd\u5c07\u8655\u7406\u7a0b\u5f0f\u6216\u8a18\u9304\u8f49\u63db\u70ba\u300c\u5b57\u5178\u300d\uff0c\u800c\u975e {0}',
		'CRRUI1030E' : '\u627e\u4e0d\u5230 {0}.{1} \u7684\u5b9a\u7fa9',
		'CRRUI1050E' : '{0} \u8b8a\u6578\u5fc5\u9808\u5305\u542b\u55ae\u5b57 \"null\"\u3002',
		'CRRUI1051E' : '\u7121\u6cd5\u5c07\u5c0f\u7d44\u4ef6\u65b0\u589e\u81f3 {0} \u8b8a\u6578\u3002',
		'CRRUI1055E' : '\u7121\u6cd5\u5c07 {1} \u5b50\u9805\u65b0\u589e\u81f3 {2} \u8b8a\u6578\u3002',		
		'CRRUI1057E' : '\u7121\u6cd5\u5c07 {0} \u5c0f\u7d44\u4ef6\u65b0\u589e\u81f3\u672c\u8eab\u3002',	
		'CRRUI1058E' : '\u7121\u6cd5\u5c07 {1} \u4e0a\u4ee3\u65b0\u589e\u81f3 {0} \u8b8a\u6578\u3002{2} \u662f\u73fe\u884c\u7684\u4e0a\u4ee3\u3002',
		'CRRUI1060E' : '\u8a66\u5716\u5c07\u5c0f\u7d44\u4ef6 \"{0}\" \u7684\u6bcd\u9805\u8a2d\u70ba {1}:{2}\uff1b\u6bcd\u9805\u5fc5\u9808\u662f\u5c0f\u7d44\u4ef6',
		'CRRUI1070E' : '\u5728\u8655\u7406\u56de\u547c\u51fd\u6578\u6642\u767c\u751f {0} \u7570\u5e38\u72c0\u6cc1\u3002\u8acb\u4f7f\u7528 try...OnException\u3002',
		'CRRUI1071E' : '\u627e\u4e0d\u5230\u670d\u52d9\u547c\u53eb\u7684\u7570\u5e38\u72c0\u6cc1\u8655\u7406\u7a0b\u5f0f\u3002\u8acb\u70ba\u670d\u52d9\u547c\u53eb\u65b0\u589e\u7570\u5e38\u72c0\u6cc1\u8655\u7406\u7a0b\u5f0f\u3002',
		'CRRUI1072E' : '\u5728\u932f\u8aa4\u56de\u547c\u51fd\u6578\u4e2d\u767c\u751f {0} \u7570\u5e38\u72c0\u6cc1\uff0c\u8acb\u7528 try...OnException \u4f86\u7de8\u78bc',		
		'CRRUI1080E' : '\u5c0f\u7d44\u4ef6\u6c92\u6709\u300c\u6587\u4ef6\u7269\u4ef6\u6a21\u578b (DOM)\u300d\u5143\u7d20\uff0c\u800c\u4e14\u672a\u5305\u542b\u5728\u6587\u4ef6\u4e2d\u3002<br>\u9019\u500b\u5c0f\u7d44\u4ef6\u7684\u73fe\u884c\u5c6c\u6027\u5982\u4e0b\uff1a<P>{0}',
		'CRRUI1083E' : '\u5728\u8655\u7406 {0} \u700f\u89bd\u5668\u4e8b\u4ef6\u6642\u767c\u751f\u932f\u8aa4\u3002',
		'CRRUI1150E' : '\u8a66\u5716\u5f9e {0} \u8b8a\u6578\u79fb\u9664 \"null\" \u6642\u5931\u6557\u3002',		
		'CRRUI1151E' : '\u8a66\u5716\u5c07\u6c92\u6709\u300c\u6587\u4ef6\u7269\u4ef6\u6a21\u578b (DOM)\u300d\u5143\u7d20\u7684\u5c0f\u7d44\u4ef6\u5f9e {0} \u8b8a\u6578\u4e2d\u79fb\u9664\uff0c\u4f46\u662f\u5931\u6557\u3002',		
		'CRRUI1155E' : '\u7121\u6cd5\u5f9e {0}: {2} \u8b8a\u6578\u4e2d\u79fb\u9664 {1}type \u7684\u5b50\u9805\u3002',
		'CRRUI1157E' : '\u7121\u6cd5\u5f9e\u5c0f\u7d44\u4ef6\u672c\u8eab\u79fb\u9664\u5c0f\u7d44\u4ef6\uff0c\u5c0f\u7d44\u4ef6\u985e\u578b\u662f {0}\u3002',
			
		'CRRUI2002E' : '{1}<br>\u5728 {0} \u5167\u767c\u751f\u932f\u8aa4\uff1a{2}',
		'CRRUI2004E' : '{0} \u6b77\u7a0b\u5305\u542b\u4e0d\u5408\u6cd5\u7684\u5f15\u6578\u3002',
		'CRRUI2005E' : '\u7121\u6cd5\u4f7f\u7528\u7a7a\u503c\u53c3\u7167\u3002',
		'CRRUI2006E' : '{0}', // The text of this message comes from some other error message.
		'CRRUI2007E' : '\u5f15\u6578\u4e0d\u5408\u6cd5\uff1a{0}\u3002',
		'CRRUI2009E' : '\u7121\u6cd5\u5f9e RUI \u8655\u7406\u7a0b\u5f0f\u4f86\u5c07\u4e8b\u4ef6\u5be6\u4f8b\u5316\u3002',
		'CRRUI2010E' : '\u5df2\u6dd8\u6c70\u7684\u51fd\u6578\uff1a{0}\u3002',
		
		'CRRUI2015E' : '\u907a\u6f0f RUIPropertiesLibrary {1} \u7684\u6a94\u6848 {0}',
		'CRRUI2016E' : 'EGL \u7a0b\u5f0f\u4f7f\u7528\u904e\u591a\u6b21',
		'CRRUI2017E' : '\u7121\u6cd5\u5c07\u985e\u578b {1} \u7684\u503c \"{0}\" \u8f49\u63db\u70ba\u985e\u578b {2}',
		'CRRUI2018E' : '\u5728\u6307\u6d3e {0} \u7d66\u985e\u578b {1} \u6642\u6ea2\u4f4d',
		'CRRUI2019E' : '\u7121\u6cd5\u5c07\u5143\u7d20 {0} \u9644\u52a0\u81f3\u9663\u5217\u3002\u9663\u5217\u7684\u5927\u5c0f\u4e0a\u9650\u662f {1}',
		'CRRUI2020E' : '\u5c0d\u9663\u5217\u51fd\u6578 setMaxSize() \u800c\u8a00\uff0c\u5f15\u6578 {0} \u7121\u6548',
		'CRRUI2021E' : '\u7121\u6cd5\u5f9e\u7d22\u5f15 {0} \u958b\u59cb\u7684\u5b57\u4e32\u64f7\u53d6\u4e0b\u4e00\u500b\u8a18\u865f',
		'CRRUI2022E' : '\u6b64\u9663\u5217\u7684\u7d22\u5f15 {0} \u8d85\u51fa\u754c\u9650\u3002\u9663\u5217\u5927\u5c0f\u70ba {1}',
		'CRRUI2023E' : '\u6240\u7528\u7684\u53c3\u7167\u70ba\u7a7a\u503c\uff1a{0}',
		'CRRUI2024E' : '\u52d5\u614b\u5b58\u53d6\u7d22\u5f15\u9375 \"{0}\" \u4e0d\u9069\u7528\u65bc\u985e\u578b {1} \u7684\u7269\u4ef6',
		'CRRUI2025E' : '\u52d5\u614b\u5b58\u53d6\u5931\u6557\uff1a\u6c92\u6709\u9019\u6a23\u7684\u7d22\u5f15\u9375\uff0c\"{0}\"',
		'CRRUI2030E' : 'XMLLib.convertFromXML \u7684\u5f15\u6578\u7121\u6548\u3002\u539f\u9810\u671f\u70ba\u5b57\u4e32\u3002\u537b\u6536\u5230 \"{0}\"',
		'CRRUI2031E' : '\u5256\u6790 XML \u6642\u767c\u751f\u932f\u8aa4\uff1a{0}',
		'CRRUI2032E' : '\u6642\u9593\u6233\u8a18\u578b\u6a23 {0} \u7121\u6548',
		'CRRUI2033E' : '\u70ba\u9663\u5217\u51fd\u6578 resize() \u6307\u5b9a\u7684\u503c {0} \u5927\u65bc\u9663\u5217\u7684\u5927\u5c0f\u4e0a\u9650 {1}',
		'CRRUI2034E' : '\u5c0d\u9663\u5217\u5143\u7d20\u4f86\u8aaa\uff0c\u985e\u578b {0} \u7121\u6548',
		'CRRUI2035E' : '\u8abf\u6574\u5927\u5c0f\u5f8c\u7684\u7dad\u5ea6\u91cf\u5927\u65bc\u9663\u5217\u7684\u7dad\u5ea6\u91cf',
		'CRRUI2036E' : '\u547c\u53eb {0} \u6642\u767c\u73fe\u7db2\u57df\u932f\u8aa4\uff1a\u5f15\u6578\u5fc5\u9808\u5728 {1} \u548c {2} \u4e4b\u9593',
		'CRRUI2037E' : '\u6578\u5b78\u932f\u8aa4\uff1a\u4e0d\u80fd\u9664\u4ee5 0',
		'CRRUI2038E' : '\u547c\u53eb {0} \u6642\u767c\u73fe\u7db2\u57df\u932f\u8aa4\uff1a\u5f15\u6578\u5fc5\u9808\u5927\u65bc\u96f6',
		'CRRUI2039E' : '\u547c\u53eb {0} \u6642\u767c\u73fe\u7db2\u57df\u932f\u8aa4\uff1a\u5f15\u6578\u5fc5\u9808\u5927\u65bc\u6216\u7b49\u65bc\u96f6',
		'CRRUI2040E' : '\u547c\u53eb {0} \u6642\u767c\u73fe\u7db2\u57df\u932f\u8aa4\uff1a\u57fa\u6578\u70ba\u96f6\u7684\u6307\u6578\u5fc5\u9808\u5927\u65bc\u96f6',
		'CRRUI2041E' : '\u547c\u53eb {0} \u6642\u767c\u73fe\u7db2\u57df\u932f\u8aa4\uff1a\u57fa\u6578\u70ba\u8ca0\u6578\u7684\u6307\u6578\u5fc5\u9808\u662f\u6574\u6578',
		'CRRUI2042E' : '\u7121\u6548\u7684\u5b50\u5b57\u4e32\u7d22\u5f15 {0}\uff1a{1}\u3002',
		'CRRUI2050E' : '\u6578\u5b78\u932f\u8aa4\uff1aabs() - \u63d0\u4f9b\u4e86 {0} \u5f15\u6578\u3002\u53ea\u63a5\u53d7 0 \u6216 1',
		'CRRUI2051E' : '\u6578\u5b78\u932f\u8aa4\uff1aadd() - \u63d0\u4f9b\u4e86 {0} \u5f15\u6578\u3002\u53ea\u63a5\u53d7 1 \u6216 2',
		'CRRUI2052E' : '\u6578\u5b78\u932f\u8aa4\uff1acompareTo() - \u63d0\u4f9b\u4e86 {0} \u5f15\u6578\u3002\u53ea\u63a5\u53d7 1 \u6216 2',
		'CRRUI2053E' : '\u6578\u5b78\u932f\u8aa4\uff1adivide() - \u8ca0\u5c0f\u6578\u4f4d\u6578 {0} \u7121\u6548',
		'CRRUI2054E' : '\u6578\u5b78\u932f\u8aa4\uff1adivide() - \u63d0\u4f9b\u4e86 {0} \u5f15\u6578\u3002\u53ea\u63a5\u53d7 1 \u5230 3',
		'CRRUI2055E' : '\u6578\u5b78\u932f\u8aa4\uff1adivideInteger() - \u63d0\u4f9b\u4e86 {0} \u5f15\u6578\u3002\u53ea\u63a5\u53d7 1 \u6216 2',
		'CRRUI2056E' : '\u6578\u5b78\u932f\u8aa4\uff1amax() - \u63d0\u4f9b\u4e86 {0} \u5f15\u6578\u3002\u53ea\u63a5\u53d7 1 \u6216 2',
		'CRRUI2057E' : '\u6578\u5b78\u932f\u8aa4\uff1amin() - \u63d0\u4f9b\u4e86 {0} \u5f15\u6578\u3002\u53ea\u63a5\u53d7 1 \u6216 2',
		'CRRUI2058E' : '\u6578\u5b78\u932f\u8aa4\uff1amultiply() - \u63d0\u4f9b\u4e86 {0} \u5f15\u6578\u3002\u53ea\u63a5\u53d7 1 \u6216 2',
		'CRRUI2059E' : '\u6578\u5b78\u932f\u8aa4\uff1anegate() - \u63d0\u4f9b\u4e86 {0} \u5f15\u6578\u3002\u53ea\u63a5\u53d7 0 \u6216 1',
		'CRRUI2060E' : '\u6578\u5b78\u932f\u8aa4\uff1aplus() - \u63d0\u4f9b\u4e86 {0} \u5f15\u6578\u3002\u53ea\u63a5\u53d7 0 \u6216 1',
		'CRRUI2061E' : '\u6578\u5b78\u932f\u8aa4\uff1apow() - \u63d0\u4f9b\u4e86 {0} \u5f15\u6578\u3002\u53ea\u63a5\u53d7 1 \u6216 2',
		'CRRUI2062E' : '\u6578\u5b78\u932f\u8aa4\uff1apow() - \u8ca0\u6b21\u65b9\uff0c{0}',
		'CRRUI2063E' : '\u6578\u5b78\u932f\u8aa4\uff1apow() - \u4f4d\u6578\u592a\u591a\uff0c{0}',
		'CRRUI2064E' : '\u6578\u5b78\u932f\u8aa4\uff1aremainder() - \u63d0\u4f9b\u4e86 {0} \u5f15\u6578\u3002\u53ea\u63a5\u53d7 1 \u6216 2',
		'CRRUI2065E' : '\u6578\u5b78\u932f\u8aa4\uff1asubtract() - \u63d0\u4f9b\u4e86 {0} \u5f15\u6578\u3002\u53ea\u63a5\u53d7 1 \u6216 2',
		'CRRUI2066E' : '\u6578\u5b78\u932f\u8aa4\uff1aformat() - \u63d0\u4f9b\u4e86 {0} \u5f15\u6578\u3002\u53ea\u63a5\u53d7 2 \u6216 6',
		'CRRUI2067E' : '\u6578\u5b78\u932f\u8aa4\uff1aformat() - \u6307\u6578\u6ea2\u4f4d\uff0c{0}',
		'CRRUI2068E' : '\u6578\u5b78\u932f\u8aa4\uff1aintValueExact() - \u5c0f\u6578\u90e8\u5206\u975e\u96f6\uff0c{0}',
		'CRRUI2069E' : '\u6578\u5b78\u932f\u8aa4\uff1aintValueExact() - \u8f49\u63db\u6ea2\u4f4d\uff0c{0}',
		'CRRUI2070E' : '\u6578\u5b78\u932f\u8aa4\uff1asetScale() - \u63d0\u4f9b\u4e86 {0} \u5f15\u6578\u3002\u53ea\u63a5\u53d7 1 \u6216 2',
		'CRRUI2071E' : '\u6578\u5b78\u932f\u8aa4\uff1asetScale() - \u8ca0\u5c0f\u6578\u4f4d\u6578\uff0c{0}',
		'CRRUI2072E' : '\u6578\u5b78\u932f\u8aa4\uff1aintCheck() - \u8f49\u63db\u932f\u8aa4\uff0c{0}',
		'CRRUI2073E' : '\u6578\u5b78\u932f\u8aa4\uff1adodivide() - \u6574\u6578\u6ea2\u4f4d',
		'CRRUI2074E' : '\u6578\u5b78\u932f\u8aa4\uff1a\u7121\u6cd5\u5c07\u5b57\u4e32 \"{1}\" \u8f49\u63db\u70ba\u6578\u5b57',
		'CRRUI2075E' : '\u6578\u5b78\u932f\u8aa4\uff1a{1} \u65b9\u6cd5\u7684\u5f15\u6578\u6578\u76ee {0} \u7121\u6548\u3002\u63d0\u4f9b\u7684\u5f15\u6578\u662f {2}',
		'CRRUI2076E' : '\u6578\u5b78\u932f\u8aa4\uff1a\u4f4d\u6578\u592a\u591a - {0}',
		'CRRUI2077E' : '\u6578\u5b78\u932f\u8aa4\uff1around() - \u63d0\u4f9b\u4e86 {0} \u5f15\u6578\u3002\u53ea\u63a5\u53d7 1 \u6216 2',
		'CRRUI2078E' : '\u6578\u5b78\u932f\u8aa4\uff1around() - \u9700\u8981\u6368\u5165',
		'CRRUI2079E' : '\u6578\u5b78\u932f\u8aa4\uff1around() - \u6368\u5165\u503c\u4e0d\u6b63\u78ba\uff0c{0}',
		'CRRUI2080E' : '\u6578\u5b78\u932f\u8aa4\uff1around() - \u6307\u6578 {0} \u6ea2\u4f4d',
		'CRRUI2081E' : '\u6578\u5b78\u932f\u8aa4\uff1afinish() - \u6307\u6578 {0} \u6ea2\u4f4d',
		'CRRUI2082E' : '\u5167\u90e8\u932f\u8aa4\uff1a\u5728\u547c\u53eb {0} \u7684\u5efa\u69cb\u5b50\u6642\u767c\u751f',
		'CRRUI2083E' : '\u5167\u90e8\u932f\u8aa4\uff1a\u5b9a\u7fa9\u985e\u5225 {0} \u6642\u767c\u751f\u554f\u984c',
		'CRRUI2084E' : '\u5167\u90e8\u932f\u8aa4\uff1a\u5728\u5c07\u5c0f\u7d44\u4ef6 {0}.{1} \u5b9a\u7fa9\u6210 egl.ui.rui.RUIPropertiesLibrary \u7684\u5b50\u985e\u5225\u6642\u767c\u751f',
		'CRRUI2085E' : '\u5167\u90e8\u932f\u8aa4\uff1a\u5728\u5c07\u5c0f\u7d44\u4ef6 {0}.{1} \u5b9a\u7fa9\u6210 {2}.{3} \u7684\u5b50\u985e\u5225\u6642\u767c\u751f',
		'CRRUI2086E' : '\u5167\u90e8\u932f\u8aa4\uff1a\u5b9a\u7fa9 RUI \u8655\u7406\u7a0b\u5f0f {0} \u6642\u767c\u751f\u554f\u984c',
		'CRRUI2087E' : '\u5167\u90e8\u932f\u8aa4\uff1a\u5b9a\u7fa9 RUI \u5c0f\u7d44\u4ef6 {0} \u6642\u767c\u751f\u554f\u984c',
		'CRRUI2088E' : 'EGL Rich UI \u4e0d\u652f\u63f4\u9019\u500b\u700f\u89bd\u5668',
		'CRRUI2089E' : '\u7121\u6cd5\u8f49\u63db JSON \u683c\u5f0f "{0}"\uff0c\u56e0\u70ba {1}',
		'CRRUI2090E' : '\u7121\u6cd5\u547c\u53eb\u670d\u52d9\uff1a{0}',
		'CRRUI2091E' : '\u7121\u6cd5\u50b3\u9001\u4e8b\u4ef6\u7d66 Eclipse IDE\uff1a{0}',
		'CRRUI2092E' : '\u5167\u90e8\u932f\u8aa4\uff1a\u8655\u7406 IDE \u4e8b\u4ef6 {0} \u6642\u767c\u751f\u554f\u984c',
		'CRRUI2093E' : '\u5167\u90e8\u932f\u8aa4\uff1a\u7121\u6cd5\u76e3\u63a7\u51fd\u6578 {0}',
		'CRRUI2094E' : 'EGL \u51fd\u6578\u547c\u53eb\u5c0e\u81f4\u9019\u500b\u932f\u8aa4\uff1a',
		'CRRUI2095E' : '\u627e\u4e0d\u5230\u5c0e\u81f4\u9019\u500b\u932f\u8aa4\u7684 EGL \u51fd\u6578\u547c\u53eb',
		'CRRUI2097E' : '\u5c6c\u6027 {0} \u7684 CSS \u6a23\u5f0f\u503c "{1}" \u7121\u6548',
		'CRRUI2097E' : 'CSS \u6a23\u5f0f {0} \u7121\u6cd5\u5256\u6790\u6b63\u78ba\u3002\u8acb\u6aa2\u67e5\u8a9e\u6cd5\uff0c\u6216\u4f7f\u7528\u5916\u90e8\u6a23\u5f0f\u8868\u3002',
		'CRRUI2098E' : '\u300c\u62d6\u653e\u300d\u652f\u63f4\u671f\u9593\u767c\u751f\u932f\u8aa4\uff1a{0}',
		'CRRUI2099E' : '\u5728 Rich UI \u4e2d\uff0c\u985e\u578b {0} \u4e0d\u652f\u63f4 EGL "set" \u4f5c\u696d',
		'CRRUI2100E' : 'RuiLib.convertFromXML \u7684\u5f15\u6578\u7121\u6548\u3002\u539f\u9810\u671f\u70ba\u5b57\u4e32\u3002\u537b\u6536\u5230 {0} \u985e\u578b\u7684\u7269\u4ef6',
		'CRRUI2101E' : '\u56e0\u70ba {2}\uff0c\u800c\u5728 "{0}" \u5167\u627e\u4e0d\u5230 indexOf "{1}"',
		'CRRUI2102E' : '\u7121\u6cd5\u6392\u5e8f\u9663\u5217',
		'CRRUI2103E' : '\u56e0 {2}\uff0c\u9020\u6210\u9055\u898f\u5b58\u53d6\u7269\u4ef6\uff08\u985e\u578b\u70ba "{1}"\uff09\u4e2d\u7684 "{0}"',
		'CRRUI2104E' : '\u7121\u6cd5\u5256\u6790 JSON \u5b57\u4e32 "{0}"',
		'CRRUI2105E' : '\u5617\u8a66\u8a2d\u5b9a {0} \u6642\uff0c\u767c\u751f JSON \u5256\u6790\u932f\u8aa4\u3002\u6b04\u4f4d\u4e0d\u5728 JSON \u5b57\u4e32\u5167\u7684\u9810\u671f\u4f4d\u7f6e\u3002',
		'CRRUI2106E' : '\u5256\u6790 JSON \u6642\uff0c\u8a66\u5716\u5c07 {0} \u8a2d\u70ba\u7a7a\u503c\u5931\u6557\uff0c\u56e0\u70ba\u5b83\u4e26\u672a\u5ba3\u544a\u6210\u53ef\u70ba\u7a7a\u503c\u7684\u6b04\u4f4d\u3002',
		'CRRUI2107E' : '\u670d\u52d9\u7a0b\u5f0f\u5eab JSON \u8f49\u63db\u51fd\u6578\u91dd\u5c0d\u300c\u8a18\u9304\u300d\u6216\u300c\u5b57\u5178\u300d\u64cd\u4f5c\u3002{0} \u4e0d\u662f\u652f\u63f4\u7684\u985e\u578b\u3002',
		'CRRUI2108E' : 'XML \u7a0b\u5f0f\u5eab XML \u8f49\u63db\u51fd\u6578\u91dd\u5c0d\u300c\u8a18\u9304\u300d\u64cd\u4f5c\u3002{0} \u4e0d\u662f\u652f\u63f4\u7684\u985e\u578b\u3002',
		
		'CRRUI2111E' : 'MathContext() \u932f\u8aa4\uff1a\u6307\u5b9a\u7684\u5f15\u6578\u6578\u76ee {0} \u7121\u6548\uff1b\u539f\u9810\u671f\u70ba 1 \u81f3 4 \u500b\u3002',
		'CRRUI2112E' : 'MathContext() \u932f\u8aa4\uff1a\u6307\u5b9a\u7684\u6578\u5b57\u6578\u76ee {0} \u592a\u5c0f\u3002',
		'CRRUI2113E' : 'MathContext() \u932f\u8aa4\uff1a\u6307\u5b9a\u7684\u6578\u5b57\u6578\u76ee {0} \u592a\u5927\u3002',
		'CRRUI2114E' : 'MathContext() \u932f\u8aa4\uff1a\u6307\u5b9a\u7684\u8868\u55ae\u503c {0} \u7121\u6548\u3002',
		'CRRUI2115E' : 'MathContext() \u932f\u8aa4\uff1a\u6307\u5b9a\u7684\u6368\u5165\u6a21\u5f0f\u503c {0} \u7121\u6548\u3002',
		
	    'CRRUI2700E' : '\u672a\u5728\u5fc5\u8981\u6b04\u4f4d\u4e2d\u8f38\u5165 - \u8acb\u91cd\u65b0\u8f38\u5165\u3002',
		'CRRUI2702E' : '\u8f38\u5165\u4e2d\u7684\u8cc7\u6599\u985e\u578b\u932f\u8aa4 - \u8acb\u91cd\u65b0\u8f38\u5165\u3002',
		'CRRUI2703E' : '\u8d85\u904e\u5bb9\u8a31\u7684\u6709\u6548\u4f4d\u6578 - \u8acb\u91cd\u65b0\u8f38\u5165\u3002',
		'CRRUI2704E' : '\u8f38\u5165\u672a\u5728\u5b9a\u7fa9\u7684\u7bc4\u570d\uff08{0} \u81f3 {1}\uff09\u5167 - \u8acb\u91cd\u65b0\u8f38\u5165\u3002',
		'CRRUI2705E' : '\u8f38\u5165\u9577\u5ea6\u4e0b\u9650\u932f\u8aa4 - \u8acb\u91cd\u65b0\u8f38\u5165\u3002',
		'CRRUI2707E' : '\u8f38\u5165\u4e2d\u767c\u751f\u6a21\u7d44\u6aa2\u67e5\u932f\u8aa4 - \u8acb\u91cd\u65b0\u8f38\u5165\u3002',
		'CRRUI2708E' : '\u5c0d\u6240\u5b9a\u7fa9\u7684\u65e5\u671f\u6216\u6642\u9593\u683c\u5f0f {0} \u4f86\u8aaa\uff0c\u8f38\u5165\u7121\u6548\u3002',
		'CRRUI2710E' : '\u5c0d Boolean \u6b04\u4f4d\u4f86\u8aaa\uff0c\u8f38\u5165\u7121\u6548\u3002',
		'CRRUI2712E' : '\u5341\u516d\u9032\u4f4d\u8cc7\u6599\u7121\u6548\u3002',
		'CRRUI2713E' : '\u6240\u8f38\u5165\u7684\u503c\u7121\u6548\uff0c\u56e0\u70ba\u5b83\u4e0d\u7b26\u5408\u6240\u8a2d\u7684\u578b\u6a23\u3002',		
		'CRRUI2716E' : '\u8f38\u5165\u672a\u5728\u5b9a\u7fa9\u7684\u6709\u6548\u503c\u6e05\u55ae\u5167 - \u8acb\u91cd\u65b0\u8f38\u5165\u3002',
		'CRRUI2717E' : '\u6307\u5b9a\u7684\u65e5\u671f\u548c\u6642\u9593\u683c\u5f0f {0} \u7121\u6548\u3002',	
		'CRRUI2719E' : '\u5256\u6790\u8f38\u5165\u503c\u6642\u767c\u751f\u932f\u8aa4\u3002',

		'CRRUI3650E' : '\u627e\u4e0d\u5230\u90e8\u7f72\u63cf\u8ff0\u5b50\u6a94\u6848\uff1a\'{0}\'',
		'CRRUI3651E' : '\u670d\u52d9\u9023\u7d50\u7d22\u5f15\u9375 \'{0}\' \u4e0d\u5b58\u5728\u65bc\u90e8\u7f72\u63cf\u8ff0\u5b50 \'{1}\' \u4e2d',
		'CRRUI3652E' : '\u670d\u52d9\u9023\u7d50\u985e\u578b \'{0}\' \u4e0d\u6b63\u78ba\uff0c\u9810\u671f\u7684\u9023\u7d50\u985e\u578b\u61c9\u70ba \'{1}\'',
		'CRRUI3653E' : '\u5617\u8a66\u5c0d \'{0}\' \u547c\u53eb rest \u670d\u52d9\u6642\u767c\u751f\u932f\u8aa4',
		'CRRUI3654E' : '\u5efa\u7f6e\u8981\u6c42\u7269\u4ef6\u6642\u767c\u751f\u932f\u8aa4\uff1a\'{0}\'',
		'CRRUI3655E' : '\u8655\u7406\u56de\u61c9\u7269\u4ef6\u6642\u767c\u751f\u932f\u8aa4\uff1a\'{0}\'',
		'CRRUI3656E' : '\u4e0d\u652f\u63f4\u4ee5 \'formdata\' \u4f5c\u70ba\u56de\u61c9\u683c\u5f0f',
		'CRRUI3657E' : '\u5728 \'{0}\' \u4e2d\u627e\u4e0d\u5230 Proxy \u4f86\u767c\u51fa\u670d\u52d9\u547c\u53eb',
		'CRRUI3658E' : '\u5617\u8a66\u5c0d \'{1}\' \u547c\u53eb\u670d\u52d9\u6642\uff0c\'{0}\' \u4e2d\u7684 Proxy \u767c\u751f\u932f\u8aa4',
		'CRRUI3659E' : 'JSON \u56de\u61c9\u5256\u6790\u7684\u7d50\u679c\u662f\u7a7a\u503c\uff0c\u539f\u59cb\u56de\u61c9\u70ba\uff1a\'{0}\'',
		'CRRUI3660E' : '\u767c\u751f\u7570\u5e38\u72c0\u6cc1\uff0c\u7121\u6cd5\u8655\u7406 \'{0}\' \u7684\u56de\u61c9\uff0c\u539f\u56e0\uff1a\'{1}\'',
		'CRRUI3661E' : '\u5728\u5617\u8a66\u547c\u53eb\u670d\u52d9\u51fd\u6578 \'{1}\' \u6642\uff0c\'{0}\' \u907a\u6f0f\u670d\u52d9\u9023\u7d50\u8cc7\u8a0a\u3002'
};

