/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.core.java.filters;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.edt.debug.core.EDTDebugCoreMessages;
import org.eclipse.edt.debug.core.EDTDebugCorePlugin;
import org.eclipse.edt.debug.core.java.IEGLJavaDebugTarget;
import org.eclipse.edt.debug.core.java.filters.AbstractTypeFilter;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.osgi.util.NLS;

public abstract class ClasspathEntryFilter
extends AbstractTypeFilter {
    protected static final Object COULD_NOT_PARSE_CONTAINER = new Object();
    protected Map<String, Object> libraryClassesToFilter;
    private Map<IEGLJavaDebugTarget, Object> targetContainerMap;
    private Map<Object, Map<String, Object>> containerClassMap;

    @Override
    public boolean filter(IJavaStackFrame frame, IEGLJavaDebugTarget target) {
        block6: {
            Object key;
            String typeName;
            block7: {
                block5: {
                    try {
                        typeName = frame.getReferenceType().getName();
                        if (this.libraryClassesToFilter == null || !this.libraryClassesToFilter.containsKey(typeName)) break block5;
                        return true;
                    }
                    catch (DebugException debugException) {}
                }
                if (this.targetContainerMap == null || this.containerClassMap == null) break block6;
                key = this.targetContainerMap.get(target);
                if (key != null && key != COULD_NOT_PARSE_CONTAINER) break block7;
                return false;
            }
            Map<String, Object> classMap = this.containerClassMap.get(key);
            if (classMap != null) {
                return classMap.containsKey(typeName);
            }
        }
        return false;
    }

    @Override
    public void dispose() {
        this.libraryClassesToFilter = null;
        this.targetContainerMap = null;
        this.containerClassMap = null;
    }

    @Override
    public void dispose(IEGLJavaDebugTarget target) {
        super.dispose(target);
        if (this.targetContainerMap != null) {
            Object removedKey = this.targetContainerMap.remove(target);
            if (this.containerClassMap != null && removedKey == Integer.valueOf(target.hashCode())) {
                this.containerClassMap.remove(removedKey);
            }
        }
    }

    @Override
    public synchronized void initialize(IEGLJavaDebugTarget target) {
        boolean needToInitLibraries = false;
        if (this.libraryClassesToFilter == null) {
            needToInitLibraries = true;
        }
        try {
            IClasspathEntry[] entries = this.getClasspathEntries(target);
            if (entries == null) {
                entries = new IClasspathEntry[]{};
            }
            if (entries.length == 0) {
                return;
            }
            IClasspathEntry[] iClasspathEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                switch (entry.getEntryKind()) {
                    case 1: {
                        if (!needToInitLibraries) break;
                        if (this.libraryClassesToFilter == null) {
                            this.libraryClassesToFilter = new HashMap<String, Object>(100);
                        }
                        this.processLibraryEntry(entry, target);
                        break;
                    }
                    case 5: {
                        if (this.targetContainerMap == null) {
                            this.targetContainerMap = new HashMap<IEGLJavaDebugTarget, Object>();
                        }
                        if (this.containerClassMap == null) {
                            this.containerClassMap = new HashMap<Object, Map<String, Object>>(100);
                        }
                        this.processContainerEntry(entry, target);
                        break;
                    }
                    default: {
                        EDTDebugCorePlugin.log((IStatus)new Status(2, "org.eclipse.edt.debug.core", NLS.bind((String)EDTDebugCoreMessages.TypeFilterClasspathEntryNotSupported, (Object[])new Object[]{entry.getEntryKind(), this.getId()})));
                    }
                }
                ++n2;
            }
        }
        catch (CoreException ce) {
            EDTDebugCorePlugin.log(ce);
        }
    }

    protected void processLibraryEntry(IClasspathEntry entry, IEGLJavaDebugTarget target) {
        File file = entry.getPath().toFile();
        if (file.exists()) {
            if (file.isDirectory()) {
                String rootPath = file.getPath();
                if (!rootPath.endsWith(File.separator)) {
                    rootPath = String.valueOf(rootPath) + File.separator;
                }
                this.processLibraryDirectory(file, rootPath);
            } else if (file.getName().endsWith(".jar")) {
                this.processJar(file, null, this.libraryClassesToFilter);
            }
        }
    }

    protected void processJar(File file, String rootPath, Map<String, Object> classMap) {
        int rootPathLen = rootPath == null ? 0 : rootPath.length();
        try {
            JarFile jar = new JarFile(file);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String path;
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory() || !(path = entry.getName()).endsWith(".class")) continue;
                String className = path.substring(rootPathLen, path.length() - 6).replace('/', '.');
                classMap.put(className, null);
            }
        }
        catch (IOException ioe) {
            EDTCoreIDEPlugin.log((Throwable)ioe);
        }
    }

    protected void processLibraryDirectory(File dir, String pathRoot) {
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                String path = file.getPath();
                if (path.endsWith(".class")) {
                    String className = path.substring(pathRoot.length(), path.length() - 6).replace(File.separatorChar, '.');
                    this.libraryClassesToFilter.put(className, null);
                }
            } else {
                this.processLibraryDirectory(file, pathRoot);
            }
            ++n2;
        }
    }

    protected void processContainerEntry(IClasspathEntry entry, IEGLJavaDebugTarget target) {
        Map<String, Object> classMap;
        Object classMapKey = this.targetContainerMap.get(target);
        if (classMapKey == null) {
            try {
                classMapKey = this.getContainerClassMapKey(target);
            }
            catch (CoreException ce) {
                EDTDebugCorePlugin.log(ce);
            }
            if (classMapKey == null) {
                classMapKey = COULD_NOT_PARSE_CONTAINER;
            }
            this.targetContainerMap.put(target, classMapKey);
        }
        if (classMapKey != COULD_NOT_PARSE_CONTAINER && (classMap = this.containerClassMap.get(classMapKey)) == null) {
            classMap = new HashMap<String, Object>(200);
            this.containerClassMap.put(classMapKey, classMap);
            try {
                this.processClasspath(entry, target, classMap);
            }
            catch (CoreException ce) {
                EDTDebugCorePlugin.log(ce);
            }
        }
    }

    protected void processClasspath(IClasspathEntry entry, IEGLJavaDebugTarget target, Map<String, Object> classMap) throws CoreException {
        IPackageFragmentRoot[] roots;
        IJavaProject project = JavaRuntime.getJavaProject((ILaunchConfiguration)target.getJavaDebugTarget().getLaunch().getLaunchConfiguration());
        if (project == null) {
            return;
        }
        IPackageFragmentRoot[] iPackageFragmentRootArray = roots = project.findPackageFragmentRoots(entry);
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            try {
                IJavaElement[] iJavaElementArray = root.getChildren();
                int n3 = iJavaElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IJavaElement element = iJavaElementArray[n4];
                    if (element.getElementType() == 4) {
                        try {
                            IClassFile[] classes;
                            IPackageFragment pkg = (IPackageFragment)element;
                            StringBuilder pkgBuf = new StringBuilder(50);
                            IPackageFragment current = pkg;
                            while (current != null && current.getElementType() == 4) {
                                if (pkgBuf.length() > 0) {
                                    pkgBuf.insert(0, '.');
                                }
                                pkgBuf.insert(0, current.getElementName());
                                current = current.getParent();
                            }
                            String pkgString = pkgBuf.toString();
                            IClassFile[] iClassFileArray = classes = pkg.getClassFiles();
                            int n5 = classes.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IClassFile file = iClassFileArray[n6];
                                String className = file.getElementName();
                                className = className.substring(0, className.length() - 6);
                                StringBuilder buf = new StringBuilder(pkgString.length() + className.length() + 1);
                                buf.append(pkgString);
                                if (pkgString.length() > 0) {
                                    buf.append('.');
                                }
                                buf.append(className);
                                classMap.put(buf.toString(), null);
                                ++n6;
                            }
                        }
                        catch (JavaModelException jme) {
                            EDTDebugCorePlugin.log(jme);
                        }
                    }
                    ++n4;
                }
            }
            catch (JavaModelException jme) {
                EDTDebugCorePlugin.log(jme);
            }
            ++n2;
        }
    }

    protected Object getContainerClassMapKey(IEGLJavaDebugTarget target) throws CoreException {
        return target.hashCode();
    }

    protected abstract IClasspathEntry[] getClasspathEntries(IEGLJavaDebugTarget var1) throws CoreException;
}

