/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.deployment.javascript;

import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.List;
import org.eclipse.edt.gen.deployment.util.CommonUtilities;
import org.eclipse.edt.ide.deployment.core.model.DeploymentDesc;
import org.eclipse.edt.javart.resources.egldd.RestBinding;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;

public class DeploymentDescGenerator {
    private TabbedWriter writer;

    public byte[] generateBindFile(DeploymentDesc deploymentDesc) {
        byte[] result;
        StringWriter stringWriter = new StringWriter();
        this.writer = new TabbedWriter((Writer)stringWriter);
        this.genBindJSFile(deploymentDesc);
        try {
            result = stringWriter.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            result = stringWriter.toString().getBytes();
        }
        return result;
    }

    private void genBindJSFile(DeploymentDesc deploymentDesc) {
        String eglddName = deploymentDesc.getName().toLowerCase();
        this.writer.print("egl[\"eze$$BindFile_");
        this.writer.print(eglddName);
        this.writer.println("\"] = function() {");
        this.writer.print("var bindFile = new egl.eglx.services.BindFile(\"");
        this.writer.print(eglddName);
        this.writer.println("\");");
        this.writer.println("var binding;");
        List restBindings = deploymentDesc.getRestBindings();
        int i = 0;
        while (i < restBindings.size()) {
            RestBinding restBinding = (RestBinding)restBindings.get(i);
            if (restBinding.isEnableGeneration()) {
                this.writer.println("binding = new egl.eglx.services.RestBinding(");
                this.writer.pushIndent();
                this.writer.println("/*name                   */ \"" + restBinding.getName().toLowerCase() + "\",");
                this.writer.println("/*baseURI                */ \"" + restBinding.getUri() + "\",");
                this.writer.print("/*sessionCookieId        */ ");
                if (restBinding.getSessionCookieId() != null) {
                    this.writer.println("\"" + restBinding.getSessionCookieId() + "\"");
                } else {
                    this.writer.println("null");
                }
                this.writer.popIndent();
                this.writer.println(");");
                this.writer.println("bindFile.bindings.push(binding);");
            }
            ++i;
        }
        for (String include : deploymentDesc.getIncludes()) {
            this.writer.println("bindFile.includes.push(\"" + CommonUtilities.toIncludeDDName(include) + "\");");
        }
        this.writer.println("return bindFile;");
        this.writer.println("}");
    }
}

