/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.javascript.templates.eglx.services;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.gen.javascript.Context;
import org.eclipse.edt.gen.javascript.templates.JavaScriptTemplate;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.AsExpression;
import org.eclipse.edt.mof.egl.CallStatement;
import org.eclipse.edt.mof.egl.EnumerationEntry;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.MemberAccess;
import org.eclipse.edt.mof.egl.ParameterKind;
import org.eclipse.edt.mof.egl.Service;
import org.eclipse.edt.mof.egl.Statement;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.IRUtils;
import org.eclipse.edt.mof.egl.utils.TypeUtils;

public class ServicesCallStatementTemplate
extends JavaScriptTemplate {
    public void genStatementBody(CallStatement stmt, Context ctx, TabbedWriter out) {
        boolean hasXXXRestAnnotation;
        Function serviceInterfaceFunction = (Function)((MemberAccess)stmt.getInvocationTarget()).getMember();
        Annotation getRest = serviceInterfaceFunction.getAnnotation("eglx.rest.GetRest");
        Annotation putRest = serviceInterfaceFunction.getAnnotation("eglx.rest.PutRest");
        Annotation postRest = serviceInterfaceFunction.getAnnotation("eglx.rest.PostRest");
        Annotation deleteRest = serviceInterfaceFunction.getAnnotation("eglx.rest.DeleteRest");
        boolean bl = hasXXXRestAnnotation = getRest != null || putRest != null || postRest != null || deleteRest != null;
        if (hasXXXRestAnnotation) {
            this.genTrueRestInvocation(stmt, serviceInterfaceFunction, getRest, putRest, postRest, deleteRest, ctx, out);
        } else {
            this.genEglRestInvocation(stmt, serviceInterfaceFunction, ctx, out);
        }
    }

    private void genEglRestInvocation(CallStatement stmt, Function serviceInterfaceFunction, Context ctx, TabbedWriter out) {
        out.print("egl.eglx.rest.invokeEglService(egl.eglx.rest.configHttp(");
        if (stmt.getUsing() == null) {
            ctx.invoke("genExpression", (EObject)stmt.getInvocationTarget().getQualifier(), new Object[]{ctx, out});
        } else {
            ctx.invoke("genExpression", (EObject)stmt.getUsing(), new Object[]{ctx, out});
        }
        out.println(",");
        out.pushIndent();
        out.pushIndent();
        this.genRequestConfig(out);
        this.genResponseConfig(out);
        out.println("),");
        ctx.invoke("genServiceName", (EObject)stmt, new Object[]{ctx, out, stmt.getInvocationTarget().getQualifier().getType()});
        out.println(", ");
        out.println("\"" + ServicesCallStatementTemplate.operationName(serviceInterfaceFunction) + "\", ");
        Function callbackFunction = null;
        if (stmt.getCallback() != null) {
            callbackFunction = (Function)ctx.invoke("getCallbackFunction", (EObject)stmt.getCallback(), new Object[]{ctx});
        }
        this.genInParamVals(serviceInterfaceFunction, stmt.getArguments(), ctx, out);
        this.genInParamSignature(serviceInterfaceFunction, stmt.getArguments(), ctx, out);
        this.genParamOrders(serviceInterfaceFunction, ctx, out);
        this.genCallbackArgs(callbackFunction, ctx, out);
        this.genCallbackAccesor(stmt.getCallback(), ctx, out);
        out.print(", ");
        this.genCallbackAccesor(stmt.getErrorCallback(), ctx, out);
        out.println(");");
        out.popIndent();
        out.popIndent();
    }

    private void genServiceName(CallStatement stmt, Context ctx, TabbedWriter out, Service service) {
        out.print("\"");
        out.print(stmt.getInvocationTarget().getQualifier().getType().getTypeSignature());
        out.print("\"");
    }

    public void genServiceName(CallStatement stmt, Context ctx, TabbedWriter out, Type type) {
        if (type instanceof Service) {
            this.genServiceName(stmt, ctx, out, (Service)type);
        } else {
            out.print("null");
        }
    }

    private void genTrueRestInvocation(CallStatement stmt, Function serviceInterfaceFunction, Annotation getRest, Annotation putRest, Annotation postRest, Annotation deleteRest, Context ctx, TabbedWriter out) {
        Function callbackFunction = null;
        if (stmt.getCallback() != null) {
            callbackFunction = (Function)ctx.invoke("getCallbackFunction", (EObject)stmt.getCallback(), new Object[]{ctx});
        }
        this.genRestParameters(stmt, serviceInterfaceFunction, stmt.getArguments(), getRest, putRest, postRest, deleteRest, ctx, out);
        out.println(",");
        this.genInParamVals(serviceInterfaceFunction, stmt.getArguments(), ctx, out);
        this.genInParamSignature(serviceInterfaceFunction, stmt.getArguments(), ctx, out);
        this.genParamOrders(serviceInterfaceFunction, ctx, out);
        this.genCallbackArgs(callbackFunction, ctx, out);
        this.genCallbackAccesor(stmt.getCallback(), ctx, out);
        out.print(", ");
        this.genCallbackAccesor(stmt.getErrorCallback(), ctx, out);
        out.println(");");
        out.popIndent();
        out.popIndent();
    }

    private void genCallbackAccesor(Expression callBack, Context ctx, TabbedWriter out) {
        if (callBack != null) {
            ctx.invoke("genCallbackAccesor", (EObject)callBack, new Object[]{ctx, out, null});
        } else {
            out.println("null");
        }
    }

    private void genRestParameters(CallStatement stmt, Function serviceInterfaceFunction, List<Expression> tempArgs, Annotation getRest, Annotation putRest, Annotation postRest, Annotation deleteRest, Context ctx, TabbedWriter out) {
        Hashtable<String, RestArgument> mapFuncParams = new Hashtable<String, RestArgument>();
        int idx = 0;
        while (idx < serviceInterfaceFunction.getParameters().size()) {
            FunctionParameter param = (FunctionParameter)serviceInterfaceFunction.getParameters().get(idx);
            mapFuncParams.put(param.getId().toLowerCase(), new RestArgument(param, tempArgs.get(idx), idx));
            ++idx;
        }
        out.print("egl.eglx.rest.invokeService(egl.eglx.rest.configHttp(");
        if (stmt.getUsing() == null) {
            ctx.invoke("genExpression", (EObject)stmt.getInvocationTarget().getQualifier(), new Object[]{ctx, out});
        } else {
            ctx.invoke("genExpression", (EObject)stmt.getUsing(), new Object[]{ctx, out});
        }
        out.println(",");
        out.pushIndent();
        out.pushIndent();
        out.print("{");
        int resourceParamIndex = -1;
        out.print(" method : ");
        Annotation restOperation = null;
        if (getRest != null) {
            out.print("egl.eglx.http.HttpMethod._GET");
            restOperation = getRest;
        } else if (putRest != null) {
            out.print("egl.eglx.http.HttpMethod.PUT");
            restOperation = putRest;
        } else if (postRest != null) {
            out.print("egl.eglx.http.HttpMethod.POST");
            restOperation = postRest;
        } else {
            out.print("egl.eglx.http.HttpMethod._DELETE");
            restOperation = deleteRest;
        }
        resourceParamIndex = this.genRESTParameters(restOperation, mapFuncParams, serviceInterfaceFunction.getReturnType(), ctx, out);
        out.println("),");
        if (resourceParamIndex != -1) {
            Expression expr = tempArgs.get(resourceParamIndex);
            if (expr != null) {
                ctx.invoke("genExpression", (EObject)expr, new Object[]{ctx, out});
            }
        } else {
            out.print("null");
        }
    }

    private int genRESTParameters(Annotation methodRestAnnotation, Map<String, RestArgument> funcParams, Type returnType, Context ctx, TabbedWriter out) {
        String uriTemplate = (String)methodRestAnnotation.getValue("uriTemplate");
        out.print(", uri : ");
        this.genURITemplate(uriTemplate, false, funcParams, ctx, out);
        out.println("");
        RestArgument resourceRestArg = null;
        Iterator<RestArgument> it = funcParams.values().iterator();
        while (it.hasNext() && resourceRestArg == null) {
            RestArgument restArg = it.next();
            if (!restArg.isResourceArg()) continue;
            resourceRestArg = restArg;
        }
        out.print(", encoding : ");
        this.genFormatKind(methodRestAnnotation.getValue("requestFormat"), resourceRestArg != null ? resourceRestArg.getParam().getType() : null, ctx, out);
        out.print(", charset : ");
        this.printQuotedString((String)methodRestAnnotation.getValue("requestCharset"), out);
        out.print(", contentType : ");
        this.printQuotedString((String)methodRestAnnotation.getValue("requestContentType"), out);
        out.println("},");
        out.print("{encoding : ");
        this.genFormatKind(methodRestAnnotation.getValue("responseFormat"), returnType, ctx, out);
        out.print(", charset : ");
        this.printQuotedString((String)methodRestAnnotation.getValue("responseCharset"), out);
        out.print(", contentType : ");
        this.printQuotedString((String)methodRestAnnotation.getValue("responseContentType"), out);
        out.print("}");
        return resourceRestArg != null ? resourceRestArg.getParamIndex() : -1;
    }

    private void genFormatKind(Object formatEnum, Type eglType, Context ctx, TabbedWriter out) {
        if (formatEnum instanceof EnumerationEntry) {
            ctx.invoke("genRuntimeTypeName", formatEnum, new Object[]{ctx, out});
        } else if (formatEnum instanceof Expression) {
            ctx.invoke("genExpression", formatEnum, new Object[]{ctx, out});
        } else if (eglType != null && ctx.mapsToPrimitiveType(eglType)) {
            out.print("egl.eglx.services.Encoding.NONE");
        } else if (eglType != null && "eglx.lang.EDictionary".equals(eglType.getTypeSignature())) {
            out.print("egl.eglx.services.Encoding.JSON");
        } else if (eglType != null) {
            out.print("egl.eglx.services.Encoding.XML");
        } else {
            out.print("egl.eglx.services.Encoding.NONE");
        }
    }

    private void genURITemplate(String uriTemplate, boolean needs2PrintPlus, Map<String, RestArgument> mapFunctionParams, Context ctx, TabbedWriter out) {
        int length = 0;
        if (uriTemplate != null) {
            length = uriTemplate.length();
        }
        if (uriTemplate != null && length > 0) {
            String leftOfOpenCurly = uriTemplate;
            String subsitutionVar = "";
            int fndOpenCurly = uriTemplate.indexOf(123);
            if (fndOpenCurly != -1) {
                int fndCloseCurly;
                leftOfOpenCurly = uriTemplate.substring(0, fndOpenCurly);
                if (leftOfOpenCurly.length() > 0) {
                    if (needs2PrintPlus) {
                        out.print(" + ");
                    }
                    out.print("\"" + leftOfOpenCurly + "\"");
                    needs2PrintPlus = true;
                }
                if ((fndCloseCurly = uriTemplate.indexOf(125, fndOpenCurly)) != -1) {
                    subsitutionVar = uriTemplate.substring(fndOpenCurly + 1, fndCloseCurly);
                    if (subsitutionVar.length() > 0) {
                        String key;
                        RestArgument restArg;
                        if (needs2PrintPlus) {
                            out.print(" + ");
                        }
                        if ((restArg = mapFunctionParams.get(key = subsitutionVar.toLowerCase())) != null) {
                            restArg.setResourceArg(false);
                            if (needs2PrintPlus) {
                                out.print("egl.eglx.http.HttpLib.convertToURLEncoded(");
                            } else {
                                out.print("egl.eglx.http.HttpLib.checkURLEncode(");
                            }
                            Expression arg = restArg.getArg();
                            if (arg != null) {
                                if (!arg.getType().equals(TypeUtils.Type_STRING).booleanValue()) {
                                    AsExpression asExpr = IRUtils.createAsExpression((Expression)arg, (Type)TypeUtils.Type_STRING);
                                    ctx.invoke("genExpression", (EObject)asExpr, new Object[]{ctx, out});
                                } else {
                                    ctx.invoke("genExpression", (EObject)arg, new Object[]{ctx, out});
                                }
                            }
                            out.print(")");
                            needs2PrintPlus = true;
                        }
                    }
                    String rightOfCloseCurly = uriTemplate.substring(fndCloseCurly + 1, length);
                    this.genURITemplate(rightOfCloseCurly, needs2PrintPlus, mapFunctionParams, ctx, out);
                }
            } else {
                if (needs2PrintPlus) {
                    out.print(" + ");
                }
                out.print("\"" + leftOfOpenCurly + "\"");
                needs2PrintPlus = true;
            }
        } else if (!needs2PrintPlus) {
            out.print("\"\"");
        }
    }

    private void genRequestConfig(TabbedWriter out) {
        out.print("{");
        out.print("uri : \"\"");
        out.print(", method : egl.eglx.http.HttpMethod.POST");
        out.print(", encoding : egl.eglx.services.Encoding.JSON");
        out.print(", charset : \"UTF-8\"");
        out.print(", contentType : null");
        out.println("},");
    }

    private void genResponseConfig(TabbedWriter out) {
        out.print("{");
        out.print("encoding : egl.eglx.services.Encoding.JSON");
        out.print(", charset : \"UTF-8\"");
        out.print(", contentType : null");
        out.print("}");
    }

    private void genInParamVals(Function serviceInterfaceFunction, List<Expression> args, Context ctx, TabbedWriter out) {
        out.print("[");
        boolean isFirst = true;
        int idx = 0;
        while (idx < serviceInterfaceFunction.getParameters().size()) {
            if (((FunctionParameter)serviceInterfaceFunction.getParameters().get(idx)).getParameterKind() != ParameterKind.PARM_OUT) {
                if (!isFirst) {
                    out.print(", ");
                }
                isFirst = false;
                ctx.invoke("genServiceInvocationInParam", args.get(idx).getType(), new Object[]{ctx, out, args.get(idx)});
            }
            ++idx;
        }
        out.println("], ");
    }

    private void genInParamSignature(Function serviceInterfaceFunction, List<Expression> args, Context ctx, TabbedWriter out) {
        out.print("[");
        boolean isFirst = true;
        for (FunctionParameter param : serviceInterfaceFunction.getParameters()) {
            if (param.getParameterKind() == ParameterKind.PARM_OUT) continue;
            if (!isFirst) {
                out.print(", ");
            }
            out.print("\"");
            ctx.invoke("genRuntimeTypeName", param.getType(), new Object[]{ctx, out, JavaScriptTemplate.TypeNameKind.EGLImplementation});
            out.print("\"");
            isFirst = false;
        }
        out.println("], ");
    }

    public static String operationName(Function function) {
        String operationName = null;
        Annotation annot = function.getAnnotation("xml");
        if (annot != null) {
            operationName = (String)annot.getValue("name");
        }
        if ((operationName == null || operationName.length() == 0) && (annot = function.getAnnotation("alias")) != null) {
            operationName = (String)annot.getValue();
        }
        if (operationName == null || operationName.length() == 0) {
            operationName = function.getId();
        }
        return operationName;
    }

    private void genParamOrders(Function serviceInterfaceFunction, Context ctx, TabbedWriter out) {
        out.print("[");
        boolean isFirst = true;
        for (FunctionParameter param : serviceInterfaceFunction.getParameters()) {
            if (!isFirst) {
                out.print(", ");
            }
            out.print("\"");
            ctx.invoke("genName", (EObject)param, new Object[]{ctx, out});
            out.print("\"");
            isFirst = false;
        }
        if (serviceInterfaceFunction.getReturnField() != null) {
            if (!isFirst) {
                out.print(", ");
            }
            out.print("\"");
            ctx.invoke("genName", (EObject)serviceInterfaceFunction.getReturnField(), new Object[]{ctx, out});
            out.print("\"");
            isFirst = false;
        }
        out.println("], ");
    }

    private void genCallbackArgs(Function callbackFunction, Context ctx, TabbedWriter out) {
        out.print("[");
        if (callbackFunction != null) {
            boolean isFirst = true;
            int idx = 0;
            while (idx < callbackFunction.getParameters().size()) {
                FunctionParameter param = (FunctionParameter)callbackFunction.getParameters().get(idx);
                if (!(param.getParameterKind() != ParameterKind.PARM_IN || idx == callbackFunction.getParameters().size() - 1 && this.isIHttp(param))) {
                    if (!isFirst) {
                        out.print(", ");
                    }
                    ctx.invoke("genServiceCallbackArgType", param.getType(), new Object[]{ctx, out});
                    isFirst = false;
                }
                ++idx;
            }
        }
        out.println("], ");
    }

    private boolean isIHttp(FunctionParameter param) {
        Type type = param.getType();
        return "eglx.http.IHttp".equals(type.getTypeSignature());
    }

    private void printQuotedString(String val, TabbedWriter out) {
        out.print(val == null ? "null" : ServicesCallStatementTemplate.quoted((String)val));
    }

    public Boolean requiresWrappedParameters(Statement stmt, Context ctx) {
        return Boolean.FALSE;
    }

    private static class RestArgument {
        private int index;
        private FunctionParameter param;
        private Expression arg;
        private boolean isResourceArg = true;

        public RestArgument(FunctionParameter param, Expression arg, int index) {
            this.param = param;
            this.arg = arg;
            this.index = index;
            this.isResourceArg = true;
        }

        public Expression getArg() {
            return this.arg;
        }

        public FunctionParameter getParam() {
            return this.param;
        }

        public boolean isResourceArg() {
            return this.isResourceArg;
        }

        public void setResourceArg(boolean isResourceArg) {
            this.isResourceArg = isResourceArg;
        }

        public int getParamIndex() {
            return this.index;
        }
    }
}

