/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.edt.ide.core.IGenerator;
import org.eclipse.edt.ide.core.IIDECompiler;
import org.eclipse.edt.ide.core.internal.builder.ASTManager;
import org.eclipse.edt.ide.core.internal.builder.ProjectSettingsListenerManager;
import org.eclipse.edt.ide.core.internal.builder.ResourceChangeProcessor;
import org.eclipse.edt.ide.core.internal.generation.GenerationBuildManager;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyFileInfoManager;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyResourceChangeProcessor;
import org.eclipse.edt.ide.core.internal.model.EGLModelManager;
import org.eclipse.edt.ide.core.internal.model.EGLProject;
import org.eclipse.edt.ide.core.internal.refactor.SettingUpdateResourceChangeListener;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IMember;
import org.eclipse.edt.ide.core.utils.ProjectSettingsUtility;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.prefs.BackingStoreException;

public class EDTCoreIDEPlugin
extends AbstractUIPlugin
implements ISaveParticipant,
IExecutableExtension {
    private static EDTCoreIDEPlugin eglCorePlugin;
    private BundleContext fBundleContext;
    private IPropertyChangeListener propertyChangeListener = new PreferenceListener();
    public static String PLUGIN_ID;
    public static final String BUILDER_ID;
    public static final String GENERATION_BUILDER_ID;
    public static final String GENERATION_PROBLEM;
    public static final String ATT_HANDLE_ID = "org.eclipse.edt.ide.core.internal.model.EGLModelManager.handleId";
    public static String EGL_UTILITIES;
    public static final String PT_GENERATIONCONTRIBUTORS = "GenerationContributors";
    public static final String PT_COMPILERS = "compilers";
    public static final String PT_GENERATORS = "generators";
    public static final String CLASS = "class";
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String COMPILER = "compiler";
    public static final String REQUIRES = "requires";
    public static final String PREFERENCE_PAGE_ID = "preferencePageId";
    public static final String VERSION = "version";
    public static final String DESCRIPTION = "description";
    public static final String PROVIDER = "provider";
    public static final String PARENT_GEN_ID = "parentGeneratorId";
    public static final String LANGUAGE = "language";
    public static final String ENABLED_WITH = "enabledWith";
    public static final String BUNDLEID = "bundleId";
    public static final String BUNDLEROOT = "bundleRoot";
    public static final String VERSIONRANGE = "versionRange";
    public static final String SOURCEBUNDLEID = "sourceBundleId";
    public static final String SOURCEBUNDLEROOT = "sourceBundleRoot";
    public static final String JAVADOCLOCATION = "javadocLocation";
    public static final String RUNTIMECONTAINERENTRY = "runtimeContainerEntry";
    public static final String RUNTIMECONTAINER = "runtimeContainer";
    public static final boolean SUPPORT_SOAP = false;
    public static final String EDT_CONTAINER_ID = "org.eclipse.edt.ide.core.EDT_CONTAINER";
    private IIDECompiler[] compilers;
    private IGenerator[] generators;
    private final Object compilersAndGeneratorsSynchObj = new Object();
    private ResourceChangeProcessor resourceChangeProcessor = new ResourceChangeProcessor();

    static {
        PLUGIN_ID = "org.eclipse.edt.ide.core";
        BUILDER_ID = String.valueOf(PLUGIN_ID) + ".EDTBuilder";
        GENERATION_BUILDER_ID = String.valueOf(PLUGIN_ID) + ".EDTGenBuilder";
        GENERATION_PROBLEM = String.valueOf(PLUGIN_ID) + ".generationProblem";
        EGL_UTILITIES = "org.eclipse.edt.ide.core.internal.utilities";
    }

    public EDTCoreIDEPlugin() {
        eglCorePlugin = this;
    }

    public void doneSaving(ISaveContext context) {
    }

    public static EDTCoreIDEPlugin getPlugin() {
        return eglCorePlugin;
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    public void rollback(ISaveContext context) {
    }

    public void saving(ISaveContext context) throws CoreException {
    }

    public Logger getLogger() {
        Logger logger = null;
        try {
            LogManager.getLogManager().readConfiguration();
            logger = Logger.getLogger(PLUGIN_ID);
            logger.setLevel(Level.ALL);
        }
        catch (Throwable t) {
            System.out.println("ERROR - EGL Core Plugin - getting logger");
            System.out.println("REASON: " + t.getMessage());
        }
        return logger;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.fBundleContext = context;
        this.getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        EGLModelManager manager = EGLModelManager.getEGLModelManager();
        workspace.addResourceChangeListener((IResourceChangeListener)manager.deltaProcessor, 31);
        workspace.addResourceChangeListener((IResourceChangeListener)this.resourceChangeProcessor, 15);
        workspace.addResourceChangeListener((IResourceChangeListener)ASTManager.getInstance(), 8);
        workspace.addResourceChangeListener((IResourceChangeListener)WorkingCopyResourceChangeProcessor.getInstance(), 7);
        workspace.addResourceChangeListener((IResourceChangeListener)SettingUpdateResourceChangeListener.getInstance(), 5);
        ProjectSettingsListenerManager.getInstance();
        EGLCore.getPlugin().getStateLocation();
        ISavedState lastState = workspace.addSaveParticipant(PLUGIN_ID, new ISaveParticipant(){

            public void doneSaving(ISaveContext context) {
            }

            public void prepareToSave(ISaveContext context) throws CoreException {
            }

            public void rollback(ISaveContext context) {
            }

            public void saving(ISaveContext context) throws CoreException {
                context.needDelta();
            }
        });
        if (lastState == null || !WorkingCopyFileInfoManager.getInstance().hasValidState()) {
            WorkingCopyResourceChangeProcessor.getInstance().initializeWorkingCopyIndex();
        } else {
            lastState.processResourceChangeEvents(new IResourceChangeListener(){

                public void resourceChanged(IResourceChangeEvent event) {
                    WorkingCopyResourceChangeProcessor.getInstance().processPostChange(event.getDelta());
                }
            });
        }
        this.startIndexing();
    }

    public BundleContext getBundleContext() {
        return this.fBundleContext;
    }

    public Object acquireService(String serviceName) {
        ServiceReference reference = this.fBundleContext.getServiceReference(serviceName);
        if (reference == null) {
            return null;
        }
        Object service = this.fBundleContext.getService(reference);
        if (service != null) {
            this.fBundleContext.ungetService(reference);
        }
        return service;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener((IResourceChangeListener)ASTManager.getInstance());
        workspace.removeResourceChangeListener((IResourceChangeListener)this.resourceChangeProcessor);
        workspace.removeResourceChangeListener((IResourceChangeListener)WorkingCopyResourceChangeProcessor.getInstance());
        workspace.removeResourceChangeListener((IResourceChangeListener)EGLModelManager.getEGLModelManager().deltaProcessor);
        workspace.removeSaveParticipant(PLUGIN_ID);
        EGLModelManager.getEGLModelManager().shutdown();
        this.fBundleContext = null;
    }

    public void log(String msg, Exception e) {
        this.getLog().log((IStatus)new Status(1, PLUGIN_ID, 0, msg, (Throwable)e));
    }

    public static void log(IStatus status) {
        if (status != null) {
            ResourcesPlugin.getPlugin().getLog().log(status);
        }
    }

    public static void log(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        IStatus status = null;
        if (e instanceof CoreException) {
            status = ((CoreException)e).getStatus();
        } else if (e.getMessage() != null) {
            status = new Status(4, PLUGIN_ID, 0, e.getMessage(), e);
        }
        EDTCoreIDEPlugin.log(status);
    }

    public static void logErrorMessage(String message) {
        EDTCoreIDEPlugin.log((IStatus)new Status(4, PLUGIN_ID, 4, message, null));
    }

    public static void logException(Throwable e) {
        EDTCoreIDEPlugin.logException(e, null);
    }

    public static void logException(Throwable e, String message) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        IStatus status = null;
        if (e instanceof CoreException) {
            status = ((CoreException)e).getStatus();
        } else {
            if (message == null) {
                message = e.getMessage();
            }
            if (message == null) {
                message = e.toString();
            }
            status = new Status(4, PLUGIN_ID, 0, message, e);
        }
        EDTCoreIDEPlugin.log(status);
    }

    public URL getInstallURL() {
        try {
            return FileLocator.resolve((URL)EDTCoreIDEPlugin.getPlugin().getBundle().getEntry("/"));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void startIndexing() {
        EGLModelManager.getEGLModelManager().getIndexManager().reset();
    }

    public void configureEGLElementMarker(IMarker marker, IEGLElement element) throws CoreException {
        if (element instanceof IMember) {
            element = ((IMember)element).getEGLFile();
        }
        if (marker != null && element != null) {
            marker.setAttribute(ATT_HANDLE_ID, (Object)element.getHandleIdentifier());
        }
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) throws CoreException {
    }

    private void setupCompilersAndGenerators() {
        String id;
        Object command;
        int i;
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(String.valueOf(PLUGIN_ID) + "." + PT_COMPILERS);
        if (elements != null) {
            ArrayList<IIDECompiler> compilers = new ArrayList<IIDECompiler>();
            i = 0;
            while (i < elements.length) {
                try {
                    command = elements[i].createExecutableExtension(CLASS);
                    if (command instanceof IIDECompiler) {
                        IIDECompiler compiler = (IIDECompiler)command;
                        id = elements[i].getAttribute(ID);
                        if (id != null && id.length() != 0) {
                            compiler.setId(id);
                            compiler.setName(elements[i].getAttribute(NAME));
                            compiler.setPreferencePageId(elements[i].getAttribute(PREFERENCE_PAGE_ID));
                            compiler.setVersion(elements[i].getAttribute(VERSION));
                            compilers.add(compiler);
                        }
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++i;
            }
            this.compilers = compilers.toArray(new IIDECompiler[compilers.size()]);
        } else {
            this.compilers = new IIDECompiler[0];
        }
        elements = Platform.getExtensionRegistry().getConfigurationElementsFor(String.valueOf(PLUGIN_ID) + "." + PT_GENERATORS);
        if (elements != null) {
            ArrayList<IGenerator> gens = new ArrayList<IGenerator>();
            i = 0;
            while (i < elements.length) {
                try {
                    command = elements[i].createExecutableExtension(CLASS);
                    if (command instanceof IGenerator) {
                        IIDECompiler compiler;
                        IGenerator gen = (IGenerator)command;
                        id = elements[i].getAttribute(ID);
                        if (id != null && id.length() != 0 && (compiler = this.findCompiler(elements[i].getAttribute(COMPILER))) != null) {
                            gen.setId(id);
                            gen.setName(elements[i].getAttribute(NAME));
                            gen.setCompiler(compiler);
                            gen.setVersion(elements[i].getAttribute(VERSION));
                            gen.setDescription(elements[i].getAttribute(DESCRIPTION));
                            gen.setParentGeneratorId(elements[i].getAttribute(PARENT_GEN_ID));
                            gen.setLanguage(elements[i].getAttribute(LANGUAGE));
                            gen.setProvider(elements[i].getAttribute(PROVIDER));
                            gen.setEnabledWith(elements[i].getAttribute(ENABLED_WITH));
                            gens.add(gen);
                            compiler.addGenerator(gen);
                        }
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++i;
            }
            this.generators = gens.toArray(new IGenerator[gens.size()]);
        } else {
            this.generators = new IGenerator[0];
        }
    }

    private IIDECompiler findCompiler(String id) {
        if (id == null || id.length() == 0 || this.compilers == null) {
            return null;
        }
        int i = 0;
        while (i < this.compilers.length) {
            if (this.compilers[i].getId().equals(id)) {
                return this.compilers[i];
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IGenerator[] getGenerators() {
        Object object = this.compilersAndGeneratorsSynchObj;
        synchronized (object) {
            if (this.generators == null) {
                this.setupCompilersAndGenerators();
            }
        }
        return this.generators;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IIDECompiler[] getCompilers() {
        Object object = this.compilersAndGeneratorsSynchObj;
        synchronized (object) {
            if (this.compilers == null) {
                this.setupCompilersAndGenerators();
            }
        }
        return this.compilers;
    }

    public IEclipsePreferences getCorePluginPreferences() {
        return new InstanceScope().getNode(PLUGIN_ID);
    }

    public void saveCorePluginPreferences() {
        IEclipsePreferences prefs = this.getCorePluginPreferences();
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            EDTCoreIDEPlugin.log(e);
        }
    }

    private class PreferenceListener
    implements IPropertyChangeListener {
        private PreferenceListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            block14: {
                IProject[] projects;
                block13: {
                    IProject[] projects2;
                    if (!"compilerId".equals(event.getProperty())) break block13;
                    IProject[] iProjectArray = projects2 = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                    int n = projects2.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProject project = iProjectArray[n2];
                        if (project.isAccessible() && EGLProject.hasEGLNature(project) && ProjectSettingsUtility.getCompilerId(project) == null) {
                            try {
                                project.touch(null);
                            }
                            catch (CoreException e) {
                                EDTCoreIDEPlugin.log(e);
                            }
                        }
                        ++n2;
                    }
                    break block14;
                }
                if (!"generatorIds".equals(event.getProperty()) && !"buildFlag".equals(event.getProperty())) break block14;
                IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                int n = projects.length;
                int n3 = 0;
                while (n3 < n) {
                    IProject project = iProjectArray[n3];
                    if (project.isAccessible() && EGLProject.hasEGLNature(project)) {
                        String compilerId = ProjectSettingsUtility.getCompilerId(project);
                        if (compilerId == null) {
                            try {
                                GenerationBuildManager.getInstance().setProjectState(project, false);
                                project.touch(null);
                            }
                            catch (CoreException e) {
                                EDTCoreIDEPlugin.log(e);
                            }
                        } else if (compilerId.equals(EDTCoreIDEPlugin.getPlugin().getPreferenceStore().getString("compilerId")) && ProjectSettingsUtility.getGeneratorIds((IResource)project) == null) {
                            try {
                                GenerationBuildManager.getInstance().setProjectState(project, false);
                                project.touch(null);
                            }
                            catch (CoreException e) {
                                EDTCoreIDEPlugin.log(e);
                            }
                        }
                    }
                    ++n3;
                }
            }
        }
    }
}

