/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.utils;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.ide.core.internal.model.EGLModel;
import org.eclipse.edt.ide.core.internal.search.PartDeclarationInfo;
import org.eclipse.edt.ide.core.internal.search.PartInfo;
import org.eclipse.edt.ide.core.internal.search.PartInfoRequestor;
import org.eclipse.edt.ide.core.internal.utils.AbsolutePathUtility;
import org.eclipse.edt.ide.core.internal.utils.ResourceAndTLFMap;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.search.IEGLSearchResultCollector;
import org.eclipse.edt.ide.core.search.IEGLSearchScope;
import org.eclipse.edt.ide.core.search.ISearchPattern;
import org.eclipse.edt.ide.core.search.SearchEngine;
import org.eclipse.edt.ide.core.utils.EGLProjectFileUtility;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class Util {
    public static IPath stringArrayToPath(String[] stringArray) {
        Path path = new Path("");
        int i = 0;
        while (i < stringArray.length) {
            path = path.append(stringArray[i]);
            ++i;
        }
        return path;
    }

    public static String[] pathToStringArray(IPath path) {
        String[] result = new String[path.segmentCount()];
        int i = 0;
        while (i < result.length) {
            result[i] = path.segment(i);
            ++i;
        }
        return result;
    }

    public static String getFilePartName(IFile file) {
        return InternUtil.intern((String)file.getProjectRelativePath().toString());
    }

    public static String getCaseSensitiveFilePartName(IFile file) {
        return InternUtil.internCaseSensitive((String)file.getProjectRelativePath().toString());
    }

    public static String getFileContents(IFile file) throws IOException, CoreException {
        BufferedInputStream fileContents = new BufferedInputStream(file.getContents(true));
        byte[] bytes = new byte[((InputStream)fileContents).available()];
        try {
            ((InputStream)fileContents).read(bytes);
        }
        finally {
            ((InputStream)fileContents).close();
        }
        return new String(bytes, file.getCharset());
    }

    public static List getEGLProjectPath(IProject project) {
        ArrayList projectList = new ArrayList();
        Util.initializeEGLPathHelper(projectList, new HashSet(), project, project, false, true);
        return projectList;
    }

    public static List getEGLProjectPath(IProject project, boolean includeEGLARs, boolean searchThroughProjects) {
        ArrayList projectList = new ArrayList();
        Util.initializeEGLPathHelper(projectList, new HashSet(), project, project, includeEGLARs, searchThroughProjects);
        return projectList;
    }

    private static void initializeEGLPathHelper(List entries, Set visitedProjects, IProject project, IProject requestingProject, boolean includeEglars, boolean searchThroughProjects) {
        visitedProjects.add(project);
        IEGLProject eglProject = EGLCore.create(project);
        try {
            if (((IProject)eglProject.getResource()).isOpen()) {
                IEGLPathEntry[] resolvedEGLPath = eglProject.getResolvedEGLPath(true);
                boolean projectAdded = false;
                int i = 0;
                while (i < resolvedEGLPath.length) {
                    IProject requiredProject;
                    if (resolvedEGLPath[i].getEntryKind() == 3) {
                        entries.add(eglProject);
                        projectAdded = true;
                    } else if (resolvedEGLPath[i].getEntryKind() == 1) {
                        if (includeEglars) {
                            if (project == requestingProject || resolvedEGLPath[i].isExported()) {
                                entries.add(Util.getAbsolutePathStringForEGLAR(resolvedEGLPath[i].getPath(), project));
                            }
                        } else if (!projectAdded && Util.isPathEntryForBinaryProjectEglar(project, resolvedEGLPath[i].getPath())) {
                            entries.add(eglProject);
                        }
                    } else if (resolvedEGLPath[i].getEntryKind() == 2 && (project == requestingProject || resolvedEGLPath[i].isExported() || searchThroughProjects) && !visitedProjects.contains(requiredProject = ResourcesPlugin.getWorkspace().getRoot().getProject(resolvedEGLPath[i].getPath().toString()))) {
                        Util.initializeEGLPathHelper(entries, visitedProjects, requiredProject, requestingProject, includeEglars, searchThroughProjects);
                    }
                    ++i;
                }
            }
        }
        catch (EGLModelException e) {
            throw new BuildException((Throwable)((Object)e));
        }
    }

    private static boolean isPathEntryForBinaryProjectEglar(IProject proj, IPath path) {
        IFile file;
        if (!new EGLProjectFileUtility().isBinaryProject(proj)) {
            return false;
        }
        Object obj = EGLModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), path, true);
        return obj instanceof IFile && (file = (IFile)obj).getProject() == proj && (String.valueOf(proj.getName()) + ".eglar").equalsIgnoreCase(file.getName());
    }

    private static String getAbsolutePathStringForEGLAR(IPath path, IProject proj) {
        return AbsolutePathUtility.getAbsolutePathString(path);
    }

    public static PartInfo getUsePart(IEGLProject project, String partDeclPackage, String partTypeName) {
        PartInfo[] parts = null;
        ArrayList partslist = new ArrayList();
        try {
            IEGLElement[] projects = new IEGLProject[]{project};
            IEGLSearchScope searchScope = SearchEngine.createEGLSearchScope(projects, true);
            PartInfoRequestor searchResult = new PartInfoRequestor(partslist);
            new SearchEngine().searchAllPartNames(ResourcesPlugin.getWorkspace(), partDeclPackage.toCharArray(), partTypeName.toCharArray(), 0, false, Short.MAX_VALUE, searchScope, searchResult, 3, null);
            parts = partslist.toArray(new PartInfo[partslist.size()]);
        }
        catch (EGLModelException e) {
            e.printStackTrace();
        }
        if (parts != null && parts.length > 0) {
            return parts[0];
        }
        return null;
    }

    public static IFile findPartFile(String fullyqualifiedPartName, IEGLProject eglProj) {
        try {
            PartDeclarationInfo part = Util.find1stPartInfoInEGLProject(fullyqualifiedPartName, eglProj, Short.MAX_VALUE, null, true);
            if (part != null) {
                if (!part.isExternal()) {
                    return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(part.getPath()));
                }
                return null;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
        return null;
    }

    public static String findPartFilePath(String fullyqualifiedPartName, IEGLProject eglProj) {
        try {
            PartDeclarationInfo part;
            int index = fullyqualifiedPartName.indexOf(":");
            if (index != -1) {
                fullyqualifiedPartName = fullyqualifiedPartName.substring(0, index);
            }
            if ((part = Util.find1stPartInfoInEGLProject(fullyqualifiedPartName, eglProj, Short.MAX_VALUE, null, true)) != null) {
                return part.getPath();
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
        return null;
    }

    public static PartDeclarationInfo find1stPartInfoInEGLProject(String fullyqualifiedPartName, IEGLProject eglProj, int partKind, IProgressMonitor monitor, boolean includeReferencedProjects) throws EGLModelException {
        int lastdot = fullyqualifiedPartName.lastIndexOf(46);
        String pkgName = "";
        String partSimpleName = fullyqualifiedPartName;
        if (lastdot != -1) {
            pkgName = fullyqualifiedPartName.substring(0, lastdot);
            partSimpleName = fullyqualifiedPartName.substring(lastdot + 1);
        }
        IEGLSearchScope projScope = SearchEngine.createEGLSearchScope(new IEGLElement[]{eglProj}, true);
        ArrayList typeList = new ArrayList();
        new SearchEngine().searchAllPartNames(ResourcesPlugin.getWorkspace(), pkgName.toCharArray(), partSimpleName.toCharArray(), 0, false, partKind, projScope, new PartInfoRequestor(typeList), 3, monitor);
        int foundCnts = typeList.size();
        if (foundCnts > 0) {
            PartDeclarationInfo foundPart = (PartDeclarationInfo)typeList.get(0);
            return foundPart;
        }
        return null;
    }

    public static PartInfo getRecordFieldNestedPart(IEGLProject project, String partDeclPackage, String partTypeName) {
        PartInfo[] parts = null;
        ArrayList partslist = new ArrayList();
        try {
            IEGLElement[] projects = new IEGLProject[]{project};
            IEGLSearchScope searchScope = SearchEngine.createEGLSearchScope(projects, true);
            PartInfoRequestor searchResult = new PartInfoRequestor(partslist);
            new SearchEngine().searchAllPartNames(ResourcesPlugin.getWorkspace(), partDeclPackage.toCharArray(), partTypeName.toCharArray(), 0, false, 24, searchScope, searchResult, 3, null);
            parts = partslist.toArray(new PartInfo[partslist.size()]);
        }
        catch (EGLModelException e) {
            e.printStackTrace();
        }
        if (parts != null && parts.length > 0) {
            return parts[0];
        }
        return null;
    }

    public static PartInfo getDataDeclarationPart(IEGLProject project, String partDeclPackage, String partTypeName) {
        PartInfo[] parts = null;
        ArrayList partslist = new ArrayList();
        try {
            IEGLElement[] projects = new IEGLProject[]{project};
            IEGLSearchScope searchScope = SearchEngine.createEGLSearchScope(projects, true);
            PartInfoRequestor searchResult = new PartInfoRequestor(partslist);
            new SearchEngine().searchAllPartNames(ResourcesPlugin.getWorkspace(), partDeclPackage.toCharArray(), partTypeName.toCharArray(), 0, false, 15896, searchScope, searchResult, 3, null);
            parts = partslist.toArray(new PartInfo[partslist.size()]);
        }
        catch (EGLModelException e) {
            e.printStackTrace();
        }
        if (parts != null && parts.length > 0) {
            return parts[0];
        }
        return null;
    }

    public static IEGLSearchScope createSearchScope(IResource resource) {
        IEGLElement[] elements = new IEGLElement[]{EGLCore.create(resource)};
        return SearchEngine.createEGLSearchScope(elements);
    }

    public static String getPackageFragmentRootPath(String pathString) {
        int ind;
        int index = pathString.indexOf("|");
        if (index == -1 && (ind = pathString.lastIndexOf("/")) != -1) {
            return pathString.substring(0, ind);
        }
        String jarPath = pathString.substring(0, index);
        return jarPath;
    }

    public static ResourceAndTLFMap[] getSourceFileAndTLFsMaps(IEGLProject eglProj) {
        final HashMap resMap = new HashMap();
        IEGLSearchResultCollector collector = new IEGLSearchResultCollector(){
            private HashMap<IResource, String> fileCache = new HashMap();

            @Override
            public void aboutToStart() {
            }

            @Override
            public void done() {
            }

            @Override
            public void accept(IResource resource, int start, int end, IEGLElement enclosingElement, int accuracy) throws CoreException {
                String fileContents = this.fileCache.get(resource);
                if (fileContents == null && resource instanceof IFile) {
                    fileContents = this.getFileContent(((IFile)resource).getContents());
                    this.fileCache.put(resource, fileContents);
                }
                int lastCharIndex = -1;
                if (fileContents != null) {
                    lastCharIndex = fileContents.length() - 1;
                }
                if (start > lastCharIndex || end > lastCharIndex) {
                    System.out.println("Wrong position!");
                    return;
                }
                String irFileName = fileContents.substring(start, end);
                IPath resPath = resource.getFullPath();
                resPath = resPath.removeFirstSegments(2).removeLastSegments(1);
                resPath = resPath.append(irFileName.toLowerCase());
                ResourceAndTLFMap map = (ResourceAndTLFMap)resMap.get(resource);
                if (map != null) {
                    map.addPath(resPath);
                } else {
                    map = new ResourceAndTLFMap(resource, resPath);
                    resMap.put(resource, map);
                }
            }

            @Override
            public void accept(IEGLElement element, int start, int end, IResource resource, int accuracy) throws CoreException {
            }

            @Override
            public IProgressMonitor getProgressMonitor() {
                return null;
            }

            private String getFileContent(InputStream inputStream) {
                InputStreamReader reader = new InputStreamReader(new BufferedInputStream(inputStream));
                StringBuffer s = new StringBuffer();
                try {
                    char[] cbuf = new char[4096];
                    int length = 0;
                    while ((length = reader.read(cbuf)) >= 0) {
                        s.append(cbuf, 0, length);
                    }
                }
                catch (IOException iOException) {}
                return s.toString();
            }
        };
        try {
            IEGLSearchScope searchScope = SearchEngine.createEGLSearchScope(new IEGLProject[]{eglProj}, true);
            ISearchPattern pattern = SearchEngine.createSearchPattern("*", 8, 0, false);
            new SearchEngine().search(ResourcesPlugin.getWorkspace(), pattern, searchScope, collector);
        }
        catch (EGLModelException e) {
            e.printStackTrace();
        }
        return resMap.values().toArray(new ResourceAndTLFMap[resMap.values().size()]);
    }
}

