/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.deployment.services.internal.testserver;

import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.edt.ide.deployment.services.internal.testserver.DDResourceChangeListener;
import org.eclipse.edt.ide.deployment.services.internal.testserver.DDUtil;
import org.eclipse.edt.ide.deployment.services.internal.testserver.DeploymentDescriptorFinder;
import org.eclipse.edt.ide.deployment.services.internal.testserver.Messages;
import org.eclipse.edt.ide.deployment.services.internal.testserver.ServicesConfigurator;
import org.eclipse.edt.ide.internal.sql.util.EGLSQLUtility;
import org.eclipse.edt.ide.testserver.AbstractTestServerContribution;
import org.eclipse.edt.ide.testserver.ClasspathUtil;
import org.eclipse.edt.ide.testserver.TestServerConfiguration;
import org.eclipse.edt.ide.testserver.TestServerIDEConnector;
import org.eclipse.edt.ide.testserver.TestServerPlugin;
import org.eclipse.edt.javart.services.servlet.proxy.RuiBrowserHttpRequest;
import org.eclipse.jst.server.core.internal.JavaServerPlugin;
import org.eclipse.jst.server.core.internal.RuntimeClasspathProviderWrapper;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.ServerUtil;

public class ServicesContribution
extends AbstractTestServerContribution {
    private final Object syncObj = new Object();
    private ArrayList<TestServerConfiguration> runningConfigurations = new ArrayList();
    private Map<TestServerConfiguration, String> currentDefaultDDName;
    private Map<TestServerConfiguration, List<DeploymentDescriptorFinder.DDFile>> currentDDFiles = new HashMap<TestServerConfiguration, List<DeploymentDescriptorFinder.DDFile>>();
    private Map<TestServerConfiguration, String> currentDDNameOrder;
    private DDResourceChangeListener ddListener;

    public ServicesContribution() {
        this.currentDefaultDDName = new HashMap<TestServerConfiguration, String>();
        this.currentDDNameOrder = new HashMap<TestServerConfiguration, String>();
        this.ddListener = new DDResourceChangeListener(this);
    }

    public void dispose() {
        this.ddListener.dispose();
        this.runningConfigurations = null;
        this.currentDDFiles = null;
        this.currentDefaultDDName = null;
        this.currentDDNameOrder = null;
        this.ddListener = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(TestServerConfiguration config) {
        Object object = this.syncObj;
        synchronized (object) {
            this.runningConfigurations.add(config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(TestServerConfiguration config) {
        Object object = this.syncObj;
        synchronized (object) {
            this.runningConfigurations.remove(config);
            this.currentDDFiles.remove(config);
            this.currentDefaultDDName.remove(config);
            this.currentDDNameOrder.remove(config);
        }
    }

    public String[] getConfiguratorClassNames(TestServerConfiguration config) {
        return new String[]{ServicesConfigurator.class.getCanonicalName()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getArgumentAdditions(TestServerConfiguration config) {
        StringBuilder buf = new StringBuilder(100);
        buf.append(" -dd \"");
        List<DeploymentDescriptorFinder.DDFile> ddFiles = DeploymentDescriptorFinder.findDeploymentDescriptors(config.getProject());
        buf.append(DeploymentDescriptorFinder.toArgumentString(ddFiles));
        buf.append("\" -ddd \"");
        String defaultDDName = DeploymentDescriptorFinder.getDefaultDDName(config.getProject());
        buf.append(defaultDDName);
        String orderedDDNames = DeploymentDescriptorFinder.toOrderedArgumentString(ddFiles);
        buf.append("\" -odd \"");
        buf.append(orderedDDNames);
        buf.append("\"");
        Object object = this.syncObj;
        synchronized (object) {
            this.currentDDFiles.put(config, ddFiles);
            this.currentDefaultDDName.put(config, defaultDDName);
            this.currentDDNameOrder.put(config, orderedDDNames);
        }
        return buf.toString();
    }

    public String[] getClasspathAdditions(TestServerConfiguration config) {
        RuntimeClasspathProviderWrapper rcpw;
        ArrayList<String> entries = new ArrayList<String>(2);
        String entry = ClasspathUtil.getClasspathEntry((String)"org.eclipse.edt.ide.deployment.core");
        if (entry != null) {
            entries.add(entry);
        }
        if ((entry = ClasspathUtil.getClasspathEntry((String)"org.eclipse.edt.ide.deployment.services")) != null) {
            entries.add(entry);
        }
        if ((entry = ClasspathUtil.getClasspathEntry((String)"org.eclipse.edt.runtime.java")) != null) {
            entries.add(entry);
        }
        if ((entry = ClasspathUtil.getClasspathEntry((String)"com.ibm.icu")) != null) {
            entries.add(entry);
        }
        DDUtil.addJDBCJars(config.getProject(), new HashSet<IProject>(), new HashSet<IResource>(), entries);
        IRuntime bestTomcat = null;
        IRuntime[] iRuntimeArray = ServerUtil.getRuntimes(null, null);
        int n = iRuntimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntime rt = iRuntimeArray[n2];
            if (rt.getRuntimeType().getName().toLowerCase().contains("tomcat")) {
                if (bestTomcat == null) {
                    bestTomcat = rt;
                } else if (bestTomcat.getRuntimeType().getVersion().compareTo(rt.getRuntimeType().getVersion()) < 0) {
                    bestTomcat = rt;
                }
            }
            ++n2;
        }
        if (bestTomcat != null && (rcpw = JavaServerPlugin.findRuntimeClasspathProvider((IRuntimeType)bestTomcat.getRuntimeType())) != null) {
            entries.add("<?xml version=\"1.0\" encoding=\"UTF-8\"?><runtimeClasspathEntry containerPath=\"org.eclipse.jst.server.core.container/" + rcpw.getId() + "/" + bestTomcat.getId() + "\" path=\"3\" type=\"4\"/>");
        }
        return entries.toArray(new String[entries.size()]);
    }

    public boolean handleServerRequest(Socket socket, PrintStream ps) throws Exception {
        RuiBrowserHttpRequest request = RuiBrowserHttpRequest.createNewRequest((Socket)socket);
        if (request.getContentArguments().containsKey("connectionProfile")) {
            this.handleConnectionProfileRequest(request, ps);
            return true;
        }
        return false;
    }

    private void handleConnectionProfileRequest(RuiBrowserHttpRequest request, PrintStream ps) throws Exception {
        String info;
        String url = null;
        String user = null;
        String pass = null;
        String schema = null;
        String className = null;
        String profileName = (String)request.getContentArguments().get("connectionProfile");
        IConnectionProfile profile = EGLSQLUtility.getConnectionProfile((String)profileName);
        if (profile != null) {
            url = EGLSQLUtility.getSQLConnectionURLPreference((IConnectionProfile)profile);
            user = EGLSQLUtility.getSQLUserId((IConnectionProfile)profile);
            pass = EGLSQLUtility.getSQLPassword((IConnectionProfile)profile);
            schema = EGLSQLUtility.getDefaultSchema((IConnectionProfile)profile);
            className = EGLSQLUtility.getSQLJDBCDriverClassPreference((IConnectionProfile)profile);
        }
        if (url == null) {
            url = "";
        }
        if (user == null) {
            user = "";
        }
        if (pass == null) {
            pass = "";
        }
        if (schema == null) {
            schema = "";
        }
        if (className == null) {
            className = "";
        }
        try {
            info = String.valueOf(URLEncoder.encode(url, "UTF-8")) + ';' + URLEncoder.encode(user, "UTF-8") + ';' + URLEncoder.encode(pass, "UTF-8") + ';' + URLEncoder.encode(schema, "UTF-8") + ';' + URLEncoder.encode(className, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            info = String.valueOf(url) + ';' + user + ';' + pass + ';' + schema + ';' + className;
        }
        ps.print(TestServerIDEConnector.getGoodResponseHeader((String)request.getURL(), (String)"application/x-www-form-urlencoded;charset=UTF-8", (boolean)false));
        try {
            ps.write(info.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ps.write(info.getBytes());
        }
    }

    public void resourceChanged(IResourceChangeEvent event, final TestServerConfiguration config) {
        try {
            class RecomputeSettings
            extends RuntimeException {
                private static final long serialVersionUID = 1L;

                RecomputeSettings() {
                }
            }
            try {
                if (event.getDelta() != null) {
                    event.getDelta().accept(new IResourceDeltaVisitor(){

                        public boolean visit(IResourceDelta delta) throws CoreException {
                            if (delta == null) {
                                return false;
                            }
                            switch (delta.getKind()) {
                                case 4: {
                                    if ((delta.getFlags() & 0x100) == 0 && (delta.getFlags() & 0x100000) == 0) {
                                        return true;
                                    }
                                }
                                case 1: 
                                case 2: {
                                    if (!"egldd".equalsIgnoreCase(delta.getFullPath().getFileExtension())) break;
                                    for (DeploymentDescriptorFinder.DDFile dd : (List)ServicesContribution.this.currentDDFiles.get(config)) {
                                        if (!dd.path.equals(delta.getResource().getLocation().toOSString())) continue;
                                        throw new RecomputeSettings();
                                    }
                                    break;
                                }
                            }
                            return true;
                        }
                    });
                }
            }
            catch (RecomputeSettings recomputeSettings) {
                new Thread(){

                    @Override
                    public void run() {
                        ServicesContribution.this.updateDDSettingsOnServer(config);
                    }
                }.start();
            }
        }
        catch (CoreException e) {
            TestServerPlugin.getDefault().log((Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateDDSettingsOnServer(TestServerConfiguration config) {
        boolean ddOrderChanged;
        List<DeploymentDescriptorFinder.DDFile> oldDDs;
        String oldDDNameOrder;
        String oldDefaultDD;
        Object object = this.syncObj;
        synchronized (object) {
            oldDefaultDD = this.currentDefaultDDName.get(config);
            oldDDNameOrder = this.currentDDNameOrder.get(config);
            oldDDs = this.currentDDFiles.get(config);
        }
        String defaultDD = DeploymentDescriptorFinder.getDefaultDDName(config.getProject());
        boolean defaultDDChanged = !oldDefaultDD.equals(defaultDD);
        List<DeploymentDescriptorFinder.DDFile> newDDFiles = DeploymentDescriptorFinder.findDeploymentDescriptors(config.getProject());
        ArrayList<DeploymentDescriptorFinder.DDFile> addedOrChangedDDFiles = new ArrayList<DeploymentDescriptorFinder.DDFile>();
        ArrayList<DeploymentDescriptorFinder.DDFile> copyOfCurrentDDFiles = new ArrayList<DeploymentDescriptorFinder.DDFile>(oldDDs);
        for (DeploymentDescriptorFinder.DDFile next : newDDFiles) {
            int size = copyOfCurrentDDFiles.size();
            DeploymentDescriptorFinder.DDFile old = null;
            int i = 0;
            while (i < size) {
                if (next.name.equals(((DeploymentDescriptorFinder.DDFile)copyOfCurrentDDFiles.get((int)i)).name)) {
                    old = (DeploymentDescriptorFinder.DDFile)copyOfCurrentDDFiles.remove(i);
                    break;
                }
                ++i;
            }
            if (old != null && old.equals(next)) continue;
            addedOrChangedDDFiles.add(next);
        }
        String newDDNameOrder = DeploymentDescriptorFinder.toOrderedArgumentString(newDDFiles);
        boolean bl = ddOrderChanged = !oldDDNameOrder.equals(newDDNameOrder);
        if (defaultDDChanged || ddOrderChanged || addedOrChangedDDFiles.size() > 0 || copyOfCurrentDDFiles.size() > 0) {
            String addedDDArg = DeploymentDescriptorFinder.toArgumentString(addedOrChangedDDFiles);
            String removedDDArg = DeploymentDescriptorFinder.toArgumentString(copyOfCurrentDDFiles);
            StringBuilder args = new StringBuilder(addedDDArg.length() + newDDNameOrder.length() + removedDDArg.length() + defaultDD.length() + 50);
            if (addedDDArg.length() > 0) {
                if (args.length() > 0) {
                    args.append('&');
                }
                args.append("ddAdded");
                args.append('=');
                args.append(addedDDArg);
            }
            if (removedDDArg.length() > 0) {
                if (args.length() > 0) {
                    args.append('&');
                }
                args.append("ddRemoved");
                args.append('=');
                args.append(removedDDArg);
            }
            if (defaultDDChanged) {
                if (args.length() > 0) {
                    args.append('&');
                }
                args.append("defaultDD");
                args.append('=');
                try {
                    args.append(URLEncoder.encode(defaultDD, "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    args.append(defaultDD);
                }
            }
            if (ddOrderChanged) {
                if (args.length() > 0) {
                    args.append('&');
                }
                args.append("orderedDDs");
                args.append('=');
                try {
                    args.append(URLEncoder.encode(newDDNameOrder, "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    args.append(newDDNameOrder);
                }
            }
            try {
                int status = config.invokeServlet("config", args.toString());
                if (status != 200) {
                    TestServerPlugin.getDefault().log(NLS.bind((String)Messages.ConfigServletBadStatus, (Object)status));
                }
            }
            catch (IOException e) {
                TestServerPlugin.getDefault().log((Exception)e);
            }
        }
        Object object2 = this.syncObj;
        synchronized (object2) {
            this.currentDDNameOrder.put(config, newDDNameOrder);
            this.currentDDFiles.put(config, newDDFiles);
            this.currentDefaultDDName.put(config, defaultDD);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TestServerConfiguration> getRunningConfigurationsCopy() {
        Object object = this.syncObj;
        synchronized (object) {
            return (List)this.runningConfigurations.clone();
        }
    }
}

