/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.util;

import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvDesignOverlay;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class ScrolledCompositeScroller
implements MouseListener,
MouseMoveListener {
    protected static final int MARGIN = 32;
    protected static final int SCROLL_INCREMENT_FACTOR = 10;
    protected boolean _bButtonDown = false;
    protected EvDesignOverlay _overlay = null;
    protected Point _ptContentSize = null;
    protected Point _ptMouse = new Point(0, 0);
    protected Point _ptOrigin = null;
    protected Rectangle _rectClient = null;
    protected ScrolledComposite _scrolledComposite = null;
    protected ScrollTimer _timer = null;

    public ScrolledCompositeScroller(ScrolledComposite scrolledComposite, EvDesignOverlay overlay) {
        this._scrolledComposite = scrolledComposite;
        this._overlay = overlay;
        this._timer = new ScrollTimer();
        this._overlay.addMouseListener(this);
        this._overlay.addMouseMoveListener(this);
    }

    public void activate() {
        this._bButtonDown = true;
        this._ptOrigin = this._scrolledComposite.getOrigin();
        this._ptContentSize = this._overlay.getSize();
        this._rectClient = this._scrolledComposite.getClientArea();
    }

    public void autoScroll(int iMouseX, int iMouseY) {
        if (!this._bButtonDown) {
            return;
        }
        this._ptMouse.x = iMouseX;
        this._ptMouse.y = iMouseY;
        boolean bStartTimer = false;
        if (this._ptMouse.x < this._ptOrigin.x + 32) {
            if (this._ptOrigin.x > 0) {
                bStartTimer = true;
            }
        } else if (this._ptMouse.x > this._ptOrigin.x + this._rectClient.width - 32 && this._ptOrigin.x + this._rectClient.width < this._ptContentSize.x) {
            bStartTimer = true;
        }
        if (this._ptMouse.y < this._ptOrigin.y + 32) {
            if (this._ptOrigin.y > 0) {
                bStartTimer = true;
            }
        } else if (this._ptMouse.y > this._ptOrigin.y + this._rectClient.height - 32 && this._ptOrigin.y + this._rectClient.height < this._ptContentSize.y) {
            bStartTimer = true;
        }
        if (bStartTimer && this._timer == null) {
            this._timer = new ScrollTimer();
            this._timer.start();
        } else if (!bStartTimer && this._timer != null) {
            this.stopTimer();
        }
    }

    public void deactivate() {
        this.stopTimer();
        this._bButtonDown = false;
    }

    public void mouseDoubleClick(MouseEvent event) {
    }

    public void mouseDown(MouseEvent event) {
        if (event.button != 1) {
            return;
        }
        this.activate();
    }

    public void mouseMove(MouseEvent event) {
        this.autoScroll(event.x, event.y);
    }

    public void mouseUp(MouseEvent event) {
        if (event.button != 1) {
            return;
        }
        this.deactivate();
    }

    protected void stopTimer() {
        if (this._timer != null) {
            this._timer._bRun = false;
        }
        this._timer = null;
    }

    protected void tick() {
        this._scrolledComposite.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ScrolledCompositeScroller.this.tickAsync();
            }
        });
    }

    protected void tickAsync() {
        int iScrollAmount;
        int iScrollAmount2;
        if (!this._bButtonDown) {
            return;
        }
        this._ptOrigin = this._scrolledComposite.getOrigin();
        Point ptOriginLeftRight = null;
        if (this._ptMouse.x - 32 < this._ptOrigin.x) {
            if (this._ptOrigin.x > 0) {
                iScrollAmount2 = (this._ptOrigin.x - (this._ptMouse.x - 32)) / 10;
                ptOriginLeftRight = new Point(Math.max(this._ptOrigin.x - iScrollAmount2, 0), this._ptOrigin.y);
            }
        } else if (this._ptMouse.x + 32 > this._ptOrigin.x + this._rectClient.width && this._ptOrigin.x + this._rectClient.width < this._ptContentSize.x) {
            iScrollAmount2 = (this._ptMouse.x + 32 - (this._ptOrigin.x + this._rectClient.width)) / 10;
            ptOriginLeftRight = new Point(Math.max(this._ptOrigin.x + iScrollAmount2, 0), this._ptOrigin.y);
        }
        Point ptOriginTopBottom = null;
        if (this._ptMouse.y - 32 < this._ptOrigin.y) {
            if (this._ptOrigin.y > 0) {
                iScrollAmount = (this._ptOrigin.y - (this._ptMouse.y - 32)) / 10;
                ptOriginTopBottom = new Point(this._ptOrigin.x, Math.max(this._ptOrigin.y - iScrollAmount, 0));
            }
        } else if (this._ptMouse.y + 32 > this._ptOrigin.y + this._rectClient.height && this._ptOrigin.y + this._rectClient.height < this._ptContentSize.y) {
            iScrollAmount = (this._ptMouse.y + 32 - (this._ptOrigin.y + this._rectClient.height)) / 10;
            ptOriginTopBottom = new Point(this._ptOrigin.x, Math.max(this._ptOrigin.y + iScrollAmount, 0));
        }
        Point ptOriginNew = null;
        if (ptOriginLeftRight != null && ptOriginTopBottom != null) {
            ptOriginNew = new Point(ptOriginLeftRight.x, ptOriginTopBottom.y);
        } else if (ptOriginLeftRight != null) {
            ptOriginNew = ptOriginLeftRight;
        } else if (ptOriginTopBottom != null) {
            ptOriginNew = ptOriginTopBottom;
        }
        if (ptOriginNew != null) {
            this._scrolledComposite.setOrigin(ptOriginNew);
            this._ptMouse.x += ptOriginNew.x - this._ptOrigin.x;
            this._ptMouse.y += ptOriginNew.y - this._ptOrigin.y;
            this._overlay.mouseMoved(this._ptMouse.x, this._ptMouse.y);
        } else {
            this.stopTimer();
        }
    }

    protected class ScrollTimer
    extends Thread {
        public boolean _bRun;

        public ScrollTimer() {
            super("Visual Editor Scroll Timer");
            this._bRun = true;
        }

        @Override
        public void run() {
            while (this._bRun) {
                try {
                    ScrolledCompositeScroller.this.tick();
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
    }
}

