/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.utils;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.ide.core.internal.model.BinaryPart;
import org.eclipse.edt.ide.core.internal.model.EGLProject;
import org.eclipse.edt.ide.core.internal.model.SourcePart;
import org.eclipse.edt.ide.core.internal.model.SourcePartElementInfo;
import org.eclipse.edt.ide.core.internal.model.SourcePropertyBlock;
import org.eclipse.edt.ide.core.internal.search.PartInfo;
import org.eclipse.edt.ide.core.internal.search.PartInfoRequestor;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.model.Signature;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.core.search.IEGLSearchScope;
import org.eclipse.edt.ide.core.search.IPartNameRequestor;
import org.eclipse.edt.ide.core.search.SearchEngine;
import org.eclipse.edt.ide.rui.document.utils.AssignmentLocator;
import org.eclipse.edt.ide.ui.internal.EGLUI;
import org.eclipse.edt.mof.egl.utils.InternUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class Util {
    public static final String RUIHANDLER = InternUtil.intern((String)"RUIHandler");
    public static final String RUIWIDGET = InternUtil.intern((String)"RUIWIdget");
    public static final String WIDGET_ID_SEPARATOR = "@@";
    public static boolean useCompression = true;
    public static String[] excludedCompression = new String[]{"com.ibm.egl.rui.dojo.runtime.local_1.6"};

    static {
        useCompression = "yes".equals(System.getProperty("EGL_RICH_UI_USE_COMPRESSION", "yes"));
    }

    public static String combineWidgetId(String projectName, String packageName, String widgetType) {
        return String.valueOf(projectName) + WIDGET_ID_SEPARATOR + packageName + WIDGET_ID_SEPARATOR + widgetType;
    }

    public static boolean isVESupportType(IFile file) {
        return Util.isVESupportType((IEGLFile)EGLCore.create((IFile)file), null);
    }

    public static boolean isVESupportType(IFile file, IEGLDocument currentDocument) {
        return Util.isVESupportType((IEGLFile)EGLCore.create((IFile)file), currentDocument);
    }

    public static boolean isRUIWidget(IFile file) {
        return Util.isRUIWidget((IEGLFile)EGLCore.create((IFile)file));
    }

    public static String getRUIWidgetId(IFile file) {
        return Util.getRUIWidgetId((IEGLFile)EGLCore.create((IFile)file));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isVESupportType(IEGLFile file, IEGLDocument currentDocument) {
        if (file == null) {
            return false;
        }
        try {
            IEGLFile sharedWorkingCopy = (IEGLFile)file.getSharedWorkingCopy(null, EGLUI.getBufferFactory(), null);
            try {
                sharedWorkingCopy.reconcile(true, null);
                IPart part = sharedWorkingCopy.getPart(new Path(file.getUnderlyingResource().getName()).removeFileExtension().toString());
                if (!part.exists()) return false;
                if (!((SourcePart)part).isHandler()) return false;
                SourcePartElementInfo partInfo = (SourcePartElementInfo)((SourcePart)part).getElementInfo();
                if (partInfo.getSubTypeName() == null) {
                    return false;
                }
                String typeName = InternUtil.intern((String)new String(partInfo.getSubTypeName()));
                if (typeName == RUIHANDLER) {
                    return true;
                }
                if (typeName != RUIWIDGET) return true;
                IEGLElement[] children = partInfo.getChildren();
                SourcePropertyBlock spb = null;
                int i = 0;
                while (i < children.length) {
                    if (children[i] instanceof SourcePropertyBlock && children[i].getElementName().equalsIgnoreCase(part.getElementName())) {
                        spb = (SourcePropertyBlock)children[i];
                        IEGLElement[] propertyChildren = spb.getChildren();
                        int j = 0;
                        while (j < propertyChildren.length) {
                            if (propertyChildren[j].getElementName().equalsIgnoreCase("targetWidget")) {
                                return true;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                if (currentDocument == null) {
                    return false;
                }
                if (spb == null) return true;
                currentDocument.getNewModelEGLFile();
                Node perpertiesBlock = currentDocument.getNewModelNodeAtOffset(spb.getSourceRange().getOffset(), spb.getSourceRange().getLength());
                AssignmentLocator assignmentLocator = new AssignmentLocator(InternUtil.intern((String)"tagName"));
                perpertiesBlock.accept((IASTVisitor)assignmentLocator);
                Assignment setting = assignmentLocator.getAssignment();
                if (setting == null) return true;
                return false;
            }
            finally {
                sharedWorkingCopy.destroy();
            }
        }
        catch (EGLModelException eGLModelException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isRUIWidget(IEGLFile file) {
        try {
            IEGLFile sharedWorkingCopy = (IEGLFile)file.getSharedWorkingCopy(null, EGLUI.getBufferFactory(), null);
            try {
                sharedWorkingCopy.reconcile(true, null);
                IPart part = sharedWorkingCopy.getPart(new Path(file.getUnderlyingResource().getName()).removeFileExtension().toString());
                if (!part.exists()) return false;
                if (!((SourcePart)part).isHandler()) return false;
                SourcePartElementInfo partInfo = (SourcePartElementInfo)((SourcePart)part).getElementInfo();
                if (partInfo.getSubTypeName() == null) {
                    return false;
                }
                String typeName = InternUtil.intern((String)new String(partInfo.getSubTypeName()));
                boolean bl = typeName == RUIWIDGET;
                return bl;
            }
            finally {
                sharedWorkingCopy.destroy();
            }
        }
        catch (EGLModelException eGLModelException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final String getRUIWidgetId(IEGLFile file) {
        try {
            IEGLFile sharedWorkingCopy = (IEGLFile)file.getSharedWorkingCopy(null, EGLUI.getBufferFactory(), null);
            try {
                String widgetId;
                sharedWorkingCopy.reconcile(true, null);
                IPart part = sharedWorkingCopy.getPart(new Path(file.getUnderlyingResource().getName()).removeFileExtension().toString());
                if (!part.exists()) return null;
                if (!((SourcePart)part).isHandler()) return null;
                String projectName = part.getEGLProject().getElementName();
                String packageName = part.getPackageFragment().getElementName();
                String widgetType = part.getElementName();
                String string = widgetId = Util.combineWidgetId(projectName, packageName, widgetType);
                return string;
            }
            finally {
                sharedWorkingCopy.destroy();
            }
        }
        catch (EGLModelException eGLModelException) {
            return null;
        }
    }

    public static IPart[] searchForRUIWidgets(IProject project) {
        LinkedHashSet<IPart> result = new LinkedHashSet<IPart>();
        try {
            ArrayList partsList = new ArrayList();
            IWorkspaceRoot workspaceroot = ResourcesPlugin.getWorkspace().getRoot();
            IEGLProject eglProject = EGLCore.create((IProject)workspaceroot.getProject(project.getName()));
            IEGLSearchScope searchScope = SearchEngine.createEGLSearchScope((IEGLElement[])new IEGLProject[]{eglProject}, (boolean)true);
            PartInfoRequestor searchResult = new PartInfoRequestor(partsList);
            new SearchEngine().searchAllPartNames(ResourcesPlugin.getWorkspace(), null, null, 2, false, 8704, searchScope, (IPartNameRequestor)searchResult, 3, null);
            for (PartInfo partinfo : partsList) {
                IPart part = partinfo.resolvePart(searchScope);
                if (part == null || part.getEGLProject().getProject() != eglProject.getProject() || !Util.isRUIWidgetOrExternalType(part)) continue;
                result.add(part);
            }
        }
        catch (EGLModelException eGLModelException) {}
        return result.toArray(new IPart[result.size()]);
    }

    private static boolean isRUIWidgetOrExternalType(IPart part) {
        if (part instanceof SourcePart) {
            if (((SourcePart)part).isHandler() && part.getSubTypeSignature() != null && RUIWIDGET == InternUtil.intern((String)Signature.toString((String)part.getSubTypeSignature()))) {
                return true;
            }
            return ((SourcePart)part).isExternalType();
        }
        if (part instanceof BinaryPart) {
            if (((BinaryPart)part).isHandler() && part.getSubTypeSignature() != null && RUIWIDGET == InternUtil.intern((String)Signature.toString((String)part.getSubTypeSignature()))) {
                return true;
            }
            return ((BinaryPart)part).isExternalType();
        }
        return false;
    }

    public static boolean isRUIProject(IProject project) {
        return EGLProject.hasRUINature((IProject)project);
    }

    public static boolean isCEProject(IProject project) {
        return EGLProject.hasCENature((IProject)project);
    }

    public static final Shell getShell() {
        IWorkbenchWindow workbenchWindow;
        Shell shell = null;
        Display display = Util.getDisplay();
        if (display != null) {
            shell = display.getActiveShell();
        }
        if (shell == null && (workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
            shell = workbenchWindow.getShell();
        }
        return shell;
    }

    public static final Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static String[] combineArray(String[] array1, String[] array2) {
        String[] result = new String[array1.length + array2.length];
        System.arraycopy(array1, 0, result, 0, array1.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    private static boolean isExcludedCompression(String fileName) {
        int i = 0;
        while (i < excludedCompression.length) {
            if (fileName.indexOf(excludedCompression[i]) > 0) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

