/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.internal.testserver;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.edt.ide.testserver.TestServerConfiguration;
import org.eclipse.edt.ide.testserver.TestServerMessages;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class UpdateErrorDialog
extends ErrorDialog {
    protected static final int BUTTON_ID_TERMINATE_SERVER = 14;
    private final IPreferenceStore prefStore;
    private final String prefKey;
    private final TestServerConfiguration[] configs;
    private Button checkbox;

    public UpdateErrorDialog(Shell parentShell, String dialogTitle, String message, IStatus status, IPreferenceStore prefStore, String prefKey, TestServerConfiguration config) {
        this(parentShell, dialogTitle, message, status, prefStore, prefKey, new TestServerConfiguration[]{config});
    }

    public UpdateErrorDialog(Shell parentShell, String dialogTitle, String message, IStatus status, IPreferenceStore prefStore, String prefKey, TestServerConfiguration[] configs) {
        super(parentShell, dialogTitle, message, status, 7);
        this.prefStore = prefStore;
        this.prefKey = prefKey;
        this.configs = configs;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        if (this.prefStore != null && this.prefKey != null) {
            this.checkbox = new Button(composite, 16416);
            this.checkbox.setText(TestServerMessages.ErrorDialogRememberDecision);
            this.checkbox.setFont(parent.getFont());
            GridData data = new GridData(0);
            data.horizontalSpan = 2;
            data.horizontalAlignment = 1;
            data.verticalIndent = 10;
            this.checkbox.setLayoutData((Object)data);
            Link link = new Link(composite, 64);
            link.setText(TestServerMessages.ErrorDialogChangeLater);
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PreferencesUtil.createPreferenceDialogOn(null, (String)"org.eclipse.edt.ide.testserver.testServerPreferences", null, null).open();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            link.setFont(parent.getFont());
            data = new GridData(0);
            data.horizontalSpan = 2;
            data.horizontalAlignment = 1;
            link.setLayoutData((Object)data);
        }
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createDetailsButton(parent);
        this.createButton(parent, 14, this.configs.length > 1 ? TestServerMessages.ErrorDialogTerminatePluralButton : TestServerMessages.ErrorDialogTerminateButton, false);
        this.createButton(parent, 0, TestServerMessages.ErrorDialogContinueButton, false);
        Button details = this.getButton(13);
        if (details != null) {
            details.setFocus();
        }
    }

    protected void storePreference(int button) {
        boolean checked;
        boolean bl = checked = this.checkbox != null && this.checkbox.getSelection();
        if (checked) {
            this.prefStore.setValue(this.prefKey, button == 14 ? 1 : 2);
        }
    }

    protected void buttonPressed(int id) {
        if (id == 14) {
            TestServerConfiguration[] testServerConfigurationArray = this.configs;
            int n = this.configs.length;
            int n2 = 0;
            while (n2 < n) {
                TestServerConfiguration config = testServerConfigurationArray[n2];
                try {
                    config.terminate();
                }
                catch (DebugException e) {
                    ErrorDialog.openError((Shell)this.getShell(), (String)TestServerMessages.TerminateFailedTitle, (String)NLS.bind((String)TestServerMessages.TerminateFailedMsg, (Object)config.getProject().getName()), (IStatus)e.getStatus());
                }
                ++n2;
            }
            this.storePreference(id);
            this.okPressed();
        } else {
            if (id == 0) {
                this.storePreference(id);
            }
            super.buttonPressed(id);
        }
    }
}

