/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.referencecompletion;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.TopLevelFunction;
import org.eclipse.edt.ide.core.internal.errors.ParseStack;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLStringListProposalHandler;
import org.eclipse.edt.ide.ui.internal.contentassist.referencecompletion.EGLAbstractReferenceCompletion;
import org.eclipse.jface.text.ITextViewer;

public class EGLParameterModifierReferenceCompletion
extends EGLAbstractReferenceCompletion {
    @Override
    protected void precompileContexts() {
        this.addContext("package a; program a function a(a a");
        this.addContext("package a; program a function a(a int");
        this.addContext("package a; program a function a(a string");
        this.addContext("package a; program a function a(a char(4)");
        this.addContext("package a; program a function a(a bin(4,2)");
        this.addContext("package a; program a function a(a decimal(4)");
        this.addContext("package a; program a function a(a timestamp(\"d\")");
    }

    @Override
    protected List returnCompletionProposals(ParseStack parseStack, String prefix, ITextViewer viewer, int documentOffset) {
        if (this.isInFunction(viewer, documentOffset)) {
            String[] strings = new String[]{"field", "in", "inOut", "sqlnullable", "out"};
            return new EGLStringListProposalHandler(viewer, documentOffset, prefix).getProposals(strings, UINlsStrings.CAProposal_EGLKeyword);
        }
        return new ArrayList(0);
    }

    private boolean isInFunction(ITextViewer viewer, int documentOffset) {
        Node partNode;
        final boolean[] valid = new boolean[1];
        Node nestedPart = this.getNestedPart(viewer, documentOffset);
        if (nestedPart != null) {
            nestedPart.accept((IASTVisitor)new AbstractASTVisitor(){

                public boolean visit(NestedFunction function) {
                    valid[0] = true;
                    return false;
                }
            });
        }
        if (!valid[0] && (partNode = this.getPart(viewer, documentOffset)) != null) {
            partNode.accept((IASTVisitor)new DefaultASTVisitor(){

                public boolean visit(TopLevelFunction function) {
                    valid[0] = true;
                    return false;
                }
            });
        }
        return valid[0];
    }
}

