/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.editor;

import java.util.List;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.CaseStatement;
import org.eclipse.edt.compiler.core.ast.DataTable;
import org.eclipse.edt.compiler.core.ast.ElseBlock;
import org.eclipse.edt.compiler.core.ast.Enumeration;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.ExternalType;
import org.eclipse.edt.compiler.core.ast.ForEachStatement;
import org.eclipse.edt.compiler.core.ast.ForStatement;
import org.eclipse.edt.compiler.core.ast.FormGroup;
import org.eclipse.edt.compiler.core.ast.Handler;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.IfStatement;
import org.eclipse.edt.compiler.core.ast.Interface;
import org.eclipse.edt.compiler.core.ast.Library;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedForm;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.OnEventBlock;
import org.eclipse.edt.compiler.core.ast.OnExceptionBlock;
import org.eclipse.edt.compiler.core.ast.OpenUIStatement;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.Program;
import org.eclipse.edt.compiler.core.ast.ProgramParameter;
import org.eclipse.edt.compiler.core.ast.Record;
import org.eclipse.edt.compiler.core.ast.Service;
import org.eclipse.edt.compiler.core.ast.TopLevelForm;
import org.eclipse.edt.compiler.core.ast.TopLevelFunction;
import org.eclipse.edt.compiler.core.ast.TryStatement;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.core.ast.WhileStatement;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class ScriptDoubleClickVisitor
extends AbstractASTVisitor {
    private IDocument fDoc;
    private int cursorOffset = -1;
    private int doubleClickSelOffset = -1;
    private boolean foundDoubleClickOffset = false;

    public ScriptDoubleClickVisitor(IDocument doc, int cusorPosition) {
        this.fDoc = doc;
        this.cursorOffset = cusorPosition;
    }

    public boolean foundDoubleClickOffset() {
        return this.foundDoubleClickOffset;
    }

    public int getDoubleClickOffset() {
        return this.doubleClickSelOffset;
    }

    private void calculateStartingEndingPosition(Node startingPositionNode, Node currentNode) {
        int blockStartingPos = startingPositionNode.getOffset() + startingPositionNode.getLength();
        this.calculateStartingEndingPosition(blockStartingPos, currentNode);
    }

    private void calculateStartingEndingPosition(int blockStartingPosition, Node currentNode) {
        int blockEndPos = currentNode.getOffset() + currentNode.getLength() - "end".length();
        this.calculateStartingEndingPosition(blockStartingPosition, blockEndPos);
    }

    private void calculateStartingEndingPosition(int blockStartingPosition, int blockEndingPosition) {
        if (this.cursorOffset == blockStartingPosition) {
            this.foundDoubleClickOffset = true;
            this.doubleClickSelOffset = blockEndingPosition;
        } else if (this.cursorOffset == blockEndingPosition) {
            this.foundDoubleClickOffset = true;
            this.doubleClickSelOffset = blockStartingPosition;
        } else {
            this.foundDoubleClickOffset = false;
        }
    }

    public boolean visit(Record record) {
        this.calcaulatePartPosition((Part)record);
        return false;
    }

    public boolean visit(DataTable dataTable) {
        this.calcaulatePartPosition((Part)dataTable);
        return false;
    }

    public boolean visit(Enumeration enumeration) {
        this.calcaulatePartPosition((Part)enumeration);
        return false;
    }

    public boolean visit(ExternalType externalType) {
        Name startingPositionNode = null;
        startingPositionNode = externalType.hasSubType() ? externalType.getSubType() : (!externalType.getExtendedTypes().isEmpty() ? (Name)externalType.getExtendedTypes().get(0) : externalType.getName());
        this.calculateStartingEndingPosition((Node)startingPositionNode, (Node)externalType);
        return false;
    }

    public boolean visit(FormGroup formGroup) {
        Name startingPositionNode = formGroup.getName();
        this.calculateStartingEndingPosition((Node)startingPositionNode, (Node)formGroup);
        return false;
    }

    public boolean visit(TopLevelForm topLevelForm) {
        this.calcaulatePartPosition((Part)topLevelForm);
        return false;
    }

    public boolean visit(Handler handler) {
        this.calcaulatePartPosition((Part)handler);
        return false;
    }

    private int searchForClosingBracket(int startPos, char closeBracket, IDocument doc) {
        int closePos = startPos;
        int length = doc.getLength();
        boolean bFnd = false;
        try {
            while (closePos < length && !bFnd) {
                char nextChar = doc.getChar(closePos);
                if (nextChar == closeBracket) {
                    bFnd = true;
                }
                ++closePos;
            }
        }
        catch (BadLocationException e) {
            closePos = -1;
            e.printStackTrace();
        }
        if (bFnd) {
            return closePos;
        }
        return -1;
    }

    public boolean visit(Program program) {
        List params = program.getParameters();
        if (params != null && !params.isEmpty()) {
            int size = params.size();
            Type paramTypeNode = ((ProgramParameter)params.get(size - 1)).getType();
            int endofParam = paramTypeNode.getOffset() + paramTypeNode.getLength();
            int closingBracketPos = this.searchForClosingBracket(endofParam, ')', this.fDoc);
            this.calculateStartingEndingPosition(closingBracketPos, (Node)program);
        } else {
            this.calcaulatePartPosition((Part)program);
        }
        return false;
    }

    public boolean visit(Library library) {
        this.calcaulatePartPosition((Part)library);
        return false;
    }

    private void calcaulatePartPosition(Part part) {
        Name startingPositionNode = null;
        startingPositionNode = part.hasSubType() ? part.getSubType() : part.getName();
        this.calculateStartingEndingPosition((Node)startingPositionNode, (Node)part);
    }

    public boolean visit(TopLevelFunction topLevelFunction) {
        int startingNodePos = -1;
        if (topLevelFunction.hasReturnType()) {
            Type returnTypeNode = topLevelFunction.getReturnType();
            startingNodePos = returnTypeNode.getOffset() + returnTypeNode.getLength();
        } else {
            Name functionNameNode = topLevelFunction.getName();
            startingNodePos = functionNameNode.getOffset() + functionNameNode.getLength();
        }
        int closingParenPos = this.searchForClosingBracket(startingNodePos, ')', this.fDoc);
        this.calculateStartingEndingPosition(closingParenPos, (Node)topLevelFunction);
        return false;
    }

    public boolean visit(NestedFunction nestedFunction) {
        Object startingNode = null;
        startingNode = nestedFunction.hasReturnType() ? nestedFunction.getReturnType() : nestedFunction.getName();
        int startingNodePos = startingNode.getOffset() + startingNode.getLength();
        int closingParenPos = this.searchForClosingBracket(startingNodePos, ')', this.fDoc);
        this.calculateStartingEndingPosition(closingParenPos, (Node)nestedFunction);
        return false;
    }

    public boolean visit(Service service) {
        Name startingPositionNode = null;
        List implementList = service.getImplementedInterfaces();
        if (implementList != null && !implementList.isEmpty()) {
            int size = implementList.size();
            startingPositionNode = (Name)implementList.get(size - 1);
        } else {
            startingPositionNode = service.getName();
        }
        this.calculateStartingEndingPosition((Node)startingPositionNode, (Node)service);
        return false;
    }

    public boolean visit(Interface interfaceNode) {
        this.calcaulatePartPosition((Part)interfaceNode);
        return false;
    }

    public boolean visit(NestedForm nestedForm) {
        Name startingPositionNode = null;
        startingPositionNode = nestedForm.hasSubType() ? nestedForm.getSubType() : nestedForm.getName();
        this.calculateStartingEndingPosition((Node)startingPositionNode, (Node)nestedForm);
        return false;
    }

    public boolean visit(TryStatement tryStatement) {
        int startingPosition = tryStatement.getOffset() + "try".length();
        List exceptionBlocks = tryStatement.getOnExceptionBlocks();
        return this.visitParentWithChildrenBlock(startingPosition, (Node)tryStatement, exceptionBlocks);
    }

    private boolean visitParentWithChildrenBlock(int startingPosition, Node parentNode, List childBlocks) {
        if (childBlocks != null && !childBlocks.isEmpty()) {
            int parentNodeEndPos = parentNode.getOffset() + parentNode.getLength();
            if (this.cursorOffset == parentNodeEndPos - "end".length()) {
                int size = childBlocks.size();
                Node lastChildBlock = (Node)childBlocks.get(size - 1);
                lastChildBlock.accept((IASTVisitor)this);
            } else {
                Node firstChildBlock = (Node)childBlocks.get(0);
                int blockEndPos = firstChildBlock.getOffset();
                this.calculateStartingEndingPosition(startingPosition, blockEndPos);
            }
        } else {
            this.calculateStartingEndingPosition(startingPosition, parentNode);
        }
        return false;
    }

    private int getOnExceptionBlockStartingPosition(OnExceptionBlock onExceptionBlock) {
        int onExceptionBlockStartingPos = onExceptionBlock.getOffset() + "onException".length();
        if (onExceptionBlock.hasExceptionDeclaration()) {
            Type exceptionType = onExceptionBlock.getExceptionType();
            int exceptionTypePos = exceptionType.getOffset() + exceptionType.getLength();
            onExceptionBlockStartingPos = this.searchForClosingBracket(exceptionTypePos, ')', this.fDoc);
        }
        return onExceptionBlockStartingPos;
    }

    public boolean visit(OnExceptionBlock onExceptionBlock) {
        Node parentNode = onExceptionBlock.getParent();
        if (parentNode instanceof TryStatement) {
            TryStatement tryStatement = (TryStatement)parentNode;
            List exceptionBlocks = tryStatement.getOnExceptionBlocks();
            int startingPosition = this.getOnExceptionBlockStartingPosition(onExceptionBlock);
            this.visitListChildrenBlock((Node)onExceptionBlock, parentNode, exceptionBlocks, startingPosition);
        }
        return false;
    }

    public boolean visit(CaseStatement caseStatement) {
        if (caseStatement.hasCriterion()) {
            Expression expr = caseStatement.getCriterion();
            int exprEndPos = expr.getOffset() + expr.getLength();
            this.calculateStartingEndingPosition(exprEndPos, (Node)caseStatement);
        } else {
            int startingPosition = caseStatement.getOffset() + "case".length();
            this.calculateStartingEndingPosition(startingPosition, (Node)caseStatement);
        }
        return false;
    }

    public boolean visit(IfStatement ifStatement) {
        Expression expr = ifStatement.getCondition();
        int exprEndPos = expr.getOffset() + expr.getLength();
        int blockStartingPos = this.searchForClosingBracket(exprEndPos, ')', this.fDoc);
        if (ifStatement.hasElse()) {
            ElseBlock elseNode = ifStatement.getElse();
            int ifStatementEndPos = ifStatement.getOffset() + ifStatement.getLength();
            if (this.cursorOffset == ifStatementEndPos - "end".length()) {
                elseNode.accept((IASTVisitor)this);
            } else {
                int blockEndingPos = elseNode.getOffset();
                this.calculateStartingEndingPosition(blockStartingPos, blockEndingPos);
            }
        } else {
            this.calculateStartingEndingPosition(blockStartingPos, (Node)ifStatement);
        }
        return false;
    }

    public boolean visit(ElseBlock elseBlock) {
        return this.visitSecondHalfChildBlock((Node)elseBlock, "else".length());
    }

    private boolean visitSecondHalfChildBlock(Node secondHalfNode, int keywordLength) {
        Node parentNode = secondHalfNode.getParent();
        if (this.cursorOffset == secondHalfNode.getOffset()) {
            parentNode.accept((IASTVisitor)this);
        } else {
            int startingPosition = secondHalfNode.getOffset() + keywordLength;
            this.calculateStartingEndingPosition(startingPosition, parentNode);
        }
        return false;
    }

    public boolean visit(WhileStatement whileStatement) {
        Expression expr = whileStatement.getExpr();
        int exprEndPos = expr.getOffset() + expr.getLength();
        int blockStartingPos = this.searchForClosingBracket(exprEndPos, ')', this.fDoc);
        this.calculateStartingEndingPosition(blockStartingPos, (Node)whileStatement);
        return false;
    }

    public boolean visit(ForStatement forStatement) {
        int startSearchRParen = forStatement.getOffset();
        Expression stepExpr = forStatement.getDeltaExpression();
        if (stepExpr != null) {
            startSearchRParen = stepExpr.getOffset() + stepExpr.getLength();
        } else {
            Expression toExpr = forStatement.getEndIndex();
            startSearchRParen = toExpr.getOffset() + toExpr.getLength();
        }
        int blockStartingPos = this.searchForClosingBracket(startSearchRParen, ')', this.fDoc);
        this.calculateStartingEndingPosition(blockStartingPos, (Node)forStatement);
        return false;
    }

    public boolean visit(ForEachStatement forEachStatement) {
        int startSearchRParen = forEachStatement.getClosingParenOffset();
        int blockStartingPos = this.searchForClosingBracket(startSearchRParen, ')', this.fDoc);
        this.calculateStartingEndingPosition(blockStartingPos, (Node)forEachStatement);
        return false;
    }

    public boolean visit(OpenUIStatement openUIStatement) {
        int startingPosition = openUIStatement.getOffset() + "openUI".length();
        List eventBlocks = openUIStatement.getEventBlocks();
        return this.visitParentWithChildrenBlock(startingPosition, (Node)openUIStatement, eventBlocks);
    }

    private int getOnEventBlockStartingPosition(OnEventBlock onEventBlock) {
        int onEventBlockStartingPos = onEventBlock.getOffset() + "onEvent".length();
        if (onEventBlock.hasStringList()) {
            List fields = onEventBlock.getStringList();
            int size = fields.size();
            Node lastField = (Node)fields.get(size - 1);
            int lastFieldEndPos = lastField.getOffset() + lastField.getLength();
            onEventBlockStartingPos = this.searchForClosingBracket(lastFieldEndPos, ')', this.fDoc);
        } else {
            onEventBlockStartingPos = this.searchForClosingBracket(onEventBlockStartingPos, ')', this.fDoc);
        }
        return onEventBlockStartingPos;
    }

    public boolean visit(OnEventBlock onEventBlock) {
        Node parentNode = onEventBlock.getParent();
        if (parentNode instanceof OpenUIStatement) {
            OpenUIStatement openUIStatment = (OpenUIStatement)parentNode;
            List eventBlocks = openUIStatment.getEventBlocks();
            int startingPosition = this.getOnEventBlockStartingPosition(onEventBlock);
            this.visitListChildrenBlock((Node)onEventBlock, parentNode, eventBlocks, startingPosition);
        }
        return false;
    }

    private void visitListChildrenBlock(Node childBlock, Node parentNode, List childBlocks, int startingPosition) {
        int size = childBlocks.size();
        boolean bFnd = false;
        int index = -1;
        int i = 0;
        while (i < size && !bFnd) {
            Node childBlockElement = (Node)childBlocks.get(i);
            if (childBlockElement.getOffset() == childBlock.getOffset()) {
                bFnd = true;
                index = i;
            }
            ++i;
        }
        if (bFnd) {
            if (index == 0 && index == size - 1) {
                if (this.cursorOffset == childBlock.getOffset()) {
                    parentNode.accept((IASTVisitor)this);
                } else {
                    this.calculateStartingEndingPosition(startingPosition, parentNode);
                }
            } else if (index == size - 1) {
                if (this.cursorOffset == childBlock.getOffset()) {
                    Node previousEventBlock = (Node)childBlocks.get(index - 1);
                    previousEventBlock.accept((IASTVisitor)this);
                } else {
                    this.calculateStartingEndingPosition(startingPosition, parentNode);
                }
            } else {
                Node nextChildBlock = (Node)childBlocks.get(index + 1);
                int endingPosition = nextChildBlock.getOffset();
                if (index == 0) {
                    if (this.cursorOffset == childBlock.getOffset()) {
                        parentNode.accept((IASTVisitor)this);
                    } else {
                        this.calculateStartingEndingPosition(startingPosition, endingPosition);
                    }
                } else if (this.cursorOffset == childBlock.getOffset()) {
                    Node previousChildBlock = (Node)childBlocks.get(index - 1);
                    previousChildBlock.accept((IASTVisitor)this);
                } else {
                    this.calculateStartingEndingPosition(startingPosition, endingPosition);
                }
            }
        }
    }
}

