/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.search;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.edt.ide.core.internal.model.BinaryPart;
import org.eclipse.edt.ide.core.internal.utils.Util;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IClassFile;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IMember;
import org.eclipse.edt.ide.ui.internal.editor.EGLEditor;
import org.eclipse.edt.ide.ui.internal.search.EGLEditorOpener;
import org.eclipse.edt.ide.ui.internal.search.EGLSearchMessages;
import org.eclipse.edt.ide.ui.internal.search.EGLSearchResultContentProvider;
import org.eclipse.edt.ide.ui.internal.search.EGLSearchResultLabelProvider;
import org.eclipse.edt.ide.ui.internal.search.EGLSearchResultTableContentProvider;
import org.eclipse.edt.ide.ui.internal.search.EGLSearchResultTreeContentProvider;
import org.eclipse.edt.ide.ui.internal.search.NameSorter;
import org.eclipse.edt.ide.ui.internal.search.PathSorter;
import org.eclipse.edt.ide.ui.internal.search.SortAction;
import org.eclipse.edt.ide.ui.internal.util.EditorUtility;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.IShowInTargetList;

public class EGLSearchResultPage
extends AbstractTextSearchViewPage
implements IAdaptable {
    private static final String KEY_SORTING = "com.etools.egl.ui.search.resultpage.sorting";
    private EGLSearchResultContentProvider fContentProvider;
    private int fCurrentSortOrder;
    private SortAction fSortByNameAction;
    private SortAction fSortByPathAction;
    private EGLEditorOpener fEditorOpener = new EGLEditorOpener();
    private static final String[] SHOW_IN_TARGETS = new String[]{"org.eclipse.ui.views.ResourceNavigator"};
    private static final IShowInTargetList SHOW_IN_TARGET_LIST = new IShowInTargetList(){

        public String[] getShowInTargetIds() {
            return SHOW_IN_TARGETS;
        }
    };

    public EGLSearchResultPage() {
        this.fSortByNameAction = new SortAction(EGLSearchMessages.EGLSearchResultPageSort_nameLabel, this, 2);
        this.fSortByPathAction = new SortAction(EGLSearchMessages.EGLSearchResultPageSort_pathLabel, this, 3);
    }

    public StructuredViewer getViewer() {
        return super.getViewer();
    }

    protected void showMatch(Match match, int offset, int length, boolean activate) throws PartInitException {
        Object matchElement = match.getElement();
        if (matchElement instanceof IFile) {
            IFile file = (IFile)matchElement;
            IEditorPart editor = this.fEditorOpener.open(match);
            if (editor != null && activate) {
                editor.getEditorSite().getPage().activate((IWorkbenchPart)editor);
            }
            if (editor instanceof EGLEditor) {
                EGLEditor textEditor = (EGLEditor)editor;
                textEditor.selectAndReveal(offset, length);
            } else if (editor != null) {
                this.showWithMarker(editor, file, offset, length);
            }
        } else if (matchElement instanceof BinaryPart) {
            IProject project;
            IEGLProject eglProj;
            BinaryPart part = (BinaryPart)matchElement;
            String fullyqualifiedPartName = part.getFullyQualifiedName();
            IFile file = Util.findPartFile((String)fullyqualifiedPartName, (IEGLProject)(eglProj = EGLCore.create((IProject)(project = part.getEGLProject().getProject()))));
            if (file != null && file.exists()) {
                EditorUtility.openClassFile(project, file.getFullPath().toString(), fullyqualifiedPartName, "org.eclipse.edt.BinaryFileEditor");
            } else {
                String filePath = Util.findPartFilePath((String)fullyqualifiedPartName, (IEGLProject)eglProj);
                EditorUtility.openClassFile(project, filePath, fullyqualifiedPartName, "org.eclipse.edt.BinaryFileEditor");
            }
        }
    }

    private void showWithMarker(IEditorPart editor, IFile file, int offset, int length) throws PartInitException {
        try {
            IMarker marker = file.createMarker("org.eclipse.search.searchmarker");
            HashMap<String, Integer> attributes = new HashMap<String, Integer>(4);
            attributes.put("charStart", new Integer(offset));
            attributes.put("charEnd", new Integer(offset + length));
            marker.setAttributes(attributes);
            IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
            marker.delete();
        }
        catch (CoreException e) {
            throw new PartInitException(EGLSearchMessages.EGLSearchResultPageErrorMarker, (Throwable)e);
        }
    }

    protected void elementsChanged(Object[] objects) {
        if (this.fContentProvider != null) {
            this.fContentProvider.elementsChanged(objects);
        }
    }

    protected void clear() {
        if (this.fContentProvider != null) {
            this.fContentProvider.clear();
        }
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        viewer.setUseHashlookup(true);
        viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new EGLSearchResultLabelProvider(this, 1), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        viewer.setContentProvider((IContentProvider)new EGLSearchResultTreeContentProvider((AbstractTreeViewer)viewer));
        this.fContentProvider = (EGLSearchResultContentProvider)viewer.getContentProvider();
    }

    protected void configureTableViewer(TableViewer viewer) {
        viewer.setUseHashlookup(true);
        viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new EGLSearchResultLabelProvider(this, 1), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        viewer.setContentProvider((IContentProvider)new EGLSearchResultTableContentProvider(viewer));
        this.setSortOrder(this.fCurrentSortOrder);
        this.fContentProvider = (EGLSearchResultContentProvider)viewer.getContentProvider();
    }

    protected void fillContextMenu(IMenuManager mgr) {
        super.fillContextMenu(mgr);
        this.addSortActions(mgr);
    }

    private void addSortActions(IMenuManager mgr) {
        if (this.getLayout() != 1) {
            return;
        }
        MenuManager sortMenu = new MenuManager(EGLSearchMessages.EGLSearchResultPageSort_byLabel);
        sortMenu.add((IAction)this.fSortByNameAction);
        sortMenu.add((IAction)this.fSortByPathAction);
        this.fSortByNameAction.setChecked(this.fCurrentSortOrder == this.fSortByNameAction.getSortOrder());
        this.fSortByPathAction.setChecked(this.fCurrentSortOrder == this.fSortByPathAction.getSortOrder());
        mgr.appendToGroup("group.viewerSetup", (IContributionItem)sortMenu);
    }

    public void setSortOrder(int sortOrder) {
        this.fCurrentSortOrder = sortOrder;
        StructuredViewer viewer = this.getViewer();
        DecoratingLabelProvider lpWrapper = (DecoratingLabelProvider)viewer.getLabelProvider();
        ((EGLSearchResultLabelProvider)lpWrapper.getLabelProvider()).setOrder(sortOrder);
        if (sortOrder == 2) {
            viewer.setSorter((ViewerSorter)new NameSorter());
        } else {
            viewer.setSorter((ViewerSorter)new PathSorter());
        }
        this.getSettings().put(KEY_SORTING, this.fCurrentSortOrder);
    }

    public void restoreState(IMemento memento) {
        Integer value;
        super.restoreState(memento);
        try {
            this.fCurrentSortOrder = this.getSettings().getInt(KEY_SORTING);
        }
        catch (NumberFormatException numberFormatException) {
            this.fCurrentSortOrder = this.fSortByNameAction.getSortOrder();
        }
        if (memento != null && (value = memento.getInteger(KEY_SORTING)) != null) {
            this.fCurrentSortOrder = value;
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putInteger(KEY_SORTING, this.fCurrentSortOrder);
    }

    public Object getAdapter(Class adapter) {
        if (IShowInTargetList.class.equals((Object)adapter)) {
            return SHOW_IN_TARGET_LIST;
        }
        return null;
    }

    protected void handleOpen(OpenEvent event) {
        Object firstElement = ((IStructuredSelection)event.getSelection()).getFirstElement();
        if ((firstElement instanceof IEGLFile || firstElement instanceof IClassFile || firstElement instanceof IMember) && this.getDisplayedMatchCount(firstElement) == 0) {
            try {
                this.fEditorOpener.open((Match)firstElement);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            return;
        }
        super.handleOpen(event);
    }
}

