/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.codegen.java;

import java.util.List;
import org.eclipse.edt.mof.EClassifier;
import org.eclipse.edt.mof.EDataType;
import org.eclipse.edt.mof.EFunction;
import org.eclipse.edt.mof.EParameter;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.codegen.api.TemplateContext;
import org.eclipse.edt.mof.codegen.api.TemplateException;
import org.eclipse.edt.mof.codegen.java.MofImplTemplate;

public class EFunctionTemplate
extends MofImplTemplate {
    public void genImpl(EFunction function, TemplateContext ctx, TabbedWriter out) throws TemplateException {
        out.println();
        out.println("@Override");
        this.genFunctionHeader(function, ctx, out);
        out.println(" {");
        out.pushIndent();
        out.println("// TODO: Default generated implementation");
        if (function.getEType() != null) {
            EClassifier eClass = function.getEType().getEClassifier();
            out.print("return ");
            if (eClass instanceof EDataType && !eClass.getName().equals("EList")) {
                Object value = ((EDataType)eClass).getDefaultValue();
                if (value == null) {
                    out.print("null");
                } else {
                    out.print(((EDataType)eClass).getDefaultValue().toString());
                }
            } else {
                out.print("null");
            }
            out.println(';');
        }
        out.popIndent();
        out.println('}');
    }

    public void genInterface(EFunction function, TemplateContext ctx, TabbedWriter out) throws TemplateException {
        out.println();
        this.genFunctionHeader(function, ctx, out);
        out.println(';');
    }

    private void genFunctionHeader(EFunction function, TemplateContext ctx, TabbedWriter out) throws TemplateException {
        out.print("public ");
        out.print(this.getETypeName(function));
        out.print(' ');
        out.print(function.getName());
        out.print('(');
        List<EParameter> parms = function.getEParameters();
        int i = 0;
        while (i < parms.size()) {
            EParameter parm = parms.get(i);
            out.print(this.getETypeName(parm.getEType()));
            out.print(' ');
            out.print(parm.getName());
            if (i < parms.size() - 1) {
                out.print(',');
            }
            ++i;
        }
        out.print(')');
    }
}

