/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.ide;

import eglx.lang.AnyException;
import eglx.lang.SysLib;
import java.lang.reflect.Method;
import org.eclipse.edt.javart.ide.IDEBindingResourceProcessor;
import org.eclipse.edt.javart.ide.IDEResourceLocator;

public class MainProgramLauncher {
    public static final String MAIN_CLASS_ARG = "egl.main.class.name";
    public static final String IDE_PORT_ARG = "egl.ide.port";
    public static final String DD_FILES_ARG = "egl.dd.list";
    public static final String DEFAULT_DD_ARG = "egl.default.dd";

    public static void main(String[] args) throws Exception {
        String defaultDD;
        int idePort;
        String className = System.getProperty(MAIN_CLASS_ARG, null);
        if (className == null || (className = className.trim()).length() == 0) {
            System.err.println("ERROR: program class name not specified during launch. Exiting.");
            return;
        }
        String idePortStr = System.getProperty(IDE_PORT_ARG, null);
        if (idePortStr == null || (idePortStr = idePortStr.trim()).length() == 0) {
            System.err.println("ERROR: IDE port number not specified during launch. Exiting.");
            return;
        }
        try {
            idePort = Integer.parseInt(idePortStr);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("ERROR: IDE port number value \"" + idePortStr + "\" not a number. Exiting.");
            return;
        }
        if (idePort < 0) {
            System.err.println("ERROR: IDE port number \"" + idePortStr + "\" invalid. Exiting.");
            return;
        }
        IDEResourceLocator resourceLocator = new IDEResourceLocator();
        IDEBindingResourceProcessor bindingProcessor = new IDEBindingResourceProcessor(idePort, resourceLocator);
        String ddFiles = System.getProperty(DD_FILES_ARG, null);
        if (ddFiles != null && (ddFiles = ddFiles.trim()).length() != 0) {
            resourceLocator.parseDDArgument(ddFiles, true);
        }
        if ((defaultDD = System.getProperty(DEFAULT_DD_ARG, null)) != null && (defaultDD = defaultDD.trim()).length() > 0) {
            try {
                bindingProcessor.setDefaultDD(defaultDD);
            }
            catch (AnyException ex) {
                ex.printStackTrace();
            }
        }
        SysLib.setBindingResourceProcessor(bindingProcessor);
        Class<?> clazz = Class.forName(className);
        Method method = clazz.getMethod("main", String[].class);
        method.invoke(null, new Object[]{args});
    }
}

