/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource;

import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jpt.common.core.internal.utility.XPointTools;
import org.eclipse.jpt.common.core.resource.ResourceLocator;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jst.common.project.facet.core.internal.FacetedProjectFrameworkJavaPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceLocatorConfig
implements Comparable<ResourceLocatorConfig> {
    public static final String PROJECT_ENABLEMENT_VARIABLE = "project";
    private String id;
    private String pluginId;
    private String className;
    private Priority priority;
    private Expression enablementCondition;

    ResourceLocatorConfig() {
    }

    public String getId() {
        return this.id;
    }

    void setId(String id) {
        this.id = id;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    public String getClassName() {
        return this.className;
    }

    void setClassName(String className) {
        this.className = className;
    }

    public Priority getPriority() {
        return this.priority;
    }

    void setPriority(Priority priority) {
        this.priority = priority;
    }

    public Expression getEnablementCondition() {
        return this.enablementCondition;
    }

    void setEnablementCondition(Expression enablementCondition) {
        this.enablementCondition = enablementCondition;
    }

    public ResourceLocator getResourceLocator() {
        return XPointTools.instantiate(this.pluginId, "org.eclipse.jpt.common.core.resourceLocators", this.className, ResourceLocator.class);
    }

    public boolean isEnabledFor(IProject project) {
        EvaluationContext evalContext = new EvaluationContext(null, (Object)project);
        evalContext.setAllowPluginActivation(true);
        evalContext.addVariable(PROJECT_ENABLEMENT_VARIABLE, (Object)project);
        if (this.enablementCondition != null) {
            try {
                EvaluationResult evalResult = this.enablementCondition.evaluate((IEvaluationContext)evalContext);
                if (evalResult == EvaluationResult.FALSE) {
                    return false;
                }
            }
            catch (CoreException e) {
                FacetedProjectFrameworkJavaPlugin.log((Exception)((Object)e));
            }
        }
        return true;
    }

    @Override
    public int compareTo(ResourceLocatorConfig other) {
        return Priority.compare(this.priority, other.priority);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Priority {
        LOWEST(6, "lowest"),
        LOWER(5, "lower"),
        LOW(4, "low"),
        NORMAL(3, "normal"),
        HIGH(2, "high"),
        HIGHER(1, "higher"),
        HIGHEST(0, "highest");

        private Integer value;
        private String literal;

        public static int compare(Priority priority1, Priority priority2) {
            return priority1.value.compareTo(priority2.value);
        }

        public static Priority get(String literal) {
            if (literal == null) {
                return NORMAL;
            }
            Priority[] priorityArray = Priority.values();
            int n = priorityArray.length;
            int n2 = 0;
            while (n2 < n) {
                Priority priority = priorityArray[n2];
                if (StringTools.stringsAreEqual((String)literal, (String)priority.literal)) {
                    return priority;
                }
                ++n2;
            }
            return null;
        }

        private Priority(int value, String literal) {
            this.value = value;
            this.literal = literal;
        }

        public String toString() {
            return this.literal;
        }
    }
}

