/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa2.context.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaCacheable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaCacheableHolder2_0;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.Cacheable2_0Annotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;

public class GenericJavaCacheable2_0
extends AbstractJavaJpaContextNode
implements JavaCacheable2_0 {
    protected Boolean specifiedCacheable = this.buildSpecifiedCacheable();
    protected boolean defaultCacheable;

    public GenericJavaCacheable2_0(JavaCacheableHolder2_0 parent) {
        super(parent);
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedCacheable_(this.buildSpecifiedCacheable());
    }

    public void update() {
        super.update();
        this.setDefaultCacheable(this.buildDefaultCacheable());
    }

    public boolean isCacheable() {
        return this.specifiedCacheable != null ? this.specifiedCacheable : this.defaultCacheable;
    }

    public Boolean getSpecifiedCacheable() {
        return this.specifiedCacheable;
    }

    public void setSpecifiedCacheable(Boolean cacheable) {
        if (this.valuesAreDifferent(cacheable, this.specifiedCacheable)) {
            if (cacheable == null) {
                this.removeCacheableAnnotation();
            } else {
                Cacheable2_0Annotation annotation = this.getCacheableAnnotationForUpdate();
                Boolean value = annotation.getValue();
                if (cacheable.booleanValue()) {
                    if (value != null && !value.booleanValue()) {
                        annotation.setValue(null);
                    }
                } else {
                    annotation.setValue(Boolean.FALSE);
                }
            }
            this.setSpecifiedCacheable_(cacheable);
        }
    }

    protected void setSpecifiedCacheable_(Boolean cacheable) {
        Boolean old = this.specifiedCacheable;
        this.specifiedCacheable = cacheable;
        this.firePropertyChanged("specifiedCacheable", old, cacheable);
    }

    private Boolean buildSpecifiedCacheable() {
        Cacheable2_0Annotation annotation = this.getCacheableAnnotation();
        if (annotation == null) {
            return null;
        }
        Boolean value = annotation.getValue();
        return value != null ? value : Boolean.TRUE;
    }

    public boolean isDefaultCacheable() {
        return this.defaultCacheable;
    }

    protected void setDefaultCacheable(boolean cacheable) {
        boolean old = this.defaultCacheable;
        this.defaultCacheable = cacheable;
        this.firePropertyChanged("defaultCacheable", old, cacheable);
    }

    protected boolean buildDefaultCacheable() {
        return this.getCacheableHolder().calculateDefaultCacheable();
    }

    protected Cacheable2_0Annotation getCacheableAnnotation() {
        return (Cacheable2_0Annotation)this.getResourcePersistentType().getAnnotation(this.getCacheableAnnotationName());
    }

    protected Cacheable2_0Annotation getCacheableAnnotationForUpdate() {
        Cacheable2_0Annotation annotation = this.getCacheableAnnotation();
        return annotation != null ? annotation : this.buildCacheableAnnotation();
    }

    protected Cacheable2_0Annotation buildCacheableAnnotation() {
        return (Cacheable2_0Annotation)this.getResourcePersistentType().addAnnotation(this.getCacheableAnnotationName());
    }

    protected void removeCacheableAnnotation() {
        this.getResourcePersistentType().removeAnnotation(this.getCacheableAnnotationName());
    }

    protected String getCacheableAnnotationName() {
        return "javax.persistence.Cacheable";
    }

    public JavaCacheableHolder2_0 getParent() {
        return (JavaCacheableHolder2_0)super.getParent();
    }

    protected JavaCacheableHolder2_0 getCacheableHolder() {
        return this.getParent();
    }

    protected JavaResourcePersistentType getResourcePersistentType() {
        return this.getCacheableHolder().getResourcePersistentType();
    }

    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.getAnnotationTextRange(astRoot);
        return textRange != null ? textRange : this.getCacheableHolder().getValidationTextRange(astRoot);
    }

    protected TextRange getAnnotationTextRange(CompilationUnit astRoot) {
        Cacheable2_0Annotation annotation = this.getCacheableAnnotation();
        return annotation == null ? null : annotation.getTextRange(astRoot);
    }
}

