/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal.xml.server32;

import java.net.URLEncoder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.tomcat.core.internal.Messages;
import org.eclipse.jst.server.tomcat.core.internal.xml.server32.Connector;
import org.eclipse.jst.server.tomcat.core.internal.xml.server32.Context;
import org.eclipse.jst.server.tomcat.core.internal.xml.server32.ContextManager;
import org.eclipse.jst.server.tomcat.core.internal.xml.server32.Server;
import org.eclipse.osgi.util.NLS;

public class ServerInstance {
    protected Server server;
    protected ContextManager contextManager;
    protected IStatus status = Status.OK_STATUS;

    public ServerInstance(Server server) {
        if (server == null) {
            throw new IllegalArgumentException("Server argument may not be null.");
        }
        this.server = server;
    }

    public IStatus getStatus() {
        return this.status;
    }

    public ContextManager getContextManager() {
        this.status = Status.OK_STATUS;
        if (this.contextManager == null) {
            this.contextManager = this.server.getContextManager();
        }
        return this.contextManager;
    }

    public Connector getConnector(int index) {
        this.status = Status.OK_STATUS;
        if (this.contextManager == null && this.getContextManager() == null) {
            return null;
        }
        return this.contextManager.getConnector(index);
    }

    public Connector[] getConnectors() {
        this.status = Status.OK_STATUS;
        if (this.contextManager == null && this.getContextManager() == null) {
            return null;
        }
        int size = this.contextManager.getConnectorCount();
        Connector[] connectors = new Connector[size];
        int i = 0;
        while (i < size) {
            connectors[i] = this.contextManager.getConnector(i);
            ++i;
        }
        return connectors;
    }

    public Context getContext(String contextPath) {
        this.status = Status.OK_STATUS;
        if (this.contextManager == null && this.getContextManager() == null) {
            return null;
        }
        if (contextPath != null && contextPath.length() > 0 && !contextPath.startsWith("/")) {
            contextPath = "/" + contextPath;
        }
        int size = this.contextManager.getContextCount();
        int i = 0;
        while (i < size) {
            Context ctx = this.contextManager.getContext(i);
            if (ctx.getPath().equals(contextPath)) {
                return ctx;
            }
            ++i;
        }
        this.status = new Status(4, "org.eclipse.jst.server.tomcat.core", NLS.bind((String)Messages.errorXMLContextNotFoundPath32, (Object)contextPath));
        return null;
    }

    public Context getContext(int index) {
        this.status = Status.OK_STATUS;
        if (this.contextManager == null && this.getContextManager() == null) {
            return null;
        }
        return this.contextManager.getContext(index);
    }

    public Context[] getContexts() {
        this.status = Status.OK_STATUS;
        if (this.contextManager == null && this.getContextManager() == null) {
            return null;
        }
        int size = this.contextManager.getContextCount();
        Context[] contexts = new Context[size];
        int i = 0;
        while (i < size) {
            contexts[i] = this.contextManager.getContext(i);
            ++i;
        }
        return contexts;
    }

    public Context createContext(int index) {
        this.status = Status.OK_STATUS;
        if (this.contextManager == null && this.getContextManager() == null) {
            return null;
        }
        return (Context)this.contextManager.createElement(index, "Context");
    }

    public boolean removeContext(String contextPath) {
        this.status = Status.OK_STATUS;
        if (this.contextManager == null && this.getContextManager() == null) {
            return false;
        }
        if (contextPath != null && contextPath.length() > 0 && !contextPath.startsWith("/")) {
            contextPath = "/" + contextPath;
        }
        int size = this.contextManager.getContextCount();
        int i = 0;
        while (i < size) {
            Context ctx = this.contextManager.getContext(i);
            if (ctx.getPath().equals(contextPath)) {
                this.contextManager.removeElement("Context", i);
                return true;
            }
            ++i;
        }
        this.status = new Status(4, "org.eclipse.jst.server.tomcat.core", NLS.bind((String)Messages.errorXMLContextNotFoundPath32, (Object)contextPath));
        return false;
    }

    public boolean removeContext(int index) {
        this.status = Status.OK_STATUS;
        if (this.contextManager == null && this.getContextManager() == null) {
            return false;
        }
        return this.contextManager.removeElement("Context", index);
    }

    public IPath getContextWorkDirectory(IPath basePath, Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Context argument may not be null.");
        }
        this.status = Status.OK_STATUS;
        if (this.contextManager == null && this.getContextManager() == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        String workDir = this.contextManager.getWorkDir();
        if (workDir == null) {
            workDir = "work";
        }
        sb.append(workDir);
        sb.append("/");
        String hostName = this.contextManager.getAttributeValue("hostName");
        if (hostName == null) {
            hostName = "localhost";
        }
        sb.append(hostName);
        sb.append("_");
        String legacyPort = this.contextManager.getAttributeValue("port");
        if (legacyPort == null) {
            legacyPort = "8080";
        }
        sb.append(legacyPort);
        sb.append(URLEncoder.encode(context.getPath()));
        Path workPath = new Path(sb.toString());
        if (!workPath.isAbsolute()) {
            if (basePath == null) {
                basePath = new Path("");
            }
            workPath = basePath.append((IPath)workPath);
        }
        return workPath;
    }

    public IPath getServerWorkDirectory(IPath basePath) {
        Path workPath;
        this.status = Status.OK_STATUS;
        if (this.contextManager == null && this.getContextManager() == null) {
            return null;
        }
        String workDir = this.contextManager.getWorkDir();
        if (workDir == null) {
            workDir = "work";
        }
        if (!(workPath = new Path(workDir)).isAbsolute()) {
            if (basePath == null) {
                basePath = new Path("");
            }
            workPath = basePath.append((IPath)workPath);
        }
        return workPath;
    }
}

