/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.isite.ISite;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class MirrorsSection
extends PDESection {
    private FormEntry fMirrorsURLEntry;

    public MirrorsSection(PDEFormPage page, Composite parent) {
        super(page, parent, 130);
        this.getSection().setText(PDEUIMessages.SiteEditor_MirrorsSection_header);
        this.getSection().setDescription(PDEUIMessages.SiteEditor_MirrorsSection_desc);
        this.createClient(this.getSection(), page.getManagedForm().getToolkit());
    }

    public void commit(boolean onSave) {
        this.fMirrorsURLEntry.commit();
        super.commit(onSave);
    }

    public void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        Composite container = toolkit.createComposite((Composite)section);
        container.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 2));
        GridData data = new GridData(768);
        container.setLayoutData((Object)data);
        data = new GridData(768);
        data.widthHint = 200;
        section.setLayoutData((Object)data);
        this.fMirrorsURLEntry = new FormEntry(container, toolkit, PDEUIMessages.SiteEditor_MirrorsSection_urlLabel, null, false);
        this.fMirrorsURLEntry.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry text) {
                MirrorsSection.this.setMirrorsURL(text.getValue());
            }
        });
        this.fMirrorsURLEntry.setEditable(this.isEditable());
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        this.initialize();
    }

    private void setMirrorsURL(String text) {
        ISiteModel model = (ISiteModel)this.getPage().getModel();
        ISite site = model.getSite();
        try {
            site.setMirrorsURL(text);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    public void dispose() {
        ISiteModel model = (ISiteModel)this.getPage().getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public void initialize() {
        ISiteModel model = (ISiteModel)this.getPage().getModel();
        this.refresh();
        model.addModelChangedListener((IModelChangedListener)this);
    }

    public void modelChanged(IModelChangedEvent e) {
        this.markStale();
    }

    public void setFocus() {
        if (this.fMirrorsURLEntry != null) {
            this.fMirrorsURLEntry.getText().setFocus();
        }
    }

    private void setIfDefined(FormEntry formText, String value) {
        if (value != null) {
            formText.setValue(value, true);
        }
    }

    public void refresh() {
        ISiteModel model = (ISiteModel)this.getPage().getModel();
        ISite site = model.getSite();
        this.setIfDefined(this.fMirrorsURLEntry, site.getMirrorsURL());
        super.refresh();
    }

    public void cancelEdit() {
        this.fMirrorsURLEntry.cancelEdit();
        super.cancelEdit();
    }

    public boolean canPaste(Clipboard clipboard) {
        TransferData[] types = clipboard.getAvailableTypes();
        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance(), RTFTransfer.getInstance()};
        int i = 0;
        while (i < types.length) {
            int j = 0;
            while (j < transfers.length) {
                if (transfers[j].isSupportedType(types[i])) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }
}

