/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.db;

import java.util.Properties;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.OdaDesignSession;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.AdaptableDataSourceProfile;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.ProfileSelectionEditorPage;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.db.DbProfilePageWrapper;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.db.DbProfileUtil;
import org.eclipse.datatools.connectivity.oda.design.ui.nls.Messages;
import org.eclipse.datatools.connectivity.oda.design.ui.pages.impl.DefaultDataSourcePropertyPage;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSourceEditorPage;
import org.eclipse.datatools.connectivity.oda.profile.internal.OdaConnectionProfile;
import org.eclipse.datatools.connectivity.oda.profile.internal.OdaProfileFactory;
import org.eclipse.datatools.connectivity.ui.wizards.ProfilePropertyPage;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.widgets.Composite;

public class DbProfilePropertyPage
extends DataSourceEditorPage {
    private DbProfilePageWrapper m_pageHelper = null;
    private ProfileSelectionEditorPage.IUpdateDesignTask m_profileUpdateDesignTask;
    private boolean m_canEditProps = true;

    protected void createAndInitCustomControl(Composite parent, Properties profileProps) {
        if (this.m_pageHelper == null) {
            this.m_pageHelper = this.createDbProfilePageWrapper();
        }
        if (this.m_pageHelper != null) {
            try {
                this.m_pageHelper.createCustomControl(parent, !this.isSessionEditable());
            }
            catch (OdaException e) {
                e.printStackTrace();
            }
            this.m_pageHelper.initCustomControl(profileProps);
        } else {
            DataSourceEditorPage odaDefaultPage = this.createDefaultPropertyPage(profileProps);
            odaDefaultPage.createControl(parent);
            this.m_pageHelper = new DbProfilePageWrapper(this, (ProfilePropertyPage)odaDefaultPage);
        }
        this.setPingButtonVisible(false);
    }

    protected DbProfilePageWrapper createDbProfilePageWrapper() {
        IConnectionProfile pageProfile;
        IConnectionProfile customDbPropPageProfile = pageProfile = this.getConnectionProfile();
        if (!this.hasLinkedProfileInPageElement() && !this.getEditingDataSource().hasLinkToProfile()) {
            Properties pageProps = pageProfile.getBaseProperties();
            if (DbProfilePropertyPage.hasMinimumProperties(pageProps)) {
                customDbPropPageProfile = this.createTransientProfile(pageProps);
            } else {
                this.m_canEditProps = false;
            }
        }
        if (customDbPropPageProfile == null) {
            return null;
        }
        OdaConnectionProfile customPageOdaDbProfile = customDbPropPageProfile instanceof OdaConnectionProfile ? (OdaConnectionProfile)customDbPropPageProfile : new OdaConnectionProfile(customDbPropPageProfile);
        ProfilePropertyPage customDbPropPage = DbProfileUtil.createDbPropertyPage(customPageOdaDbProfile, this.getOdaDataSourceId());
        if (customDbPropPage == null) {
            return null;
        }
        String pageMsg = this.m_canEditProps && this.isSessionEditable() ? Messages.dbProfilePage_editPageMessage : DbProfilePageWrapper.DEFAULT_MESSAGE;
        this.setMessage(pageMsg);
        return new DbProfilePageWrapper(this, customDbPropPage);
    }

    protected IConnectionProfile createTransientProfile(Properties connProperties) {
        try {
            return OdaProfileFactory.createTransientProfile((Properties)connProperties);
        }
        catch (OdaException odaException) {
            return null;
        }
    }

    protected void cleanup() {
        super.cleanup();
        if (this.m_pageHelper == null) {
            return;
        }
        this.m_pageHelper.cleanup();
    }

    private DataSourceEditorPage createDefaultPropertyPage(Properties profileProps) {
        DefaultDataSourcePropertyPage defaultPropPage = new DefaultDataSourcePropertyPage();
        String errorMessage = this.isInOdaDesignSession() ? (this.m_canEditProps ? Messages.dbProfilePage_noCustomPage : Messages.dbProfilePage_invalidDataSource) : Messages.dbProfilePage_notInDesignSession;
        OdaDesignSession requestSession = this.getDesignSession();
        if (requestSession.getRequestDataSourceDesign() != null && !requestSession.getRequestDataSourceDesign().hasLinkToProfile()) {
            requestSession = (OdaDesignSession)EcoreUtil.copy((EObject)requestSession);
            DataSourceDesign localRequestDesign = requestSession.getRequestDataSourceDesign();
            try {
                super.setDataSourceDesignProperties(localRequestDesign, profileProps);
            }
            catch (OdaException ex) {
                errorMessage = String.valueOf(errorMessage) + "\n";
                errorMessage = String.valueOf(errorMessage) + ex.toString();
            }
        }
        try {
            defaultPropPage.initEditSession(requestSession);
        }
        catch (OdaException ex) {
            errorMessage = String.valueOf(errorMessage) + "\n";
            errorMessage = String.valueOf(errorMessage) + ex.toString();
        }
        int messageType = this.m_canEditProps ? 2 : 3;
        this.setMessage(errorMessage, messageType);
        if (!this.m_canEditProps) {
            defaultPropPage.setPingButtonEnabled(false);
        }
        return defaultPropPage;
    }

    protected DbProfilePageWrapper getPageHelper() {
        return this.m_pageHelper;
    }

    public String getErrorMessage() {
        return this.m_pageHelper != null ? this.m_pageHelper.getErrorMessage() : super.getErrorMessage();
    }

    protected void refresh(Properties customConnectionProps) {
    }

    public Properties collectCustomProperties(Properties profileProps) {
        if (this.m_pageHelper == null) {
            return profileProps;
        }
        Properties dbProfileProps = this.m_pageHelper.collectCustomProperties(this.isSessionEditable());
        DbProfileUtil.setDbProviderIdInProperties(dbProfileProps, this.getDbProfileProviderId());
        return dbProfileProps;
    }

    String getDbProfileProviderId() {
        if (this.m_pageHelper == null) {
            return null;
        }
        return this.m_pageHelper.getDbProfileProviderId();
    }

    private boolean hasLinkedProfileInPageElement() {
        AdaptableDataSourceProfile pageProfile = this.getProfileElement();
        return pageProfile != null && pageProfile.hasLinkedProfile();
    }

    private static boolean hasMinimumProperties(Properties props) {
        return props.getProperty("org.eclipse.datatools.connectivity.driverDefinitionID") != null;
    }

    protected boolean isEditingExternalProfile() {
        return this.hasLinkedProfileInPageElement();
    }

    protected void setDataSourceDesignProperties(DataSourceDesign design, Properties propertyValuePairs) throws OdaException {
        if (this.getUpdateDesignTask().requiresExternalProfile()) {
            DbProfileUtil.updateDataSourceDesignExternalProfileProvider(design, propertyValuePairs);
        } else {
            super.setDataSourceDesignProperties(design, propertyValuePairs);
        }
    }

    public void initProfileSelectionEditSession(ProfileSelectionEditorPage profileSelectionPage) {
        if (profileSelectionPage == null) {
            return;
        }
        profileSelectionPage.delegatesTask(this.getProfileSelectionUpdateDesignTask());
    }

    private ProfileSelectionEditorPage.IUpdateDesignTask getProfileSelectionUpdateDesignTask() {
        if (this.m_profileUpdateDesignTask == null) {
            this.m_profileUpdateDesignTask = new UpdateDesignTask();
        }
        return this.m_profileUpdateDesignTask;
    }

    private UpdateDesignTask getUpdateDesignTask() {
        return (UpdateDesignTask)this.getProfileSelectionUpdateDesignTask();
    }

    class UpdateDesignTask
    implements ProfileSelectionEditorPage.IUpdateDesignTask {
        private ProfileSelectionEditorPage m_delegator;

        UpdateDesignTask() {
        }

        public DataSourceDesign collectDataSourceDesign(DataSourceDesign design, ProfileSelectionEditorPage delegator, IConnectionProfile selectedConnProfile) throws OdaException {
            if (selectedConnProfile == null) {
                return design;
            }
            this.m_delegator = delegator;
            Properties customProps = this.collectCustomProperties(selectedConnProfile);
            DbProfilePropertyPage.this.setDataSourceDesignProperties(design, customProps);
            this.m_delegator = null;
            return design;
        }

        private Properties collectCustomProperties(IConnectionProfile selectedConnProfile) {
            Properties customProps = selectedConnProfile.getBaseProperties();
            String dbProfileProviderId = this.getDbProfileProviderId(selectedConnProfile);
            DbProfileUtil.setDbProviderIdInProperties(customProps, dbProfileProviderId);
            return customProps;
        }

        private String getDbProfileProviderId(IConnectionProfile connProfile) {
            if (connProfile instanceof OdaConnectionProfile) {
                return ((OdaConnectionProfile)connProfile).getDirectProviderId();
            }
            return null;
        }

        private boolean requiresExternalProfile() {
            if (this.m_delegator == null) {
                return false;
            }
            return this.m_delegator.requiresExternalProfileLink();
        }
    }
}

