/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.java.templates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.gen.java.CommonUtilities;
import org.eclipse.edt.gen.java.Context;
import org.eclipse.edt.gen.java.templates.JavaTemplate;
import org.eclipse.edt.javart.util.JavaAliaser;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.IRUtils;

public class PartTemplate
extends JavaTemplate {
    IRUtils utils = new IRUtils();

    public void preGenPart(Part part, Context ctx) {
        ctx.putAttribute(ctx.getClass(), "partDataTablesUsed", new ArrayList());
        ctx.putAttribute(ctx.getClass(), "partFormsUsed", new ArrayList());
        ctx.putAttribute(ctx.getClass(), "partLibrariesUsed", new ArrayList());
        ctx.putAttribute(ctx.getClass(), "partRecordsUsed", new ArrayList());
        ctx.putAttribute(ctx.getClass(), "partTypesImported", new ArrayList());
        ctx.invoke("preGenPartImport", (Type)part, new Object[]{ctx});
        ctx.invoke("preGenClassBody", (Type)part, new Object[]{ctx});
    }

    public void preGenPartImport(Part part, Context ctx) {
        List typesImported = (List)ctx.getAttribute(ctx.getClass(), "partTypesImported");
        if (!typesImported.contains("org.eclipse.edt.javart.resources.*")) {
            typesImported.add("org.eclipse.edt.javart.resources.*");
        }
        if (!typesImported.contains("org.eclipse.edt.javart.*")) {
            typesImported.add("org.eclipse.edt.javart.*");
        }
    }

    public void genPart(Part part, Context ctx, TabbedWriter out) {
        ctx.invoke("genPackageStatement", (Type)part, new Object[]{ctx, out});
        ctx.invoke("genImports", (Type)part, new Object[]{ctx, out});
        ctx.invoke("genClassHeader", (Type)part, new Object[]{ctx, out});
        ctx.invoke("genClassBody", (Type)part, new Object[]{ctx, out});
        out.println("}");
    }

    public void genPackageStatement(Part part, Context ctx, TabbedWriter out) {
        String packageName = CommonUtilities.packageName((Part)part);
        if (packageName != null && packageName.length() > 0) {
            out.print("package ");
            out.print(packageName);
            out.println(";");
        }
    }

    public void genImports(Part part, Context ctx, TabbedWriter out) {
        List typesImported = (List)ctx.getAttribute(ctx.getClass(), "partTypesImported");
        for (String imported : typesImported) {
            if (imported.indexOf("[") >= 0) {
                imported = imported.substring(0, imported.indexOf("["));
            }
            if (imported.indexOf("<") >= 0) {
                imported = imported.substring(0, imported.indexOf("<"));
            }
            if (imported.startsWith(".")) continue;
            int lastDot = imported.lastIndexOf(46);
            String type = lastDot == -1 ? JavaAliaser.getAlias((String)imported) : (imported.startsWith("java.lang.") ? imported : String.valueOf(imported.substring(0, lastDot)) + '.' + JavaAliaser.getAlias((String)imported.substring(lastDot + 1)));
            out.println("import " + type + ";");
        }
        out.println("@SuppressWarnings(\"unused\")");
    }

    public void genPartName(Part part, Context ctx, TabbedWriter out) {
        if (ctx.mapsToNativeType((Type)part)) {
            out.print(ctx.getNativeImplementationMapping((Type)part));
        } else {
            String value = part.getClassifier().getTypeSignature();
            List typesImported = (List)ctx.getAttribute(ctx.getClass(), "partTypesImported");
            for (String imported : typesImported) {
                if (!value.equalsIgnoreCase(imported) || value.indexOf(46) < 0) continue;
                out.print(CommonUtilities.classAlias((Part)part));
                return;
            }
            out.print(CommonUtilities.fullClassAlias((Part)part));
        }
    }

    public void genClassName(Part part, Context ctx, TabbedWriter out) {
        out.print(JavaAliaser.getAlias((String)part.getId()));
    }

    public void genSuperClass(Part part, Context ctx, TabbedWriter out) {
        ctx.invoke("genSuperClass", (Type)part, new Object[]{ctx, out});
    }

    public void genSerialVersionUID(Part part, Context ctx, TabbedWriter out) {
        out.println("private static final long serialVersionUID = 10L;");
    }
}

