/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.java.templates;

import java.util.List;
import org.eclipse.edt.gen.EglContext;
import org.eclipse.edt.gen.ReorganizeCode;
import org.eclipse.edt.gen.java.Context;
import org.eclipse.edt.gen.java.templates.JavaTemplate;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.codegen.api.TemplateContext;
import org.eclipse.edt.mof.egl.Statement;
import org.eclipse.edt.mof.egl.StatementBlock;
import org.eclipse.edt.mof.egl.utils.IRUtils;

public class StatementBlockTemplate
extends JavaTemplate {
    public void preGen(StatementBlock block, Context ctx) {
        for (Statement stmt : block.getStatements()) {
            ctx.invoke("preGen", (EObject)stmt, new Object[]{ctx});
        }
    }

    public void genStatementBody(StatementBlock block, Context ctx, TabbedWriter out) {
        out.println("{");
        this.processStatements(block, ctx, out);
        out.println("}");
    }

    public void genStatementBodyNoBraces(StatementBlock block, Context ctx, TabbedWriter out) {
        this.processStatements(block, ctx, out);
    }

    public void genStatementEnd(StatementBlock block, Context ctx, TabbedWriter out) {
    }

    protected void processStatements(StatementBlock block, Context ctx, TabbedWriter out) {
        ctx.setCurrentFile(IRUtils.getQualifiedFileName((EObject)block));
        for (Statement stmt : block.getStatements()) {
            ctx.adjustSmapStatementLevel(1);
            ReorganizeCode reorganizeCode = new ReorganizeCode();
            List blockArray = reorganizeCode.reorgCode(stmt, (EglContext)ctx);
            if (blockArray != null && blockArray.get(0) != null) {
                ctx.invoke("genStatementNoBraces", (Statement)blockArray.get(0), (TemplateContext)ctx, out);
            }
            ctx.invoke("genStatement", stmt, (TemplateContext)ctx, out);
            if (blockArray != null && blockArray.get(1) != null) {
                ctx.invoke("genStatementNoBraces", (Statement)blockArray.get(1), (TemplateContext)ctx, out);
            }
            ctx.adjustSmapStatementLevel(-1);
            if (ctx.getSmapStatementLevel() != 0) continue;
            ctx.writeSmapLine();
        }
    }
}

