/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.javascript.templates.eglx.services.annotations;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.edt.gen.javascript.Context;
import org.eclipse.edt.gen.javascript.templates.JavaScriptTemplate;
import org.eclipse.edt.gen.javascript.templates.eglx.services.CommonUtilities;
import org.eclipse.edt.gen.javascript.templates.eglx.services.Constants;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.AnnotationType;
import org.eclipse.edt.mof.egl.EnumerationEntry;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.ParameterKind;
import org.eclipse.edt.mof.egl.Type;

public abstract class RestBase
extends JavaScriptTemplate
implements Constants {
    protected void genUsing(Annotation rest, Context ctx, TabbedWriter out) {
        out.print("ezeHttp");
    }

    protected abstract void genRuntimeInvocationFunctionName(TabbedWriter var1);

    public void genRestInvocation(AnnotationType type, Context ctx, TabbedWriter out, Annotation rest, Function function) {
        out.print("egl.eglx.rest.");
        this.genRuntimeInvocationFunctionName(out);
        out.print("(egl.eglx.rest.configHttp(");
        this.genUsing(rest, ctx, out);
        out.println(",");
        out.pushIndent();
        out.pushIndent();
        Map<String, RestArgument> mapFuncParams = this.getRestArguments(function);
        this.genRequestConfig(rest, mapFuncParams, function, ctx, out);
        this.genResponseConfig(rest, function, ctx, out);
        out.println("),");
        this.genAnnotationSpecificOptions(function, rest, mapFuncParams, ctx, out);
        this.genInParamVals(rest, function, ctx, out);
        this.genInParamSignature(function, ctx, out);
        this.genParamOrders(function, ctx, out);
        this.genCallbackArgs(function, ctx, out);
        this.genCallbackDelegate(rest, ctx, out);
        out.print(", ");
        this.genErrorCallbackDelegate(rest, ctx, out);
        out.println(");");
        out.popIndent();
        out.popIndent();
    }

    protected abstract void genAnnotationSpecificOptions(Function var1, Annotation var2, Map<String, RestArgument> var3, Context var4, TabbedWriter var5);

    protected void genCallbackDelegate(Annotation rest, Context ctx, TabbedWriter out) {
        out.print("ezeCallbackDelegate");
    }

    protected void genErrorCallbackDelegate(Annotation rest, Context ctx, TabbedWriter out) {
        out.print("ezeErrorCallbackDelegate");
    }

    protected Map<String, RestArgument> getRestArguments(Function function) {
        Hashtable<String, RestArgument> mapFuncParams = new Hashtable<String, RestArgument>();
        int idx = 0;
        while (idx < function.getParameters().size()) {
            FunctionParameter param = (FunctionParameter)function.getParameters().get(idx);
            mapFuncParams.put(param.getId().toLowerCase(), new RestArgument(param, idx));
            ++idx;
        }
        return mapFuncParams;
    }

    private void genInParamSignature(Function function, Context ctx, TabbedWriter out) {
        out.print("[");
        boolean isFirst = true;
        for (FunctionParameter param : function.getParameters()) {
            if (param.getParameterKind() == ParameterKind.PARM_OUT) continue;
            if (!isFirst) {
                out.print(", ");
            }
            out.print("\"");
            ctx.invoke("genRuntimeTypeName", param.getType(), new Object[]{ctx, out, JavaScriptTemplate.TypeNameKind.EGLImplementation});
            out.print("\"");
            isFirst = false;
        }
        out.println("], ");
    }

    protected void genInParamVals(Annotation rest, Function function, Context ctx, TabbedWriter out) {
        out.print("[");
        boolean isFirst = true;
        int idx = 0;
        while (idx < function.getParameters().size()) {
            FunctionParameter parameter = (FunctionParameter)function.getParameters().get(idx);
            if (parameter.getParameterKind() != ParameterKind.PARM_OUT) {
                if (!isFirst) {
                    out.print(", ");
                }
                isFirst = false;
                ctx.invoke("genServiceInvocationInParam", parameter.getType(), new Object[]{ctx, out, this.getInParamVal(rest, function, idx, ctx)});
            }
            ++idx;
        }
        out.println("], ");
    }

    protected Expression getInParamVal(Annotation rest, Function function, int idx, Context ctx) {
        return CommonUtilities.createMember((FunctionParameter)function.getParameters().get(idx), ctx);
    }

    private void genRequestConfig(Annotation rest, Map<String, RestArgument> mapFuncParams, Function function, Context ctx, TabbedWriter out) {
        out.print("{");
        out.print(" method : ");
        this.genMethodValue(rest, ctx, out);
        out.print(", uri : ");
        this.genURITemplate(rest, false, mapFuncParams, ctx, out);
        out.println(",");
        out.print(" encoding : ");
        this.genRequestEncodingValue(rest, mapFuncParams, ctx, out);
        out.print(", charset : ");
        this.printQuotedString((String)rest.getValue("requestCharset"), out);
        out.print(", contentType : ");
        this.printQuotedString((String)rest.getValue("requestContentType"), out);
        out.println("},");
    }

    protected void genMethodValue(Annotation rest, Context ctx, TabbedWriter out) {
        ctx.invoke("genRuntimeTypeName", rest.getValue("method"), new Object[]{ctx, out});
    }

    protected void genRequestEncodingValue(Annotation rest, Map<String, RestArgument> mapFuncParams, Context ctx, TabbedWriter out) {
        RestArgument resourceRestArg = this.getResourceArg(mapFuncParams);
        this.genFormatKind(rest.getValue("requestFormat"), resourceRestArg != null ? resourceRestArg.getParam().getType() : null, ctx, out);
    }

    protected RestArgument getResourceArg(Map<String, RestArgument> mapFuncParams) {
        RestArgument resourceRestArg = null;
        Iterator<RestArgument> it = mapFuncParams.values().iterator();
        while (it.hasNext() && resourceRestArg == null) {
            RestArgument restArg = it.next();
            if (!restArg.isResourceArg()) continue;
            resourceRestArg = restArg;
        }
        return resourceRestArg;
    }

    protected void genResponseEncodingValue(Annotation rest, Function function, Context ctx, TabbedWriter out) {
        this.genFormatKind(rest.getValue("responseFormat"), function.getReturnType(), ctx, out);
    }

    private void genResponseConfig(Annotation rest, Function function, Context ctx, TabbedWriter out) {
        out.print("{encoding : ");
        this.genResponseEncodingValue(rest, function, ctx, out);
        out.print(", charset : ");
        this.printQuotedString((String)rest.getValue("responseCharset"), out);
        out.print(", contentType : ");
        this.printQuotedString((String)rest.getValue("responseContentType"), out);
        out.print("}");
    }

    private void genFormatKind(Object formatEnum, Type eglType, Context ctx, TabbedWriter out) {
        if (formatEnum instanceof EnumerationEntry) {
            ctx.invoke("genRuntimeTypeName", formatEnum, new Object[]{ctx, out});
        } else if (formatEnum instanceof Expression) {
            ctx.invoke("genExpression", formatEnum, new Object[]{ctx, out});
        } else if (eglType != null && ctx.mapsToPrimitiveType(eglType)) {
            out.print("egl.eglx.services.Encoding.NONE");
        } else if (eglType != null && "eglx.lang.EDictionary".equals(eglType.getTypeSignature())) {
            out.print("egl.eglx.services.Encoding.JSON");
        } else if (eglType != null) {
            out.print("egl.eglx.services.Encoding.XML");
        } else {
            out.print("egl.eglx.services.Encoding.NONE");
        }
    }

    protected abstract void genURITemplate(Annotation var1, boolean var2, Map<String, RestArgument> var3, Context var4, TabbedWriter var5);

    private void genParamOrders(Function function, Context ctx, TabbedWriter out) {
        out.print("[");
        boolean isFirst = true;
        for (FunctionParameter param : function.getParameters()) {
            if (!isFirst) {
                out.print(", ");
            }
            out.print("\"");
            ctx.invoke("genName", (EObject)param, new Object[]{ctx, out});
            out.print("\"");
            isFirst = false;
        }
        if (function.getReturnField() != null) {
            if (!isFirst) {
                out.print(", ");
            }
            out.print("\"");
            ctx.invoke("genName", (EObject)function.getReturnField(), new Object[]{ctx, out});
            out.print("\"");
            isFirst = false;
        }
        out.println("], ");
    }

    protected void genCallbackArgs(Function function, Context ctx, TabbedWriter out) {
        out.print("[");
        boolean isFirst = true;
        for (FunctionParameter param : function.getParameters()) {
            if (param.getParameterKind() == ParameterKind.PARM_IN) continue;
            if (!isFirst) {
                out.print(", ");
            }
            out.print("{");
            out.print("eglSignature : \"");
            if (param.isNullable()) {
                out.print("?");
            }
            ctx.invoke("genSignature", param.getType(), new Object[]{ctx, out});
            out.print("\", eglType : ");
            ctx.invoke("genServiceCallbackArgType", param.getType(), new Object[]{ctx, out});
            out.print(", paramName : \"");
            ctx.invoke("genName", (EObject)param, new Object[]{ctx, out});
            out.print("\"}");
            isFirst = false;
        }
        if (function.getReturnType() != null) {
            if (!isFirst) {
                out.print(", ");
            }
            out.print("{");
            out.print("eglSignature : \"");
            if (function.isNullable()) {
                out.print("?");
            }
            ctx.invoke("genSignature", function.getReturnType(), new Object[]{ctx, out});
            out.print("\", eglType : ");
            ctx.invoke("genServiceCallbackArgType", function.getReturnType(), new Object[]{ctx, out});
            out.print(", paramName : \"return\"}");
        }
        out.println("], ");
    }

    private void printQuotedString(String val, TabbedWriter out) {
        out.print(val == null ? "null" : RestBase.quoted((String)val));
    }

    protected static class RestArgument {
        protected int index;
        protected FunctionParameter param;
        private boolean isResourceArg = true;

        public RestArgument(FunctionParameter param, int index) {
            this.param = param;
            this.index = index;
            this.isResourceArg = true;
        }

        public FunctionParameter getParam() {
            return this.param;
        }

        public boolean isResourceArg() {
            return this.isResourceArg;
        }

        public void setResourceArg(boolean isResourceArg) {
            this.isResourceArg = isResourceArg;
        }

        public int getParamIndex() {
            return this.index;
        }
    }
}

