/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen;

import org.eclipse.edt.gen.EglContext;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.EVisitor;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.Assignment;
import org.eclipse.edt.mof.egl.BoxingExpression;
import org.eclipse.edt.mof.egl.ConstructorInvocation;
import org.eclipse.edt.mof.egl.DelegateInvocation;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.FunctionInvocation;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.InvocationExpression;
import org.eclipse.edt.mof.egl.Literal;
import org.eclipse.edt.mof.egl.NewExpression;
import org.eclipse.edt.mof.egl.ParameterKind;
import org.eclipse.edt.mof.egl.QualifiedFunctionInvocation;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.TypeUtils;
import org.eclipse.edt.mof.impl.AbstractVisitor;

public class CommonUtilities {
    public static boolean hasSideEffects(Expression expr, EglContext ctx) {
        return new CheckSideEffects().checkSideEffect(expr, ctx);
    }

    public static boolean isExpressionStatementNeedingGeneration(Expression expr, EglContext ctx) {
        return new CheckExpressionStatementNeedingGeneration().checkForGeneration(expr, ctx);
    }

    public static boolean hasLocalVariableSideEffects(Expression expr, EglContext ctx) {
        return new CheckLocalVariableSideEffects().checkLocalVariableSideEffect(expr, ctx);
    }

    public static Expression hasBoxingExpression(Expression expr) {
        return new CheckForBoxingExpression().checkForBoxingExpression(expr);
    }

    public static boolean isArgumentToBeAltered(FunctionParameter parameter, Expression expression, EglContext ctx) {
        if (parameter.getParameterKind() == ParameterKind.PARM_IN) {
            if (TypeUtils.isReferenceType((Type)parameter.getType())) {
                return false;
            }
            if (parameter.isNullable() || expression.isNullable() || !ctx.mapsToPrimitiveType(parameter.getType())) {
                return parameter.isConst() == false;
            }
            if (!parameter.getType().equals(expression.getType()).booleanValue()) {
                if (parameter.isConst().booleanValue()) {
                    return false;
                }
                return !(expression instanceof Literal);
            }
            return false;
        }
        return CommonUtilities.isBoxedParameterType(parameter, ctx) && parameter.isConst() == false;
    }

    public static boolean isBoxedParameterType(FunctionParameter parameter, EglContext ctx) {
        if (parameter.getParameterKind() == ParameterKind.PARM_INOUT) {
            if (TypeUtils.isReferenceType((Type)parameter.getType())) {
                return true;
            }
            if (ctx.mapsToPrimitiveType(parameter.getType())) {
                return true;
            }
            if (parameter.isNullable()) {
                return true;
            }
        } else if (parameter.getParameterKind() == ParameterKind.PARM_OUT) {
            return true;
        }
        return false;
    }

    public static Annotation includeEndOffset(Annotation annotation, EglContext ctx) {
        if (annotation != null) {
            annotation.addAnnotation(ctx.getFactory().createAnnotation("IncludeEndOffsetInGenerationMessage"));
        }
        return annotation;
    }

    public static class CheckExpressionStatementNeedingGeneration
    extends AbstractVisitor {
        boolean has = false;
        EglContext ctx;

        public boolean checkForGeneration(Expression expr, EglContext ctx) {
            this.ctx = ctx;
            this.disallowRevisit();
            this.setReturnData(false);
            expr.accept((EVisitor)this);
            return (Boolean)this.getReturnData();
        }

        public boolean visit(EObject obj) {
            return false;
        }

        public boolean visit(Expression expr) {
            return !this.has;
        }

        public boolean visit(NewExpression expr) {
            this.has = true;
            this.setReturnData(this.has);
            return true;
        }

        public boolean visit(Assignment expr) {
            this.has = true;
            this.setReturnData(this.has);
            return true;
        }

        public boolean visit(ConstructorInvocation expr) {
            this.has = true;
            this.setReturnData(this.has);
            return false;
        }

        public boolean visit(FunctionInvocation expr) {
            this.has = true;
            this.setReturnData(this.has);
            return false;
        }

        public boolean visit(DelegateInvocation expr) {
            this.has = true;
            this.setReturnData(this.has);
            return false;
        }

        public boolean visit(QualifiedFunctionInvocation expr) {
            this.has = true;
            this.setReturnData(this.has);
            return false;
        }
    }

    public static class CheckForBoxingExpression
    extends AbstractVisitor {
        boolean has = false;

        public Expression checkForBoxingExpression(Expression expr) {
            this.disallowRevisit();
            this.setReturnData(null);
            expr.accept((EVisitor)this);
            return (Expression)this.getReturnData();
        }

        public boolean visit(EObject obj) {
            return false;
        }

        public boolean visit(Expression expr) {
            return !this.has;
        }

        public boolean visit(BoxingExpression expr) {
            this.has = true;
            this.setReturnData(expr);
            return false;
        }
    }

    public static class CheckLocalVariableSideEffects
    extends AbstractVisitor {
        boolean has = false;
        EglContext ctx;

        public boolean checkLocalVariableSideEffect(Expression expr, EglContext ctx) {
            this.ctx = ctx;
            this.disallowRevisit();
            this.setReturnData(false);
            expr.accept((EVisitor)this);
            return (Boolean)this.getReturnData();
        }

        public boolean visit(EObject obj) {
            return false;
        }

        public boolean visit(Expression expr) {
            return !this.has;
        }

        public boolean visit(FunctionInvocation expr) {
            this.processInvocation((InvocationExpression)expr);
            return false;
        }

        public boolean visit(DelegateInvocation expr) {
            this.processInvocation((InvocationExpression)expr);
            return false;
        }

        public boolean visit(QualifiedFunctionInvocation expr) {
            this.processInvocation((InvocationExpression)expr);
            return false;
        }

        private void processInvocation(InvocationExpression object) {
            int i = 0;
            while (i < object.getTarget().getParameters().size()) {
                if (CommonUtilities.isArgumentToBeAltered((FunctionParameter)object.getTarget().getParameters().get(i), (Expression)object.getArguments().get(i), this.ctx)) {
                    this.has = true;
                    this.setReturnData(this.has);
                    break;
                }
                ++i;
            }
        }
    }

    public static class CheckSideEffects
    extends AbstractVisitor {
        boolean has = false;
        EglContext ctx;

        public boolean checkSideEffect(Expression expr, EglContext ctx) {
            this.ctx = ctx;
            this.disallowRevisit();
            this.setReturnData(false);
            expr.accept((EVisitor)this);
            return (Boolean)this.getReturnData();
        }

        public boolean visit(EObject obj) {
            return false;
        }

        public boolean visit(Expression expr) {
            return !this.has;
        }

        public boolean visit(NewExpression expr) {
            this.has = true;
            this.setReturnData(this.has);
            return true;
        }

        public boolean visit(Assignment expr) {
            this.has = true;
            this.setReturnData(this.has);
            return true;
        }

        public boolean visit(FunctionInvocation expr) {
            boolean altered = false;
            int i = 0;
            while (i < expr.getTarget().getParameters().size()) {
                if (CommonUtilities.isArgumentToBeAltered((FunctionParameter)expr.getTarget().getParameters().get(i), (Expression)expr.getArguments().get(i), this.ctx)) {
                    altered = true;
                }
                ++i;
            }
            if (!altered) {
                return true;
            }
            this.has = true;
            this.setReturnData(this.has);
            return false;
        }

        public boolean visit(DelegateInvocation expr) {
            this.has = true;
            this.setReturnData(this.has);
            return false;
        }

        public boolean visit(QualifiedFunctionInvocation expr) {
            boolean altered = false;
            int i = 0;
            while (i < expr.getTarget().getParameters().size()) {
                if (CommonUtilities.isArgumentToBeAltered((FunctionParameter)expr.getTarget().getParameters().get(i), (Expression)expr.getArguments().get(i), this.ctx)) {
                    altered = true;
                }
                ++i;
            }
            if (!altered) {
                return true;
            }
            this.has = true;
            this.setReturnData(this.has);
            return false;
        }
    }
}

