/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.binding;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.compiler.internal.io.IIOBufferReader;
import org.eclipse.edt.compiler.internal.io.IIOBufferWriter;
import org.eclipse.edt.compiler.internal.io.IRFileNameUtility;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPathManager;
import org.eclipse.edt.ide.core.internal.lookup.ProjectEnvironmentManager;
import org.eclipse.edt.ide.core.internal.lookup.ProjectIREnvironment;
import org.eclipse.edt.ide.core.internal.utils.Util;
import org.eclipse.edt.mof.egl.utils.IRUtils;
import org.eclipse.edt.mof.egl.utils.InternUtil;
import org.eclipse.edt.mof.serialization.SerializationException;

public class BinaryFileManager {
    private static BinaryFileManager INSTANCE = new BinaryFileManager();

    private BinaryFileManager() {
    }

    public static BinaryFileManager getInstance() {
        return INSTANCE;
    }

    private IFile[] getOutputFileForRead(String[] packageName, String partName, IProject project) {
        try {
            IContainer output = ProjectBuildPathManager.getInstance().getProjectBuildPath(project).getOutputLocation();
            IPath pathWithoutExt = Util.stringArrayToPath(IRFileNameUtility.toIRFileName((String[])packageName)).append(IRFileNameUtility.toIRFileName((String)partName));
            return new IFile[]{output.getFile(pathWithoutExt.addFileExtension("eglxml")), output.getFile(pathWithoutExt.addFileExtension("eglbin")), output.getFile(pathWithoutExt.addFileExtension("mofxml")), output.getFile(pathWithoutExt.addFileExtension("mofbin"))};
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void removePart(String[] packageName, String name, IProject project) {
        this.removePart(packageName, name, project, true);
    }

    public void removePart(String[] packageName, String name, IProject project, boolean deleteFromDisk) {
        if (deleteFromDisk) {
            IFile[] files;
            IFile[] iFileArray = files = this.getOutputFileForRead(packageName, name, project);
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file = iFileArray[n2];
                if (file.exists()) {
                    Writer writer = new Writer(ResourcesPlugin.getWorkspace().getRoot().getFile(file.getFullPath()));
                    writer.allEntriesRemoved();
                }
                ++n2;
            }
        }
        ProjectIREnvironment env = ProjectEnvironmentManager.getInstance().getProjectEnvironment(project).getIREnvironment();
        env.remove(BinaryFileManager.eglIRKey(packageName, name));
        env.remove(BinaryFileManager.mofIRKey(packageName, name));
    }

    public static String eglIRKey(String[] packageName, String partName) {
        StringBuilder buf = new StringBuilder();
        buf.append("egl");
        buf.append(":");
        if (packageName != null && packageName.length > 0) {
            buf.append(IRUtils.concatWithSeparator((String[])packageName, (String)"."));
            buf.append('.');
        }
        buf.append(partName);
        return buf.toString();
    }

    public static String mofIRKey(String[] packageName, String partName) {
        StringBuilder buf = new StringBuilder();
        if (packageName != null && packageName.length > 0) {
            buf.append(IRUtils.concatWithSeparator((String[])packageName, (String)"."));
            buf.append('.');
        }
        buf.append(partName);
        return buf.toString();
    }

    public void addPackage(String[] packages, IProject project) {
        IContainer container = ProjectBuildPathManager.getInstance().getProjectBuildPath(project).getOutputLocation();
        try {
            org.eclipse.edt.ide.core.internal.builder.Util.createFolder(Util.stringArrayToPath(IRFileNameUtility.toIRFileName((String[])packages)), container);
        }
        catch (CoreException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void removePackage(String[] packages, IProject project) {
        IContainer container = ProjectBuildPathManager.getInstance().getProjectBuildPath(project).getOutputLocation();
        if ((container = container.getFolder(Util.stringArrayToPath(IRFileNameUtility.toIRFileName((String[])packages)))).exists() && container.getType() != 4) {
            try {
                container.delete(true, null);
            }
            catch (CoreException e) {
                throw new BuildException((Throwable)e);
            }
        }
    }

    public static class Reader
    implements IIOBufferReader {
        private IFile bufferFile;

        public Reader(IFile bufferFile) {
            this.bufferFile = bufferFile;
        }

        public Object readEntry(String name) throws IOException {
            byte[] result = null;
            if (this.bufferFile.exists()) {
                try {
                    BufferedInputStream inputStream = new BufferedInputStream(this.bufferFile.getContents());
                    try {
                        byte[] contents = new byte[inputStream.available()];
                        inputStream.read(contents);
                        result = contents;
                    }
                    finally {
                        inputStream.close();
                    }
                }
                catch (CoreException e) {
                    throw new BuildException("CoreException", (Throwable)e);
                }
            }
            return result;
        }

        public List getEntries() throws IOException {
            ArrayList<String> entries = new ArrayList<String>();
            if (this.bufferFile.exists()) {
                String name = new String(this.bufferFile.getName());
                Path path = new Path(name);
                path = path.removeFileExtension();
                entries.add(InternUtil.intern((String)path.toString()));
            }
            return entries;
        }

        public InputStream getInputStream(String name) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    public static class Writer
    implements IIOBufferWriter {
        private static final boolean DEBUG = false;
        private byte[] entry;
        private IFile bufferFile;

        public Writer(IFile bufferFile) {
            this.bufferFile = bufferFile;
        }

        public void beginWriting() throws IOException {
            this.entry = null;
        }

        public void writeEntry(String entryName, Object value) throws IOException, SerializationException {
            this.entry = (byte[])value;
        }

        public void finishWriting() throws IOException {
            BufferedInputStream inputStream = new BufferedInputStream(new ByteArrayInputStream(this.entry));
            try {
                try {
                    if (this.bufferFile.exists()) {
                        if (this.entry.length > 0) {
                            this.bufferFile.setContents((InputStream)inputStream, true, false, null);
                            if (!this.bufferFile.isDerived()) {
                                this.bufferFile.setDerived(true, null);
                            }
                        } else {
                            this.bufferFile.delete(true, null);
                        }
                    } else if (this.entry.length > 0) {
                        this.bufferFile.create((InputStream)inputStream, 1, null);
                        this.bufferFile.setDerived(true, null);
                    }
                }
                catch (CoreException coreException) {
                    throw new IOException("EclipseZipFileIOBufferWriter::finishWriting");
                }
            }
            finally {
                ((InputStream)inputStream).close();
            }
        }

        public void allEntriesRemoved() {
            try {
                if (this.bufferFile.exists()) {
                    this.bufferFile.delete(true, false, null);
                }
            }
            catch (CoreException e) {
                throw new BuildException((Throwable)e);
            }
        }
    }
}

