/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.edt.compiler.internal.core.lookup.IBuildPathEntry;
import org.eclipse.edt.ide.core.internal.builder.AbstractBuilder;
import org.eclipse.edt.ide.core.internal.builder.AbstractProcessingQueue;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPath;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPathEntryManager;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPathManager;
import org.eclipse.edt.ide.core.internal.lookup.ProjectEnvironment;
import org.eclipse.edt.ide.core.internal.lookup.ProjectIREnvironment;
import org.eclipse.edt.mof.serialization.Environment;
import org.eclipse.edt.mof.serialization.IEnvironment;

public class ProjectEnvironmentManager {
    private Map<IProject, ProjectEnvironment> projectEnvironments;
    private Map<IProject, ProjectIREnvironment> irEnvironments;
    private boolean environmentPushed = false;
    private static final ProjectEnvironmentManager INSTANCE = new ProjectEnvironmentManager();

    private ProjectEnvironmentManager() {
        this.init();
    }

    public static ProjectEnvironmentManager getInstance() {
        return INSTANCE;
    }

    public void clearAll() {
        this.init();
    }

    public void clear(IProject project) {
        ProjectEnvironment result;
        ProjectIREnvironment env = this.irEnvironments.get(project);
        if (env != null) {
            env.reset();
        }
        if ((result = this.projectEnvironments.get(project)) != null) {
            result.clear();
        }
    }

    public void remove(IProject project) {
        this.projectEnvironments.remove(project);
        this.irEnvironments.remove(project);
    }

    private void init() {
        this.projectEnvironments = new HashMap<IProject, ProjectEnvironment>();
        this.irEnvironments = new HashMap<IProject, ProjectIREnvironment>();
    }

    public synchronized ProjectEnvironment getProjectEnvironment(IProject project) {
        ProjectEnvironment result = this.projectEnvironments.get(project);
        if (result == null) {
            result = new ProjectEnvironment(project);
            this.projectEnvironments.put(project, result);
            result.setIREnvironment(this.getIREnvironment(project));
            result.setProjectBuildPathEntries(this.getProjectBuildPathEntriesFor(project));
            result.setDeclaringProjectBuildPathEntry(ProjectBuildPathEntryManager.getInstance().getProjectBuildPathEntry(project));
        }
        return result;
    }

    protected synchronized ProjectIREnvironment getIREnvironment(IProject project) {
        ProjectIREnvironment env = this.irEnvironments.get(project);
        if (env == null) {
            env = new ProjectIREnvironment();
            this.irEnvironments.put(project, env);
        }
        return env;
    }

    private IBuildPathEntry[] getProjectBuildPathEntriesFor(IProject project) {
        ProjectBuildPath projectBuildPath = ProjectBuildPathManager.getInstance().getProjectBuildPath(project);
        return projectBuildPath.getBuildPathEntries();
    }

    public void beginBuilding(AbstractBuilder builder) {
        IProject project = builder.getBuilder().getProject();
        AbstractProcessingQueue processingQueue = builder.getProcessingQueue();
        ProjectBuildPathEntry entry = ProjectBuildPathEntryManager.getInstance().getProjectBuildPathEntry(project);
        entry.setProcessingQueue(processingQueue);
        ProjectEnvironment env = this.getProjectEnvironment(project);
        env.clearRootPackage();
        env.initIREnvironments();
        Environment.pushEnv((IEnvironment)env.getIREnvironment());
        this.environmentPushed = true;
    }

    public void endBuilding(AbstractBuilder builder) {
        IProject project = builder.getBuilder().getProject();
        ProjectBuildPathEntry entry = ProjectBuildPathEntryManager.getInstance().getProjectBuildPathEntry(project);
        entry.setProcessingQueue(null);
        if (this.environmentPushed) {
            Environment.popEnv();
            this.environmentPushed = false;
        }
    }

    public int getCount() {
        return this.projectEnvironments.size();
    }
}

