/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup.workingcopy;

import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.compiler.internal.core.lookup.IBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.AbstractProjectInfo;
import org.eclipse.edt.ide.core.internal.lookup.IFileInfo;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPath;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPathManager;
import org.eclipse.edt.ide.core.internal.lookup.WrapperedZipFileBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyFileInfoManager;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectBuildPathManager;
import org.eclipse.edt.ide.core.internal.partinfo.EGLFileOrigin;
import org.eclipse.edt.ide.core.internal.partinfo.IPartOrigin;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.PartNotFoundException;

public class WorkingCopyProjectInfo
extends AbstractProjectInfo {
    private HashMap packageMap = new HashMap();

    public WorkingCopyProjectInfo(IProject project) {
        super(project);
    }

    @Override
    public IPartOrigin getPartOrigin(String[] packageName, String partName) {
        WorkingCopyProjectInfoEntry entry;
        HashMap partMap = (HashMap)this.packageMap.get(packageName);
        if (partMap != null && (entry = (WorkingCopyProjectInfoEntry)partMap.get(partName)) != null) {
            return new EGLFileOrigin(entry.file);
        }
        IPartOrigin partOrigin = super.getPartOrigin(packageName, partName);
        if (partOrigin == null || partOrigin.getEGLFile() == null) {
            IBuildPathEntry[] pathEntries;
            ProjectBuildPath buildPath = ProjectBuildPathManager.getInstance().getProjectBuildPath(this.getProject());
            IBuildPathEntry[] iBuildPathEntryArray = pathEntries = buildPath.getBuildPathEntries();
            int n = pathEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IPartOrigin zipPartOrigin;
                IBuildPathEntry pathEntry = iBuildPathEntryArray[n2];
                if (pathEntry instanceof WrapperedZipFileBuildPathEntry && (zipPartOrigin = ((WrapperedZipFileBuildPathEntry)pathEntry).getPartOrigin(packageName, partName)) != null) {
                    return zipPartOrigin;
                }
                ++n2;
            }
        }
        return partOrigin;
    }

    @Override
    public boolean hasPackage(String[] packageName) {
        boolean hasPackage = super.hasPackage(packageName);
        if (!hasPackage) {
            IBuildPathEntry[] pathEntries;
            ProjectBuildPath buildPath = ProjectBuildPathManager.getInstance().getProjectBuildPath(this.getProject());
            IBuildPathEntry[] iBuildPathEntryArray = pathEntries = buildPath.getBuildPathEntries();
            int n = pathEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IBuildPathEntry pathEntry = iBuildPathEntryArray[n2];
                if (pathEntry instanceof WrapperedZipFileBuildPathEntry && pathEntry.hasPackage(packageName)) {
                    return true;
                }
                ++n2;
            }
        }
        return hasPackage;
    }

    @Override
    public int hasPart(String[] packageName, String partName) {
        WorkingCopyProjectInfoEntry entry;
        HashMap partMap = (HashMap)this.packageMap.get(packageName);
        if (partMap != null && (entry = (WorkingCopyProjectInfoEntry)partMap.get(partName)) != null) {
            if (entry.entryType != 1) {
                return entry.partType;
            }
            return 1;
        }
        int partType = super.hasPart(packageName, partName);
        if (partType == 1) {
            IBuildPathEntry[] pathEntries;
            ProjectBuildPath buildPath = ProjectBuildPathManager.getInstance().getProjectBuildPath(this.getProject());
            IBuildPathEntry[] iBuildPathEntryArray = pathEntries = buildPath.getBuildPathEntries();
            int n = pathEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IBuildPathEntry pathEntry = iBuildPathEntryArray[n2];
                if (pathEntry instanceof WrapperedZipFileBuildPathEntry && 1 != (partType = pathEntry.hasPart(packageName, partName))) break;
                ++n2;
            }
        }
        return partType;
    }

    private void recordEntry(String[] packageName, String partName, WorkingCopyProjectInfoEntry entry) {
        HashMap<String, WorkingCopyProjectInfoEntry> partMap = (HashMap<String, WorkingCopyProjectInfoEntry>)this.packageMap.get(packageName);
        if (partMap == null) {
            partMap = new HashMap<String, WorkingCopyProjectInfoEntry>();
            this.packageMap.put(packageName, partMap);
        }
        partMap.put(partName, entry);
    }

    @Override
    public void clear() {
        super.clear();
        this.packageMap.clear();
    }

    public void resetWorkingCopies() {
        this.packageMap.clear();
    }

    @Override
    protected IFileInfo getCachedFileInfo(IProject project, IPath projectRelativePath) {
        return WorkingCopyFileInfoManager.getInstance().getFileInfo(project, projectRelativePath);
    }

    @Override
    public String getCaseSensitivePartName(String[] packageName, String partName) {
        WorkingCopyProjectInfoEntry entry;
        HashMap partMap = (HashMap)this.packageMap.get(packageName);
        if (partMap != null && (entry = (WorkingCopyProjectInfoEntry)partMap.get(partName)) != null) {
            return entry.caseSensitivePartName;
        }
        String caseSensitivePartName = super.getCaseSensitivePartName(packageName, partName);
        if (caseSensitivePartName == null) {
            IBuildPathEntry[] pathEntries;
            ProjectBuildPath buildPath = ProjectBuildPathManager.getInstance().getProjectBuildPath(this.getProject());
            IBuildPathEntry[] iBuildPathEntryArray = pathEntries = buildPath.getBuildPathEntries();
            int n = pathEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IBuildPathEntry pathEntry = iBuildPathEntryArray[n2];
                if (pathEntry instanceof WrapperedZipFileBuildPathEntry) {
                    try {
                        Part part = pathEntry.findPart(packageName, partName);
                        if (part != null) {
                            caseSensitivePartName = part.getName();
                        } else {
                            String fileExtension;
                            int index = partName.lastIndexOf(".");
                            if (index > -1 && "egl".equalsIgnoreCase(fileExtension = partName.substring(index + 1))) {
                                caseSensitivePartName = partName;
                            }
                        }
                        if (caseSensitivePartName != null) {
                            return caseSensitivePartName;
                        }
                    }
                    catch (PartNotFoundException partNotFoundException) {}
                }
                ++n2;
            }
        }
        return caseSensitivePartName;
    }

    @Override
    protected IContainer[] getSourceLocations(IProject project) {
        return WorkingCopyProjectBuildPathManager.getInstance().getProjectBuildPath(project).getSourceLocations();
    }

    public void workingCopyPartAdded(String[] packageName, String partName, int partType, IFile file, String caseSensitivePartName) {
        this.recordEntry(packageName, partName, new WorkingCopyProjectInfoEntry(partType, file, 2, caseSensitivePartName));
    }

    public void workingCopyPartRemoved(String[] packageName, String partName, int partType, IFile file, String caseSensitivePartName) {
        this.recordEntry(packageName, partName, new WorkingCopyProjectInfoEntry(partType, file, 1, caseSensitivePartName));
    }

    public void workingCopyPartChanged(String[] packageName, String partName, int partType, IFile file, String caseSensitivePartName) {
        this.recordEntry(packageName, partName, new WorkingCopyProjectInfoEntry(partType, file, 0, caseSensitivePartName));
    }

    private class WorkingCopyProjectInfoEntry {
        public static final int CHANGE = 0;
        public static final int REMOVAL = 1;
        public static final int ADDITION = 2;
        private int partType;
        private IFile file;
        private int entryType;
        private String caseSensitivePartName;

        public WorkingCopyProjectInfoEntry(int partType, IFile file, int entryType, String caseSensitivePartName) {
            this.partType = partType;
            this.file = file;
            this.entryType = entryType;
            this.caseSensitivePartName = caseSensitivePartName;
        }
    }
}

