/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.edt.ide.core.internal.search.PartInfo;
import org.eclipse.edt.ide.core.internal.search.PartInfoRequestor;
import org.eclipse.edt.ide.core.internal.search.UnresolvablePartInfo;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.ElementChangedEvent;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLElementDelta;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IElementChangedListener;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.model.Signature;
import org.eclipse.edt.ide.core.search.IEGLSearchScope;
import org.eclipse.edt.ide.core.search.IPartNameRequestor;
import org.eclipse.edt.ide.core.search.SearchEngine;

public class AllPartsCache {
    private static PartInfo[] fgTypeCache = null;
    private static int fgSizeHint = 2000;
    private static int fgNumberOfCacheFlushes = 0;
    private static Comparator fgPartNameComparator = new PartNameComparator();

    public static void getParts(IEGLSearchScope scope, int kind, IProgressMonitor monitor, Collection partsFound) throws EGLModelException {
        AllPartsCache.getParts(scope, kind, null, monitor, partsFound);
    }

    private static void addPartToCollection(IEGLSearchScope scope, PartInfo info, Collection partsFound, int kind, String subType) throws EGLModelException {
        if ((info.getPartType() & kind) != 0) {
            if (subType != null && subType.length() > 0) {
                String partSubTypeString;
                IPart part = info.resolvePart(scope);
                if (part != null && part.getSubTypeSignature() != null && (partSubTypeString = Signature.toString(part.getSubTypeSignature())).equalsIgnoreCase(subType)) {
                    partsFound.add(info);
                }
            } else {
                partsFound.add(info);
            }
        }
    }

    public static void getParts(IEGLSearchScope scope, int kind, String subType, IProgressMonitor monitor, Collection partsFound) throws EGLModelException {
        PartInfo[] allParts = AllPartsCache.getAllParts(monitor);
        boolean isWorkspaceScope = scope.equals(SearchEngine.createWorkspaceScope());
        int i = 0;
        while (i < allParts.length) {
            PartInfo info = fgTypeCache[i];
            if (isWorkspaceScope || info.isEnclosed(scope)) {
                AllPartsCache.addPartToCollection(scope, info, partsFound, kind, subType);
            }
            ++i;
        }
    }

    public static synchronized PartInfo[] getAllParts(IProgressMonitor monitor) throws EGLModelException {
        if (fgTypeCache == null) {
            ArrayList searchResult = new ArrayList(fgSizeHint);
            AllPartsCache.doSearchParts(SearchEngine.createWorkspaceScope(), Short.MAX_VALUE, monitor, searchResult);
            if (monitor != null && monitor.isCanceled()) {
                return null;
            }
            monitor = null;
            fgTypeCache = searchResult.toArray(new PartInfo[searchResult.size()]);
            Arrays.sort(fgTypeCache, AllPartsCache.getPartNameComperator());
            fgSizeHint = fgTypeCache.length;
            EGLCore.addElementChangedListener(new PartCacheDeltaListener());
        }
        if (monitor != null) {
            monitor.done();
        }
        return fgTypeCache;
    }

    public static boolean isCacheUpToDate() {
        return fgTypeCache != null;
    }

    public static int getNumberOfAllPartsHint() {
        return fgSizeHint;
    }

    public static Comparator getPartNameComperator() {
        return fgPartNameComparator;
    }

    private static void doSearchParts(IEGLSearchScope scope, int style, IProgressMonitor monitor, Collection typesFound) throws EGLModelException {
        new SearchEngine().searchAllPartNames(ResourcesPlugin.getWorkspace(), null, null, 2, false, style, scope, new PartInfoRequestor(typesFound), 3, monitor);
    }

    public static int getNumberOfCacheFlushes() {
        return fgNumberOfCacheFlushes;
    }

    public static PartInfo[] getPartsForName(String simplePartName, IEGLSearchScope searchScope, IProgressMonitor monitor) throws EGLModelException {
        UnresolvablePartInfo key;
        ArrayList<PartInfo> result = new ArrayList<PartInfo>();
        HashSet<String> namesFound = new HashSet<String>();
        PartInfo[] allParts = AllPartsCache.getAllParts(monitor);
        int index = Arrays.binarySearch(allParts, key = new UnresolvablePartInfo("", simplePartName, null, null), AllPartsCache.getPartNameComperator());
        if (index >= 0 && index < allParts.length) {
            PartInfo curr;
            int i = index - 1;
            while (i >= 0) {
                curr = allParts[i];
                if (!simplePartName.equals(curr.getPartName())) break;
                if (!namesFound.contains(curr.getFullyQualifiedName()) && curr.isEnclosed(searchScope)) {
                    result.add(curr);
                    namesFound.add(curr.getFullyQualifiedName());
                }
                --i;
            }
            i = index;
            while (i < allParts.length) {
                curr = allParts[i];
                if (!simplePartName.equals(curr.getPartName())) break;
                if (!namesFound.contains(curr.getFullyQualifiedName()) && curr.isEnclosed(searchScope)) {
                    result.add(curr);
                    namesFound.add(curr.getFullyQualifiedName());
                }
                ++i;
            }
        }
        return result.toArray(new PartInfo[result.size()]);
    }

    public static PartInfo[] getAllPartsForName(String simplePartName, IEGLSearchScope searchScope, IProgressMonitor monitor, int partType) throws EGLModelException {
        UnresolvablePartInfo key;
        ArrayList<PartInfo> result = new ArrayList<PartInfo>();
        PartInfo[] allParts = AllPartsCache.getAllParts(monitor);
        int index = Arrays.binarySearch(allParts, key = new UnresolvablePartInfo("", simplePartName, null, null), AllPartsCache.getPartNameComperator());
        if (index >= 0 && index < allParts.length) {
            PartInfo curr;
            int i = index - 1;
            while (i >= 0) {
                curr = allParts[i];
                if (!simplePartName.equals(curr.getPartName())) break;
                if ((curr.getPartType() & partType) != 0 && curr.isEnclosed(searchScope)) {
                    result.add(curr);
                }
                --i;
            }
            i = index;
            while (i < allParts.length) {
                curr = allParts[i];
                if (!simplePartName.equals(curr.getPartName())) break;
                if ((curr.getPartType() & partType) != 0 && curr.isEnclosed(searchScope)) {
                    result.add(curr);
                }
                ++i;
            }
        }
        return result.toArray(new PartInfo[result.size()]);
    }

    public static boolean isIndexUpToDate() {
        class TypeFoundException
        extends Error {
            TypeFoundException() {
            }
        }
        IPartNameRequestor requestor = new IPartNameRequestor(){

            @Override
            public void acceptPart(char[] packageName, char[] simplePartName, char partType, char[][] enclosingPartNames, String path, IPath projectPath) {
                throw new TypeFoundException();
            }
        };
        try {
            new SearchEngine().searchAllPartNames(ResourcesPlugin.getWorkspace(), null, null, 2, false, Short.MAX_VALUE, SearchEngine.createWorkspaceScope(), requestor, 2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (EGLModelException eGLModelException) {
            return false;
        }
        catch (OperationCanceledException operationCanceledException) {
            return false;
        }
        catch (TypeFoundException typeFoundException) {}
        return true;
    }

    public static void flushCache() {
        ++fgNumberOfCacheFlushes;
        fgTypeCache = null;
    }

    private static class PartCacheDeltaListener
    implements IElementChangedListener {
        private PartCacheDeltaListener() {
        }

        @Override
        public void elementChanged(ElementChangedEvent event) {
            boolean needsFlushing = this.processDelta(event.getDelta());
            if (needsFlushing) {
                fgTypeCache = null;
                fgNumberOfCacheFlushes = fgNumberOfCacheFlushes + 1;
                EGLCore.removeElementChangedListener(this);
            }
        }

        private boolean processDelta(IEGLElementDelta delta) {
            IEGLElement elem = delta.getElement();
            boolean isAddedOrRemoved = delta.getKind() != 4 || (delta.getFlags() & 0xC0) != 0;
            switch (elem.getElementType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 7: 
                case 8: {
                    if (isAddedOrRemoved) {
                        return true;
                    }
                    return this.processChildrenDelta(delta);
                }
                case 6: {
                    if (((IEGLFile)elem).isWorkingCopy()) {
                        return false;
                    }
                    if (isAddedOrRemoved || this.isPossibleStructuralChange(delta.getFlags())) {
                        return true;
                    }
                    return this.processChildrenDelta(delta);
                }
            }
            return false;
        }

        private boolean isPossibleStructuralChange(int flags) {
            return (flags & 0x4001) == 1;
        }

        private boolean processChildrenDelta(IEGLElementDelta delta) {
            IEGLElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                if (this.processDelta(children[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    private static class PartNameComparator
    implements Comparator {
        private PartNameComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((PartInfo)o1).getPartName().compareTo(((PartInfo)o2).getPartName());
        }
    }
}

