/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.search.matching;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.compiler.binding.AnnotationAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.AnnotationBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.PartBinding;
import org.eclipse.edt.compiler.binding.annotationType.StereotypeAnnotationTypeBinding;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedForm;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.TopLevelFunction;
import org.eclipse.edt.compiler.internal.core.utils.CharOperation;
import org.eclipse.edt.ide.core.internal.model.EGLElement;
import org.eclipse.edt.ide.core.internal.model.SourcePartElementInfo;
import org.eclipse.edt.ide.core.internal.model.Util;
import org.eclipse.edt.ide.core.internal.model.index.IEntryResult;
import org.eclipse.edt.ide.core.internal.model.index.impl.IndexInput;
import org.eclipse.edt.ide.core.internal.model.index.impl.IndexedFile;
import org.eclipse.edt.ide.core.internal.model.indexing.AbstractIndexer;
import org.eclipse.edt.ide.core.internal.search.EGLSearchScope;
import org.eclipse.edt.ide.core.internal.search.IIndexSearchRequestor;
import org.eclipse.edt.ide.core.internal.search.matching.SearchPattern;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IIndexConstants;
import org.eclipse.edt.ide.core.model.IMember;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.search.IEGLSearchScope;

public class PartDeclarationPattern
extends SearchPattern {
    private char[] pkg;
    private char[][] enclosingTypeNames;
    protected char[] simpleName;
    protected boolean isPartDecl;
    protected char partTypes;
    private char[] decodedPackage;
    private char[][] decodedEnclosingTypeNames;
    protected char[] decodedSimpleName;
    protected char decodedPartTypes;

    public PartDeclarationPattern(int matchMode, boolean isCaseSensitive) {
        super(matchMode, isCaseSensitive);
    }

    public PartDeclarationPattern(char[] pkg, char[][] enclosingTypeNames, char[] simpleName, char partTypes, int matchMode, boolean isCaseSensitive) {
        super(matchMode, isCaseSensitive);
        char[] cArray = this.pkg = isCaseSensitive ? pkg : CharOperation.toLowerCase((char[])pkg);
        if (isCaseSensitive || enclosingTypeNames == null) {
            this.enclosingTypeNames = enclosingTypeNames;
        } else {
            int length = enclosingTypeNames.length;
            this.enclosingTypeNames = new char[length][];
            int i = 0;
            while (i < length) {
                this.enclosingTypeNames[i] = CharOperation.toLowerCase((char[])enclosingTypeNames[i]);
                ++i;
            }
        }
        this.simpleName = isCaseSensitive ? simpleName : CharOperation.toLowerCase((char[])simpleName);
        this.partTypes = partTypes;
        this.needsResolve = pkg != null && enclosingTypeNames != null;
    }

    @Override
    public void decodeIndexEntry(IEntryResult entryResult) {
        char[] word = entryResult.getWord();
        this.isPartDecl = true;
        if (CharOperation.prefixEquals((char[])IIndexConstants.PART_DECL, (char[])word)) {
            int size = word.length;
            this.decodedPartTypes = word[9];
            int oldSlash = 10;
            int slash = CharOperation.indexOf((char)'/', (char[])word, (int)(oldSlash + 1));
            this.decodedPackage = slash == oldSlash + 1 ? CharOperation.NO_CHAR : CharOperation.subarray((char[])word, (int)(oldSlash + 1), (int)slash);
            int n = slash + 1;
            slash = CharOperation.indexOf((char)'/', (char[])word, (int)(slash + 1));
            this.decodedSimpleName = CharOperation.subarray((char[])word, (int)n, (int)slash);
            this.decodedEnclosingTypeNames = slash + 1 < size ? (slash + 3 == size && word[slash + 1] == ONE_ZERO[0] ? ONE_ZERO_CHAR : CharOperation.splitOn((char)'/', (char[])CharOperation.subarray((char[])word, (int)(slash + 1), (int)(size - 1)))) : CharOperation.NO_CHAR_CHAR;
        } else {
            this.isPartDecl = false;
        }
    }

    @Override
    public void feedIndexRequestor(IIndexSearchRequestor requestor, int detailLevel, int[] references, IndexInput input, IEGLSearchScope scope) throws IOException {
        int i = 0;
        int max = references.length;
        while (i < max) {
            String path;
            IndexedFile file = input.getIndexedFile(references[i]);
            if (file != null && scope.encloses(path = IndexedFile.convertPath(file.getPath()))) {
                Set projects;
                Map<IPath, Set> eglarProjectsMap;
                String filePkgRootPath = org.eclipse.edt.ide.core.internal.utils.Util.getPackageFragmentRootPath(path);
                String filePkg = "";
                if (!Util.isEGLARFileName(filePkgRootPath)) {
                    int ind = 0;
                    int k = 0;
                    while (k < 2) {
                        ind = filePkgRootPath.indexOf("/", ind + 1);
                        ++k;
                    }
                    if (ind != -1) {
                        filePkg = filePkgRootPath.substring(ind + 1);
                        filePkg = filePkg.replace("/", ".");
                        filePkgRootPath = filePkgRootPath.substring(0, ind);
                    }
                }
                if (Util.isEGLARFileName(filePkgRootPath) && scope instanceof EGLSearchScope && (eglarProjectsMap = ((EGLSearchScope)scope).getEglarProjectsMap()) != null && (projects = eglarProjectsMap.get(new Path(filePkgRootPath))) != null) {
                    for (IEGLProject eglProj : projects) {
                        requestor.acceptPartDeclaration(eglProj.getPath(), path, this.decodedSimpleName, this.decodedPartTypes, this.decodedEnclosingTypeNames, this.decodedPackage);
                    }
                    return;
                }
                IPath[] enclosingPaths = scope.enclosingProjects();
                IPath projectPath = null;
                int j = 0;
                while (j < enclosingPaths.length) {
                    if (enclosingPaths[j].segmentCount() <= 1) {
                        IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(enclosingPaths[j].toString());
                        IEGLProject eglProj = EGLCore.create(proj);
                        try {
                            IPackageFragment pkgFrag;
                            IPackageFragmentRoot pkgFragRoot = eglProj.getPackageFragmentRoot((IPath)new Path(filePkgRootPath));
                            if (pkgFragRoot != null && pkgFragRoot.exists() && (filePkg == null || filePkg.trim().isEmpty() || (pkgFrag = pkgFragRoot.getPackageFragment(filePkg)) != null && pkgFrag.exists())) {
                                projectPath = enclosingPaths[j];
                                requestor.acceptPartDeclaration(projectPath, path, this.decodedSimpleName, this.decodedPartTypes, this.decodedEnclosingTypeNames, this.decodedPackage);
                            }
                        }
                        catch (EGLModelException e) {
                            e.printStackTrace();
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    @Override
    public char[] indexEntryPrefix() {
        return AbstractIndexer.bestPartDeclarationPrefix(this.pkg, this.simpleName, this.partTypes, this.matchMode, this.isCaseSensitive);
    }

    @Override
    protected int matchContainer() {
        return 15;
    }

    @Override
    public int matchesFunctionPart(TopLevelFunction function) {
        return this.matchesPart((Part)function);
    }

    @Override
    public int matchesPart(Part type) {
        if (!this.matchesPartType(type)) {
            return 0;
        }
        return this.matchLevel(type);
    }

    @Override
    public int matchesPart(IPart part) {
        if (!this.matchesPartType(part)) {
            return 0;
        }
        return this.matchLevel(part);
    }

    @Override
    public int matchesNestedFormPart(NestedForm node) {
        if (this.partTypes != ' ' && this.partTypes != Short.MAX_VALUE) {
            return 0;
        }
        IPartBinding partBinding = this.getPartBinding(node.getName());
        if (partBinding != null && partBinding != IBinding.NOT_FOUND_BINDING) {
            char[] enclosingTypeName = this.enclosingTypeNames == null ? null : CharOperation.concatWith((char[][])this.enclosingTypeNames, (char)'.');
            return this.matchLevelForType(this.simpleName, this.pkg, enclosingTypeName, this.getPartBinding(node.getName()));
        }
        return 3;
    }

    @Override
    public int matchLevel(Node node, boolean resolve) {
        if (node instanceof Part) {
            Part type = (Part)node;
            if (this.simpleName != null && !this.matchesName(this.simpleName, type.getName().getCanonicalName().toCharArray())) {
                return 0;
            }
        } else if (node instanceof NestedForm) {
            NestedForm type = (NestedForm)node;
            if (this.simpleName != null && !this.matchesName(this.simpleName, type.getName().getCanonicalName().toCharArray())) {
                return 0;
            }
        } else {
            return 0;
        }
        return 1;
    }

    @Override
    public int matchLevel(IMember member, boolean resolve) {
        if (member instanceof IPart) {
            IPart type = (IPart)member;
            if (this.simpleName != null && !this.matchesName(this.simpleName, type.getElementName().toCharArray())) {
                return 0;
            }
        }
        return 1;
    }

    public int matchLevel(Part part) {
        char[] enclosingTypeName = this.enclosingTypeNames == null ? null : CharOperation.concatWith((char[][])this.enclosingTypeNames, (char)'.');
        return this.matchLevelForType(this.simpleName, this.pkg, enclosingTypeName, this.getPartBinding(part));
    }

    public int matchLevel(IPart part) {
        return 0;
    }

    protected boolean matchesType(char[] simpleNamePattern, char[] pkgPattern, char[] enclosingNamePattern, char[] fullyQualifiedTypeName) {
        if (enclosingNamePattern == null) {
            return this.matchesType(simpleNamePattern, pkgPattern, fullyQualifiedTypeName);
        }
        char[] pattern = pkgPattern == null ? enclosingNamePattern : CharOperation.concat((char[])pkgPattern, (char[])enclosingNamePattern, (char)'.');
        return this.matchesType(simpleNamePattern, pattern, fullyQualifiedTypeName);
    }

    protected int matchLevelForType(char[] simpleNamePattern, char[] qualificationPattern, char[] enclosingNamePattern, IPartBinding partBinding) {
        if (partBinding != null && partBinding != IBinding.NOT_FOUND_BINDING) {
            if (enclosingNamePattern == null) {
                return this.matchLevelForType(simpleNamePattern, qualificationPattern, partBinding);
            }
            if (qualificationPattern == null) {
                return this.matchLevelForType(simpleNamePattern, enclosingNamePattern, partBinding);
            }
            return 0;
        }
        return 0;
    }

    protected boolean partTypesMatch() {
        if ((this.partTypes & this.decodedPartTypes) == 0) {
            return this.decodedPartTypes == '\b' && ((this.partTypes & 2) != 0 || (this.partTypes & 0x8000) != 0);
        }
        return true;
    }

    @Override
    protected boolean matchIndexEntry() {
        if (!this.partTypesMatch()) {
            return false;
        }
        if (!this.isPartDecl) {
            return false;
        }
        if (this.pkg != null && !CharOperation.equals((char[])this.pkg, (char[])this.decodedPackage, (boolean)this.isCaseSensitive)) {
            return false;
        }
        if (this.enclosingTypeNames != null && (this.enclosingTypeNames.length == 0 ? this.decodedEnclosingTypeNames != CharOperation.NO_CHAR_CHAR : !CharOperation.equals((char[][])this.enclosingTypeNames, (char[][])this.decodedEnclosingTypeNames, (boolean)this.isCaseSensitive))) {
            return false;
        }
        if (this.simpleName != null) {
            switch (this.matchMode) {
                case 0: {
                    if (CharOperation.equals((char[])this.simpleName, (char[])this.decodedSimpleName, (boolean)this.isCaseSensitive)) break;
                    return false;
                }
                case 1: {
                    if (CharOperation.prefixEquals((char[])this.simpleName, (char[])this.decodedSimpleName, (boolean)this.isCaseSensitive)) break;
                    return false;
                }
                case 2: {
                    if (CharOperation.match((char[])this.simpleName, (char[])this.decodedSimpleName, (boolean)this.isCaseSensitive)) break;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        buffer.append("PartDeclarationPattern: pkg<");
        if (this.pkg != null) {
            buffer.append(this.pkg);
        }
        buffer.append(">, enclosing<");
        if (this.enclosingTypeNames != null) {
            int i = 0;
            while (i < this.enclosingTypeNames.length) {
                buffer.append(this.enclosingTypeNames[i]);
                if (i < this.enclosingTypeNames.length - 1) {
                    buffer.append('.');
                }
                ++i;
            }
        }
        buffer.append(">, type<");
        if (this.simpleName != null) {
            buffer.append(this.simpleName);
        }
        buffer.append(">, ");
        switch (this.matchMode) {
            case 0: {
                buffer.append("exact match, ");
                break;
            }
            case 1: {
                buffer.append("prefix match, ");
                break;
            }
            case 2: {
                buffer.append("pattern match, ");
            }
        }
        if (this.isCaseSensitive) {
            buffer.append("case sensitive");
        } else {
            buffer.append("case insensitive");
        }
        return buffer.toString();
    }

    private boolean matchesPartType(Part part) {
        boolean match = false;
        int partType = part.getPartType();
        switch (this.partTypes) {
            case '\u0001': {
                match = partType == 0;
                break;
            }
            case '\b': {
                match = partType == 1 && !this.isAnnotation(part);
                break;
            }
            case '\u0002': {
                match = partType == 1 && this.isAnnotation(part);
                break;
            }
            case '\u8000': {
                match = partType == 1 && this.isStereotype(part);
                break;
            }
            case '\u0010': {
                match = partType == 3;
                break;
            }
            case '\u0100': {
                match = partType == 8;
                break;
            }
            case '\u0080': {
                match = partType == 2;
                break;
            }
            case '@': {
                match = partType == 5;
                break;
            }
            case ' ': {
                match = partType == 4;
                break;
            }
            case '\u0004': {
                match = partType == 6;
                break;
            }
            case '\u0200': {
                match = partType == 9;
                break;
            }
            case '\u0400': {
                match = partType == 10;
                break;
            }
            case '\u0800': {
                match = partType == 11;
                break;
            }
            case '\u1000': {
                match = partType == 12;
                break;
            }
            case '\u2000': {
                match = partType == 13;
                break;
            }
            case '\u4000': {
                match = partType == 14;
                break;
            }
            case '\u7fff': {
                match = true;
            }
        }
        return match;
    }

    private boolean isAnnotation(IPart part) {
        try {
            SourcePartElementInfo partInfo = (SourcePartElementInfo)((EGLElement)((Object)part)).getElementInfo();
            return "eglx.lang.Annotation".equals(new String(partInfo.getSubTypeName())) || this.isStereotype(part);
        }
        catch (EGLModelException eGLModelException) {
            return false;
        }
    }

    private boolean isStereotype(IPart part) {
        try {
            SourcePartElementInfo partInfo = (SourcePartElementInfo)((EGLElement)((Object)part)).getElementInfo();
            return "eglx.lang.Stereotype".equals(new String(partInfo.getSubTypeName()));
        }
        catch (EGLModelException eGLModelException) {
            return false;
        }
    }

    private boolean isAnnotation(Part part) {
        Name name = part.getName();
        IBinding binding = name.resolveBinding();
        if (binding != null && binding instanceof PartBinding) {
            IAnnotationBinding subtype = ((PartBinding)binding).getSubTypeAnnotationBinding();
            return subtype instanceof AnnotationBinding && subtype.getType() instanceof AnnotationAnnotationTypeBinding;
        }
        return false;
    }

    private boolean isStereotype(Part part) {
        IAnnotationBinding subtype;
        Name name = part.getName();
        IBinding binding = name.resolveBinding();
        if (binding != null && binding instanceof PartBinding && (subtype = ((PartBinding)binding).getSubTypeAnnotationBinding()) instanceof AnnotationBinding && subtype.getType() instanceof AnnotationAnnotationTypeBinding) {
            IAnnotationBinding stereotype = subtype.getAnnotation((IAnnotationTypeBinding)StereotypeAnnotationTypeBinding.getInstance());
            return stereotype != null && stereotype.getType() instanceof StereotypeAnnotationTypeBinding;
        }
        return false;
    }

    private boolean matchesPartType(IPart part) {
        boolean match = false;
        try {
            SourcePartElementInfo partInfo = (SourcePartElementInfo)((EGLElement)((Object)part)).getElementInfo();
            switch (this.partTypes) {
                case '\u0001': {
                    match = partInfo.isProgram();
                    break;
                }
                case '\b': {
                    match = partInfo.isRecord() && !this.isAnnotation(part);
                    break;
                }
                case '\u0002': {
                    match = partInfo.isRecord() && this.isAnnotation(part);
                    break;
                }
                case '\u8000': {
                    match = partInfo.isRecord() && this.isStereotype(part);
                    break;
                }
                case '\u0010': {
                    match = partInfo.isDataItem();
                    break;
                }
                case '\u0100': {
                    match = partInfo.isLibrary();
                    break;
                }
                case '\u0080': {
                    match = partInfo.isFunction();
                    break;
                }
                case '@': {
                    match = partInfo.isFormGroup();
                    break;
                }
                case ' ': {
                    match = partInfo.isForm();
                    break;
                }
                case '\u0004': {
                    match = partInfo.isDataTable();
                    break;
                }
                case '\u0200': {
                    match = partInfo.isHandler();
                    break;
                }
                case '\u0400': {
                    match = partInfo.isService();
                    break;
                }
                case '\u0800': {
                    match = partInfo.isInterface();
                    break;
                }
                case '\u1000': {
                    match = partInfo.isDelegate();
                    break;
                }
                case '\u2000': {
                    match = partInfo.isExternalType();
                    break;
                }
                case '\u4000': {
                    match = partInfo.isEnumeration();
                    break;
                }
                case '\u7fff': {
                    match = true;
                }
            }
        }
        catch (EGLModelException e) {
            e.printStackTrace();
        }
        return match;
    }

    @Override
    public int getPatternType() {
        return 1;
    }
}

