/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.search.matching;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.edt.compiler.binding.FormBinding;
import org.eclipse.edt.compiler.binding.IAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.ImportDeclaration;
import org.eclipse.edt.compiler.core.ast.Lexer;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedForm;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.TopLevelFunction;
import org.eclipse.edt.compiler.internal.core.utils.CharOperation;
import org.eclipse.edt.ide.core.internal.model.index.IEntryResult;
import org.eclipse.edt.ide.core.internal.model.index.IIndex;
import org.eclipse.edt.ide.core.internal.model.index.impl.BlocksIndexInput;
import org.eclipse.edt.ide.core.internal.model.index.impl.IndexInput;
import org.eclipse.edt.ide.core.internal.search.IIndexSearchRequestor;
import org.eclipse.edt.ide.core.internal.search.matching.FunctionDeclarationPattern;
import org.eclipse.edt.ide.core.internal.search.matching.FunctionReferencePattern;
import org.eclipse.edt.ide.core.internal.search.matching.MatchLocator2;
import org.eclipse.edt.ide.core.internal.search.matching.MatchingNodeSet;
import org.eclipse.edt.ide.core.internal.search.matching.OrPattern;
import org.eclipse.edt.ide.core.internal.search.matching.PartDeclarationPattern;
import org.eclipse.edt.ide.core.internal.search.matching.PartReferencePattern;
import org.eclipse.edt.ide.core.internal.search.matching.QualifiedPartDeclarationPattern;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IFunction;
import org.eclipse.edt.ide.core.model.IIndexConstants;
import org.eclipse.edt.ide.core.model.IMember;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.search.IEGLSearchConstants;
import org.eclipse.edt.ide.core.search.IEGLSearchScope;
import org.eclipse.edt.ide.core.search.ISearchPattern;

public abstract class SearchPattern
implements ISearchPattern,
IIndexConstants,
IEGLSearchConstants {
    protected int matchMode;
    protected boolean isCaseSensitive;
    public boolean needsResolve = true;
    public IEGLElement focus;
    public static final int IMPOSSIBLE_MATCH = 0;
    public static final int POSSIBLE_MATCH = 1;
    public static final int ACCURATE_MATCH = 2;
    public static final int INACCURATE_MATCH = 3;
    public static final int EGL_FILE = 1;
    public static final int PART = 2;
    public static final int FIELD = 4;
    public static final int FUNCTION = 8;
    public static final int USE = 16;
    public static final int DECLARATION = 1;
    public static final int REFERENCE = 2;
    public static final int ALLOCCUR = 3;

    public SearchPattern(int matchMode, boolean isCaseSensitive) {
        this.matchMode = matchMode;
        this.isCaseSensitive = isCaseSensitive;
    }

    public static SearchPattern createPattern(String patternString, int searchFor, int limitTo, int matchMode, boolean isCaseSensitive) {
        if (patternString == null || patternString.length() == 0) {
            return null;
        }
        SearchPattern searchPattern = null;
        switch (searchFor) {
            case 0: {
                searchPattern = new OrPattern(SearchPattern.createPartPattern(patternString, Short.MAX_VALUE, limitTo, matchMode, isCaseSensitive), SearchPattern.createAllFunctionPattern(patternString, limitTo, matchMode, isCaseSensitive));
                break;
            }
            case 1: {
                searchPattern = SearchPattern.createPartPattern(patternString, '\u0001', limitTo, matchMode, isCaseSensitive);
                break;
            }
            case 4: {
                searchPattern = SearchPattern.createPartPattern(patternString, '\b', limitTo, matchMode, isCaseSensitive);
                break;
            }
            case 5: {
                searchPattern = SearchPattern.createPartPattern(patternString, '\u0010', limitTo, matchMode, isCaseSensitive);
                break;
            }
            case 9: {
                searchPattern = SearchPattern.createPartPattern(patternString, '\u0100', limitTo, matchMode, isCaseSensitive);
                break;
            }
            case 7: {
                searchPattern = SearchPattern.createPartPattern(patternString, '@', limitTo, matchMode, isCaseSensitive);
                break;
            }
            case 6: {
                searchPattern = SearchPattern.createPartPattern(patternString, ' ', limitTo, matchMode, isCaseSensitive);
                break;
            }
            case 3: {
                searchPattern = SearchPattern.createPartPattern(patternString, '\u0004', limitTo, matchMode, isCaseSensitive);
                break;
            }
            case 12: {
                searchPattern = SearchPattern.createPartPattern(patternString, '\u0200', limitTo, matchMode, isCaseSensitive);
                break;
            }
            case 15: {
                searchPattern = SearchPattern.createPartPattern(patternString, '\u1000', limitTo, matchMode, isCaseSensitive);
                break;
            }
            case 16: {
                searchPattern = SearchPattern.createPartPattern(patternString, '\u2000', limitTo, matchMode, isCaseSensitive);
                break;
            }
            case 17: {
                searchPattern = SearchPattern.createPartPattern(patternString, '\u4000', limitTo, matchMode, isCaseSensitive);
                break;
            }
            case 13: {
                searchPattern = SearchPattern.createPartPattern(patternString, '\u0400', limitTo, matchMode, isCaseSensitive);
                break;
            }
            case 14: {
                searchPattern = SearchPattern.createPartPattern(patternString, '\u0800', limitTo, matchMode, isCaseSensitive);
                break;
            }
            case 11: {
                break;
            }
            case 10: {
                searchPattern = SearchPattern.createAllFunctionPattern(patternString, limitTo, matchMode, isCaseSensitive);
                break;
            }
            case 8: {
                if (limitTo != 0) {
                    throw new UnsupportedOperationException();
                }
                searchPattern = SearchPattern.createPartPattern(patternString, '\u0080', limitTo, matchMode, isCaseSensitive);
                break;
            }
            case 18: {
                searchPattern = SearchPattern.createPartPattern(patternString, '\u0002', limitTo, matchMode, isCaseSensitive);
                break;
            }
            case 19: {
                searchPattern = SearchPattern.createPartPattern(patternString, '\u8000', limitTo, matchMode, isCaseSensitive);
            }
        }
        return searchPattern;
    }

    public static SearchPattern createPattern(IEGLElement element, int limitTo) {
        SearchPattern searchPattern = null;
        switch (element.getElementType()) {
            case 8: {
                IPart type = (IPart)element;
                searchPattern = SearchPattern.createPartPattern(type.getElementName().toCharArray(), type.getPackageFragment().getElementName().toCharArray(), SearchPattern.enclosingPartNames(type), limitTo);
            }
        }
        if (searchPattern != null) {
            searchPattern.focus = element;
        }
        return searchPattern;
    }

    private static SearchPattern createPartPattern(char[] simpleName, char[] packageName, char[][] enclosingPartNames, int limitTo) {
        PartDeclarationPattern searchPattern = null;
        switch (limitTo) {
            case 0: {
                searchPattern = new PartDeclarationPattern(packageName, enclosingPartNames, simpleName, (char)Short.MAX_VALUE, 0, true);
            }
        }
        return searchPattern;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static SearchPattern createFunctionPattern(String patternString, int limitTo, int matchMode, boolean isCaseSensitive) {
        lexer = new Lexer((Reader)new StringReader(patternString));
        mode = 1;
        declaringType = null;
        selector = null;
        parameterType = null;
        parameterTypes = null;
        parameterCount = -1;
        foundClosingParenthesis = false;
        try {
            token = lexer.next_token().sym;
            if (true) ** GOTO lbl65
        }
        catch (IOException v0) {
            return null;
        }
        do {
            block2 : switch (mode) {
                case 1: {
                    switch (token) {
                        case 45: {
                            if (declaringType == null) {
                                if (selector == null) {
                                    return null;
                                }
                                declaringType = selector;
                            } else {
                                tokenSource = new String(lexer.yytext());
                                declaringType = String.valueOf(declaringType) + tokenSource + selector;
                            }
                            selector = null;
                            break block2;
                        }
                        case 58: {
                            parameterTypes = new String[5];
                            parameterCount = 0;
                            mode = 2;
                            break block2;
                        }
                    }
                    if (selector == null) {
                        selector = new String(lexer.yytext());
                        break;
                    }
                    selector = String.valueOf(selector) + new String(lexer.yytext());
                    break;
                }
                case 2: {
                    switch (token) {
                        case 68: {
                            if (parameterType == null) {
                                return null;
                            }
                            if (parameterTypes.length == parameterCount) {
                                v1 = parameterTypes;
                                parameterTypes = new String[parameterCount * 2];
                                System.arraycopy(v1, 0, parameterTypes, 0, parameterCount);
                            }
                            parameterTypes[parameterCount++] = parameterType;
                            parameterType = null;
                            break block2;
                        }
                        case 59: {
                            foundClosingParenthesis = true;
                            if (parameterType == null) break block2;
                            if (parameterTypes.length == parameterCount) {
                                v2 = parameterTypes;
                                parameterTypes = new String[parameterCount * 2];
                                System.arraycopy(v2, 0, parameterTypes, 0, parameterCount);
                            }
                            parameterTypes[parameterCount++] = parameterType;
                            break block2;
                        }
                    }
                    parameterType = parameterType == null ? new String(lexer.yytext()) : String.valueOf(parameterType) + new String(lexer.yytext());
                }
            }
            try {
                token = lexer.next_token().sym;
            }
            catch (IOException v3) {
                return null;
            }
lbl65:
            // 2 sources

        } while (token != 0);
        if (parameterCount > 0 && !foundClosingParenthesis) {
            return null;
        }
        if (selector == null) {
            return null;
        }
        selectorChars = selector.toCharArray();
        if (selectorChars.length == 1 && selectorChars[0] == '*') {
            selectorChars = null;
        }
        declaringTypeQualification = null;
        parameterTypeQualifications /* !! */  = null;
        parameterTypeSimpleNames /* !! */  = null;
        if (declaringType != null && (declaringTypeQualification = declaringType.toCharArray()).length == 1 && declaringTypeQualification[0] == '*') {
            declaringTypeQualification = null;
        }
        if (parameterCount >= 0) {
            parameterTypeQualifications /* !! */  = new char[parameterCount][];
            parameterTypeSimpleNames /* !! */  = new char[parameterCount][];
            i = 0;
            while (i < parameterCount) {
                parameterTypePart = parameterTypes[i].toCharArray();
                lastDotPosition = CharOperation.lastIndexOf((char)'.', (char[])parameterTypePart);
                if (lastDotPosition >= 0) {
                    parameterTypeQualifications /* !! */ [i] = CharOperation.subarray((char[])parameterTypePart, (int)0, (int)lastDotPosition);
                    parameterTypeQualifications /* !! */ [i] = (char[])(parameterTypeQualifications /* !! */ [i].length == 1 && parameterTypeQualifications /* !! */ [i][0] == '*' ? null : CharOperation.concat((char[])SearchPattern.ONE_STAR, (char[])parameterTypeQualifications /* !! */ [i]));
                    parameterTypeSimpleNames /* !! */ [i] = CharOperation.subarray((char[])parameterTypePart, (int)(lastDotPosition + 1), (int)parameterTypePart.length);
                } else {
                    parameterTypeQualifications /* !! */ [i] = null;
                    parameterTypeSimpleNames /* !! */ [i] = parameterTypePart;
                }
                if (parameterTypeSimpleNames /* !! */ [i].length == 1 && parameterTypeSimpleNames /* !! */ [i][0] == '*') {
                    parameterTypeSimpleNames /* !! */ [i] = null;
                }
                ++i;
            }
        }
        searchPattern = null;
        switch (limitTo) {
            case 0: {
                searchPattern = SearchPattern.createPartPattern(patternString, '\u0080', limitTo, matchMode, isCaseSensitive);
                break;
            }
            case 1: {
                searchPattern = new FunctionReferencePattern(selectorChars, matchMode, isCaseSensitive, declaringTypeQualification, null);
                break;
            }
            case 2: {
                searchPattern = new OrPattern(SearchPattern.createPartPattern(patternString, '\u0080', limitTo, matchMode, isCaseSensitive), new FunctionReferencePattern(selectorChars, matchMode, isCaseSensitive, declaringTypeQualification, null));
            }
        }
        return searchPattern;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static SearchPattern createAllFunctionPattern(String patternString, int limitTo, int matchMode, boolean isCaseSensitive) {
        lexer = new Lexer((Reader)new StringReader(patternString));
        mode = 1;
        declaringType = null;
        selector = null;
        parameterType = null;
        parameterTypes = null;
        parameterCount = -1;
        foundClosingParenthesis = false;
        try {
            token = lexer.next_token().sym;
            if (true) ** GOTO lbl65
        }
        catch (IOException v0) {
            return null;
        }
        do {
            block2 : switch (mode) {
                case 1: {
                    switch (token) {
                        case 45: {
                            if (declaringType == null) {
                                if (selector == null) {
                                    return null;
                                }
                                declaringType = selector;
                            } else {
                                tokenSource = new String(lexer.yytext());
                                declaringType = String.valueOf(declaringType) + tokenSource + selector;
                            }
                            selector = null;
                            break block2;
                        }
                        case 58: {
                            parameterTypes = new String[5];
                            parameterCount = 0;
                            mode = 2;
                            break block2;
                        }
                    }
                    if (selector == null) {
                        selector = new String(lexer.yytext());
                        break;
                    }
                    selector = String.valueOf(selector) + new String(lexer.yytext());
                    break;
                }
                case 2: {
                    switch (token) {
                        case 68: {
                            if (parameterType == null) {
                                return null;
                            }
                            if (parameterTypes.length == parameterCount) {
                                v1 = parameterTypes;
                                parameterTypes = new String[parameterCount * 2];
                                System.arraycopy(v1, 0, parameterTypes, 0, parameterCount);
                            }
                            parameterTypes[parameterCount++] = parameterType;
                            parameterType = null;
                            break block2;
                        }
                        case 59: {
                            foundClosingParenthesis = true;
                            if (parameterType == null) break block2;
                            if (parameterTypes.length == parameterCount) {
                                v2 = parameterTypes;
                                parameterTypes = new String[parameterCount * 2];
                                System.arraycopy(v2, 0, parameterTypes, 0, parameterCount);
                            }
                            parameterTypes[parameterCount++] = parameterType;
                            break block2;
                        }
                    }
                    parameterType = parameterType == null ? new String(lexer.yytext()) : String.valueOf(parameterType) + new String(lexer.yytext());
                }
            }
            try {
                token = lexer.next_token().sym;
            }
            catch (IOException v3) {
                return null;
            }
lbl65:
            // 2 sources

        } while (token != 0);
        if (parameterCount > 0 && !foundClosingParenthesis) {
            return null;
        }
        if (selector == null) {
            return null;
        }
        selectorChars = selector.toCharArray();
        if (selectorChars.length == 1 && selectorChars[0] == '*') {
            selectorChars = null;
        }
        declaringTypeQualification = null;
        parameterTypeQualifications /* !! */  = null;
        parameterTypeSimpleNames /* !! */  = null;
        if (declaringType != null && (declaringTypeQualification = declaringType.toCharArray()).length == 1 && declaringTypeQualification[0] == '*') {
            declaringTypeQualification = null;
        }
        if (parameterCount >= 0) {
            parameterTypeQualifications /* !! */  = new char[parameterCount][];
            parameterTypeSimpleNames /* !! */  = new char[parameterCount][];
            i = 0;
            while (i < parameterCount) {
                parameterTypePart = parameterTypes[i].toCharArray();
                lastDotPosition = CharOperation.lastIndexOf((char)'.', (char[])parameterTypePart);
                if (lastDotPosition >= 0) {
                    parameterTypeQualifications /* !! */ [i] = CharOperation.subarray((char[])parameterTypePart, (int)0, (int)lastDotPosition);
                    parameterTypeQualifications /* !! */ [i] = (char[])(parameterTypeQualifications /* !! */ [i].length == 1 && parameterTypeQualifications /* !! */ [i][0] == '*' ? null : CharOperation.concat((char[])SearchPattern.ONE_STAR, (char[])parameterTypeQualifications /* !! */ [i]));
                    parameterTypeSimpleNames /* !! */ [i] = CharOperation.subarray((char[])parameterTypePart, (int)(lastDotPosition + 1), (int)parameterTypePart.length);
                } else {
                    parameterTypeQualifications /* !! */ [i] = null;
                    parameterTypeSimpleNames /* !! */ [i] = parameterTypePart;
                }
                if (parameterTypeSimpleNames /* !! */ [i].length == 1 && parameterTypeSimpleNames /* !! */ [i][0] == '*') {
                    parameterTypeSimpleNames /* !! */ [i] = null;
                }
                ++i;
            }
        }
        searchPattern /* !! */  = null;
        switch (limitTo) {
            case 0: {
                searchPattern /* !! */  = new FunctionDeclarationPattern(selectorChars, matchMode, isCaseSensitive, declaringTypeQualification);
                break;
            }
            case 1: {
                searchPattern /* !! */  = new FunctionReferencePattern(selectorChars, matchMode, isCaseSensitive, declaringTypeQualification, null);
                break;
            }
            case 2: {
                searchPattern /* !! */  = new OrPattern(new FunctionDeclarationPattern(selectorChars, matchMode, isCaseSensitive, declaringTypeQualification), new FunctionReferencePattern(selectorChars, matchMode, isCaseSensitive, declaringTypeQualification, null));
            }
        }
        return searchPattern /* !! */ ;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static SearchPattern createPartPattern(String patternString, char searchFor, int limitTo, int matchMode, boolean isCaseSensitive) {
        lexer = new Lexer((Reader)new StringReader(patternString));
        part = null;
        try {
            token = lexer.next_token().sym;
            if (true) ** GOTO lbl15
        }
        catch (IOException v0) {
            return null;
        }
        do {
            part = part == null ? lexer.yytext() : String.valueOf(part) + lexer.yytext();
            try {
                token = lexer.next_token().sym;
            }
            catch (IOException v1) {
                return null;
            }
lbl15:
            // 2 sources

        } while (token != 0);
        if (part == null) {
            return null;
        }
        qualificationChars = null;
        typeChars = null;
        if (part != null) {
            typePart = part.toCharArray();
            lastDotPosition = CharOperation.lastIndexOf((char)'.', (char[])typePart);
            if (lastDotPosition >= 0) {
                qualificationChars = CharOperation.subarray((char[])typePart, (int)0, (int)lastDotPosition);
                if (qualificationChars.length == 1 && qualificationChars[0] == '*') {
                    qualificationChars = null;
                }
                typeChars = CharOperation.subarray((char[])typePart, (int)(lastDotPosition + 1), (int)typePart.length);
            } else {
                qualificationChars = null;
                typeChars = typePart;
            }
        }
        searchPattern /* !! */  = null;
        switch (limitTo) {
            case 0: {
                searchPattern /* !! */  = new QualifiedPartDeclarationPattern(qualificationChars, typeChars, searchFor, matchMode, isCaseSensitive);
                break;
            }
            case 1: {
                searchPattern /* !! */  = new PartReferencePattern(qualificationChars, typeChars, searchFor, matchMode, isCaseSensitive);
                break;
            }
            case 2: {
                searchPattern /* !! */  = new OrPattern(new QualifiedPartDeclarationPattern(qualificationChars, typeChars, searchFor, matchMode, isCaseSensitive), new PartReferencePattern(qualificationChars, typeChars, searchFor, matchMode, isCaseSensitive));
            }
        }
        return searchPattern /* !! */ ;
    }

    protected abstract void decodeIndexEntry(IEntryResult var1);

    private static char[][] enclosingPartNames(IPart type) {
        IEGLElement parent = type.getParent();
        switch (parent.getElementType()) {
            case 6: {
                return CharOperation.NO_CHAR_CHAR;
            }
            case 8: {
                return CharOperation.arrayConcat((char[][])SearchPattern.enclosingPartNames((IPart)parent), (char[])parent.getElementName().toCharArray());
            }
        }
        return null;
    }

    public abstract void feedIndexRequestor(IIndexSearchRequestor var1, int var2, int[] var3, IndexInput var4, IEGLSearchScope var5) throws IOException;

    public void findIndexMatches(IIndex index, IIndexSearchRequestor requestor, int detailLevel, IProgressMonitor progressMonitor, IEGLSearchScope scope) throws IOException {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        BlocksIndexInput input = new BlocksIndexInput(index.getIndexFile());
        try {
            ((IndexInput)input).open();
            this.findIndexMatches(input, requestor, detailLevel, progressMonitor, scope);
        }
        finally {
            ((IndexInput)input).close();
        }
    }

    public void findIndexMatches(IndexInput input, IIndexSearchRequestor requestor, int detailLevel, IProgressMonitor progressMonitor, IEGLSearchScope scope) throws IOException {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        IEntryResult[] entries = input.queryEntriesPrefixedBy(this.indexEntryPrefix());
        if (entries == null) {
            return;
        }
        int i = 0;
        int max = entries.length;
        while (i < max) {
            if (progressMonitor != null && progressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            IEntryResult entry = entries[i];
            this.decodeIndexEntry(entry);
            if (this.matchIndexEntry()) {
                this.feedIndexRequestor(requestor, detailLevel, entry.getFileReferences(), input, scope);
            }
            ++i;
        }
    }

    public abstract char[] indexEntryPrefix();

    protected abstract int matchContainer();

    public boolean matchesBinary(Object binaryInfo, Object enclosingBinaryInfo) {
        return false;
    }

    protected void matchCheck(Node node, MatchingNodeSet set) {
        int matchLevel = this.matchLevel(node, false);
        switch (matchLevel) {
            case 1: {
                set.addPossibleMatch(node);
                break;
            }
            case 2: {
                set.addTrustedMatch(node);
            }
        }
    }

    protected int matchCheck(Node node) {
        int matchLevel = this.matchLevel(node, false);
        return matchLevel;
    }

    protected int matchCheck(IMember member) {
        int matchLevel = this.matchLevel(member, false);
        return matchLevel;
    }

    protected boolean matchesName(char[] pattern, char[] name) {
        if (pattern == null) {
            return true;
        }
        if (name != null) {
            switch (this.matchMode) {
                case 0: {
                    return CharOperation.equals((char[])pattern, (char[])name, (boolean)this.isCaseSensitive);
                }
                case 1: {
                    return CharOperation.prefixEquals((char[])pattern, (char[])name, (boolean)this.isCaseSensitive);
                }
                case 2: {
                    if (!this.isCaseSensitive) {
                        pattern = CharOperation.toLowerCase((char[])pattern);
                    }
                    return CharOperation.match((char[])pattern, (char[])name, (boolean)this.isCaseSensitive);
                }
            }
        }
        return false;
    }

    protected boolean matchesType(char[] simpleNamePattern, char[] qualificationPattern, char[] fullyQualifiedTypeName) {
        char[] pattern = simpleNamePattern == null ? (qualificationPattern == null ? ONE_STAR : CharOperation.concat((char[])qualificationPattern, (char[])ONE_STAR, (char)'.')) : (qualificationPattern == null ? CharOperation.concat((char[])ONE_STAR, (char[])simpleNamePattern) : CharOperation.concat((char[])qualificationPattern, (char[])simpleNamePattern, (char)'.'));
        if (!this.isCaseSensitive) {
            pattern = CharOperation.toLowerCase((char[])pattern);
        }
        return CharOperation.match((char[])pattern, (char[])fullyQualifiedTypeName, (boolean)this.isCaseSensitive);
    }

    protected abstract boolean matchIndexEntry();

    public abstract int matchLevel(Node var1, boolean var2);

    public abstract int matchLevel(IMember var1, boolean var2);

    protected char[] toArrayName(char[] simpleName, int dimensions) {
        if (dimensions == 0) {
            return simpleName;
        }
        int length = simpleName.length;
        char[] result = new char[length + dimensions * 2];
        System.arraycopy(simpleName, 0, result, 0, length);
        int i = 0;
        while (i < dimensions) {
            result[simpleName.length + i * 2] = 91;
            result[simpleName.length + i * 2 + 1] = 93;
            ++i;
        }
        return result;
    }

    public String toString() {
        return "SearchPattern";
    }

    protected void matchReportImportRef(ImportDeclaration importRef, IEGLElement element, int accuracy, MatchLocator2 locator) throws CoreException {
        this.matchReportReference((Node)importRef.getName(), element, accuracy, locator);
    }

    protected void matchReportReference(Node reference, IEGLElement element, int accuracy, MatchLocator2 locator) throws CoreException {
        locator.report(reference.getOffset(), reference.getOffset() + reference.getLength(), element, accuracy);
    }

    protected IPartBinding getPartBinding(Part part) {
        return this.getPartBinding(part.getName());
    }

    protected IPartBinding getPartBinding(Name name) {
        IBinding b = name.resolveBinding();
        if (b != null && b != IBinding.NOT_FOUND_BINDING) {
            ITypeBinding typeBinding;
            ITypeBinding iTypeBinding = typeBinding = b.isTypeBinding() ? (ITypeBinding)b : null;
            if (b.isDataBinding()) {
                typeBinding = ((IDataBinding)b).getType();
            }
            if (typeBinding != null && typeBinding != IBinding.NOT_FOUND_BINDING && typeBinding.isPartBinding()) {
                return (IPartBinding)typeBinding;
            }
            if (typeBinding == null && b instanceof IPartBinding) {
                return (IPartBinding)b;
            }
        }
        return null;
    }

    protected int matchLevelForType(char[] simpleNamePattern, char[] qualificationPattern, TopLevelFunction function) {
        if (function == null) {
            return 3;
        }
        IPartBinding partBinding = this.getPartBinding((Part)function);
        if (partBinding == null || partBinding == IBinding.NOT_FOUND_BINDING) {
            return 3;
        }
        return this.matchLevelForType(simpleNamePattern, qualificationPattern, partBinding);
    }

    protected int matchLevelForType(char[] simpleNamePattern, char[] qualificationPattern, IPartBinding partBinding) {
        char[] qualifiedPackageName;
        IPartBinding topLevelPart;
        if (partBinding == null) {
            return 3;
        }
        StringBuffer qualifiedPartName = new StringBuffer();
        if (partBinding.getKind() == 8 && ((FormBinding)partBinding).isNestedForm()) {
            topLevelPart = ((FormBinding)partBinding).getEnclosingFormGroup();
            qualifiedPartName.append(topLevelPart.getName());
            qualifiedPartName.append("." + partBinding.getName());
        } else {
            topLevelPart = partBinding;
            qualifiedPartName.append(partBinding.getName());
        }
        StringBuffer result = new StringBuffer();
        String[] packageName = partBinding.getPackageName();
        if (packageName != null) {
            int i = 0;
            while (i < packageName.length) {
                result.append(packageName[i]);
                if (i + 1 < packageName.length) {
                    result.append('.');
                }
                ++i;
            }
            qualifiedPackageName = result.toString().toCharArray();
        } else {
            qualifiedPackageName = null;
        }
        char[] qualifiedSourceName = qualifiedPartName.toString().toCharArray();
        if (this.matchesType(simpleNamePattern, qualificationPattern, qualifiedPackageName == null ? qualifiedSourceName : CharOperation.concat((char[])qualifiedPackageName, (char[])qualifiedSourceName, (char)'.'))) {
            return 2;
        }
        if (partBinding.getKind() == 8 && ((FormBinding)partBinding).isNestedForm() && new String(qualificationPattern).indexOf(46) == -1 ? this.matchesType(CharOperation.concat((char[])qualificationPattern, (char[])simpleNamePattern, (char)'.'), null, qualifiedPackageName == null ? qualifiedSourceName : CharOperation.concat((char[])qualifiedPackageName, (char[])qualifiedSourceName, (char)'.')) : qualificationPattern != null && new String(qualificationPattern).indexOf(46) == -1 && this.matchesType(CharOperation.concat((char[])qualificationPattern, (char[])simpleNamePattern, (char)'.'), null, qualifiedPackageName == null ? qualifiedSourceName : CharOperation.concat((char[])qualifiedPackageName, (char[])qualifiedSourceName, (char)'.'))) {
            return 2;
        }
        return 0;
    }

    protected int matchLevelForType(char[] simpleNamePattern, char[] qualificationPattern, IAnnotationTypeBinding binding) {
        char[] qualifiedPackageName;
        if (binding == null) {
            return 3;
        }
        StringBuffer qualifiedPartName = new StringBuffer();
        qualifiedPartName.append(binding.getName());
        StringBuffer result = new StringBuffer();
        String[] packageName = binding.getPackageName();
        if (packageName != null) {
            int i = 0;
            while (i < packageName.length) {
                result.append(packageName[i]);
                if (i + 1 < packageName.length) {
                    result.append('.');
                }
                ++i;
            }
            qualifiedPackageName = result.toString().toCharArray();
        } else {
            qualifiedPackageName = null;
        }
        char[] qualifiedSourceName = qualifiedPartName.toString().toCharArray();
        if (this.matchesType(simpleNamePattern, qualificationPattern, qualifiedPackageName == null ? qualifiedSourceName : CharOperation.concat((char[])qualifiedPackageName, (char[])qualifiedSourceName, (char)'.'))) {
            return 2;
        }
        if (qualificationPattern != null && new String(qualificationPattern).indexOf(46) == -1 && this.matchesType(CharOperation.concat((char[])qualificationPattern, (char[])simpleNamePattern, (char)'.'), null, qualifiedPackageName == null ? qualifiedSourceName : CharOperation.concat((char[])qualifiedPackageName, (char[])qualifiedSourceName, (char)'.'))) {
            return 2;
        }
        return 0;
    }

    protected int matchLevelForType(char[] simpleNamePattern, char[] qualificationPattern, IPart part) {
        if (part == null) {
            return 3;
        }
        StringBuffer qualifiedPartName = new StringBuffer();
        IPart topLevelPart = part;
        qualifiedPartName.append(part.getElementName());
        if (this.matchesType(simpleNamePattern, qualificationPattern, topLevelPart.getFullyQualifiedName().toCharArray())) {
            return 2;
        }
        if (qualificationPattern != null && new String(qualificationPattern).indexOf(46) == -1 && this.matchesType(CharOperation.concat((char[])qualificationPattern, (char[])simpleNamePattern, (char)'.'), null, topLevelPart.getFullyQualifiedName().toCharArray())) {
            return 2;
        }
        return 0;
    }

    public int matchesPartType(Name node, IPartBinding partBinding, boolean forceQualification) {
        return 0;
    }

    public int matchesNestedFormPart(NestedForm node) {
        return 0;
    }

    public int matchesPart(Part node) {
        return 0;
    }

    public int matchesPart(IPart part) {
        return 0;
    }

    public int matchesAnnotationType(Name node, IAnnotationTypeBinding binding, boolean forceQualification) {
        return 0;
    }

    public int matchesFunctionPartType(Name node, IPartBinding partBinding) {
        return 0;
    }

    public int matchesFunctionPartType(IFunction function) {
        return 0;
    }

    public int matchesFunctionPart(TopLevelFunction function) {
        return 0;
    }

    public abstract int getPatternType();
}

