/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.deployment.services.internal.testserver;

import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.edt.compiler.internal.PartWrapper;
import org.eclipse.edt.compiler.tools.IRUtils;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.core.utils.DefaultDeploymentDescriptorUtility;
import org.eclipse.edt.ide.deployment.core.model.DeploymentDesc;
import org.eclipse.edt.ide.internal.sql.util.EGLSQLUtility;
import org.eclipse.edt.ide.testserver.ClasspathUtil;
import org.eclipse.edt.ide.testserver.TestServerPlugin;
import org.eclipse.edt.javart.resources.egldd.SQLDatabaseBinding;

public class DDUtil {
    public static void addJDBCJars(IProject project, Set<IProject> seenProjects, final Set<IResource> seenDDs, final List<String> classpath) {
        IFile ddFile;
        if (seenProjects.contains(project)) {
            return;
        }
        seenProjects.add(project);
        PartWrapper defaultDD = DefaultDeploymentDescriptorUtility.getDefaultDeploymentDescriptor((IResource)project);
        if (defaultDD.getPartPath() != null && defaultDD.getPartPath().length() > 0 && !seenDDs.contains(ddFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(defaultDD.getPartPath()))) && ddFile.exists()) {
            seenDDs.add((IResource)ddFile);
            DDUtil.parseDD((IResource)ddFile, classpath, seenDDs);
        }
        try {
            IWorkspaceRoot root;
            if (!project.hasNature("org.eclipse.edt.ide.core.eglnature")) {
                return;
            }
            IEGLProject eglProject = EGLCore.create((IProject)project);
            if (eglProject == null) {
                return;
            }
            IPackageFragmentRoot[] iPackageFragmentRootArray = eglProject.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                root = iPackageFragmentRootArray[n2];
                if (root.getResource() != null) {
                    root.getResource().accept(new IResourceProxyVisitor(){

                        public boolean visit(IResourceProxy proxy) throws CoreException {
                            if (proxy.getType() == 1) {
                                if (IRUtils.matchesFileName((String)proxy.getName(), (char[])ClasspathUtil.SUFFIX_egldd, (char[])ClasspathUtil.SUFFIX_EGLDD) && !seenDDs.contains(proxy.requestResource())) {
                                    IResource ddFile = proxy.requestResource();
                                    seenDDs.add(ddFile);
                                    DDUtil.parseDD(ddFile, classpath, seenDDs);
                                }
                                return false;
                            }
                            return true;
                        }
                    }, 0);
                }
                ++n2;
            }
            root = ResourcesPlugin.getWorkspace().getRoot();
            IEGLPathEntry[] iEGLPathEntryArray = eglProject.getResolvedEGLPath(true);
            int n3 = iEGLPathEntryArray.length;
            n = 0;
            while (n < n3) {
                IResource resource;
                IEGLPathEntry entry = iEGLPathEntryArray[n];
                if (entry.getEntryKind() == 2 && (resource = root.findMember(entry.getPath())) != null && resource.getType() == 4 && resource.isAccessible()) {
                    DDUtil.addJDBCJars((IProject)resource, seenProjects, seenDDs, classpath);
                }
                ++n;
            }
        }
        catch (CoreException e) {
            TestServerPlugin.getDefault().log(e.getMessage(), (Exception)((Object)e));
        }
    }

    private static void parseDD(IResource file, List<String> classpath, Set<IResource> seenDDs) {
        try {
            DeploymentDesc dd = DeploymentDesc.createDeploymentDescriptor((String)file.getLocation().toOSString());
            List bindings = dd.getSqlDatabaseBindings();
            if (bindings.size() > 0) {
                for (SQLDatabaseBinding binding : bindings) {
                    String jars = null;
                    if (binding.isUseURI()) {
                        IConnectionProfile profile;
                        String uri = binding.getUri();
                        if (uri == null) continue;
                        if ((uri = uri.trim()).startsWith("workspace://") && (profile = EGLSQLUtility.getConnectionProfile((String)uri.substring(12))) != null) {
                            jars = EGLSQLUtility.getLoadingPath((IConnectionProfile)profile);
                        }
                    } else {
                        jars = binding.getJarList();
                    }
                    if (jars == null || (jars = jars.trim()).length() <= 0) continue;
                    StringTokenizer tok = new StringTokenizer(jars, File.pathSeparator);
                    while (tok.hasMoreTokens()) {
                        String next = tok.nextToken();
                        String entry = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><runtimeClasspathEntry externalArchive=\"" + next + "\" path=\"3\" type=\"2\"/>";
                        if (classpath.contains(entry)) continue;
                        classpath.add(entry);
                    }
                }
            }
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            for (String include : dd.getIncludes()) {
                IResource resource = root.findMember(include);
                if (resource == null || !resource.isAccessible() || seenDDs.contains(resource)) continue;
                seenDDs.add(resource);
                DDUtil.parseDD(resource, classpath, seenDDs);
            }
        }
        catch (Exception e) {
            TestServerPlugin.getDefault().log(e.getMessage(), e);
        }
    }
}

