/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.wizards.insertwidget;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.DataTemplate;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetDescriptorRegistry;
import org.eclipse.edt.ide.rui.visualeditor.internal.wizards.insertwidget.InsertDataModel;
import org.eclipse.edt.ide.rui.visualeditor.internal.wizards.insertwidget.WidgetType;
import org.eclipse.edt.ide.rui.visualeditor.internal.wizards.util.NameFinder;
import org.eclipse.edt.ide.rui.visualeditor.plugin.Activator;

public class InsertDataNode {
    private InsertDataNode parent;
    private List<InsertDataNode> children;
    private InsertDataModel model;
    private String nodeType;
    private Set<String> nodeTypeDetails;
    private boolean isArray;
    private boolean isContainer;
    private String purpose;
    private String bindingName;
    private boolean isGen;
    private List<DataTemplate> dataTemplates;
    private List<DataTemplate> forDisplayDataTemplates;
    private List<DataTemplate> forCreateDataTemplates;
    private List<DataTemplate> forUpdateDataTemplates;
    private String fieldName;
    private String fieldType;
    private String labelText;
    private WidgetType widgetType;
    private WidgetType[] widgetTypes;
    private WidgetType[] forDisplayWidgetTypes;
    private WidgetType[] forCreateWidgetTypes;
    private WidgetType[] forUpdateWidgetTypes;
    private String widgetName;

    public InsertDataNode(InsertDataModel model, String bindingName, String fieldType) {
        this.model = model;
        this.children = new ArrayList<InsertDataNode>();
        this.bindingName = bindingName;
        this.fieldType = fieldType;
        this.nodeTypeDetails = new HashSet<String>();
        this.purpose = "FOR_DISPLAY";
        this.createFieldName();
    }

    private void createFieldName() {
        this.fieldName = this.bindingName.contains(".") ? this.bindingName.substring(this.bindingName.lastIndexOf(".") + 1, this.bindingName.length()) : this.bindingName;
    }

    public InsertDataModel getModel() {
        return this.model;
    }

    public String getBindingName() {
        return this.bindingName;
    }

    public void setBindingName(String bindingName) {
        this.bindingName = bindingName;
    }

    public InsertDataNode getParent() {
        return this.parent;
    }

    public void setParent(InsertDataNode parent) {
        this.parent = parent;
    }

    public List<InsertDataNode> getChildren() {
        return this.children;
    }

    public void addChild(InsertDataNode child) {
        this.children.add(child);
        child.setParent(this);
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public void setChildren(List<InsertDataNode> children) {
        this.children = children;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    public boolean isGen() {
        return this.isGen;
    }

    public void setGen(boolean isGen) {
        this.isGen = isGen;
    }

    public Set<String> getNodeTypeDetails() {
        return this.nodeTypeDetails;
    }

    public void addNodeTypeDetail(String nodeTypeDetail) {
        if (nodeTypeDetail != null) {
            this.nodeTypeDetails.add(nodeTypeDetail);
        }
    }

    public void removeNodeTypeDetail(String nodeTypeDetail) {
        this.nodeTypeDetails.remove(nodeTypeDetail);
    }

    public boolean isArray() {
        return this.isArray;
    }

    public void setArray(boolean isArray) {
        this.isArray = isArray;
    }

    public boolean isContainer() {
        return this.isContainer;
    }

    public void setContainer(boolean isContainer) {
        this.isContainer = isContainer;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
    }

    public String getLabelText() {
        if (this.labelText == null) {
            int lastIndex = this.bindingName.lastIndexOf(".");
            this.labelText = lastIndex == -1 ? this.bindingName : this.bindingName.substring(lastIndex + 1);
        }
        return this.labelText;
    }

    public void setLabelText(String labelText) {
        this.labelText = labelText;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public void update() {
        this.widgetTypes = null;
        this.widgetType = null;
    }

    public WidgetType[] getWidgetTypes() {
        WidgetType defaultWidgetType;
        WidgetType widgetType;
        DataTemplate dataTemplate;
        int i;
        List<DataTemplate> dataTemplatesTime;
        boolean isTimeStamp;
        boolean bl = isTimeStamp = this.fieldType.equalsIgnoreCase("timestamp(\"hhmmss\")") || this.fieldType.equalsIgnoreCase("timestamp(\"yyyyMMddhhmmss\")") || this.fieldType.equalsIgnoreCase("timestamp");
        if (this.purpose.equals("FOR_DISPLAY")) {
            if (this.forDisplayWidgetTypes == null) {
                this.forDisplayDataTemplates = WidgetDescriptorRegistry.getInstance(this.model.getProject()).getMappingDescriptorDataTemplates(this.purpose, this.nodeType, this.nodeTypeDetails, this.isArray, this.isContainer);
                if (isTimeStamp) {
                    HashSet<String> timeNodeTypeDetails = new HashSet<String>();
                    timeNodeTypeDetails.add("TYPE_PRIMITIVE_TIME");
                    dataTemplatesTime = WidgetDescriptorRegistry.getInstance(this.model.getProject()).getMappingDescriptorDataTemplates(this.purpose, null, timeNodeTypeDetails, this.isArray, this.isContainer);
                    for (DataTemplate dataTemplate2 : dataTemplatesTime) {
                        if (!dataTemplate2.getName().equals("DojoTimeTextBox (read only)")) continue;
                        this.forDisplayDataTemplates.add(dataTemplate2);
                    }
                }
                this.forDisplayWidgetTypes = new WidgetType[this.forDisplayDataTemplates.size()];
                i = 0;
                while (i < this.forDisplayWidgetTypes.length) {
                    dataTemplate = this.forDisplayDataTemplates.get(i);
                    this.forDisplayWidgetTypes[i] = widgetType = new WidgetType(dataTemplate.getName(), dataTemplate.getWidgetDescriptor().getType());
                    ++i;
                }
            }
            this.dataTemplates = this.forDisplayDataTemplates;
            this.widgetTypes = this.forDisplayWidgetTypes;
        }
        if (this.purpose.equals("FOR_CREATE")) {
            if (this.forCreateWidgetTypes == null) {
                this.forCreateDataTemplates = WidgetDescriptorRegistry.getInstance(this.model.getProject()).getMappingDescriptorDataTemplates(this.purpose, this.nodeType, this.nodeTypeDetails, this.isArray, this.isContainer);
                if (isTimeStamp) {
                    HashSet<String> timeNodeTypeDetails = new HashSet<String>();
                    timeNodeTypeDetails.add("TYPE_PRIMITIVE_TIME");
                    dataTemplatesTime = WidgetDescriptorRegistry.getInstance(this.model.getProject()).getMappingDescriptorDataTemplates(this.purpose, null, timeNodeTypeDetails, this.isArray, this.isContainer);
                    for (DataTemplate dataTemplate2 : dataTemplatesTime) {
                        if (!dataTemplate2.getName().equals("DojoTimeTextBox")) continue;
                        this.forCreateDataTemplates.add(dataTemplate2);
                    }
                }
                this.forCreateWidgetTypes = new WidgetType[this.forCreateDataTemplates.size()];
                i = 0;
                while (i < this.forCreateWidgetTypes.length) {
                    dataTemplate = this.forCreateDataTemplates.get(i);
                    this.forCreateWidgetTypes[i] = widgetType = new WidgetType(dataTemplate.getName(), dataTemplate.getWidgetDescriptor().getType());
                    ++i;
                }
            }
            this.dataTemplates = this.forCreateDataTemplates;
            this.widgetTypes = this.forCreateWidgetTypes;
        }
        if (this.purpose.equals("FOR_UPDATE")) {
            if (this.forUpdateWidgetTypes == null) {
                this.forUpdateDataTemplates = WidgetDescriptorRegistry.getInstance(this.model.getProject()).getMappingDescriptorDataTemplates(this.purpose, this.nodeType, this.nodeTypeDetails, this.isArray, this.isContainer);
                if (isTimeStamp) {
                    HashSet<String> timeNodeTypeDetails = new HashSet<String>();
                    timeNodeTypeDetails.add("TYPE_PRIMITIVE_TIME");
                    dataTemplatesTime = WidgetDescriptorRegistry.getInstance(this.model.getProject()).getMappingDescriptorDataTemplates(this.purpose, null, timeNodeTypeDetails, this.isArray, this.isContainer);
                    for (DataTemplate dataTemplate2 : dataTemplatesTime) {
                        if (!dataTemplate2.getName().equals("DojoTimeTextBox") && !dataTemplate2.getName().equals("DojoTimeTextBox (read only)")) continue;
                        this.forUpdateDataTemplates.add(dataTemplate2);
                    }
                }
                this.forUpdateWidgetTypes = new WidgetType[this.forUpdateDataTemplates.size()];
                i = 0;
                while (i < this.forUpdateWidgetTypes.length) {
                    dataTemplate = this.forUpdateDataTemplates.get(i);
                    this.forUpdateWidgetTypes[i] = widgetType = new WidgetType(dataTemplate.getName(), dataTemplate.getWidgetDescriptor().getType());
                    ++i;
                }
            }
            this.dataTemplates = this.forUpdateDataTemplates;
            this.widgetTypes = this.forUpdateWidgetTypes;
        }
        if ((defaultWidgetType = this.getDefaultWidgetType()) != null) {
            int i2 = 0;
            while (i2 < this.widgetTypes.length) {
                if (this.widgetTypes[i2].getName().equalsIgnoreCase(defaultWidgetType.getName())) {
                    this.widgetTypes[i2] = this.widgetTypes[0];
                    this.widgetTypes[0] = defaultWidgetType;
                }
                ++i2;
            }
        }
        return this.widgetTypes;
    }

    public WidgetType getDefaultWidgetType() {
        WidgetType defaultWidgetType = null;
        String defaultWidgetTypeName = Activator.getDefault().getPreferenceStore().getString(String.valueOf(this.bindingName) + this.purpose);
        if (defaultWidgetTypeName == null || defaultWidgetTypeName.equals("")) {
            for (DataTemplate dataTemplate : this.dataTemplates) {
                if (!dataTemplate.getDataMapping().isDefault()) continue;
                defaultWidgetType = new WidgetType(dataTemplate.getName(), dataTemplate.getWidgetDescriptor().getType());
                break;
            }
        } else {
            for (DataTemplate dataTemplate : this.dataTemplates) {
                if (!defaultWidgetTypeName.equalsIgnoreCase(dataTemplate.getName())) continue;
                defaultWidgetType = new WidgetType(dataTemplate.getName(), dataTemplate.getWidgetDescriptor().getType());
                break;
            }
        }
        return defaultWidgetType;
    }

    public DataTemplate getDataTemplate() {
        for (DataTemplate dataTemplate : this.dataTemplates) {
            if (!dataTemplate.getName().equals(this.widgetType.getName())) continue;
            return dataTemplate;
        }
        return null;
    }

    public WidgetType getWidgetType() {
        if (this.widgetTypes == null) {
            this.getWidgetTypes();
            this.widgetType = this.widgetTypes.length == 0 ? new WidgetType("None", "None") : this.widgetTypes[0];
        }
        return this.widgetType;
    }

    public void setWidgetType(WidgetType widgetType) {
        this.widgetType = widgetType;
    }

    public String getWidgetName() {
        return this.widgetName;
    }

    public void setWidgetName(String widgetName) {
        this.widgetName = widgetName;
    }

    public String getDefaultWidgetName() {
        String tempWidgetName;
        int i = 0;
        String defaultWidgetName = tempWidgetName = String.valueOf(this.bindingName.replace(".", "_")) + "_" + this.getShortWidgetType();
        while (this.isFieldNameExist(defaultWidgetName)) {
            defaultWidgetName = String.valueOf(tempWidgetName) + ++i;
        }
        return defaultWidgetName;
    }

    private String getShortWidgetType() {
        String shortWidgetType;
        if (this.parent == null) {
            shortWidgetType = "ui";
        } else {
            WidgetType widgetType = this.getWidgetType();
            String widgetTypeType = widgetType.getType();
            ArrayList<String> widgetTypeShortNames = new ArrayList<String>();
            int i = 0;
            while (i < widgetTypeType.length()) {
                char character = widgetTypeType.charAt(i);
                if (character >= 'A' && character <= 'Z') {
                    String widgetTypeShortName = widgetTypeType.substring(i);
                    widgetTypeShortNames.add(widgetTypeShortName);
                }
                ++i;
            }
            shortWidgetType = ((String)widgetTypeShortNames.get(widgetTypeShortNames.size() - 1)).toLowerCase();
            if (shortWidgetType.equals("box")) {
                shortWidgetType = (String)widgetTypeShortNames.get(widgetTypeShortNames.size() - 2);
                char ch = Character.toLowerCase(shortWidgetType.charAt(0));
                shortWidgetType = String.valueOf(ch) + shortWidgetType.substring(1, shortWidgetType.length());
            }
        }
        return shortWidgetType;
    }

    private boolean isFieldNameExist(String fieldName) {
        return NameFinder.getInstance().isFieldNameExist(fieldName) || this.isFieldNameExistInInsertWidgetModel(fieldName);
    }

    private boolean isFieldNameExistInInsertWidgetModel(String widgetName) {
        List<InsertDataNode> roots = this.model.getRootDataNodes();
        Iterator<InsertDataNode> iterator = roots.iterator();
        if (iterator.hasNext()) {
            InsertDataNode root = iterator.next();
            return this.isFieldNameExistInInsertWidgetModel(root, widgetName);
        }
        return false;
    }

    private boolean isFieldNameExistInInsertWidgetModel(InsertDataNode parent, String widgetName) {
        if (parent.equals(this)) {
            return false;
        }
        if (parent.getWidgetName() == null ? parent.getDefaultWidgetName().equalsIgnoreCase(widgetName) : parent.getWidgetName().equalsIgnoreCase(widgetName)) {
            return true;
        }
        List<InsertDataNode> children = parent.getChildren();
        Iterator<InsertDataNode> iterator = children.iterator();
        if (iterator.hasNext()) {
            InsertDataNode child = iterator.next();
            return this.isFieldNameExistInInsertWidgetModel(child, widgetName);
        }
        return false;
    }

    public class NodeType {
        public static final String TYPE_PRIMITIVE_ALL = "TYPE_PRIMITIVE_ALL";
        public static final String TYPE_RECORD_ALL = "TYPE_RECORD_ALL";
    }

    public class NodeTypeDetail {
        public static final String TYPE_PRIMITIVE_STRING = "TYPE_PRIMITIVE_STRING";
        public static final String TYPE_PRIMITIVE_DATE = "TYPE_PRIMITIVE_DATE";
        public static final String TYPE_PRIMITIVE_TIME = "TYPE_PRIMITIVE_TIME";
        public static final String TYPE_PRIMITIVE_TIMESTAMP = "TYPE_PRIMITIVE_TIMESTAMP";
        public static final String TYPE_PRIMITIVE_BIGINT = "TYPE_PRIMITIVE_BIGINT";
        public static final String TYPE_PRIMITIVE_BIN = "TYPE_PRIMITIVE_BIN";
        public static final String TYPE_PRIMITIVE_DECIMAL = "TYPE_PRIMITIVE_DECIMAL";
        public static final String TYPE_PRIMITIVE_FLOAT = "TYPE_PRIMITIVE_FLOAT";
        public static final String TYPE_PRIMITIVE_INT = "TYPE_PRIMITIVE_INT";
        public static final String TYPE_PRIMITIVE_NUM = "TYPE_PRIMITIVE_NUM";
        public static final String TYPE_PRIMITIVE_MONEY = "TYPE_PRIMITIVE_MONEY";
        public static final String TYPE_PRIMITIVE_SMALLINT = "TYPE_PRIMITIVE_SMALLINT";
        public static final String TYPE_PRIMITIVE_SMALLFLOAT = "TYPE_PRIMITIVE_SMALLFLOAT";
        public static final String TYPE_PRIMITIVE_BOOLEAN = "TYPE_PRIMITIVE_BOOLEAN";
        public static final String TYPE_RECORD_SIMPLE = "TYPE_RECORD_SIMPLE";
        public static final String TYPE_RECORD_EMBED_RECORD = "TYPE_RECORD_EMBED_RECORD";
        public static final String TYPE_RECORD_WITH_PRIMITIVE_ARRAY = "TYPE_RECORD_WITH_PRIMITIVE_ARRAY";
        public static final String TYPE_RECORD_WITH_RECORD_ARRAY = "TYPE_RECORD_WITH_RECORD_ARRAY";
    }

    public class Purpose {
        public static final String FOR_DISPLAY = "FOR_DISPLAY";
        public static final String FOR_CREATE = "FOR_CREATE";
        public static final String FOR_UPDATE = "FOR_UPDATE";
    }

    public class RUIWidgetType {
        public static final String NONE = "None";
    }
}

