/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.codemanipulation;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.compiler.binding.AmbiguousTypeBinding;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.Boolean;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.AnnotationExpression;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.CallStatement;
import org.eclipse.edt.compiler.core.ast.DataTable;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.ExternalType;
import org.eclipse.edt.compiler.core.ast.FunctionInvocation;
import org.eclipse.edt.compiler.core.ast.Handler;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.ImportDeclaration;
import org.eclipse.edt.compiler.core.ast.Interface;
import org.eclipse.edt.compiler.core.ast.Library;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NameType;
import org.eclipse.edt.compiler.core.ast.NestedForm;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.Program;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.compiler.core.ast.Record;
import org.eclipse.edt.compiler.core.ast.ReturningToNameClause;
import org.eclipse.edt.compiler.core.ast.Service;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.TopLevelForm;
import org.eclipse.edt.compiler.core.ast.TopLevelFunction;
import org.eclipse.edt.compiler.core.ast.TransferStatement;
import org.eclipse.edt.compiler.core.ast.UseStatement;
import org.eclipse.edt.ide.core.internal.compiler.SystemEnvironmentManager;
import org.eclipse.edt.ide.core.internal.utils.Util;
import org.eclipse.edt.ide.ui.internal.codemanipulation.OrganizeImportsOperation;
import org.eclipse.edt.mof.egl.utils.IRUtils;
import org.eclipse.edt.mof.serialization.IEnvironment;

public class OrganizeImportsVisitor
extends AbstractASTExpressionVisitor {
    private Name currentPartName = null;
    private OrganizeImportsOperation.OrganizedImportSection resolvedTypes;
    private Map unresolvedTypes;
    Set originalImports;
    private Boolean fIsIncludeRefFunc;
    private IProject project;
    private IEnvironment env;

    public OrganizeImportsVisitor(OrganizeImportsOperation.OrganizedImportSection resolvedTypes, Map unresolvedTypes, Set oldImports, Boolean isIncludeRefFunc, IProject project) {
        this.resolvedTypes = resolvedTypes;
        this.unresolvedTypes = unresolvedTypes;
        this.originalImports = oldImports;
        this.fIsIncludeRefFunc = isIncludeRefFunc;
        this.project = project;
        this.env = SystemEnvironmentManager.findSystemEnvironment((IProject)project, null).getIREnvironment();
    }

    public void setCurrentPartName(Name partName) {
        this.currentPartName = partName;
    }

    public boolean visitExpression(Expression expression) {
        if (expression.isName()) {
            this.addUnresolvedName((Name)expression);
        }
        return true;
    }

    public boolean visit(TopLevelFunction topLevelFunction) {
        return true;
    }

    public boolean visit(CallStatement callStatement) {
        Expression invocationTarget = callStatement.getInvocationTarget();
        if (!invocationTarget.isName()) {
            ITypeBinding binding = invocationTarget.resolveTypeBinding();
            if (this.isResolvedBinding((IBinding)binding)) {
                this.addToResovledTypes((IBinding)binding);
            }
        } else {
            this.addUnresolvedName((Name)invocationTarget);
        }
        return true;
    }

    public boolean visit(AnnotationExpression annotationExpression) {
        Name annotationName = annotationExpression.getName();
        IPartBinding sysPartBinding = SystemEnvironmentManager.findSystemEnvironment((IProject)this.project, null).getPartBinding(null, annotationName.getIdentifier());
        if (!Binding.isValidBinding((IBinding)sysPartBinding)) {
            this.addUnresolvedName(annotationName);
        }
        return true;
    }

    public boolean visit(SettingsBlock settingsBlock) {
        settingsBlock.accept((IASTVisitor)new AbstractASTVisitor(){

            public boolean visit(Assignment assignment) {
                String prefixValue;
                IAnnotationBinding annotationBinding = assignment.resolveBinding();
                if (annotationBinding != null && annotationBinding != IBinding.NOT_FOUND_BINDING && annotationBinding.getName().equalsIgnoreCase("msgTablePrefix") && (prefixValue = (String)annotationBinding.getValue()) != null && prefixValue.length() > 0) {
                    OrganizeImportsVisitor.this.check4MsgTablePrefix(prefixValue);
                }
                Expression lhsExp = assignment.getLeftHandSide();
                OrganizeImportsVisitor.this.visitExpression(lhsExp);
                return true;
            }
        });
        return true;
    }

    private void check4MsgTablePrefix(String msgTablePrefixValue) {
        if (msgTablePrefixValue != null && msgTablePrefixValue.length() > 0) {
            boolean fndSingleTypeMatch = false;
            Iterator oldIt = this.originalImports.iterator();
            while (oldIt.hasNext() && !fndSingleTypeMatch) {
                ImportDeclaration oldImportDecl = (ImportDeclaration)oldIt.next();
                Name importNameNode = oldImportDecl.getName();
                String oldPackageName = "";
                if (!oldImportDecl.isOnDemand()) {
                    String oldPartName = importNameNode.getIdentifier();
                    if (!oldPartName.startsWith(msgTablePrefixValue)) continue;
                    fndSingleTypeMatch = true;
                    if (importNameNode instanceof QualifiedName) {
                        oldPackageName = ((QualifiedName)importNameNode).getQualifier().getCanonicalName();
                    }
                    this.resolvedTypes.addImport(oldPackageName, oldPartName);
                    continue;
                }
                oldPackageName = importNameNode.getCanonicalName();
                this.resolvedTypes.addImport(oldPackageName, "*");
            }
        }
    }

    public boolean visit(Service service) {
        this.handlePart((Part)service);
        for (Name nextName : service.getImplementedInterfaces()) {
            this.addUnresolvedName(nextName);
        }
        return true;
    }

    public boolean visit(ExternalType externalType) {
        this.handlePart((Part)externalType);
        for (Name nextName : externalType.getExtendedTypes()) {
            this.addUnresolvedName(nextName);
        }
        return true;
    }

    public boolean visit(Record record) {
        this.handlePart((Part)record);
        return true;
    }

    public boolean visit(DataTable dataTable) {
        this.handlePart((Part)dataTable);
        return true;
    }

    public boolean visit(TopLevelForm topLevelForm) {
        this.handlePart((Part)topLevelForm);
        return true;
    }

    public boolean visit(NestedForm nestedForm) {
        Name subType = nestedForm.getSubType();
        if (subType != null) {
            this.addUnresolvedName(subType);
        }
        return true;
    }

    public boolean visit(Handler handler) {
        this.handlePart((Part)handler);
        return true;
    }

    public boolean visit(Interface interfaceNode) {
        this.handlePart((Part)interfaceNode);
        return true;
    }

    public boolean visit(Library library) {
        this.handlePart((Part)library);
        return true;
    }

    public boolean visit(Program program) {
        this.handlePart((Part)program);
        return true;
    }

    private void handlePart(Part part) {
        Name subType = part.getSubType();
        if (subType != null) {
            this.addUnresolvedName(subType);
        }
    }

    public boolean visit(UseStatement useStatement) {
        for (Name nextName : useStatement.getNames()) {
            this.addUnresolvedName(nextName);
        }
        return true;
    }

    public boolean visit(ReturningToNameClause returningToNameClause) {
        this.addUnresolvedName(returningToNameClause.getName());
        return true;
    }

    public boolean visit(TransferStatement transferStatement) {
        Expression invocationTarget = transferStatement.getInvocationTarget();
        if (!invocationTarget.isName()) {
            ITypeBinding binding = invocationTarget.resolveTypeBinding();
            if (this.isResolvedBinding((IBinding)binding)) {
                this.addToResovledTypes((IBinding)binding);
            }
        } else {
            this.addUnresolvedName((Name)invocationTarget);
        }
        return true;
    }

    public boolean visit(FunctionInvocation functionInvocation) {
        Expression expr = functionInvocation.getTarget();
        expr.accept((IASTVisitor)this);
        expr.accept((IASTVisitor)new AbstractASTExpressionVisitor(){

            public boolean visitExpression(Expression expr) {
                if (expr.isName() && ((Name)expr).isSimpleName()) {
                    OrganizeImportsVisitor.this.addUnresolvedName((Name)expr);
                }
                return false;
            }
        });
        return true;
    }

    private boolean isResolvedBinding(IBinding binding) {
        return binding != null && binding != IBinding.NOT_FOUND_BINDING && !(binding instanceof AmbiguousTypeBinding);
    }

    private void addUnresolvedName(Name nameNode) {
        IBinding binding = nameNode.resolveBinding();
        this.addToUnresolvedTypes(nameNode, binding);
    }

    private void addToUnresolvedTypes(Name nameNode, IBinding binding) {
        if (!this.isResolvedBinding(binding)) {
            this.addToUnresolvedTypes(nameNode);
        }
    }

    public boolean visit(QualifiedName qualifiedName) {
        QualifiedName nameNode = qualifiedName;
        while (nameNode.isQualifiedName()) {
            nameNode = nameNode.getQualifier();
        }
        this.addUnresolvedName((Name)nameNode);
        return true;
    }

    public boolean visit(NameType nameType) {
        ITypeBinding typeBinding = nameType.resolveTypeBinding();
        this.addToUnresolvedTypes(nameType.getName(), (IBinding)typeBinding);
        return true;
    }

    public boolean visitName(Name name) {
        IBinding binding;
        if (name != this.currentPartName && this.isResolvedBinding(binding = name.resolveBinding())) {
            this.addToResovledTypes(binding);
        }
        return true;
    }

    private void addToResovledTypes(IBinding binding) {
        ITypeBinding typeBinding = null;
        if (binding.isTypeBinding()) {
            typeBinding = (ITypeBinding)binding;
        } else if (binding.isAnnotationBinding()) {
            IAnnotationBinding annotationBinding = (IAnnotationBinding)binding;
            if (!annotationBinding.isAnnotationField()) {
                typeBinding = annotationBinding.getType();
            }
        } else if (binding.isDataBinding()) {
            IDataBinding dataBinding = (IDataBinding)binding;
            switch (dataBinding.getKind()) {
                case 9: 
                case 10: 
                case 11: 
                case 26: 
                case 27: {
                    typeBinding = dataBinding.getType();
                    break;
                }
                case 21: {
                    typeBinding = dataBinding.getType();
                    break;
                }
            }
        }
        if (typeBinding != null && typeBinding.isPartBinding()) {
            IPartBinding cfr_ignored_0 = (IPartBinding)typeBinding;
            String partName = typeBinding.getCaseSensitiveName();
            String[] pkgName = typeBinding.getPackageName();
            IPath pkgPath = Util.stringArrayToPath((String[])pkgName);
            String packageName = pkgPath.toString().replace('/', '.');
            boolean isSysPart = packageName != null && "" != packageName ? IRUtils.isSystemPart((String)(String.valueOf(packageName) + "." + partName), (IEnvironment)this.env) : IRUtils.isSystemPart((String)partName, (IEnvironment)this.env);
            if (!isSysPart || isSysPart && this.isInOriginalImports(packageName, partName)) {
                this.resolvedTypes.addImport(packageName, partName);
            }
        } else if (typeBinding != null && typeBinding instanceof IAnnotationTypeBinding) {
            IPath pkgPath;
            String packageName;
            boolean isSysAnnotation;
            IAnnotationTypeBinding annotationTypeBinding = (IAnnotationTypeBinding)typeBinding;
            String partName = annotationTypeBinding.getCaseSensitiveName();
            String[] pkgName = annotationTypeBinding.getPackageName();
            if (pkgName != null && (!(isSysAnnotation = (packageName = (pkgPath = Util.stringArrayToPath((String[])pkgName)).toString().replace('/', '.')) != null && "" != packageName ? IRUtils.isSystemPart((String)(String.valueOf(packageName) + "." + partName), (IEnvironment)this.env) : IRUtils.isSystemPart((String)partName, (IEnvironment)this.env)) || isSysAnnotation && this.isInOriginalImports(packageName, partName))) {
                this.resolvedTypes.addImport(packageName, partName);
            }
        }
    }

    private boolean isInOriginalImports(String pkgName2Test, String partName2Test) {
        boolean fndInOriginal = false;
        Iterator oldIt = this.originalImports.iterator();
        while (oldIt.hasNext() && !fndInOriginal) {
            ImportDeclaration oldImportDecl = (ImportDeclaration)oldIt.next();
            Name importNameNode = oldImportDecl.getName();
            String oldPackageName = "";
            if (!oldImportDecl.isOnDemand()) {
                String oldPartName = importNameNode.getIdentifier();
                if (!partName2Test.equalsIgnoreCase(oldPartName)) continue;
                if (importNameNode instanceof QualifiedName) {
                    oldPackageName = ((QualifiedName)importNameNode).getQualifier().getCanonicalName();
                }
                if (!oldPackageName.equalsIgnoreCase(pkgName2Test)) continue;
                fndInOriginal = true;
                continue;
            }
            oldPackageName = importNameNode.getCanonicalName();
            if (!pkgName2Test.equalsIgnoreCase(oldPackageName)) continue;
            fndInOriginal = true;
        }
        return fndInOriginal;
    }

    private void addToUnresolvedTypes(Name name) {
        this.addToMapTypes(name, this.unresolvedTypes);
    }

    private void addToMapTypes(Name name, Map types) {
        String strname = name.getIdentifier();
        if (!types.containsKey(strname)) {
            types.put(strname, name);
        }
    }
}

